package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "blockMsolPowerShell", 
    "enabledPreviewFeatures", 
    "guestUserRoleId", 
    "permissionGrantPolicyIdsAssignedToDefaultUserRole"})
@JsonInclude(Include.NON_NULL)
public class AuthorizationPolicy extends PolicyBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.authorizationPolicy";
    }

    @JsonProperty("blockMsolPowerShell")
    protected Boolean blockMsolPowerShell;

    @JsonProperty("enabledPreviewFeatures")
    protected List<String> enabledPreviewFeatures;

    @JsonProperty("enabledPreviewFeatures@nextLink")
    protected String enabledPreviewFeaturesNextLink;

    @JsonProperty("guestUserRoleId")
    protected String guestUserRoleId;

    @JsonProperty("permissionGrantPolicyIdsAssignedToDefaultUserRole")
    protected List<String> permissionGrantPolicyIdsAssignedToDefaultUserRole;

    @JsonProperty("permissionGrantPolicyIdsAssignedToDefaultUserRole@nextLink")
    protected String permissionGrantPolicyIdsAssignedToDefaultUserRoleNextLink;

    protected AuthorizationPolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAuthorizationPolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime deletedDateTime;
        private String description;
        private String displayName;
        private Boolean blockMsolPowerShell;
        private List<String> enabledPreviewFeatures;
        private String enabledPreviewFeaturesNextLink;
        private String guestUserRoleId;
        private List<String> permissionGrantPolicyIdsAssignedToDefaultUserRole;
        private String permissionGrantPolicyIdsAssignedToDefaultUserRoleNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder deletedDateTime(OffsetDateTime deletedDateTime) {
            this.deletedDateTime = deletedDateTime;
            this.changedFields = changedFields.add("deletedDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder blockMsolPowerShell(Boolean blockMsolPowerShell) {
            this.blockMsolPowerShell = blockMsolPowerShell;
            this.changedFields = changedFields.add("blockMsolPowerShell");
            return this;
        }

        public Builder enabledPreviewFeatures(List<String> enabledPreviewFeatures) {
            this.enabledPreviewFeatures = enabledPreviewFeatures;
            this.changedFields = changedFields.add("enabledPreviewFeatures");
            return this;
        }

        public Builder enabledPreviewFeatures(String... enabledPreviewFeatures) {
            return enabledPreviewFeatures(Arrays.asList(enabledPreviewFeatures));
        }

        public Builder enabledPreviewFeaturesNextLink(String enabledPreviewFeaturesNextLink) {
            this.enabledPreviewFeaturesNextLink = enabledPreviewFeaturesNextLink;
            this.changedFields = changedFields.add("enabledPreviewFeatures");
            return this;
        }

        public Builder guestUserRoleId(String guestUserRoleId) {
            this.guestUserRoleId = guestUserRoleId;
            this.changedFields = changedFields.add("guestUserRoleId");
            return this;
        }

        public Builder permissionGrantPolicyIdsAssignedToDefaultUserRole(List<String> permissionGrantPolicyIdsAssignedToDefaultUserRole) {
            this.permissionGrantPolicyIdsAssignedToDefaultUserRole = permissionGrantPolicyIdsAssignedToDefaultUserRole;
            this.changedFields = changedFields.add("permissionGrantPolicyIdsAssignedToDefaultUserRole");
            return this;
        }

        public Builder permissionGrantPolicyIdsAssignedToDefaultUserRole(String... permissionGrantPolicyIdsAssignedToDefaultUserRole) {
            return permissionGrantPolicyIdsAssignedToDefaultUserRole(Arrays.asList(permissionGrantPolicyIdsAssignedToDefaultUserRole));
        }

        public Builder permissionGrantPolicyIdsAssignedToDefaultUserRoleNextLink(String permissionGrantPolicyIdsAssignedToDefaultUserRoleNextLink) {
            this.permissionGrantPolicyIdsAssignedToDefaultUserRoleNextLink = permissionGrantPolicyIdsAssignedToDefaultUserRoleNextLink;
            this.changedFields = changedFields.add("permissionGrantPolicyIdsAssignedToDefaultUserRole");
            return this;
        }

        public AuthorizationPolicy build() {
            AuthorizationPolicy _x = new AuthorizationPolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.authorizationPolicy";
            _x.id = id;
            _x.deletedDateTime = deletedDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.blockMsolPowerShell = blockMsolPowerShell;
            _x.enabledPreviewFeatures = enabledPreviewFeatures;
            _x.enabledPreviewFeaturesNextLink = enabledPreviewFeaturesNextLink;
            _x.guestUserRoleId = guestUserRoleId;
            _x.permissionGrantPolicyIdsAssignedToDefaultUserRole = permissionGrantPolicyIdsAssignedToDefaultUserRole;
            _x.permissionGrantPolicyIdsAssignedToDefaultUserRoleNextLink = permissionGrantPolicyIdsAssignedToDefaultUserRoleNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="blockMsolPowerShell")
    @JsonIgnore
    public Optional<Boolean> getBlockMsolPowerShell() {
        return Optional.ofNullable(blockMsolPowerShell);
    }

    public AuthorizationPolicy withBlockMsolPowerShell(Boolean blockMsolPowerShell) {
        AuthorizationPolicy _x = _copy();
        _x.changedFields = changedFields.add("blockMsolPowerShell");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authorizationPolicy");
        _x.blockMsolPowerShell = blockMsolPowerShell;
        return _x;
    }

    @Property(name="enabledPreviewFeatures")
    @JsonIgnore
    public CollectionPage<String> getEnabledPreviewFeatures() {
        return new CollectionPage<String>(contextPath, String.class, enabledPreviewFeatures, Optional.ofNullable(enabledPreviewFeaturesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="enabledPreviewFeatures")
    @JsonIgnore
    public CollectionPage<String> getEnabledPreviewFeatures(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, enabledPreviewFeatures, Optional.ofNullable(enabledPreviewFeaturesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="guestUserRoleId")
    @JsonIgnore
    public Optional<String> getGuestUserRoleId() {
        return Optional.ofNullable(guestUserRoleId);
    }

    public AuthorizationPolicy withGuestUserRoleId(String guestUserRoleId) {
        AuthorizationPolicy _x = _copy();
        _x.changedFields = changedFields.add("guestUserRoleId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.authorizationPolicy");
        _x.guestUserRoleId = guestUserRoleId;
        return _x;
    }

    @Property(name="permissionGrantPolicyIdsAssignedToDefaultUserRole")
    @JsonIgnore
    public CollectionPage<String> getPermissionGrantPolicyIdsAssignedToDefaultUserRole() {
        return new CollectionPage<String>(contextPath, String.class, permissionGrantPolicyIdsAssignedToDefaultUserRole, Optional.ofNullable(permissionGrantPolicyIdsAssignedToDefaultUserRoleNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="permissionGrantPolicyIdsAssignedToDefaultUserRole")
    @JsonIgnore
    public CollectionPage<String> getPermissionGrantPolicyIdsAssignedToDefaultUserRole(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, permissionGrantPolicyIdsAssignedToDefaultUserRole, Optional.ofNullable(permissionGrantPolicyIdsAssignedToDefaultUserRoleNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AuthorizationPolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AuthorizationPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AuthorizationPolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AuthorizationPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AuthorizationPolicy _copy() {
        AuthorizationPolicy _x = new AuthorizationPolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.deletedDateTime = deletedDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.blockMsolPowerShell = blockMsolPowerShell;
        _x.enabledPreviewFeatures = enabledPreviewFeatures;
        _x.guestUserRoleId = guestUserRoleId;
        _x.permissionGrantPolicyIdsAssignedToDefaultUserRole = permissionGrantPolicyIdsAssignedToDefaultUserRole;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AuthorizationPolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deletedDateTime=");
        b.append(this.deletedDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("blockMsolPowerShell=");
        b.append(this.blockMsolPowerShell);
        b.append(", ");
        b.append("enabledPreviewFeatures=");
        b.append(this.enabledPreviewFeatures);
        b.append(", ");
        b.append("guestUserRoleId=");
        b.append(this.guestUserRoleId);
        b.append(", ");
        b.append("permissionGrantPolicyIdsAssignedToDefaultUserRole=");
        b.append(this.permissionGrantPolicyIdsAssignedToDefaultUserRole);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
