package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import odata.msgraph.client.beta.entity.collection.request.AuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.EmailAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.Fido2AuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.LongRunningOperationCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.MicrosoftAuthenticatorAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PasswordAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PasswordlessMicrosoftAuthenticatorAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.PhoneAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SecurityQuestionAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.SoftwareOathAuthenticationMethodCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TemporaryAccessPassAuthenticationMethodCollectionRequest;

@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class Authentication extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.authentication";
    }

    protected Authentication() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAuthentication() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Authentication build() {
            Authentication _x = new Authentication();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.authentication";
            _x.id = id;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @NavigationProperty(name="methods")
    @JsonIgnore
    public AuthenticationMethodCollectionRequest getMethods() {
        return new AuthenticationMethodCollectionRequest(
                        contextPath.addSegment("methods"));
    }

    @NavigationProperty(name="securityQuestionMethods")
    @JsonIgnore
    public SecurityQuestionAuthenticationMethodCollectionRequest getSecurityQuestionMethods() {
        return new SecurityQuestionAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("securityQuestionMethods"));
    }

    @NavigationProperty(name="phoneMethods")
    @JsonIgnore
    public PhoneAuthenticationMethodCollectionRequest getPhoneMethods() {
        return new PhoneAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("phoneMethods"));
    }

    @NavigationProperty(name="passwordMethods")
    @JsonIgnore
    public PasswordAuthenticationMethodCollectionRequest getPasswordMethods() {
        return new PasswordAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("passwordMethods"));
    }

    @NavigationProperty(name="operations")
    @JsonIgnore
    public LongRunningOperationCollectionRequest getOperations() {
        return new LongRunningOperationCollectionRequest(
                        contextPath.addSegment("operations"));
    }

    @NavigationProperty(name="emailMethods")
    @JsonIgnore
    public EmailAuthenticationMethodCollectionRequest getEmailMethods() {
        return new EmailAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("emailMethods"));
    }

    @NavigationProperty(name="oathMethods")
    @JsonIgnore
    public SoftwareOathAuthenticationMethodCollectionRequest getOathMethods() {
        return new SoftwareOathAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("oathMethods"));
    }

    @NavigationProperty(name="microsoftAuthenticatorMethods")
    @JsonIgnore
    public MicrosoftAuthenticatorAuthenticationMethodCollectionRequest getMicrosoftAuthenticatorMethods() {
        return new MicrosoftAuthenticatorAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("microsoftAuthenticatorMethods"));
    }

    @NavigationProperty(name="passwordlessMicrosoftAuthenticatorMethods")
    @JsonIgnore
    public PasswordlessMicrosoftAuthenticatorAuthenticationMethodCollectionRequest getPasswordlessMicrosoftAuthenticatorMethods() {
        return new PasswordlessMicrosoftAuthenticatorAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("passwordlessMicrosoftAuthenticatorMethods"));
    }

    @NavigationProperty(name="fido2Methods")
    @JsonIgnore
    public Fido2AuthenticationMethodCollectionRequest getFido2Methods() {
        return new Fido2AuthenticationMethodCollectionRequest(
                        contextPath.addSegment("fido2Methods"));
    }

    @NavigationProperty(name="temporaryAccessPassMethods")
    @JsonIgnore
    public TemporaryAccessPassAuthenticationMethodCollectionRequest getTemporaryAccessPassMethods() {
        return new TemporaryAccessPassAuthenticationMethodCollectionRequest(
                        contextPath.addSegment("temporaryAccessPassMethods"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Authentication patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Authentication _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Authentication put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Authentication _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Authentication _copy() {
        Authentication _x = new Authentication();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Authentication[");
        b.append("id=");
        b.append(this.id);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
