package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AuditActor;
import odata.msgraph.client.beta.complex.AuditResource;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“A class containing the properties for Audit Event.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "componentName", 
    "actor", 
    "activity", 
    "activityDateTime", 
    "activityType", 
    "activityOperationType", 
    "activityResult", 
    "correlationId", 
    "resources", 
    "category"})
@JsonInclude(Include.NON_NULL)
public class AuditEvent extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.auditEvent";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("componentName")
    protected String componentName;

    @JsonProperty("actor")
    protected AuditActor actor;

    @JsonProperty("activity")
    protected String activity;

    @JsonProperty("activityDateTime")
    protected OffsetDateTime activityDateTime;

    @JsonProperty("activityType")
    protected String activityType;

    @JsonProperty("activityOperationType")
    protected String activityOperationType;

    @JsonProperty("activityResult")
    protected String activityResult;

    @JsonProperty("correlationId")
    protected String correlationId;

    @JsonProperty("resources")
    protected List<AuditResource> resources;

    @JsonProperty("resources@nextLink")
    protected String resourcesNextLink;

    @JsonProperty("category")
    protected String category;

    protected AuditEvent() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAuditEvent() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String componentName;
        private AuditActor actor;
        private String activity;
        private OffsetDateTime activityDateTime;
        private String activityType;
        private String activityOperationType;
        private String activityResult;
        private String correlationId;
        private List<AuditResource> resources;
        private String resourcesNextLink;
        private String category;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Event display name.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Component name.”</i>
         * 
         * @param componentName
         *            value of {@code componentName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder componentName(String componentName) {
            this.componentName = componentName;
            this.changedFields = changedFields.add("componentName");
            return this;
        }

        /**
         * <i>“AAD user and application that are associated with the audit event.”</i>
         * 
         * @param actor
         *            value of {@code actor} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder actor(AuditActor actor) {
            this.actor = actor;
            this.changedFields = changedFields.add("actor");
            return this;
        }

        /**
         * <i>“Friendly name of the activity.”</i>
         * 
         * @param activity
         *            value of {@code activity} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activity(String activity) {
            this.activity = activity;
            this.changedFields = changedFields.add("activity");
            return this;
        }

        /**
         * <i>“The date time in UTC when the activity was performed.”</i>
         * 
         * @param activityDateTime
         *            value of {@code activityDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activityDateTime(OffsetDateTime activityDateTime) {
            this.activityDateTime = activityDateTime;
            this.changedFields = changedFields.add("activityDateTime");
            return this;
        }

        /**
         * <i>“The type of activity that was being performed.”</i>
         * 
         * @param activityType
         *            value of {@code activityType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activityType(String activityType) {
            this.activityType = activityType;
            this.changedFields = changedFields.add("activityType");
            return this;
        }

        /**
         * <i>“The HTTP operation type of the activity.”</i>
         * 
         * @param activityOperationType
         *            value of {@code activityOperationType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activityOperationType(String activityOperationType) {
            this.activityOperationType = activityOperationType;
            this.changedFields = changedFields.add("activityOperationType");
            return this;
        }

        /**
         * <i>“The result of the activity.”</i>
         * 
         * @param activityResult
         *            value of {@code activityResult} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder activityResult(String activityResult) {
            this.activityResult = activityResult;
            this.changedFields = changedFields.add("activityResult");
            return this;
        }

        /**
         * <i>“The client request Id that is used to correlate activity within the system.”</i>
         * 
         * @param correlationId
         *            value of {@code correlationId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder correlationId(String correlationId) {
            this.correlationId = correlationId;
            this.changedFields = changedFields.add("correlationId");
            return this;
        }

        /**
         * <i>“Resources being modified.”</i>
         * 
         * @param resources
         *            value of {@code resources} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resources(List<AuditResource> resources) {
            this.resources = resources;
            this.changedFields = changedFields.add("resources");
            return this;
        }

        /**
         * <i>“Resources being modified.”</i>
         * 
         * @param resources
         *            value of {@code resources} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resources(AuditResource... resources) {
            return resources(Arrays.asList(resources));
        }

        /**
         * <i>“Resources being modified.”</i>
         * 
         * @param resourcesNextLink
         *            value of {@code resources@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder resourcesNextLink(String resourcesNextLink) {
            this.resourcesNextLink = resourcesNextLink;
            this.changedFields = changedFields.add("resources");
            return this;
        }

        /**
         * <i>“Audit category.”</i>
         * 
         * @param category
         *            value of {@code category} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder category(String category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        public AuditEvent build() {
            AuditEvent _x = new AuditEvent();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.auditEvent";
            _x.id = id;
            _x.displayName = displayName;
            _x.componentName = componentName;
            _x.actor = actor;
            _x.activity = activity;
            _x.activityDateTime = activityDateTime;
            _x.activityType = activityType;
            _x.activityOperationType = activityOperationType;
            _x.activityResult = activityResult;
            _x.correlationId = correlationId;
            _x.resources = resources;
            _x.resourcesNextLink = resourcesNextLink;
            _x.category = category;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Event display name.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Event display name.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public AuditEvent withDisplayName(String displayName) {
        AuditEvent _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditEvent");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Component name.”</i>
     * 
     * @return property componentName
     */
    @Property(name="componentName")
    @JsonIgnore
    public Optional<String> getComponentName() {
        return Optional.ofNullable(componentName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code componentName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Component name.”</i>
     * 
     * @param componentName
     *            new value of {@code componentName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code componentName} field changed
     */
    public AuditEvent withComponentName(String componentName) {
        AuditEvent _x = _copy();
        _x.changedFields = changedFields.add("componentName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditEvent");
        _x.componentName = componentName;
        return _x;
    }

    /**
     * <i>“AAD user and application that are associated with the audit event.”</i>
     * 
     * @return property actor
     */
    @Property(name="actor")
    @JsonIgnore
    public Optional<AuditActor> getActor() {
        return Optional.ofNullable(actor);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code actor} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“AAD user and application that are associated with the audit event.”</i>
     * 
     * @param actor
     *            new value of {@code actor} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code actor} field changed
     */
    public AuditEvent withActor(AuditActor actor) {
        AuditEvent _x = _copy();
        _x.changedFields = changedFields.add("actor");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditEvent");
        _x.actor = actor;
        return _x;
    }

    /**
     * <i>“Friendly name of the activity.”</i>
     * 
     * @return property activity
     */
    @Property(name="activity")
    @JsonIgnore
    public Optional<String> getActivity() {
        return Optional.ofNullable(activity);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code activity} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Friendly name of the activity.”</i>
     * 
     * @param activity
     *            new value of {@code activity} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activity} field changed
     */
    public AuditEvent withActivity(String activity) {
        AuditEvent _x = _copy();
        _x.changedFields = changedFields.add("activity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditEvent");
        _x.activity = activity;
        return _x;
    }

    /**
     * <i>“The date time in UTC when the activity was performed.”</i>
     * 
     * @return property activityDateTime
     */
    @Property(name="activityDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getActivityDateTime() {
        return Optional.ofNullable(activityDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code activityDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The date time in UTC when the activity was performed.”</i>
     * 
     * @param activityDateTime
     *            new value of {@code activityDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activityDateTime} field changed
     */
    public AuditEvent withActivityDateTime(OffsetDateTime activityDateTime) {
        AuditEvent _x = _copy();
        _x.changedFields = changedFields.add("activityDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditEvent");
        _x.activityDateTime = activityDateTime;
        return _x;
    }

    /**
     * <i>“The type of activity that was being performed.”</i>
     * 
     * @return property activityType
     */
    @Property(name="activityType")
    @JsonIgnore
    public Optional<String> getActivityType() {
        return Optional.ofNullable(activityType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code activityType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The type of activity that was being performed.”</i>
     * 
     * @param activityType
     *            new value of {@code activityType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activityType} field changed
     */
    public AuditEvent withActivityType(String activityType) {
        AuditEvent _x = _copy();
        _x.changedFields = changedFields.add("activityType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditEvent");
        _x.activityType = activityType;
        return _x;
    }

    /**
     * <i>“The HTTP operation type of the activity.”</i>
     * 
     * @return property activityOperationType
     */
    @Property(name="activityOperationType")
    @JsonIgnore
    public Optional<String> getActivityOperationType() {
        return Optional.ofNullable(activityOperationType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * activityOperationType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The HTTP operation type of the activity.”</i>
     * 
     * @param activityOperationType
     *            new value of {@code activityOperationType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activityOperationType} field changed
     */
    public AuditEvent withActivityOperationType(String activityOperationType) {
        AuditEvent _x = _copy();
        _x.changedFields = changedFields.add("activityOperationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditEvent");
        _x.activityOperationType = activityOperationType;
        return _x;
    }

    /**
     * <i>“The result of the activity.”</i>
     * 
     * @return property activityResult
     */
    @Property(name="activityResult")
    @JsonIgnore
    public Optional<String> getActivityResult() {
        return Optional.ofNullable(activityResult);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code activityResult}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The result of the activity.”</i>
     * 
     * @param activityResult
     *            new value of {@code activityResult} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code activityResult} field changed
     */
    public AuditEvent withActivityResult(String activityResult) {
        AuditEvent _x = _copy();
        _x.changedFields = changedFields.add("activityResult");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditEvent");
        _x.activityResult = activityResult;
        return _x;
    }

    /**
     * <i>“The client request Id that is used to correlate activity within the system.”</i>
     * 
     * @return property correlationId
     */
    @Property(name="correlationId")
    @JsonIgnore
    public Optional<String> getCorrelationId() {
        return Optional.ofNullable(correlationId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code correlationId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The client request Id that is used to correlate activity within the system.”</i>
     * 
     * @param correlationId
     *            new value of {@code correlationId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code correlationId} field changed
     */
    public AuditEvent withCorrelationId(String correlationId) {
        AuditEvent _x = _copy();
        _x.changedFields = changedFields.add("correlationId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditEvent");
        _x.correlationId = correlationId;
        return _x;
    }

    /**
     * <i>“Resources being modified.”</i>
     * 
     * @return property resources
     */
    @Property(name="resources")
    @JsonIgnore
    public CollectionPage<AuditResource> getResources() {
        return new CollectionPage<AuditResource>(contextPath, AuditResource.class, resources, Optional.ofNullable(resourcesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Resources being modified.”</i>
     * 
     * @return property resources
     */
    @Property(name="resources")
    @JsonIgnore
    public CollectionPage<AuditResource> getResources(HttpRequestOptions options) {
        return new CollectionPage<AuditResource>(contextPath, AuditResource.class, resources, Optional.ofNullable(resourcesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Audit category.”</i>
     * 
     * @return property category
     */
    @Property(name="category")
    @JsonIgnore
    public Optional<String> getCategory() {
        return Optional.ofNullable(category);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code category} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Audit category.”</i>
     * 
     * @param category
     *            new value of {@code category} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code category} field changed
     */
    public AuditEvent withCategory(String category) {
        AuditEvent _x = _copy();
        _x.changedFields = changedFields.add("category");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.auditEvent");
        _x.category = category;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AuditEvent patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AuditEvent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AuditEvent put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AuditEvent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AuditEvent _copy() {
        AuditEvent _x = new AuditEvent();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.componentName = componentName;
        _x.actor = actor;
        _x.activity = activity;
        _x.activityDateTime = activityDateTime;
        _x.activityType = activityType;
        _x.activityOperationType = activityOperationType;
        _x.activityResult = activityResult;
        _x.correlationId = correlationId;
        _x.resources = resources;
        _x.category = category;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AuditEvent[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("componentName=");
        b.append(this.componentName);
        b.append(", ");
        b.append("actor=");
        b.append(this.actor);
        b.append(", ");
        b.append("activity=");
        b.append(this.activity);
        b.append(", ");
        b.append("activityDateTime=");
        b.append(this.activityDateTime);
        b.append(", ");
        b.append("activityType=");
        b.append(this.activityType);
        b.append(", ");
        b.append("activityOperationType=");
        b.append(this.activityOperationType);
        b.append(", ");
        b.append("activityResult=");
        b.append(this.activityResult);
        b.append(", ");
        b.append("correlationId=");
        b.append(this.correlationId);
        b.append(", ");
        b.append("resources=");
        b.append(this.resources);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
