package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.enums.RoutingMode;

@JsonPropertyOrder({
    "@odata.type", 
    "routingMode", 
    "sources", 
    "receivers"})
@JsonInclude(Include.NON_NULL)
public class AudioRoutingGroup extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.audioRoutingGroup";
    }

    @JsonProperty("routingMode")
    protected RoutingMode routingMode;

    @JsonProperty("sources")
    protected List<String> sources;

    @JsonProperty("sources@nextLink")
    protected String sourcesNextLink;

    @JsonProperty("receivers")
    protected List<String> receivers;

    @JsonProperty("receivers@nextLink")
    protected String receiversNextLink;

    protected AudioRoutingGroup() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAudioRoutingGroup() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private RoutingMode routingMode;
        private List<String> sources;
        private String sourcesNextLink;
        private List<String> receivers;
        private String receiversNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder routingMode(RoutingMode routingMode) {
            this.routingMode = routingMode;
            this.changedFields = changedFields.add("routingMode");
            return this;
        }

        public Builder sources(List<String> sources) {
            this.sources = sources;
            this.changedFields = changedFields.add("sources");
            return this;
        }

        public Builder sources(String... sources) {
            return sources(Arrays.asList(sources));
        }

        public Builder sourcesNextLink(String sourcesNextLink) {
            this.sourcesNextLink = sourcesNextLink;
            this.changedFields = changedFields.add("sources");
            return this;
        }

        public Builder receivers(List<String> receivers) {
            this.receivers = receivers;
            this.changedFields = changedFields.add("receivers");
            return this;
        }

        public Builder receivers(String... receivers) {
            return receivers(Arrays.asList(receivers));
        }

        public Builder receiversNextLink(String receiversNextLink) {
            this.receiversNextLink = receiversNextLink;
            this.changedFields = changedFields.add("receivers");
            return this;
        }

        public AudioRoutingGroup build() {
            AudioRoutingGroup _x = new AudioRoutingGroup();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.audioRoutingGroup";
            _x.id = id;
            _x.routingMode = routingMode;
            _x.sources = sources;
            _x.sourcesNextLink = sourcesNextLink;
            _x.receivers = receivers;
            _x.receiversNextLink = receiversNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="routingMode")
    @JsonIgnore
    public Optional<RoutingMode> getRoutingMode() {
        return Optional.ofNullable(routingMode);
    }

    public AudioRoutingGroup withRoutingMode(RoutingMode routingMode) {
        AudioRoutingGroup _x = _copy();
        _x.changedFields = changedFields.add("routingMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.audioRoutingGroup");
        _x.routingMode = routingMode;
        return _x;
    }

    @Property(name="sources")
    @JsonIgnore
    public CollectionPage<String> getSources() {
        return new CollectionPage<String>(contextPath, String.class, sources, Optional.ofNullable(sourcesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="sources")
    @JsonIgnore
    public CollectionPage<String> getSources(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, sources, Optional.ofNullable(sourcesNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="receivers")
    @JsonIgnore
    public CollectionPage<String> getReceivers() {
        return new CollectionPage<String>(contextPath, String.class, receivers, Optional.ofNullable(receiversNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="receivers")
    @JsonIgnore
    public CollectionPage<String> getReceivers(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, receivers, Optional.ofNullable(receiversNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AudioRoutingGroup patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AudioRoutingGroup _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AudioRoutingGroup put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AudioRoutingGroup _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AudioRoutingGroup _copy() {
        AudioRoutingGroup _x = new AudioRoutingGroup();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.routingMode = routingMode;
        _x.sources = sources;
        _x.receivers = receivers;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AudioRoutingGroup[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("routingMode=");
        b.append(this.routingMode);
        b.append(", ");
        b.append("sources=");
        b.append(this.sources);
        b.append(", ");
        b.append("receivers=");
        b.append(this.receivers);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
