package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.Identity;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "reviewedBy", 
    "reviewedDateTime", 
    "reviewResult", 
    "justification"})
@JsonInclude(Include.NON_NULL)
public class ApprovalStep extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.approvalStep";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("reviewedBy")
    protected Identity reviewedBy;

    @JsonProperty("reviewedDateTime")
    protected OffsetDateTime reviewedDateTime;

    @JsonProperty("reviewResult")
    protected String reviewResult;

    @JsonProperty("justification")
    protected String justification;

    protected ApprovalStep() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderApprovalStep() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private Identity reviewedBy;
        private OffsetDateTime reviewedDateTime;
        private String reviewResult;
        private String justification;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder reviewedBy(Identity reviewedBy) {
            this.reviewedBy = reviewedBy;
            this.changedFields = changedFields.add("reviewedBy");
            return this;
        }

        public Builder reviewedDateTime(OffsetDateTime reviewedDateTime) {
            this.reviewedDateTime = reviewedDateTime;
            this.changedFields = changedFields.add("reviewedDateTime");
            return this;
        }

        public Builder reviewResult(String reviewResult) {
            this.reviewResult = reviewResult;
            this.changedFields = changedFields.add("reviewResult");
            return this;
        }

        public Builder justification(String justification) {
            this.justification = justification;
            this.changedFields = changedFields.add("justification");
            return this;
        }

        public ApprovalStep build() {
            ApprovalStep _x = new ApprovalStep();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.approvalStep";
            _x.id = id;
            _x.displayName = displayName;
            _x.reviewedBy = reviewedBy;
            _x.reviewedDateTime = reviewedDateTime;
            _x.reviewResult = reviewResult;
            _x.justification = justification;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public ApprovalStep withDisplayName(String displayName) {
        ApprovalStep _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.approvalStep");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="reviewedBy")
    @JsonIgnore
    public Optional<Identity> getReviewedBy() {
        return Optional.ofNullable(reviewedBy);
    }

    public ApprovalStep withReviewedBy(Identity reviewedBy) {
        ApprovalStep _x = _copy();
        _x.changedFields = changedFields.add("reviewedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.approvalStep");
        _x.reviewedBy = reviewedBy;
        return _x;
    }

    @Property(name="reviewedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getReviewedDateTime() {
        return Optional.ofNullable(reviewedDateTime);
    }

    public ApprovalStep withReviewedDateTime(OffsetDateTime reviewedDateTime) {
        ApprovalStep _x = _copy();
        _x.changedFields = changedFields.add("reviewedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.approvalStep");
        _x.reviewedDateTime = reviewedDateTime;
        return _x;
    }

    @Property(name="reviewResult")
    @JsonIgnore
    public Optional<String> getReviewResult() {
        return Optional.ofNullable(reviewResult);
    }

    public ApprovalStep withReviewResult(String reviewResult) {
        ApprovalStep _x = _copy();
        _x.changedFields = changedFields.add("reviewResult");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.approvalStep");
        _x.reviewResult = reviewResult;
        return _x;
    }

    @Property(name="justification")
    @JsonIgnore
    public Optional<String> getJustification() {
        return Optional.ofNullable(justification);
    }

    public ApprovalStep withJustification(String justification) {
        ApprovalStep _x = _copy();
        _x.changedFields = changedFields.add("justification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.approvalStep");
        _x.justification = justification;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ApprovalStep patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ApprovalStep _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ApprovalStep put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ApprovalStep _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ApprovalStep _copy() {
        ApprovalStep _x = new ApprovalStep();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.reviewedBy = reviewedBy;
        _x.reviewedDateTime = reviewedDateTime;
        _x.reviewResult = reviewResult;
        _x.justification = justification;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ApprovalStep[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("reviewedBy=");
        b.append(this.reviewedBy);
        b.append(", ");
        b.append("reviewedDateTime=");
        b.append(this.reviewedDateTime);
        b.append(", ");
        b.append("reviewResult=");
        b.append(this.reviewResult);
        b.append(", ");
        b.append("justification=");
        b.append(this.justification);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
