package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 */@JsonPropertyOrder({
    "@odata.type", 
    "appDisplayName", 
    "successfulSignInCount", 
    "failedSignInCount", 
    "successPercentage"})
@JsonInclude(Include.NON_NULL)
public class ApplicationSignInSummary extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.applicationSignInSummary";
    }

    @JsonProperty("appDisplayName")
    protected String appDisplayName;

    @JsonProperty("successfulSignInCount")
    protected Long successfulSignInCount;

    @JsonProperty("failedSignInCount")
    protected Long failedSignInCount;

    @JsonProperty("successPercentage")
    protected Double successPercentage;

    protected ApplicationSignInSummary() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderApplicationSignInSummary() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String appDisplayName;
        private Long successfulSignInCount;
        private Long failedSignInCount;
        private Double successPercentage;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder appDisplayName(String appDisplayName) {
            this.appDisplayName = appDisplayName;
            this.changedFields = changedFields.add("appDisplayName");
            return this;
        }

        public Builder successfulSignInCount(Long successfulSignInCount) {
            this.successfulSignInCount = successfulSignInCount;
            this.changedFields = changedFields.add("successfulSignInCount");
            return this;
        }

        public Builder failedSignInCount(Long failedSignInCount) {
            this.failedSignInCount = failedSignInCount;
            this.changedFields = changedFields.add("failedSignInCount");
            return this;
        }

        public Builder successPercentage(Double successPercentage) {
            this.successPercentage = successPercentage;
            this.changedFields = changedFields.add("successPercentage");
            return this;
        }

        public ApplicationSignInSummary build() {
            ApplicationSignInSummary _x = new ApplicationSignInSummary();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.applicationSignInSummary";
            _x.id = id;
            _x.appDisplayName = appDisplayName;
            _x.successfulSignInCount = successfulSignInCount;
            _x.failedSignInCount = failedSignInCount;
            _x.successPercentage = successPercentage;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="appDisplayName")
    @JsonIgnore
    public Optional<String> getAppDisplayName() {
        return Optional.ofNullable(appDisplayName);
    }

    public ApplicationSignInSummary withAppDisplayName(String appDisplayName) {
        ApplicationSignInSummary _x = _copy();
        _x.changedFields = changedFields.add("appDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applicationSignInSummary");
        _x.appDisplayName = appDisplayName;
        return _x;
    }

    @Property(name="successfulSignInCount")
    @JsonIgnore
    public Optional<Long> getSuccessfulSignInCount() {
        return Optional.ofNullable(successfulSignInCount);
    }

    public ApplicationSignInSummary withSuccessfulSignInCount(Long successfulSignInCount) {
        ApplicationSignInSummary _x = _copy();
        _x.changedFields = changedFields.add("successfulSignInCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applicationSignInSummary");
        _x.successfulSignInCount = successfulSignInCount;
        return _x;
    }

    @Property(name="failedSignInCount")
    @JsonIgnore
    public Optional<Long> getFailedSignInCount() {
        return Optional.ofNullable(failedSignInCount);
    }

    public ApplicationSignInSummary withFailedSignInCount(Long failedSignInCount) {
        ApplicationSignInSummary _x = _copy();
        _x.changedFields = changedFields.add("failedSignInCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applicationSignInSummary");
        _x.failedSignInCount = failedSignInCount;
        return _x;
    }

    @Property(name="successPercentage")
    @JsonIgnore
    public Optional<Double> getSuccessPercentage() {
        return Optional.ofNullable(successPercentage);
    }

    public ApplicationSignInSummary withSuccessPercentage(Double successPercentage) {
        ApplicationSignInSummary _x = _copy();
        _x.changedFields = changedFields.add("successPercentage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applicationSignInSummary");
        _x.successPercentage = successPercentage;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ApplicationSignInSummary patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ApplicationSignInSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ApplicationSignInSummary put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ApplicationSignInSummary _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ApplicationSignInSummary _copy() {
        ApplicationSignInSummary _x = new ApplicationSignInSummary();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.appDisplayName = appDisplayName;
        _x.successfulSignInCount = successfulSignInCount;
        _x.failedSignInCount = failedSignInCount;
        _x.successPercentage = successPercentage;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ApplicationSignInSummary[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("appDisplayName=");
        b.append(this.appDisplayName);
        b.append(", ");
        b.append("successfulSignInCount=");
        b.append(this.successfulSignInCount);
        b.append(", ");
        b.append("failedSignInCount=");
        b.append(this.failedSignInCount);
        b.append(", ");
        b.append("successPercentage=");
        b.append(this.successPercentage);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
