package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.StreamProvider;
import com.github.davidmoten.odata.client.StreamUploader;
import com.github.davidmoten.odata.client.StreamUploaderChunked;
import com.github.davidmoten.odata.client.StreamUploaderSingleCall;
import com.github.davidmoten.odata.client.UploadStrategy;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ApiApplication;
import odata.msgraph.client.beta.complex.AppRole;
import odata.msgraph.client.beta.complex.InformationalUrl;
import odata.msgraph.client.beta.complex.KeyCredential;
import odata.msgraph.client.beta.complex.OnPremisesPublishing;
import odata.msgraph.client.beta.complex.OptionalClaims;
import odata.msgraph.client.beta.complex.ParentalControlSettings;
import odata.msgraph.client.beta.complex.PasswordCredential;
import odata.msgraph.client.beta.complex.PublicClientApplication;
import odata.msgraph.client.beta.complex.RequiredResourceAccess;
import odata.msgraph.client.beta.complex.WebApplication;
import odata.msgraph.client.beta.entity.collection.request.DirectoryObjectCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.ExtensionPropertyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.HomeRealmDiscoveryPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TokenIssuancePolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.TokenLifetimePolicyCollectionRequest;
import odata.msgraph.client.beta.entity.request.ConnectorGroupRequest;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.SynchronizationRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
 * <p>
 * Supported = true
 * <p>
 * <b>Org.OData.Capabilities.V1.ChangeTracking</b>
 * <p>
 * Supported = true
 */@JsonPropertyOrder({
    "@odata.type", 
    "api", 
    "appId", 
    "appRoles", 
    "createdDateTime", 
    "description", 
    "isFallbackPublicClient", 
    "identifierUris", 
    "displayName", 
    "groupMembershipClaims", 
    "info", 
    "isDeviceOnlyAuthSupported", 
    "keyCredentials", 
    "logo", 
    "notes", 
    "optionalClaims", 
    "parentalControlSettings", 
    "passwordCredentials", 
    "publicClient", 
    "publisherDomain", 
    "requiredResourceAccess", 
    "signInAudience", 
    "tags", 
    "tokenEncryptionKeyId", 
    "web", 
    "onPremisesPublishing"})
@JsonInclude(Include.NON_NULL)
public class Application extends DirectoryObject implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.application";
    }

    @JsonProperty("api")
    protected ApiApplication api;

    @JsonProperty("appId")
    protected String appId;

    @JsonProperty("appRoles")
    protected List<AppRole> appRoles;

    @JsonProperty("appRoles@nextLink")
    protected String appRolesNextLink;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("isFallbackPublicClient")
    protected Boolean isFallbackPublicClient;

    @JsonProperty("identifierUris")
    protected List<String> identifierUris;

    @JsonProperty("identifierUris@nextLink")
    protected String identifierUrisNextLink;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("groupMembershipClaims")
    protected String groupMembershipClaims;

    @JsonProperty("info")
    protected InformationalUrl info;

    @JsonProperty("isDeviceOnlyAuthSupported")
    protected Boolean isDeviceOnlyAuthSupported;

    @JsonProperty("keyCredentials")
    protected List<KeyCredential> keyCredentials;

    @JsonProperty("keyCredentials@nextLink")
    protected String keyCredentialsNextLink;

    @JsonProperty("logo")
    protected String logo;

    @JsonProperty("notes")
    protected String notes;

    @JsonProperty("optionalClaims")
    protected OptionalClaims optionalClaims;

    @JsonProperty("parentalControlSettings")
    protected ParentalControlSettings parentalControlSettings;

    @JsonProperty("passwordCredentials")
    protected List<PasswordCredential> passwordCredentials;

    @JsonProperty("passwordCredentials@nextLink")
    protected String passwordCredentialsNextLink;

    @JsonProperty("publicClient")
    protected PublicClientApplication publicClient;

    @JsonProperty("publisherDomain")
    protected String publisherDomain;

    @JsonProperty("requiredResourceAccess")
    protected List<RequiredResourceAccess> requiredResourceAccess;

    @JsonProperty("requiredResourceAccess@nextLink")
    protected String requiredResourceAccessNextLink;

    @JsonProperty("signInAudience")
    protected String signInAudience;

    @JsonProperty("tags")
    protected List<String> tags;

    @JsonProperty("tags@nextLink")
    protected String tagsNextLink;

    @JsonProperty("tokenEncryptionKeyId")
    protected String tokenEncryptionKeyId;

    @JsonProperty("web")
    protected WebApplication web;

    @JsonProperty("onPremisesPublishing")
    protected OnPremisesPublishing onPremisesPublishing;

    protected Application() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderApplication() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime deletedDateTime;
        private ApiApplication api;
        private String appId;
        private List<AppRole> appRoles;
        private String appRolesNextLink;
        private OffsetDateTime createdDateTime;
        private String description;
        private Boolean isFallbackPublicClient;
        private List<String> identifierUris;
        private String identifierUrisNextLink;
        private String displayName;
        private String groupMembershipClaims;
        private InformationalUrl info;
        private Boolean isDeviceOnlyAuthSupported;
        private List<KeyCredential> keyCredentials;
        private String keyCredentialsNextLink;
        private String logo;
        private String notes;
        private OptionalClaims optionalClaims;
        private ParentalControlSettings parentalControlSettings;
        private List<PasswordCredential> passwordCredentials;
        private String passwordCredentialsNextLink;
        private PublicClientApplication publicClient;
        private String publisherDomain;
        private List<RequiredResourceAccess> requiredResourceAccess;
        private String requiredResourceAccessNextLink;
        private String signInAudience;
        private List<String> tags;
        private String tagsNextLink;
        private String tokenEncryptionKeyId;
        private WebApplication web;
        private OnPremisesPublishing onPremisesPublishing;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder deletedDateTime(OffsetDateTime deletedDateTime) {
            this.deletedDateTime = deletedDateTime;
            this.changedFields = changedFields.add("deletedDateTime");
            return this;
        }

        public Builder api(ApiApplication api) {
            this.api = api;
            this.changedFields = changedFields.add("api");
            return this;
        }

        public Builder appId(String appId) {
            this.appId = appId;
            this.changedFields = changedFields.add("appId");
            return this;
        }

        public Builder appRoles(List<AppRole> appRoles) {
            this.appRoles = appRoles;
            this.changedFields = changedFields.add("appRoles");
            return this;
        }

        public Builder appRoles(AppRole... appRoles) {
            return appRoles(Arrays.asList(appRoles));
        }

        public Builder appRolesNextLink(String appRolesNextLink) {
            this.appRolesNextLink = appRolesNextLink;
            this.changedFields = changedFields.add("appRoles");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder isFallbackPublicClient(Boolean isFallbackPublicClient) {
            this.isFallbackPublicClient = isFallbackPublicClient;
            this.changedFields = changedFields.add("isFallbackPublicClient");
            return this;
        }

        public Builder identifierUris(List<String> identifierUris) {
            this.identifierUris = identifierUris;
            this.changedFields = changedFields.add("identifierUris");
            return this;
        }

        public Builder identifierUris(String... identifierUris) {
            return identifierUris(Arrays.asList(identifierUris));
        }

        public Builder identifierUrisNextLink(String identifierUrisNextLink) {
            this.identifierUrisNextLink = identifierUrisNextLink;
            this.changedFields = changedFields.add("identifierUris");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder groupMembershipClaims(String groupMembershipClaims) {
            this.groupMembershipClaims = groupMembershipClaims;
            this.changedFields = changedFields.add("groupMembershipClaims");
            return this;
        }

        public Builder info(InformationalUrl info) {
            this.info = info;
            this.changedFields = changedFields.add("info");
            return this;
        }

        public Builder isDeviceOnlyAuthSupported(Boolean isDeviceOnlyAuthSupported) {
            this.isDeviceOnlyAuthSupported = isDeviceOnlyAuthSupported;
            this.changedFields = changedFields.add("isDeviceOnlyAuthSupported");
            return this;
        }

        public Builder keyCredentials(List<KeyCredential> keyCredentials) {
            this.keyCredentials = keyCredentials;
            this.changedFields = changedFields.add("keyCredentials");
            return this;
        }

        public Builder keyCredentials(KeyCredential... keyCredentials) {
            return keyCredentials(Arrays.asList(keyCredentials));
        }

        public Builder keyCredentialsNextLink(String keyCredentialsNextLink) {
            this.keyCredentialsNextLink = keyCredentialsNextLink;
            this.changedFields = changedFields.add("keyCredentials");
            return this;
        }

        public Builder logo(String logo) {
            this.logo = logo;
            this.changedFields = changedFields.add("logo");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder optionalClaims(OptionalClaims optionalClaims) {
            this.optionalClaims = optionalClaims;
            this.changedFields = changedFields.add("optionalClaims");
            return this;
        }

        public Builder parentalControlSettings(ParentalControlSettings parentalControlSettings) {
            this.parentalControlSettings = parentalControlSettings;
            this.changedFields = changedFields.add("parentalControlSettings");
            return this;
        }

        public Builder passwordCredentials(List<PasswordCredential> passwordCredentials) {
            this.passwordCredentials = passwordCredentials;
            this.changedFields = changedFields.add("passwordCredentials");
            return this;
        }

        public Builder passwordCredentials(PasswordCredential... passwordCredentials) {
            return passwordCredentials(Arrays.asList(passwordCredentials));
        }

        public Builder passwordCredentialsNextLink(String passwordCredentialsNextLink) {
            this.passwordCredentialsNextLink = passwordCredentialsNextLink;
            this.changedFields = changedFields.add("passwordCredentials");
            return this;
        }

        public Builder publicClient(PublicClientApplication publicClient) {
            this.publicClient = publicClient;
            this.changedFields = changedFields.add("publicClient");
            return this;
        }

        public Builder publisherDomain(String publisherDomain) {
            this.publisherDomain = publisherDomain;
            this.changedFields = changedFields.add("publisherDomain");
            return this;
        }

        public Builder requiredResourceAccess(List<RequiredResourceAccess> requiredResourceAccess) {
            this.requiredResourceAccess = requiredResourceAccess;
            this.changedFields = changedFields.add("requiredResourceAccess");
            return this;
        }

        public Builder requiredResourceAccess(RequiredResourceAccess... requiredResourceAccess) {
            return requiredResourceAccess(Arrays.asList(requiredResourceAccess));
        }

        public Builder requiredResourceAccessNextLink(String requiredResourceAccessNextLink) {
            this.requiredResourceAccessNextLink = requiredResourceAccessNextLink;
            this.changedFields = changedFields.add("requiredResourceAccess");
            return this;
        }

        public Builder signInAudience(String signInAudience) {
            this.signInAudience = signInAudience;
            this.changedFields = changedFields.add("signInAudience");
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags = tags;
            this.changedFields = changedFields.add("tags");
            return this;
        }

        public Builder tags(String... tags) {
            return tags(Arrays.asList(tags));
        }

        public Builder tagsNextLink(String tagsNextLink) {
            this.tagsNextLink = tagsNextLink;
            this.changedFields = changedFields.add("tags");
            return this;
        }

        public Builder tokenEncryptionKeyId(String tokenEncryptionKeyId) {
            this.tokenEncryptionKeyId = tokenEncryptionKeyId;
            this.changedFields = changedFields.add("tokenEncryptionKeyId");
            return this;
        }

        public Builder web(WebApplication web) {
            this.web = web;
            this.changedFields = changedFields.add("web");
            return this;
        }

        public Builder onPremisesPublishing(OnPremisesPublishing onPremisesPublishing) {
            this.onPremisesPublishing = onPremisesPublishing;
            this.changedFields = changedFields.add("onPremisesPublishing");
            return this;
        }

        public Application build() {
            Application _x = new Application();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.application";
            _x.id = id;
            _x.deletedDateTime = deletedDateTime;
            _x.api = api;
            _x.appId = appId;
            _x.appRoles = appRoles;
            _x.appRolesNextLink = appRolesNextLink;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.isFallbackPublicClient = isFallbackPublicClient;
            _x.identifierUris = identifierUris;
            _x.identifierUrisNextLink = identifierUrisNextLink;
            _x.displayName = displayName;
            _x.groupMembershipClaims = groupMembershipClaims;
            _x.info = info;
            _x.isDeviceOnlyAuthSupported = isDeviceOnlyAuthSupported;
            _x.keyCredentials = keyCredentials;
            _x.keyCredentialsNextLink = keyCredentialsNextLink;
            _x.logo = logo;
            _x.notes = notes;
            _x.optionalClaims = optionalClaims;
            _x.parentalControlSettings = parentalControlSettings;
            _x.passwordCredentials = passwordCredentials;
            _x.passwordCredentialsNextLink = passwordCredentialsNextLink;
            _x.publicClient = publicClient;
            _x.publisherDomain = publisherDomain;
            _x.requiredResourceAccess = requiredResourceAccess;
            _x.requiredResourceAccessNextLink = requiredResourceAccessNextLink;
            _x.signInAudience = signInAudience;
            _x.tags = tags;
            _x.tagsNextLink = tagsNextLink;
            _x.tokenEncryptionKeyId = tokenEncryptionKeyId;
            _x.web = web;
            _x.onPremisesPublishing = onPremisesPublishing;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="api")
    @JsonIgnore
    public Optional<ApiApplication> getApi() {
        return Optional.ofNullable(api);
    }

    public Application withApi(ApiApplication api) {
        Application _x = _copy();
        _x.changedFields = changedFields.add("api");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.application");
        _x.api = api;
        return _x;
    }

    @Property(name="appId")
    @JsonIgnore
    public Optional<String> getAppId() {
        return Optional.ofNullable(appId);
    }

    public Application withAppId(String appId) {
        Application _x = _copy();
        _x.changedFields = changedFields.add("appId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.application");
        _x.appId = appId;
        return _x;
    }

    @Property(name="appRoles")
    @JsonIgnore
    public CollectionPage<AppRole> getAppRoles() {
        return new CollectionPage<AppRole>(contextPath, AppRole.class, appRoles, Optional.ofNullable(appRolesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="appRoles")
    @JsonIgnore
    public CollectionPage<AppRole> getAppRoles(HttpRequestOptions options) {
        return new CollectionPage<AppRole>(contextPath, AppRole.class, appRoles, Optional.ofNullable(appRolesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public Application withCreatedDateTime(OffsetDateTime createdDateTime) {
        Application _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.application");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Application withDescription(String description) {
        Application _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.application");
        _x.description = description;
        return _x;
    }

    @Property(name="isFallbackPublicClient")
    @JsonIgnore
    public Optional<Boolean> getIsFallbackPublicClient() {
        return Optional.ofNullable(isFallbackPublicClient);
    }

    public Application withIsFallbackPublicClient(Boolean isFallbackPublicClient) {
        Application _x = _copy();
        _x.changedFields = changedFields.add("isFallbackPublicClient");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.application");
        _x.isFallbackPublicClient = isFallbackPublicClient;
        return _x;
    }

    @Property(name="identifierUris")
    @JsonIgnore
    public CollectionPage<String> getIdentifierUris() {
        return new CollectionPage<String>(contextPath, String.class, identifierUris, Optional.ofNullable(identifierUrisNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="identifierUris")
    @JsonIgnore
    public CollectionPage<String> getIdentifierUris(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, identifierUris, Optional.ofNullable(identifierUrisNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Application withDisplayName(String displayName) {
        Application _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.application");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="groupMembershipClaims")
    @JsonIgnore
    public Optional<String> getGroupMembershipClaims() {
        return Optional.ofNullable(groupMembershipClaims);
    }

    public Application withGroupMembershipClaims(String groupMembershipClaims) {
        Application _x = _copy();
        _x.changedFields = changedFields.add("groupMembershipClaims");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.application");
        _x.groupMembershipClaims = groupMembershipClaims;
        return _x;
    }

    @Property(name="info")
    @JsonIgnore
    public Optional<InformationalUrl> getInfo() {
        return Optional.ofNullable(info);
    }

    public Application withInfo(InformationalUrl info) {
        Application _x = _copy();
        _x.changedFields = changedFields.add("info");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.application");
        _x.info = info;
        return _x;
    }

    @Property(name="isDeviceOnlyAuthSupported")
    @JsonIgnore
    public Optional<Boolean> getIsDeviceOnlyAuthSupported() {
        return Optional.ofNullable(isDeviceOnlyAuthSupported);
    }

    public Application withIsDeviceOnlyAuthSupported(Boolean isDeviceOnlyAuthSupported) {
        Application _x = _copy();
        _x.changedFields = changedFields.add("isDeviceOnlyAuthSupported");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.application");
        _x.isDeviceOnlyAuthSupported = isDeviceOnlyAuthSupported;
        return _x;
    }

    @Property(name="keyCredentials")
    @JsonIgnore
    public CollectionPage<KeyCredential> getKeyCredentials() {
        return new CollectionPage<KeyCredential>(contextPath, KeyCredential.class, keyCredentials, Optional.ofNullable(keyCredentialsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="keyCredentials")
    @JsonIgnore
    public CollectionPage<KeyCredential> getKeyCredentials(HttpRequestOptions options) {
        return new CollectionPage<KeyCredential>(contextPath, KeyCredential.class, keyCredentials, Optional.ofNullable(keyCredentialsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="logo")
    @JsonIgnore
    public Optional<StreamProvider> getLogo() {
        return RequestHelper.createStreamForEdmStream(contextPath, this, "logo", logo);
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploader} which can be used to upload the stream
     * to the {@code logo} property.
     *
     * @return a StreamUploader if upload permitted
     */
    @Property(name="logo")
    public Optional<StreamUploaderSingleCall> putLogo() {
        return putLogo(UploadStrategy.singleCall());
    }

    /**
     * If metadata indicate that the stream is editable then returns
     * a {@link StreamUploaderChunked} which can be used to upload the stream
     * to the {@code logo} property.
     *
     * @return a StreamUploaderChunked if upload permitted
     */
    @Property(name="logo")
    public Optional<StreamUploaderChunked> putChunkedLogo() {
        return putLogo(UploadStrategy.chunked());
    }

    @Property(name="logo")
    public <T extends StreamUploader<T>> Optional<T> putLogo(UploadStrategy<T> strategy) {
        return strategy.builder(contextPath.addSegment("logo"), this, "logo");
    }

    @Property(name="notes")
    @JsonIgnore
    public Optional<String> getNotes() {
        return Optional.ofNullable(notes);
    }

    public Application withNotes(String notes) {
        Application _x = _copy();
        _x.changedFields = changedFields.add("notes");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.application");
        _x.notes = notes;
        return _x;
    }

    @Property(name="optionalClaims")
    @JsonIgnore
    public Optional<OptionalClaims> getOptionalClaims() {
        return Optional.ofNullable(optionalClaims);
    }

    public Application withOptionalClaims(OptionalClaims optionalClaims) {
        Application _x = _copy();
        _x.changedFields = changedFields.add("optionalClaims");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.application");
        _x.optionalClaims = optionalClaims;
        return _x;
    }

    @Property(name="parentalControlSettings")
    @JsonIgnore
    public Optional<ParentalControlSettings> getParentalControlSettings() {
        return Optional.ofNullable(parentalControlSettings);
    }

    public Application withParentalControlSettings(ParentalControlSettings parentalControlSettings) {
        Application _x = _copy();
        _x.changedFields = changedFields.add("parentalControlSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.application");
        _x.parentalControlSettings = parentalControlSettings;
        return _x;
    }

    @Property(name="passwordCredentials")
    @JsonIgnore
    public CollectionPage<PasswordCredential> getPasswordCredentials() {
        return new CollectionPage<PasswordCredential>(contextPath, PasswordCredential.class, passwordCredentials, Optional.ofNullable(passwordCredentialsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="passwordCredentials")
    @JsonIgnore
    public CollectionPage<PasswordCredential> getPasswordCredentials(HttpRequestOptions options) {
        return new CollectionPage<PasswordCredential>(contextPath, PasswordCredential.class, passwordCredentials, Optional.ofNullable(passwordCredentialsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="publicClient")
    @JsonIgnore
    public Optional<PublicClientApplication> getPublicClient() {
        return Optional.ofNullable(publicClient);
    }

    public Application withPublicClient(PublicClientApplication publicClient) {
        Application _x = _copy();
        _x.changedFields = changedFields.add("publicClient");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.application");
        _x.publicClient = publicClient;
        return _x;
    }

    @Property(name="publisherDomain")
    @JsonIgnore
    public Optional<String> getPublisherDomain() {
        return Optional.ofNullable(publisherDomain);
    }

    public Application withPublisherDomain(String publisherDomain) {
        Application _x = _copy();
        _x.changedFields = changedFields.add("publisherDomain");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.application");
        _x.publisherDomain = publisherDomain;
        return _x;
    }

    @Property(name="requiredResourceAccess")
    @JsonIgnore
    public CollectionPage<RequiredResourceAccess> getRequiredResourceAccess() {
        return new CollectionPage<RequiredResourceAccess>(contextPath, RequiredResourceAccess.class, requiredResourceAccess, Optional.ofNullable(requiredResourceAccessNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="requiredResourceAccess")
    @JsonIgnore
    public CollectionPage<RequiredResourceAccess> getRequiredResourceAccess(HttpRequestOptions options) {
        return new CollectionPage<RequiredResourceAccess>(contextPath, RequiredResourceAccess.class, requiredResourceAccess, Optional.ofNullable(requiredResourceAccessNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="signInAudience")
    @JsonIgnore
    public Optional<String> getSignInAudience() {
        return Optional.ofNullable(signInAudience);
    }

    public Application withSignInAudience(String signInAudience) {
        Application _x = _copy();
        _x.changedFields = changedFields.add("signInAudience");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.application");
        _x.signInAudience = signInAudience;
        return _x;
    }

    @Property(name="tags")
    @JsonIgnore
    public CollectionPage<String> getTags() {
        return new CollectionPage<String>(contextPath, String.class, tags, Optional.ofNullable(tagsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="tags")
    @JsonIgnore
    public CollectionPage<String> getTags(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, tags, Optional.ofNullable(tagsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="tokenEncryptionKeyId")
    @JsonIgnore
    public Optional<String> getTokenEncryptionKeyId() {
        return Optional.ofNullable(tokenEncryptionKeyId);
    }

    public Application withTokenEncryptionKeyId(String tokenEncryptionKeyId) {
        Application _x = _copy();
        _x.changedFields = changedFields.add("tokenEncryptionKeyId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.application");
        _x.tokenEncryptionKeyId = tokenEncryptionKeyId;
        return _x;
    }

    @Property(name="web")
    @JsonIgnore
    public Optional<WebApplication> getWeb() {
        return Optional.ofNullable(web);
    }

    public Application withWeb(WebApplication web) {
        Application _x = _copy();
        _x.changedFields = changedFields.add("web");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.application");
        _x.web = web;
        return _x;
    }

    @Property(name="onPremisesPublishing")
    @JsonIgnore
    public Optional<OnPremisesPublishing> getOnPremisesPublishing() {
        return Optional.ofNullable(onPremisesPublishing);
    }

    public Application withOnPremisesPublishing(OnPremisesPublishing onPremisesPublishing) {
        Application _x = _copy();
        _x.changedFields = changedFields.add("onPremisesPublishing");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.application");
        _x.onPremisesPublishing = onPremisesPublishing;
        return _x;
    }

    @NavigationProperty(name="extensionProperties")
    @JsonIgnore
    public ExtensionPropertyCollectionRequest getExtensionProperties() {
        return new ExtensionPropertyCollectionRequest(
                        contextPath.addSegment("extensionProperties"));
    }

    @NavigationProperty(name="createdOnBehalfOf")
    @JsonIgnore
    public DirectoryObjectRequest getCreatedOnBehalfOf() {
        return new DirectoryObjectRequest(contextPath.addSegment("createdOnBehalfOf"));
    }

    @NavigationProperty(name="owners")
    @JsonIgnore
    public DirectoryObjectCollectionRequest getOwners() {
        return new DirectoryObjectCollectionRequest(
                        contextPath.addSegment("owners"));
    }

    @NavigationProperty(name="homeRealmDiscoveryPolicies")
    @JsonIgnore
    public HomeRealmDiscoveryPolicyCollectionRequest getHomeRealmDiscoveryPolicies() {
        return new HomeRealmDiscoveryPolicyCollectionRequest(
                        contextPath.addSegment("homeRealmDiscoveryPolicies"));
    }

    @NavigationProperty(name="tokenIssuancePolicies")
    @JsonIgnore
    public TokenIssuancePolicyCollectionRequest getTokenIssuancePolicies() {
        return new TokenIssuancePolicyCollectionRequest(
                        contextPath.addSegment("tokenIssuancePolicies"));
    }

    @NavigationProperty(name="tokenLifetimePolicies")
    @JsonIgnore
    public TokenLifetimePolicyCollectionRequest getTokenLifetimePolicies() {
        return new TokenLifetimePolicyCollectionRequest(
                        contextPath.addSegment("tokenLifetimePolicies"));
    }

    @NavigationProperty(name="connectorGroup")
    @JsonIgnore
    public ConnectorGroupRequest getConnectorGroup() {
        return new ConnectorGroupRequest(contextPath.addSegment("connectorGroup"));
    }

    @NavigationProperty(name="synchronization")
    @JsonIgnore
    public SynchronizationRequest getSynchronization() {
        return new SynchronizationRequest(contextPath.addSegment("synchronization"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Application patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Application _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Application put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Application _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Application _copy() {
        Application _x = new Application();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.deletedDateTime = deletedDateTime;
        _x.api = api;
        _x.appId = appId;
        _x.appRoles = appRoles;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.isFallbackPublicClient = isFallbackPublicClient;
        _x.identifierUris = identifierUris;
        _x.displayName = displayName;
        _x.groupMembershipClaims = groupMembershipClaims;
        _x.info = info;
        _x.isDeviceOnlyAuthSupported = isDeviceOnlyAuthSupported;
        _x.keyCredentials = keyCredentials;
        _x.logo = logo;
        _x.notes = notes;
        _x.optionalClaims = optionalClaims;
        _x.parentalControlSettings = parentalControlSettings;
        _x.passwordCredentials = passwordCredentials;
        _x.publicClient = publicClient;
        _x.publisherDomain = publisherDomain;
        _x.requiredResourceAccess = requiredResourceAccess;
        _x.signInAudience = signInAudience;
        _x.tags = tags;
        _x.tokenEncryptionKeyId = tokenEncryptionKeyId;
        _x.web = web;
        _x.onPremisesPublishing = onPremisesPublishing;
        return _x;
    }

    @Action(name = "addKey")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<KeyCredential> addKey(KeyCredential keyCredential, PasswordCredential passwordCredential, String proof) {
        Preconditions.checkNotNull(keyCredential, "keyCredential cannot be null");
        Preconditions.checkNotNull(proof, "proof cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("keyCredential", "microsoft.graph.keyCredential", keyCredential)
            .put("passwordCredential", "microsoft.graph.passwordCredential", passwordCredential)
            .put("proof", "Edm.String", Checks.checkIsAscii(proof))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<KeyCredential>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.addKey"), KeyCredential.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "addPassword")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<PasswordCredential> addPassword(PasswordCredential passwordCredential) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("passwordCredential", "microsoft.graph.passwordCredential", passwordCredential)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<PasswordCredential>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.addPassword"), PasswordCredential.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "removeKey")
    @JsonIgnore
    public ActionRequestNoReturn removeKey(String keyId, String proof) {
        Preconditions.checkNotNull(keyId, "keyId cannot be null");
        Preconditions.checkNotNull(proof, "proof cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("keyId", "Edm.Guid", keyId)
            .put("proof", "Edm.String", Checks.checkIsAscii(proof))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.removeKey"), _parameters);
    }

    @Action(name = "removePassword")
    @JsonIgnore
    public ActionRequestNoReturn removePassword(String keyId) {
        Preconditions.checkNotNull(keyId, "keyId cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("keyId", "Edm.Guid", keyId)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.removePassword"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Application[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deletedDateTime=");
        b.append(this.deletedDateTime);
        b.append(", ");
        b.append("api=");
        b.append(this.api);
        b.append(", ");
        b.append("appId=");
        b.append(this.appId);
        b.append(", ");
        b.append("appRoles=");
        b.append(this.appRoles);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("isFallbackPublicClient=");
        b.append(this.isFallbackPublicClient);
        b.append(", ");
        b.append("identifierUris=");
        b.append(this.identifierUris);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("groupMembershipClaims=");
        b.append(this.groupMembershipClaims);
        b.append(", ");
        b.append("info=");
        b.append(this.info);
        b.append(", ");
        b.append("isDeviceOnlyAuthSupported=");
        b.append(this.isDeviceOnlyAuthSupported);
        b.append(", ");
        b.append("keyCredentials=");
        b.append(this.keyCredentials);
        b.append(", ");
        b.append("logo=");
        b.append(this.logo);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("optionalClaims=");
        b.append(this.optionalClaims);
        b.append(", ");
        b.append("parentalControlSettings=");
        b.append(this.parentalControlSettings);
        b.append(", ");
        b.append("passwordCredentials=");
        b.append(this.passwordCredentials);
        b.append(", ");
        b.append("publicClient=");
        b.append(this.publicClient);
        b.append(", ");
        b.append("publisherDomain=");
        b.append(this.publisherDomain);
        b.append(", ");
        b.append("requiredResourceAccess=");
        b.append(this.requiredResourceAccess);
        b.append(", ");
        b.append("signInAudience=");
        b.append(this.signInAudience);
        b.append(", ");
        b.append("tags=");
        b.append(this.tags);
        b.append(", ");
        b.append("tokenEncryptionKeyId=");
        b.append(this.tokenEncryptionKeyId);
        b.append(", ");
        b.append("web=");
        b.append(this.web);
        b.append(", ");
        b.append("onPremisesPublishing=");
        b.append(this.onPremisesPublishing);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
