package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementTroubleshootingErrorDetails;
import odata.msgraph.client.beta.complex.KeyValuePair;


/**
 * <i>“Event representing an Apple Vpp Token Troubleshooting Event.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "tokenId"})
@JsonInclude(Include.NON_NULL)
public class AppleVppTokenTroubleshootingEvent extends DeviceManagementTroubleshootingEvent implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.appleVppTokenTroubleshootingEvent";
    }

    @JsonProperty("tokenId")
    protected String tokenId;

    protected AppleVppTokenTroubleshootingEvent() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAppleVppTokenTroubleshootingEvent() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime eventDateTime;
        private String correlationId;
        private DeviceManagementTroubleshootingErrorDetails troubleshootingErrorDetails;
        private String eventName;
        private List<KeyValuePair> additionalInformation;
        private String additionalInformationNextLink;
        private String tokenId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder eventDateTime(OffsetDateTime eventDateTime) {
            this.eventDateTime = eventDateTime;
            this.changedFields = changedFields.add("eventDateTime");
            return this;
        }

        public Builder correlationId(String correlationId) {
            this.correlationId = correlationId;
            this.changedFields = changedFields.add("correlationId");
            return this;
        }

        public Builder troubleshootingErrorDetails(DeviceManagementTroubleshootingErrorDetails troubleshootingErrorDetails) {
            this.troubleshootingErrorDetails = troubleshootingErrorDetails;
            this.changedFields = changedFields.add("troubleshootingErrorDetails");
            return this;
        }

        public Builder eventName(String eventName) {
            this.eventName = eventName;
            this.changedFields = changedFields.add("eventName");
            return this;
        }

        public Builder additionalInformation(List<KeyValuePair> additionalInformation) {
            this.additionalInformation = additionalInformation;
            this.changedFields = changedFields.add("additionalInformation");
            return this;
        }

        public Builder additionalInformation(KeyValuePair... additionalInformation) {
            return additionalInformation(Arrays.asList(additionalInformation));
        }

        public Builder additionalInformationNextLink(String additionalInformationNextLink) {
            this.additionalInformationNextLink = additionalInformationNextLink;
            this.changedFields = changedFields.add("additionalInformation");
            return this;
        }

        /**
         * <i>“Apple Volume Purchase Program Token Identifier.”</i>
         * 
         * @param tokenId
         *            value of {@code tokenId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tokenId(String tokenId) {
            this.tokenId = tokenId;
            this.changedFields = changedFields.add("tokenId");
            return this;
        }

        public AppleVppTokenTroubleshootingEvent build() {
            AppleVppTokenTroubleshootingEvent _x = new AppleVppTokenTroubleshootingEvent();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.appleVppTokenTroubleshootingEvent";
            _x.id = id;
            _x.eventDateTime = eventDateTime;
            _x.correlationId = correlationId;
            _x.troubleshootingErrorDetails = troubleshootingErrorDetails;
            _x.eventName = eventName;
            _x.additionalInformation = additionalInformation;
            _x.additionalInformationNextLink = additionalInformationNextLink;
            _x.tokenId = tokenId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Apple Volume Purchase Program Token Identifier.”</i>
     * 
     * @return property tokenId
     */
    @Property(name="tokenId")
    @JsonIgnore
    public Optional<String> getTokenId() {
        return Optional.ofNullable(tokenId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code tokenId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Apple Volume Purchase Program Token Identifier.”</i>
     * 
     * @param tokenId
     *            new value of {@code tokenId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tokenId} field changed
     */
    public AppleVppTokenTroubleshootingEvent withTokenId(String tokenId) {
        AppleVppTokenTroubleshootingEvent _x = _copy();
        _x.changedFields = changedFields.add("tokenId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleVppTokenTroubleshootingEvent");
        _x.tokenId = tokenId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AppleVppTokenTroubleshootingEvent patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AppleVppTokenTroubleshootingEvent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AppleVppTokenTroubleshootingEvent put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AppleVppTokenTroubleshootingEvent _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AppleVppTokenTroubleshootingEvent _copy() {
        AppleVppTokenTroubleshootingEvent _x = new AppleVppTokenTroubleshootingEvent();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.eventDateTime = eventDateTime;
        _x.correlationId = correlationId;
        _x.troubleshootingErrorDetails = troubleshootingErrorDetails;
        _x.eventName = eventName;
        _x.additionalInformation = additionalInformation;
        _x.tokenId = tokenId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppleVppTokenTroubleshootingEvent[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("eventDateTime=");
        b.append(this.eventDateTime);
        b.append(", ");
        b.append("correlationId=");
        b.append(this.correlationId);
        b.append(", ");
        b.append("troubleshootingErrorDetails=");
        b.append(this.troubleshootingErrorDetails);
        b.append(", ");
        b.append("eventName=");
        b.append(this.eventName);
        b.append(", ");
        b.append("additionalInformation=");
        b.append(this.additionalInformation);
        b.append(", ");
        b.append("tokenId=");
        b.append(this.tokenId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
