package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.KeyValue;
import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.complex.VpnOnDemandRule;
import odata.msgraph.client.beta.complex.VpnProxyServer;
import odata.msgraph.client.beta.complex.VpnServer;
import odata.msgraph.client.beta.enums.AppleVpnConnectionType;
import odata.msgraph.client.beta.enums.VpnAuthenticationMethod;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Apple VPN configuration profile.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "connectionName", 
    "connectionType", 
    "loginGroupOrDomain", 
    "role", 
    "realm", 
    "server", 
    "identifier", 
    "customData", 
    "customKeyValueData", 
    "enableSplitTunneling", 
    "authenticationMethod", 
    "enablePerApp", 
    "safariDomains", 
    "onDemandRules", 
    "proxyServer", 
    "optInToDeviceIdSharing"})
@JsonInclude(Include.NON_NULL)
public class AppleVpnConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.appleVpnConfiguration";
    }

    @JsonProperty("connectionName")
    protected String connectionName;

    @JsonProperty("connectionType")
    protected AppleVpnConnectionType connectionType;

    @JsonProperty("loginGroupOrDomain")
    protected String loginGroupOrDomain;

    @JsonProperty("role")
    protected String role;

    @JsonProperty("realm")
    protected String realm;

    @JsonProperty("server")
    protected VpnServer server;

    @JsonProperty("identifier")
    protected String identifier;

    @JsonProperty("customData")
    protected List<KeyValue> customData;

    @JsonProperty("customData@nextLink")
    protected String customDataNextLink;

    @JsonProperty("customKeyValueData")
    protected List<KeyValuePair> customKeyValueData;

    @JsonProperty("customKeyValueData@nextLink")
    protected String customKeyValueDataNextLink;

    @JsonProperty("enableSplitTunneling")
    protected Boolean enableSplitTunneling;

    @JsonProperty("authenticationMethod")
    protected VpnAuthenticationMethod authenticationMethod;

    @JsonProperty("enablePerApp")
    protected Boolean enablePerApp;

    @JsonProperty("safariDomains")
    protected List<String> safariDomains;

    @JsonProperty("safariDomains@nextLink")
    protected String safariDomainsNextLink;

    @JsonProperty("onDemandRules")
    protected List<VpnOnDemandRule> onDemandRules;

    @JsonProperty("onDemandRules@nextLink")
    protected String onDemandRulesNextLink;

    @JsonProperty("proxyServer")
    protected VpnProxyServer proxyServer;

    @JsonProperty("optInToDeviceIdSharing")
    protected Boolean optInToDeviceIdSharing;

    protected AppleVpnConfiguration() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Connection name displayed to the user.”</i>
     * 
     * @return property connectionName
     */
    @Property(name="connectionName")
    @JsonIgnore
    public Optional<String> getConnectionName() {
        return Optional.ofNullable(connectionName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code connectionName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Connection name displayed to the user.”</i>
     * 
     * @param connectionName
     *            new value of {@code connectionName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code connectionName} field changed
     */
    public AppleVpnConfiguration withConnectionName(String connectionName) {
        AppleVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("connectionName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleVpnConfiguration");
        _x.connectionName = connectionName;
        return _x;
    }

    /**
     * <i>“Connection type.”</i>
     * 
     * @return property connectionType
     */
    @Property(name="connectionType")
    @JsonIgnore
    public Optional<AppleVpnConnectionType> getConnectionType() {
        return Optional.ofNullable(connectionType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code connectionType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Connection type.”</i>
     * 
     * @param connectionType
     *            new value of {@code connectionType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code connectionType} field changed
     */
    public AppleVpnConfiguration withConnectionType(AppleVpnConnectionType connectionType) {
        AppleVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("connectionType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleVpnConfiguration");
        _x.connectionType = connectionType;
        return _x;
    }

    /**
     * <i>“Login group or domain when connection type is set to Dell SonicWALL Mobile
     * Connection.”</i>
     * 
     * @return property loginGroupOrDomain
     */
    @Property(name="loginGroupOrDomain")
    @JsonIgnore
    public Optional<String> getLoginGroupOrDomain() {
        return Optional.ofNullable(loginGroupOrDomain);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * loginGroupOrDomain} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Login group or domain when connection type is set to Dell SonicWALL Mobile
     * Connection.”</i>
     * 
     * @param loginGroupOrDomain
     *            new value of {@code loginGroupOrDomain} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code loginGroupOrDomain} field changed
     */
    public AppleVpnConfiguration withLoginGroupOrDomain(String loginGroupOrDomain) {
        AppleVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("loginGroupOrDomain");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleVpnConfiguration");
        _x.loginGroupOrDomain = loginGroupOrDomain;
        return _x;
    }

    /**
     * <i>“Role when connection type is set to Pulse Secure.”</i>
     * 
     * @return property role
     */
    @Property(name="role")
    @JsonIgnore
    public Optional<String> getRole() {
        return Optional.ofNullable(role);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code role} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Role when connection type is set to Pulse Secure.”</i>
     * 
     * @param role
     *            new value of {@code role} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code role} field changed
     */
    public AppleVpnConfiguration withRole(String role) {
        AppleVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("role");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleVpnConfiguration");
        _x.role = role;
        return _x;
    }

    /**
     * <i>“Realm when connection type is set to Pulse Secure.”</i>
     * 
     * @return property realm
     */
    @Property(name="realm")
    @JsonIgnore
    public Optional<String> getRealm() {
        return Optional.ofNullable(realm);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code realm} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Realm when connection type is set to Pulse Secure.”</i>
     * 
     * @param realm
     *            new value of {@code realm} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code realm} field changed
     */
    public AppleVpnConfiguration withRealm(String realm) {
        AppleVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("realm");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleVpnConfiguration");
        _x.realm = realm;
        return _x;
    }

    /**
     * <i>“VPN Server on the network. Make sure end users can access this network location.”</i>
     * 
     * @return property server
     */
    @Property(name="server")
    @JsonIgnore
    public Optional<VpnServer> getServer() {
        return Optional.ofNullable(server);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code server} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“VPN Server on the network. Make sure end users can access this network location.”</i>
     * 
     * @param server
     *            new value of {@code server} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code server} field changed
     */
    public AppleVpnConfiguration withServer(VpnServer server) {
        AppleVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("server");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleVpnConfiguration");
        _x.server = server;
        return _x;
    }

    /**
     * <i>“Identifier provided by VPN vendor when connection type is set to Custom VPN. For
     * example: Cisco AnyConnect uses an identifier of the form com.cisco.anyconnect.
     * applevpn.plugin”</i>
     * 
     * @return property identifier
     */
    @Property(name="identifier")
    @JsonIgnore
    public Optional<String> getIdentifier() {
        return Optional.ofNullable(identifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code identifier} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Identifier provided by VPN vendor when connection type is set to Custom VPN. For
     * example: Cisco AnyConnect uses an identifier of the form com.cisco.anyconnect.
     * applevpn.plugin”</i>
     * 
     * @param identifier
     *            new value of {@code identifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code identifier} field changed
     */
    public AppleVpnConfiguration withIdentifier(String identifier) {
        AppleVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("identifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleVpnConfiguration");
        _x.identifier = identifier;
        return _x;
    }

    /**
     * <i>“Custom data when connection type is set to Custom VPN. Use this field to enable
     * functionality not supported by Intune, but available in your VPN solution.
     * Contact your VPN vendor to learn how to add these key/value pairs. This
     * collection can contain a maximum of 25 elements.”</i>
     * 
     * @return property customData
     */
    @Property(name="customData")
    @JsonIgnore
    public CollectionPage<KeyValue> getCustomData() {
        return new CollectionPage<KeyValue>(contextPath, KeyValue.class, customData, Optional.ofNullable(customDataNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Custom data when connection type is set to Custom VPN. Use this field to enable
     * functionality not supported by Intune, but available in your VPN solution.
     * Contact your VPN vendor to learn how to add these key/value pairs. This
     * collection can contain a maximum of 25 elements.”</i>
     * 
     * @return property customData
     */
    @Property(name="customData")
    @JsonIgnore
    public CollectionPage<KeyValue> getCustomData(HttpRequestOptions options) {
        return new CollectionPage<KeyValue>(contextPath, KeyValue.class, customData, Optional.ofNullable(customDataNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Custom data when connection type is set to Custom VPN. Use this field to enable
     * functionality not supported by Intune, but available in your VPN solution.
     * Contact your VPN vendor to learn how to add these key/value pairs. This
     * collection can contain a maximum of 25 elements.”</i>
     * 
     * @return property customKeyValueData
     */
    @Property(name="customKeyValueData")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getCustomKeyValueData() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, customKeyValueData, Optional.ofNullable(customKeyValueDataNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Custom data when connection type is set to Custom VPN. Use this field to enable
     * functionality not supported by Intune, but available in your VPN solution.
     * Contact your VPN vendor to learn how to add these key/value pairs. This
     * collection can contain a maximum of 25 elements.”</i>
     * 
     * @return property customKeyValueData
     */
    @Property(name="customKeyValueData")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getCustomKeyValueData(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, customKeyValueData, Optional.ofNullable(customKeyValueDataNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Send all network traffic through VPN.”</i>
     * 
     * @return property enableSplitTunneling
     */
    @Property(name="enableSplitTunneling")
    @JsonIgnore
    public Optional<Boolean> getEnableSplitTunneling() {
        return Optional.ofNullable(enableSplitTunneling);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enableSplitTunneling} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Send all network traffic through VPN.”</i>
     * 
     * @param enableSplitTunneling
     *            new value of {@code enableSplitTunneling} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enableSplitTunneling} field changed
     */
    public AppleVpnConfiguration withEnableSplitTunneling(Boolean enableSplitTunneling) {
        AppleVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enableSplitTunneling");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleVpnConfiguration");
        _x.enableSplitTunneling = enableSplitTunneling;
        return _x;
    }

    /**
     * <i>“Authentication method for this VPN connection.”</i>
     * 
     * @return property authenticationMethod
     */
    @Property(name="authenticationMethod")
    @JsonIgnore
    public Optional<VpnAuthenticationMethod> getAuthenticationMethod() {
        return Optional.ofNullable(authenticationMethod);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authenticationMethod} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Authentication method for this VPN connection.”</i>
     * 
     * @param authenticationMethod
     *            new value of {@code authenticationMethod} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authenticationMethod} field changed
     */
    public AppleVpnConfiguration withAuthenticationMethod(VpnAuthenticationMethod authenticationMethod) {
        AppleVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authenticationMethod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleVpnConfiguration");
        _x.authenticationMethod = authenticationMethod;
        return _x;
    }

    /**
     * <i>“Setting this to true creates Per-App VPN payload which can later be associated
     * with Apps that can trigger this VPN conneciton on the end user's iOS device.”</i>
     * 
     * @return property enablePerApp
     */
    @Property(name="enablePerApp")
    @JsonIgnore
    public Optional<Boolean> getEnablePerApp() {
        return Optional.ofNullable(enablePerApp);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code enablePerApp}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Setting this to true creates Per-App VPN payload which can later be associated
     * with Apps that can trigger this VPN conneciton on the end user's iOS device.”</i>
     * 
     * @param enablePerApp
     *            new value of {@code enablePerApp} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enablePerApp} field changed
     */
    public AppleVpnConfiguration withEnablePerApp(Boolean enablePerApp) {
        AppleVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enablePerApp");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleVpnConfiguration");
        _x.enablePerApp = enablePerApp;
        return _x;
    }

    /**
     * <i>“Safari domains when this VPN per App setting is enabled. In addition to the apps
     * associated with this VPN, Safari domains specified here will also be able to
     * trigger this VPN connection.”</i>
     * 
     * @return property safariDomains
     */
    @Property(name="safariDomains")
    @JsonIgnore
    public CollectionPage<String> getSafariDomains() {
        return new CollectionPage<String>(contextPath, String.class, safariDomains, Optional.ofNullable(safariDomainsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Safari domains when this VPN per App setting is enabled. In addition to the apps
     * associated with this VPN, Safari domains specified here will also be able to
     * trigger this VPN connection.”</i>
     * 
     * @return property safariDomains
     */
    @Property(name="safariDomains")
    @JsonIgnore
    public CollectionPage<String> getSafariDomains(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, safariDomains, Optional.ofNullable(safariDomainsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“On-Demand Rules. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property onDemandRules
     */
    @Property(name="onDemandRules")
    @JsonIgnore
    public CollectionPage<VpnOnDemandRule> getOnDemandRules() {
        return new CollectionPage<VpnOnDemandRule>(contextPath, VpnOnDemandRule.class, onDemandRules, Optional.ofNullable(onDemandRulesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“On-Demand Rules. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property onDemandRules
     */
    @Property(name="onDemandRules")
    @JsonIgnore
    public CollectionPage<VpnOnDemandRule> getOnDemandRules(HttpRequestOptions options) {
        return new CollectionPage<VpnOnDemandRule>(contextPath, VpnOnDemandRule.class, onDemandRules, Optional.ofNullable(onDemandRulesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Proxy Server.”</i>
     * 
     * @return property proxyServer
     */
    @Property(name="proxyServer")
    @JsonIgnore
    public Optional<VpnProxyServer> getProxyServer() {
        return Optional.ofNullable(proxyServer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code proxyServer}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Proxy Server.”</i>
     * 
     * @param proxyServer
     *            new value of {@code proxyServer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code proxyServer} field changed
     */
    public AppleVpnConfiguration withProxyServer(VpnProxyServer proxyServer) {
        AppleVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("proxyServer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleVpnConfiguration");
        _x.proxyServer = proxyServer;
        return _x;
    }

    /**
     * <i>“Opt-In to sharing the device's Id to third-party vpn clients for use during
     * network access control validation.”</i>
     * 
     * @return property optInToDeviceIdSharing
     */
    @Property(name="optInToDeviceIdSharing")
    @JsonIgnore
    public Optional<Boolean> getOptInToDeviceIdSharing() {
        return Optional.ofNullable(optInToDeviceIdSharing);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * optInToDeviceIdSharing} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Opt-In to sharing the device's Id to third-party vpn clients for use during
     * network access control validation.”</i>
     * 
     * @param optInToDeviceIdSharing
     *            new value of {@code optInToDeviceIdSharing} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code optInToDeviceIdSharing} field changed
     */
    public AppleVpnConfiguration withOptInToDeviceIdSharing(Boolean optInToDeviceIdSharing) {
        AppleVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("optInToDeviceIdSharing");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleVpnConfiguration");
        _x.optInToDeviceIdSharing = optInToDeviceIdSharing;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AppleVpnConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AppleVpnConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AppleVpnConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AppleVpnConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AppleVpnConfiguration _copy() {
        AppleVpnConfiguration _x = new AppleVpnConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.connectionName = connectionName;
        _x.connectionType = connectionType;
        _x.loginGroupOrDomain = loginGroupOrDomain;
        _x.role = role;
        _x.realm = realm;
        _x.server = server;
        _x.identifier = identifier;
        _x.customData = customData;
        _x.customKeyValueData = customKeyValueData;
        _x.enableSplitTunneling = enableSplitTunneling;
        _x.authenticationMethod = authenticationMethod;
        _x.enablePerApp = enablePerApp;
        _x.safariDomains = safariDomains;
        _x.onDemandRules = onDemandRules;
        _x.proxyServer = proxyServer;
        _x.optInToDeviceIdSharing = optInToDeviceIdSharing;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppleVpnConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("connectionName=");
        b.append(this.connectionName);
        b.append(", ");
        b.append("connectionType=");
        b.append(this.connectionType);
        b.append(", ");
        b.append("loginGroupOrDomain=");
        b.append(this.loginGroupOrDomain);
        b.append(", ");
        b.append("role=");
        b.append(this.role);
        b.append(", ");
        b.append("realm=");
        b.append(this.realm);
        b.append(", ");
        b.append("server=");
        b.append(this.server);
        b.append(", ");
        b.append("identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("customData=");
        b.append(this.customData);
        b.append(", ");
        b.append("customKeyValueData=");
        b.append(this.customKeyValueData);
        b.append(", ");
        b.append("enableSplitTunneling=");
        b.append(this.enableSplitTunneling);
        b.append(", ");
        b.append("authenticationMethod=");
        b.append(this.authenticationMethod);
        b.append(", ");
        b.append("enablePerApp=");
        b.append(this.enablePerApp);
        b.append(", ");
        b.append("safariDomains=");
        b.append(this.safariDomains);
        b.append(", ");
        b.append("onDemandRules=");
        b.append(this.onDemandRules);
        b.append(", ");
        b.append("proxyServer=");
        b.append(this.proxyServer);
        b.append(", ");
        b.append("optInToDeviceIdSharing=");
        b.append(this.optInToDeviceIdSharing);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
