package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;


/**
 * <i>“Apple push notification certificate.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "appleIdentifier", 
    "topicIdentifier", 
    "lastModifiedDateTime", 
    "expirationDateTime", 
    "certificateUploadStatus", 
    "certificateUploadFailureReason", 
    "certificateSerialNumber", 
    "certificate"})
@JsonInclude(Include.NON_NULL)
public class ApplePushNotificationCertificate extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.applePushNotificationCertificate";
    }

    @JsonProperty("appleIdentifier")
    protected String appleIdentifier;

    @JsonProperty("topicIdentifier")
    protected String topicIdentifier;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    @JsonProperty("certificateUploadStatus")
    protected String certificateUploadStatus;

    @JsonProperty("certificateUploadFailureReason")
    protected String certificateUploadFailureReason;

    @JsonProperty("certificateSerialNumber")
    protected String certificateSerialNumber;

    @JsonProperty("certificate")
    protected String certificate;

    protected ApplePushNotificationCertificate() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderApplePushNotificationCertificate() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String appleIdentifier;
        private String topicIdentifier;
        private OffsetDateTime lastModifiedDateTime;
        private OffsetDateTime expirationDateTime;
        private String certificateUploadStatus;
        private String certificateUploadFailureReason;
        private String certificateSerialNumber;
        private String certificate;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Apple Id of the account used to create the MDM push certificate.”</i>
         * 
         * @param appleIdentifier
         *            value of {@code appleIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appleIdentifier(String appleIdentifier) {
            this.appleIdentifier = appleIdentifier;
            this.changedFields = changedFields.add("appleIdentifier");
            return this;
        }

        /**
         * <i>“Topic Id.”</i>
         * 
         * @param topicIdentifier
         *            value of {@code topicIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder topicIdentifier(String topicIdentifier) {
            this.topicIdentifier = topicIdentifier;
            this.changedFields = changedFields.add("topicIdentifier");
            return this;
        }

        /**
         * <i>“Last modified date and time for Apple push notification certificate.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“The expiration date and time for Apple push notification certificate.”</i>
         * 
         * @param expirationDateTime
         *            value of {@code expirationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        /**
         * <i>“The certificate upload status.”</i>
         * 
         * @param certificateUploadStatus
         *            value of {@code certificateUploadStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateUploadStatus(String certificateUploadStatus) {
            this.certificateUploadStatus = certificateUploadStatus;
            this.changedFields = changedFields.add("certificateUploadStatus");
            return this;
        }

        /**
         * <i>“The reason the certificate upload failed.”</i>
         * 
         * @param certificateUploadFailureReason
         *            value of {@code certificateUploadFailureReason} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateUploadFailureReason(String certificateUploadFailureReason) {
            this.certificateUploadFailureReason = certificateUploadFailureReason;
            this.changedFields = changedFields.add("certificateUploadFailureReason");
            return this;
        }

        /**
         * <i>“Certificate serial number. This property is read-only.”</i>
         * <p>
         * <b>Org.OData.Core.V1.Computed</b>
         * <p>
         * true
         * <p>
         * <b>Org.OData.Core.V1.Permissions</b>
         * 
         * @param certificateSerialNumber
         *            value of {@code certificateSerialNumber} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateSerialNumber(String certificateSerialNumber) {
            this.certificateSerialNumber = certificateSerialNumber;
            this.changedFields = changedFields.add("certificateSerialNumber");
            return this;
        }

        public Builder certificate(String certificate) {
            this.certificate = certificate;
            this.changedFields = changedFields.add("certificate");
            return this;
        }

        public ApplePushNotificationCertificate build() {
            ApplePushNotificationCertificate _x = new ApplePushNotificationCertificate();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.applePushNotificationCertificate";
            _x.id = id;
            _x.appleIdentifier = appleIdentifier;
            _x.topicIdentifier = topicIdentifier;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.expirationDateTime = expirationDateTime;
            _x.certificateUploadStatus = certificateUploadStatus;
            _x.certificateUploadFailureReason = certificateUploadFailureReason;
            _x.certificateSerialNumber = certificateSerialNumber;
            _x.certificate = certificate;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Apple Id of the account used to create the MDM push certificate.”</i>
     * 
     * @return property appleIdentifier
     */
    @Property(name="appleIdentifier")
    @JsonIgnore
    public Optional<String> getAppleIdentifier() {
        return Optional.ofNullable(appleIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appleIdentifier}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Apple Id of the account used to create the MDM push certificate.”</i>
     * 
     * @param appleIdentifier
     *            new value of {@code appleIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appleIdentifier} field changed
     */
    public ApplePushNotificationCertificate withAppleIdentifier(String appleIdentifier) {
        ApplePushNotificationCertificate _x = _copy();
        _x.changedFields = changedFields.add("appleIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applePushNotificationCertificate");
        _x.appleIdentifier = appleIdentifier;
        return _x;
    }

    /**
     * <i>“Topic Id.”</i>
     * 
     * @return property topicIdentifier
     */
    @Property(name="topicIdentifier")
    @JsonIgnore
    public Optional<String> getTopicIdentifier() {
        return Optional.ofNullable(topicIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code topicIdentifier}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Topic Id.”</i>
     * 
     * @param topicIdentifier
     *            new value of {@code topicIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code topicIdentifier} field changed
     */
    public ApplePushNotificationCertificate withTopicIdentifier(String topicIdentifier) {
        ApplePushNotificationCertificate _x = _copy();
        _x.changedFields = changedFields.add("topicIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applePushNotificationCertificate");
        _x.topicIdentifier = topicIdentifier;
        return _x;
    }

    /**
     * <i>“Last modified date and time for Apple push notification certificate.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last modified date and time for Apple push notification certificate.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public ApplePushNotificationCertificate withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        ApplePushNotificationCertificate _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applePushNotificationCertificate");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“The expiration date and time for Apple push notification certificate.”</i>
     * 
     * @return property expirationDateTime
     */
    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * expirationDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The expiration date and time for Apple push notification certificate.”</i>
     * 
     * @param expirationDateTime
     *            new value of {@code expirationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code expirationDateTime} field changed
     */
    public ApplePushNotificationCertificate withExpirationDateTime(OffsetDateTime expirationDateTime) {
        ApplePushNotificationCertificate _x = _copy();
        _x.changedFields = changedFields.add("expirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applePushNotificationCertificate");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    /**
     * <i>“The certificate upload status.”</i>
     * 
     * @return property certificateUploadStatus
     */
    @Property(name="certificateUploadStatus")
    @JsonIgnore
    public Optional<String> getCertificateUploadStatus() {
        return Optional.ofNullable(certificateUploadStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateUploadStatus} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The certificate upload status.”</i>
     * 
     * @param certificateUploadStatus
     *            new value of {@code certificateUploadStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateUploadStatus} field changed
     */
    public ApplePushNotificationCertificate withCertificateUploadStatus(String certificateUploadStatus) {
        ApplePushNotificationCertificate _x = _copy();
        _x.changedFields = changedFields.add("certificateUploadStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applePushNotificationCertificate");
        _x.certificateUploadStatus = certificateUploadStatus;
        return _x;
    }

    /**
     * <i>“The reason the certificate upload failed.”</i>
     * 
     * @return property certificateUploadFailureReason
     */
    @Property(name="certificateUploadFailureReason")
    @JsonIgnore
    public Optional<String> getCertificateUploadFailureReason() {
        return Optional.ofNullable(certificateUploadFailureReason);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateUploadFailureReason} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“The reason the certificate upload failed.”</i>
     * 
     * @param certificateUploadFailureReason
     *            new value of {@code certificateUploadFailureReason} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateUploadFailureReason} field changed
     */
    public ApplePushNotificationCertificate withCertificateUploadFailureReason(String certificateUploadFailureReason) {
        ApplePushNotificationCertificate _x = _copy();
        _x.changedFields = changedFields.add("certificateUploadFailureReason");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applePushNotificationCertificate");
        _x.certificateUploadFailureReason = certificateUploadFailureReason;
        return _x;
    }

    /**
     * <i>“Certificate serial number. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @return property certificateSerialNumber
     */
    @Property(name="certificateSerialNumber")
    @JsonIgnore
    public Optional<String> getCertificateSerialNumber() {
        return Optional.ofNullable(certificateSerialNumber);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateSerialNumber} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Certificate serial number. This property is read-only.”</i>
     * <p>
     * <b>Org.OData.Core.V1.Computed</b>
     * <p>
     * true
     * <p>
     * <b>Org.OData.Core.V1.Permissions</b>
     * 
     * @param certificateSerialNumber
     *            new value of {@code certificateSerialNumber} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateSerialNumber} field changed
     */
    public ApplePushNotificationCertificate withCertificateSerialNumber(String certificateSerialNumber) {
        ApplePushNotificationCertificate _x = _copy();
        _x.changedFields = changedFields.add("certificateSerialNumber");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applePushNotificationCertificate");
        _x.certificateSerialNumber = certificateSerialNumber;
        return _x;
    }

    @Property(name="certificate")
    @JsonIgnore
    public Optional<String> getCertificate() {
        return Optional.ofNullable(certificate);
    }

    public ApplePushNotificationCertificate withCertificate(String certificate) {
        ApplePushNotificationCertificate _x = _copy();
        _x.changedFields = changedFields.add("certificate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.applePushNotificationCertificate");
        _x.certificate = certificate;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ApplePushNotificationCertificate patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ApplePushNotificationCertificate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ApplePushNotificationCertificate put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ApplePushNotificationCertificate _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ApplePushNotificationCertificate _copy() {
        ApplePushNotificationCertificate _x = new ApplePushNotificationCertificate();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.appleIdentifier = appleIdentifier;
        _x.topicIdentifier = topicIdentifier;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.expirationDateTime = expirationDateTime;
        _x.certificateUploadStatus = certificateUploadStatus;
        _x.certificateUploadFailureReason = certificateUploadFailureReason;
        _x.certificateSerialNumber = certificateSerialNumber;
        _x.certificate = certificate;
        return _x;
    }

    @Action(name = "generateApplePushNotificationCertificateSigningRequest")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> generateApplePushNotificationCertificateSigningRequest() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.generateApplePushNotificationCertificateSigningRequest"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Function(name = "downloadApplePushNotificationCertificateSigningRequest")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<String> downloadApplePushNotificationCertificateSigningRequest() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.downloadApplePushNotificationCertificateSigningRequest"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ApplePushNotificationCertificate[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("appleIdentifier=");
        b.append(this.appleIdentifier);
        b.append(", ");
        b.append("topicIdentifier=");
        b.append(this.topicIdentifier);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append(", ");
        b.append("certificateUploadStatus=");
        b.append(this.certificateUploadStatus);
        b.append(", ");
        b.append("certificateUploadFailureReason=");
        b.append(this.certificateUploadFailureReason);
        b.append(", ");
        b.append("certificateSerialNumber=");
        b.append(this.certificateSerialNumber);
        b.append(", ");
        b.append("certificate=");
        b.append(this.certificate);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
