package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


/**
 * <i>“Experimental profile to increase the rate of device check-ins per day of iOS/
 * macOS devices.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "enableExpeditedCheckin"})
@JsonInclude(Include.NON_NULL)
public class AppleExpeditedCheckinConfigurationBase extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.appleExpeditedCheckinConfigurationBase";
    }

    @JsonProperty("enableExpeditedCheckin")
    protected Boolean enableExpeditedCheckin;

    protected AppleExpeditedCheckinConfigurationBase() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Gets or sets whether to enable expedited device check-ins.”</i>
     * 
     * @return property enableExpeditedCheckin
     */
    @Property(name="enableExpeditedCheckin")
    @JsonIgnore
    public Optional<Boolean> getEnableExpeditedCheckin() {
        return Optional.ofNullable(enableExpeditedCheckin);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enableExpeditedCheckin} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Gets or sets whether to enable expedited device check-ins.”</i>
     * 
     * @param enableExpeditedCheckin
     *            new value of {@code enableExpeditedCheckin} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enableExpeditedCheckin} field changed
     */
    public AppleExpeditedCheckinConfigurationBase withEnableExpeditedCheckin(Boolean enableExpeditedCheckin) {
        AppleExpeditedCheckinConfigurationBase _x = _copy();
        _x.changedFields = changedFields.add("enableExpeditedCheckin");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appleExpeditedCheckinConfigurationBase");
        _x.enableExpeditedCheckin = enableExpeditedCheckin;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AppleExpeditedCheckinConfigurationBase patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AppleExpeditedCheckinConfigurationBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AppleExpeditedCheckinConfigurationBase put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AppleExpeditedCheckinConfigurationBase _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AppleExpeditedCheckinConfigurationBase _copy() {
        AppleExpeditedCheckinConfigurationBase _x = new AppleExpeditedCheckinConfigurationBase();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.enableExpeditedCheckin = enableExpeditedCheckin;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppleExpeditedCheckinConfigurationBase[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("enableExpeditedCheckin=");
        b.append(this.enableExpeditedCheckin);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
