package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.AppVulnerabilityManagedDeviceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AppVulnerabilityMobileAppCollectionRequest;
import odata.msgraph.client.beta.enums.AppVulnerabilityTaskMitigationType;
import odata.msgraph.client.beta.enums.DeviceAppManagementTaskCategory;
import odata.msgraph.client.beta.enums.DeviceAppManagementTaskPriority;
import odata.msgraph.client.beta.enums.DeviceAppManagementTaskStatus;


/**
 * <i>“An app vulnerability task.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "appName", 
    "appPublisher", 
    "appVersion", 
    "mitigationType", 
    "insights", 
    "managedDeviceCount", 
    "mobileAppCount", 
    "remediation"})
@JsonInclude(Include.NON_NULL)
public class AppVulnerabilityTask extends DeviceAppManagementTask implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.appVulnerabilityTask";
    }

    @JsonProperty("appName")
    protected String appName;

    @JsonProperty("appPublisher")
    protected String appPublisher;

    @JsonProperty("appVersion")
    protected String appVersion;

    @JsonProperty("mitigationType")
    protected AppVulnerabilityTaskMitigationType mitigationType;

    @JsonProperty("insights")
    protected String insights;

    @JsonProperty("managedDeviceCount")
    protected Integer managedDeviceCount;

    @JsonProperty("mobileAppCount")
    protected Integer mobileAppCount;

    @JsonProperty("remediation")
    protected String remediation;

    protected AppVulnerabilityTask() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAppVulnerabilityTask() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime dueDateTime;
        private DeviceAppManagementTaskCategory category;
        private DeviceAppManagementTaskPriority priority;
        private String creator;
        private String creatorNotes;
        private String assignedTo;
        private DeviceAppManagementTaskStatus status;
        private String appName;
        private String appPublisher;
        private String appVersion;
        private AppVulnerabilityTaskMitigationType mitigationType;
        private String insights;
        private Integer managedDeviceCount;
        private Integer mobileAppCount;
        private String remediation;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder dueDateTime(OffsetDateTime dueDateTime) {
            this.dueDateTime = dueDateTime;
            this.changedFields = changedFields.add("dueDateTime");
            return this;
        }

        public Builder category(DeviceAppManagementTaskCategory category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        public Builder priority(DeviceAppManagementTaskPriority priority) {
            this.priority = priority;
            this.changedFields = changedFields.add("priority");
            return this;
        }

        public Builder creator(String creator) {
            this.creator = creator;
            this.changedFields = changedFields.add("creator");
            return this;
        }

        public Builder creatorNotes(String creatorNotes) {
            this.creatorNotes = creatorNotes;
            this.changedFields = changedFields.add("creatorNotes");
            return this;
        }

        public Builder assignedTo(String assignedTo) {
            this.assignedTo = assignedTo;
            this.changedFields = changedFields.add("assignedTo");
            return this;
        }

        public Builder status(DeviceAppManagementTaskStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        /**
         * <i>“The app name.”</i>
         * 
         * @param appName
         *            value of {@code appName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appName(String appName) {
            this.appName = appName;
            this.changedFields = changedFields.add("appName");
            return this;
        }

        /**
         * <i>“The app publisher.”</i>
         * 
         * @param appPublisher
         *            value of {@code appPublisher} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appPublisher(String appPublisher) {
            this.appPublisher = appPublisher;
            this.changedFields = changedFields.add("appPublisher");
            return this;
        }

        /**
         * <i>“The app version.”</i>
         * 
         * @param appVersion
         *            value of {@code appVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appVersion(String appVersion) {
            this.appVersion = appVersion;
            this.changedFields = changedFields.add("appVersion");
            return this;
        }

        /**
         * <i>“The mitigation type.”</i>
         * 
         * @param mitigationType
         *            value of {@code mitigationType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mitigationType(AppVulnerabilityTaskMitigationType mitigationType) {
            this.mitigationType = mitigationType;
            this.changedFields = changedFields.add("mitigationType");
            return this;
        }

        /**
         * <i>“Information about the mitigation.”</i>
         * 
         * @param insights
         *            value of {@code insights} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder insights(String insights) {
            this.insights = insights;
            this.changedFields = changedFields.add("insights");
            return this;
        }

        /**
         * <i>“The number of vulnerable devices.”</i>
         * 
         * @param managedDeviceCount
         *            value of {@code managedDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder managedDeviceCount(Integer managedDeviceCount) {
            this.managedDeviceCount = managedDeviceCount;
            this.changedFields = changedFields.add("managedDeviceCount");
            return this;
        }

        /**
         * <i>“The number of vulnerable mobile apps.”</i>
         * 
         * @param mobileAppCount
         *            value of {@code mobileAppCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileAppCount(Integer mobileAppCount) {
            this.mobileAppCount = mobileAppCount;
            this.changedFields = changedFields.add("mobileAppCount");
            return this;
        }

        /**
         * <i>“The remediation steps.”</i>
         * 
         * @param remediation
         *            value of {@code remediation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder remediation(String remediation) {
            this.remediation = remediation;
            this.changedFields = changedFields.add("remediation");
            return this;
        }

        public AppVulnerabilityTask build() {
            AppVulnerabilityTask _x = new AppVulnerabilityTask();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.appVulnerabilityTask";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.createdDateTime = createdDateTime;
            _x.dueDateTime = dueDateTime;
            _x.category = category;
            _x.priority = priority;
            _x.creator = creator;
            _x.creatorNotes = creatorNotes;
            _x.assignedTo = assignedTo;
            _x.status = status;
            _x.appName = appName;
            _x.appPublisher = appPublisher;
            _x.appVersion = appVersion;
            _x.mitigationType = mitigationType;
            _x.insights = insights;
            _x.managedDeviceCount = managedDeviceCount;
            _x.mobileAppCount = mobileAppCount;
            _x.remediation = remediation;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The app name.”</i>
     * 
     * @return property appName
     */
    @Property(name="appName")
    @JsonIgnore
    public Optional<String> getAppName() {
        return Optional.ofNullable(appName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appName} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The app name.”</i>
     * 
     * @param appName
     *            new value of {@code appName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appName} field changed
     */
    public AppVulnerabilityTask withAppName(String appName) {
        AppVulnerabilityTask _x = _copy();
        _x.changedFields = changedFields.add("appName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appVulnerabilityTask");
        _x.appName = appName;
        return _x;
    }

    /**
     * <i>“The app publisher.”</i>
     * 
     * @return property appPublisher
     */
    @Property(name="appPublisher")
    @JsonIgnore
    public Optional<String> getAppPublisher() {
        return Optional.ofNullable(appPublisher);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appPublisher}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The app publisher.”</i>
     * 
     * @param appPublisher
     *            new value of {@code appPublisher} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appPublisher} field changed
     */
    public AppVulnerabilityTask withAppPublisher(String appPublisher) {
        AppVulnerabilityTask _x = _copy();
        _x.changedFields = changedFields.add("appPublisher");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appVulnerabilityTask");
        _x.appPublisher = appPublisher;
        return _x;
    }

    /**
     * <i>“The app version.”</i>
     * 
     * @return property appVersion
     */
    @Property(name="appVersion")
    @JsonIgnore
    public Optional<String> getAppVersion() {
        return Optional.ofNullable(appVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code appVersion} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The app version.”</i>
     * 
     * @param appVersion
     *            new value of {@code appVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appVersion} field changed
     */
    public AppVulnerabilityTask withAppVersion(String appVersion) {
        AppVulnerabilityTask _x = _copy();
        _x.changedFields = changedFields.add("appVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appVulnerabilityTask");
        _x.appVersion = appVersion;
        return _x;
    }

    /**
     * <i>“The mitigation type.”</i>
     * 
     * @return property mitigationType
     */
    @Property(name="mitigationType")
    @JsonIgnore
    public Optional<AppVulnerabilityTaskMitigationType> getMitigationType() {
        return Optional.ofNullable(mitigationType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code mitigationType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The mitigation type.”</i>
     * 
     * @param mitigationType
     *            new value of {@code mitigationType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mitigationType} field changed
     */
    public AppVulnerabilityTask withMitigationType(AppVulnerabilityTaskMitigationType mitigationType) {
        AppVulnerabilityTask _x = _copy();
        _x.changedFields = changedFields.add("mitigationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appVulnerabilityTask");
        _x.mitigationType = mitigationType;
        return _x;
    }

    /**
     * <i>“Information about the mitigation.”</i>
     * 
     * @return property insights
     */
    @Property(name="insights")
    @JsonIgnore
    public Optional<String> getInsights() {
        return Optional.ofNullable(insights);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code insights} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Information about the mitigation.”</i>
     * 
     * @param insights
     *            new value of {@code insights} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code insights} field changed
     */
    public AppVulnerabilityTask withInsights(String insights) {
        AppVulnerabilityTask _x = _copy();
        _x.changedFields = changedFields.add("insights");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appVulnerabilityTask");
        _x.insights = insights;
        return _x;
    }

    /**
     * <i>“The number of vulnerable devices.”</i>
     * 
     * @return property managedDeviceCount
     */
    @Property(name="managedDeviceCount")
    @JsonIgnore
    public Optional<Integer> getManagedDeviceCount() {
        return Optional.ofNullable(managedDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * managedDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The number of vulnerable devices.”</i>
     * 
     * @param managedDeviceCount
     *            new value of {@code managedDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code managedDeviceCount} field changed
     */
    public AppVulnerabilityTask withManagedDeviceCount(Integer managedDeviceCount) {
        AppVulnerabilityTask _x = _copy();
        _x.changedFields = changedFields.add("managedDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appVulnerabilityTask");
        _x.managedDeviceCount = managedDeviceCount;
        return _x;
    }

    /**
     * <i>“The number of vulnerable mobile apps.”</i>
     * 
     * @return property mobileAppCount
     */
    @Property(name="mobileAppCount")
    @JsonIgnore
    public Optional<Integer> getMobileAppCount() {
        return Optional.ofNullable(mobileAppCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code mobileAppCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The number of vulnerable mobile apps.”</i>
     * 
     * @param mobileAppCount
     *            new value of {@code mobileAppCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mobileAppCount} field changed
     */
    public AppVulnerabilityTask withMobileAppCount(Integer mobileAppCount) {
        AppVulnerabilityTask _x = _copy();
        _x.changedFields = changedFields.add("mobileAppCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appVulnerabilityTask");
        _x.mobileAppCount = mobileAppCount;
        return _x;
    }

    /**
     * <i>“The remediation steps.”</i>
     * 
     * @return property remediation
     */
    @Property(name="remediation")
    @JsonIgnore
    public Optional<String> getRemediation() {
        return Optional.ofNullable(remediation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code remediation}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The remediation steps.”</i>
     * 
     * @param remediation
     *            new value of {@code remediation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code remediation} field changed
     */
    public AppVulnerabilityTask withRemediation(String remediation) {
        AppVulnerabilityTask _x = _copy();
        _x.changedFields = changedFields.add("remediation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appVulnerabilityTask");
        _x.remediation = remediation;
        return _x;
    }

    /**
     * <i>“The vulnerable managed devices.”</i>
     * 
     * @return navigational property managedDevices
     */
    @NavigationProperty(name="managedDevices")
    @JsonIgnore
    public AppVulnerabilityManagedDeviceCollectionRequest getManagedDevices() {
        return new AppVulnerabilityManagedDeviceCollectionRequest(
                        contextPath.addSegment("managedDevices"));
    }

    /**
     * <i>“The vulnerable mobile apps.”</i>
     * 
     * @return navigational property mobileApps
     */
    @NavigationProperty(name="mobileApps")
    @JsonIgnore
    public AppVulnerabilityMobileAppCollectionRequest getMobileApps() {
        return new AppVulnerabilityMobileAppCollectionRequest(
                        contextPath.addSegment("mobileApps"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AppVulnerabilityTask patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AppVulnerabilityTask _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AppVulnerabilityTask put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AppVulnerabilityTask _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AppVulnerabilityTask _copy() {
        AppVulnerabilityTask _x = new AppVulnerabilityTask();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.createdDateTime = createdDateTime;
        _x.dueDateTime = dueDateTime;
        _x.category = category;
        _x.priority = priority;
        _x.creator = creator;
        _x.creatorNotes = creatorNotes;
        _x.assignedTo = assignedTo;
        _x.status = status;
        _x.appName = appName;
        _x.appPublisher = appPublisher;
        _x.appVersion = appVersion;
        _x.mitigationType = mitigationType;
        _x.insights = insights;
        _x.managedDeviceCount = managedDeviceCount;
        _x.mobileAppCount = mobileAppCount;
        _x.remediation = remediation;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppVulnerabilityTask[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("dueDateTime=");
        b.append(this.dueDateTime);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("priority=");
        b.append(this.priority);
        b.append(", ");
        b.append("creator=");
        b.append(this.creator);
        b.append(", ");
        b.append("creatorNotes=");
        b.append(this.creatorNotes);
        b.append(", ");
        b.append("assignedTo=");
        b.append(this.assignedTo);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("appName=");
        b.append(this.appName);
        b.append(", ");
        b.append("appPublisher=");
        b.append(this.appPublisher);
        b.append(", ");
        b.append("appVersion=");
        b.append(this.appVersion);
        b.append(", ");
        b.append("mitigationType=");
        b.append(this.mitigationType);
        b.append(", ");
        b.append("insights=");
        b.append(this.insights);
        b.append(", ");
        b.append("managedDeviceCount=");
        b.append(this.managedDeviceCount);
        b.append(", ");
        b.append("mobileAppCount=");
        b.append(this.mobileAppCount);
        b.append(", ");
        b.append("remediation=");
        b.append(this.remediation);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
