package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <i>“An app vulnerability mobile app.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "mobileAppId", 
    "displayName", 
    "createdDateTime", 
    "lastModifiedDateTime", 
    "mobileAppType", 
    "version"})
@JsonInclude(Include.NON_NULL)
public class AppVulnerabilityMobileApp extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.appVulnerabilityMobileApp";
    }

    @JsonProperty("mobileAppId")
    protected String mobileAppId;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("mobileAppType")
    protected String mobileAppType;

    @JsonProperty("version")
    protected String version;

    protected AppVulnerabilityMobileApp() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAppVulnerabilityMobileApp() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String mobileAppId;
        private String displayName;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private String mobileAppType;
        private String version;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“The Intune mobile app ID.”</i>
         * 
         * @param mobileAppId
         *            value of {@code mobileAppId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileAppId(String mobileAppId) {
            this.mobileAppId = mobileAppId;
            this.changedFields = changedFields.add("mobileAppId");
            return this;
        }

        /**
         * <i>“The device name.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“The created date.”</i>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“The last modified date.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“The app type.”</i>
         * 
         * @param mobileAppType
         *            value of {@code mobileAppType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder mobileAppType(String mobileAppType) {
            this.mobileAppType = mobileAppType;
            this.changedFields = changedFields.add("mobileAppType");
            return this;
        }

        /**
         * <i>“The app version.”</i>
         * 
         * @param version
         *            value of {@code version} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public AppVulnerabilityMobileApp build() {
            AppVulnerabilityMobileApp _x = new AppVulnerabilityMobileApp();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.appVulnerabilityMobileApp";
            _x.id = id;
            _x.mobileAppId = mobileAppId;
            _x.displayName = displayName;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.mobileAppType = mobileAppType;
            _x.version = version;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“The Intune mobile app ID.”</i>
     * 
     * @return property mobileAppId
     */
    @Property(name="mobileAppId")
    @JsonIgnore
    public Optional<String> getMobileAppId() {
        return Optional.ofNullable(mobileAppId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code mobileAppId}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The Intune mobile app ID.”</i>
     * 
     * @param mobileAppId
     *            new value of {@code mobileAppId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mobileAppId} field changed
     */
    public AppVulnerabilityMobileApp withMobileAppId(String mobileAppId) {
        AppVulnerabilityMobileApp _x = _copy();
        _x.changedFields = changedFields.add("mobileAppId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appVulnerabilityMobileApp");
        _x.mobileAppId = mobileAppId;
        return _x;
    }

    /**
     * <i>“The device name.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The device name.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public AppVulnerabilityMobileApp withDisplayName(String displayName) {
        AppVulnerabilityMobileApp _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appVulnerabilityMobileApp");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“The created date.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The created date.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public AppVulnerabilityMobileApp withCreatedDateTime(OffsetDateTime createdDateTime) {
        AppVulnerabilityMobileApp _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appVulnerabilityMobileApp");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“The last modified date.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“The last modified date.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public AppVulnerabilityMobileApp withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        AppVulnerabilityMobileApp _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appVulnerabilityMobileApp");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“The app type.”</i>
     * 
     * @return property mobileAppType
     */
    @Property(name="mobileAppType")
    @JsonIgnore
    public Optional<String> getMobileAppType() {
        return Optional.ofNullable(mobileAppType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code mobileAppType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The app type.”</i>
     * 
     * @param mobileAppType
     *            new value of {@code mobileAppType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code mobileAppType} field changed
     */
    public AppVulnerabilityMobileApp withMobileAppType(String mobileAppType) {
        AppVulnerabilityMobileApp _x = _copy();
        _x.changedFields = changedFields.add("mobileAppType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appVulnerabilityMobileApp");
        _x.mobileAppType = mobileAppType;
        return _x;
    }

    /**
     * <i>“The app version.”</i>
     * 
     * @return property version
     */
    @Property(name="version")
    @JsonIgnore
    public Optional<String> getVersion() {
        return Optional.ofNullable(version);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code version} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“The app version.”</i>
     * 
     * @param version
     *            new value of {@code version} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code version} field changed
     */
    public AppVulnerabilityMobileApp withVersion(String version) {
        AppVulnerabilityMobileApp _x = _copy();
        _x.changedFields = changedFields.add("version");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appVulnerabilityMobileApp");
        _x.version = version;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AppVulnerabilityMobileApp patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AppVulnerabilityMobileApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AppVulnerabilityMobileApp put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AppVulnerabilityMobileApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AppVulnerabilityMobileApp _copy() {
        AppVulnerabilityMobileApp _x = new AppVulnerabilityMobileApp();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.mobileAppId = mobileAppId;
        _x.displayName = displayName;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.mobileAppType = mobileAppType;
        _x.version = version;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppVulnerabilityMobileApp[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("mobileAppId=");
        b.append(this.mobileAppId);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("mobileAppType=");
        b.append(this.mobileAppType);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
