package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "appRoleId", 
    "creationTimestamp", 
    "principalDisplayName", 
    "principalId", 
    "principalType", 
    "resourceDisplayName", 
    "resourceId"})
@JsonInclude(Include.NON_NULL)
public class AppRoleAssignment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.appRoleAssignment";
    }

    @JsonProperty("appRoleId")
    protected String appRoleId;

    @JsonProperty("creationTimestamp")
    protected OffsetDateTime creationTimestamp;

    @JsonProperty("principalDisplayName")
    protected String principalDisplayName;

    @JsonProperty("principalId")
    protected String principalId;

    @JsonProperty("principalType")
    protected String principalType;

    @JsonProperty("resourceDisplayName")
    protected String resourceDisplayName;

    @JsonProperty("resourceId")
    protected String resourceId;

    protected AppRoleAssignment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAppRoleAssignment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String appRoleId;
        private OffsetDateTime creationTimestamp;
        private String principalDisplayName;
        private String principalId;
        private String principalType;
        private String resourceDisplayName;
        private String resourceId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder appRoleId(String appRoleId) {
            this.appRoleId = appRoleId;
            this.changedFields = changedFields.add("appRoleId");
            return this;
        }

        public Builder creationTimestamp(OffsetDateTime creationTimestamp) {
            this.creationTimestamp = creationTimestamp;
            this.changedFields = changedFields.add("creationTimestamp");
            return this;
        }

        public Builder principalDisplayName(String principalDisplayName) {
            this.principalDisplayName = principalDisplayName;
            this.changedFields = changedFields.add("principalDisplayName");
            return this;
        }

        public Builder principalId(String principalId) {
            this.principalId = principalId;
            this.changedFields = changedFields.add("principalId");
            return this;
        }

        public Builder principalType(String principalType) {
            this.principalType = principalType;
            this.changedFields = changedFields.add("principalType");
            return this;
        }

        public Builder resourceDisplayName(String resourceDisplayName) {
            this.resourceDisplayName = resourceDisplayName;
            this.changedFields = changedFields.add("resourceDisplayName");
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.changedFields = changedFields.add("resourceId");
            return this;
        }

        public AppRoleAssignment build() {
            AppRoleAssignment _x = new AppRoleAssignment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.appRoleAssignment";
            _x.id = id;
            _x.appRoleId = appRoleId;
            _x.creationTimestamp = creationTimestamp;
            _x.principalDisplayName = principalDisplayName;
            _x.principalId = principalId;
            _x.principalType = principalType;
            _x.resourceDisplayName = resourceDisplayName;
            _x.resourceId = resourceId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="appRoleId")
    @JsonIgnore
    public Optional<String> getAppRoleId() {
        return Optional.ofNullable(appRoleId);
    }

    public AppRoleAssignment withAppRoleId(String appRoleId) {
        AppRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("appRoleId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appRoleAssignment");
        _x.appRoleId = appRoleId;
        return _x;
    }

    @Property(name="creationTimestamp")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreationTimestamp() {
        return Optional.ofNullable(creationTimestamp);
    }

    public AppRoleAssignment withCreationTimestamp(OffsetDateTime creationTimestamp) {
        AppRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("creationTimestamp");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appRoleAssignment");
        _x.creationTimestamp = creationTimestamp;
        return _x;
    }

    @Property(name="principalDisplayName")
    @JsonIgnore
    public Optional<String> getPrincipalDisplayName() {
        return Optional.ofNullable(principalDisplayName);
    }

    public AppRoleAssignment withPrincipalDisplayName(String principalDisplayName) {
        AppRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("principalDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appRoleAssignment");
        _x.principalDisplayName = principalDisplayName;
        return _x;
    }

    @Property(name="principalId")
    @JsonIgnore
    public Optional<String> getPrincipalId() {
        return Optional.ofNullable(principalId);
    }

    public AppRoleAssignment withPrincipalId(String principalId) {
        AppRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("principalId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appRoleAssignment");
        _x.principalId = principalId;
        return _x;
    }

    @Property(name="principalType")
    @JsonIgnore
    public Optional<String> getPrincipalType() {
        return Optional.ofNullable(principalType);
    }

    public AppRoleAssignment withPrincipalType(String principalType) {
        AppRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("principalType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appRoleAssignment");
        _x.principalType = principalType;
        return _x;
    }

    @Property(name="resourceDisplayName")
    @JsonIgnore
    public Optional<String> getResourceDisplayName() {
        return Optional.ofNullable(resourceDisplayName);
    }

    public AppRoleAssignment withResourceDisplayName(String resourceDisplayName) {
        AppRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("resourceDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appRoleAssignment");
        _x.resourceDisplayName = resourceDisplayName;
        return _x;
    }

    @Property(name="resourceId")
    @JsonIgnore
    public Optional<String> getResourceId() {
        return Optional.ofNullable(resourceId);
    }

    public AppRoleAssignment withResourceId(String resourceId) {
        AppRoleAssignment _x = _copy();
        _x.changedFields = changedFields.add("resourceId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appRoleAssignment");
        _x.resourceId = resourceId;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AppRoleAssignment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AppRoleAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AppRoleAssignment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AppRoleAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AppRoleAssignment _copy() {
        AppRoleAssignment _x = new AppRoleAssignment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.appRoleId = appRoleId;
        _x.creationTimestamp = creationTimestamp;
        _x.principalDisplayName = principalDisplayName;
        _x.principalId = principalId;
        _x.principalType = principalType;
        _x.resourceDisplayName = resourceDisplayName;
        _x.resourceId = resourceId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppRoleAssignment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("appRoleId=");
        b.append(this.appRoleId);
        b.append(", ");
        b.append("creationTimestamp=");
        b.append(this.creationTimestamp);
        b.append(", ");
        b.append("principalDisplayName=");
        b.append(this.principalDisplayName);
        b.append(", ");
        b.append("principalId=");
        b.append(this.principalId);
        b.append(", ");
        b.append("principalType=");
        b.append(this.principalType);
        b.append(", ");
        b.append("resourceDisplayName=");
        b.append(this.resourceDisplayName);
        b.append(", ");
        b.append("resourceId=");
        b.append(this.resourceId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
