package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AppLogCollectionDownloadDetails;
import odata.msgraph.client.beta.enums.AppLogUploadState;


/**
 * <i>“AppLogCollectionRequest Entity.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "status", 
    "errorMessage", 
    "customLogFolders", 
    "completedDateTime"})
@JsonInclude(Include.NON_NULL)
public class AppLogCollectionRequest extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.appLogCollectionRequest";
    }

    @JsonProperty("status")
    protected AppLogUploadState status;

    @JsonProperty("errorMessage")
    protected String errorMessage;

    @JsonProperty("customLogFolders")
    protected List<String> customLogFolders;

    @JsonProperty("customLogFolders@nextLink")
    protected String customLogFoldersNextLink;

    @JsonProperty("completedDateTime")
    protected OffsetDateTime completedDateTime;

    protected AppLogCollectionRequest() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAppLogCollectionRequest() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private AppLogUploadState status;
        private String errorMessage;
        private List<String> customLogFolders;
        private String customLogFoldersNextLink;
        private OffsetDateTime completedDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Log upload status”</i>
         * 
         * @param status
         *            value of {@code status} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder status(AppLogUploadState status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        /**
         * <i>“Error message if any during the upload process”</i>
         * 
         * @param errorMessage
         *            value of {@code errorMessage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            this.changedFields = changedFields.add("errorMessage");
            return this;
        }

        /**
         * <i>“List of log folders.”</i>
         * 
         * @param customLogFolders
         *            value of {@code customLogFolders} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customLogFolders(List<String> customLogFolders) {
            this.customLogFolders = customLogFolders;
            this.changedFields = changedFields.add("customLogFolders");
            return this;
        }

        /**
         * <i>“List of log folders.”</i>
         * 
         * @param customLogFolders
         *            value of {@code customLogFolders} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customLogFolders(String... customLogFolders) {
            return customLogFolders(Arrays.asList(customLogFolders));
        }

        /**
         * <i>“List of log folders.”</i>
         * 
         * @param customLogFoldersNextLink
         *            value of {@code customLogFolders@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customLogFoldersNextLink(String customLogFoldersNextLink) {
            this.customLogFoldersNextLink = customLogFoldersNextLink;
            this.changedFields = changedFields.add("customLogFolders");
            return this;
        }

        /**
         * <i>“Time at which the upload log request reached a terminal state”</i>
         * 
         * @param completedDateTime
         *            value of {@code completedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder completedDateTime(OffsetDateTime completedDateTime) {
            this.completedDateTime = completedDateTime;
            this.changedFields = changedFields.add("completedDateTime");
            return this;
        }

        public AppLogCollectionRequest build() {
            AppLogCollectionRequest _x = new AppLogCollectionRequest();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.appLogCollectionRequest";
            _x.id = id;
            _x.status = status;
            _x.errorMessage = errorMessage;
            _x.customLogFolders = customLogFolders;
            _x.customLogFoldersNextLink = customLogFoldersNextLink;
            _x.completedDateTime = completedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Log upload status”</i>
     * 
     * @return property status
     */
    @Property(name="status")
    @JsonIgnore
    public Optional<AppLogUploadState> getStatus() {
        return Optional.ofNullable(status);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code status} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Log upload status”</i>
     * 
     * @param status
     *            new value of {@code status} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code status} field changed
     */
    public AppLogCollectionRequest withStatus(AppLogUploadState status) {
        AppLogCollectionRequest _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appLogCollectionRequest");
        _x.status = status;
        return _x;
    }

    /**
     * <i>“Error message if any during the upload process”</i>
     * 
     * @return property errorMessage
     */
    @Property(name="errorMessage")
    @JsonIgnore
    public Optional<String> getErrorMessage() {
        return Optional.ofNullable(errorMessage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code errorMessage}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Error message if any during the upload process”</i>
     * 
     * @param errorMessage
     *            new value of {@code errorMessage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code errorMessage} field changed
     */
    public AppLogCollectionRequest withErrorMessage(String errorMessage) {
        AppLogCollectionRequest _x = _copy();
        _x.changedFields = changedFields.add("errorMessage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appLogCollectionRequest");
        _x.errorMessage = errorMessage;
        return _x;
    }

    /**
     * <i>“List of log folders.”</i>
     * 
     * @return property customLogFolders
     */
    @Property(name="customLogFolders")
    @JsonIgnore
    public CollectionPage<String> getCustomLogFolders() {
        return new CollectionPage<String>(contextPath, String.class, customLogFolders, Optional.ofNullable(customLogFoldersNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of log folders.”</i>
     * 
     * @return property customLogFolders
     */
    @Property(name="customLogFolders")
    @JsonIgnore
    public CollectionPage<String> getCustomLogFolders(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, customLogFolders, Optional.ofNullable(customLogFoldersNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Time at which the upload log request reached a terminal state”</i>
     * 
     * @return property completedDateTime
     */
    @Property(name="completedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedDateTime() {
        return Optional.ofNullable(completedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code completedDateTime
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Time at which the upload log request reached a terminal state”</i>
     * 
     * @param completedDateTime
     *            new value of {@code completedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code completedDateTime} field changed
     */
    public AppLogCollectionRequest withCompletedDateTime(OffsetDateTime completedDateTime) {
        AppLogCollectionRequest _x = _copy();
        _x.changedFields = changedFields.add("completedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appLogCollectionRequest");
        _x.completedDateTime = completedDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AppLogCollectionRequest patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AppLogCollectionRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AppLogCollectionRequest put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AppLogCollectionRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AppLogCollectionRequest _copy() {
        AppLogCollectionRequest _x = new AppLogCollectionRequest();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.status = status;
        _x.errorMessage = errorMessage;
        _x.customLogFolders = customLogFolders;
        _x.completedDateTime = completedDateTime;
        return _x;
    }

    @Action(name = "createDownloadUrl")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<AppLogCollectionDownloadDetails> createDownloadUrl() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestReturningNonCollectionUnwrapped<AppLogCollectionDownloadDetails>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createDownloadUrl"), AppLogCollectionDownloadDetails.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppLogCollectionRequest[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("errorMessage=");
        b.append(this.errorMessage);
        b.append(", ");
        b.append("customLogFolders=");
        b.append(this.customLogFolders);
        b.append(", ");
        b.append("completedDateTime=");
        b.append(this.completedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
