package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AppConsentRequestScope;
import odata.msgraph.client.beta.entity.collection.request.UserConsentRequestCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "appId", 
    "appDisplayName", 
    "consentType", 
    "pendingScopes"})
@JsonInclude(Include.NON_NULL)
public class AppConsentRequest extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.appConsentRequest";
    }

    @JsonProperty("appId")
    protected String appId;

    @JsonProperty("appDisplayName")
    protected String appDisplayName;

    @JsonProperty("consentType")
    protected String consentType;

    @JsonProperty("pendingScopes")
    protected List<AppConsentRequestScope> pendingScopes;

    @JsonProperty("pendingScopes@nextLink")
    protected String pendingScopesNextLink;

    protected AppConsentRequest() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAppConsentRequest() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String appId;
        private String appDisplayName;
        private String consentType;
        private List<AppConsentRequestScope> pendingScopes;
        private String pendingScopesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder appId(String appId) {
            this.appId = appId;
            this.changedFields = changedFields.add("appId");
            return this;
        }

        public Builder appDisplayName(String appDisplayName) {
            this.appDisplayName = appDisplayName;
            this.changedFields = changedFields.add("appDisplayName");
            return this;
        }

        public Builder consentType(String consentType) {
            this.consentType = consentType;
            this.changedFields = changedFields.add("consentType");
            return this;
        }

        public Builder pendingScopes(List<AppConsentRequestScope> pendingScopes) {
            this.pendingScopes = pendingScopes;
            this.changedFields = changedFields.add("pendingScopes");
            return this;
        }

        public Builder pendingScopes(AppConsentRequestScope... pendingScopes) {
            return pendingScopes(Arrays.asList(pendingScopes));
        }

        public Builder pendingScopesNextLink(String pendingScopesNextLink) {
            this.pendingScopesNextLink = pendingScopesNextLink;
            this.changedFields = changedFields.add("pendingScopes");
            return this;
        }

        public AppConsentRequest build() {
            AppConsentRequest _x = new AppConsentRequest();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.appConsentRequest";
            _x.id = id;
            _x.appId = appId;
            _x.appDisplayName = appDisplayName;
            _x.consentType = consentType;
            _x.pendingScopes = pendingScopes;
            _x.pendingScopesNextLink = pendingScopesNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="appId")
    @JsonIgnore
    public Optional<String> getAppId() {
        return Optional.ofNullable(appId);
    }

    public AppConsentRequest withAppId(String appId) {
        AppConsentRequest _x = _copy();
        _x.changedFields = changedFields.add("appId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appConsentRequest");
        _x.appId = appId;
        return _x;
    }

    @Property(name="appDisplayName")
    @JsonIgnore
    public Optional<String> getAppDisplayName() {
        return Optional.ofNullable(appDisplayName);
    }

    public AppConsentRequest withAppDisplayName(String appDisplayName) {
        AppConsentRequest _x = _copy();
        _x.changedFields = changedFields.add("appDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appConsentRequest");
        _x.appDisplayName = appDisplayName;
        return _x;
    }

    @Property(name="consentType")
    @JsonIgnore
    public Optional<String> getConsentType() {
        return Optional.ofNullable(consentType);
    }

    public AppConsentRequest withConsentType(String consentType) {
        AppConsentRequest _x = _copy();
        _x.changedFields = changedFields.add("consentType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.appConsentRequest");
        _x.consentType = consentType;
        return _x;
    }

    @Property(name="pendingScopes")
    @JsonIgnore
    public CollectionPage<AppConsentRequestScope> getPendingScopes() {
        return new CollectionPage<AppConsentRequestScope>(contextPath, AppConsentRequestScope.class, pendingScopes, Optional.ofNullable(pendingScopesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="pendingScopes")
    @JsonIgnore
    public CollectionPage<AppConsentRequestScope> getPendingScopes(HttpRequestOptions options) {
        return new CollectionPage<AppConsentRequestScope>(contextPath, AppConsentRequestScope.class, pendingScopes, Optional.ofNullable(pendingScopesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @NavigationProperty(name="userConsentRequests")
    @JsonIgnore
    public UserConsentRequestCollectionRequest getUserConsentRequests() {
        return new UserConsentRequestCollectionRequest(
                        contextPath.addSegment("userConsentRequests"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AppConsentRequest patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AppConsentRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AppConsentRequest put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AppConsentRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AppConsentRequest _copy() {
        AppConsentRequest _x = new AppConsentRequest();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.appId = appId;
        _x.appDisplayName = appDisplayName;
        _x.consentType = consentType;
        _x.pendingScopes = pendingScopes;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppConsentRequest[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("appId=");
        b.append(this.appId);
        b.append(", ");
        b.append("appDisplayName=");
        b.append(this.appDisplayName);
        b.append(", ");
        b.append("consentType=");
        b.append(this.consentType);
        b.append(", ");
        b.append("pendingScopes=");
        b.append(this.pendingScopes);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
