package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.entity.request.AndroidWorkProfileCertificateProfileBaseRequest;
import odata.msgraph.client.beta.entity.request.AndroidWorkProfileTrustedRootCertificateRequest;
import odata.msgraph.client.beta.enums.AndroidEapType;
import odata.msgraph.client.beta.enums.AndroidWiFiSecurityType;
import odata.msgraph.client.beta.enums.NonEapAuthenticationMethodForEapTtlsType;
import odata.msgraph.client.beta.enums.NonEapAuthenticationMethodForPeap;
import odata.msgraph.client.beta.enums.WiFiAuthenticationMethod;
import odata.msgraph.client.beta.enums.WiFiProxySetting;


/**
 * <i>“By providing the configurations in this profile you can instruct the Android
 * Work Profile device to connect to desired Wi-Fi endpoint. By specifying the
 * authentication method and security types expected by Wi-Fi endpoint you can make
 * the Wi-Fi connection seamless for end user.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "eapType", 
    "authenticationMethod", 
    "innerAuthenticationProtocolForEapTtls", 
    "innerAuthenticationProtocolForPeap", 
    "outerIdentityPrivacyTemporaryValue", 
    "proxySettings", 
    "proxyAutomaticConfigurationUrl"})
@JsonInclude(Include.NON_NULL)
public class AndroidWorkProfileEnterpriseWiFiConfiguration extends AndroidWorkProfileWiFiConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidWorkProfileEnterpriseWiFiConfiguration";
    }

    @JsonProperty("eapType")
    protected AndroidEapType eapType;

    @JsonProperty("authenticationMethod")
    protected WiFiAuthenticationMethod authenticationMethod;

    @JsonProperty("innerAuthenticationProtocolForEapTtls")
    protected NonEapAuthenticationMethodForEapTtlsType innerAuthenticationProtocolForEapTtls;

    @JsonProperty("innerAuthenticationProtocolForPeap")
    protected NonEapAuthenticationMethodForPeap innerAuthenticationProtocolForPeap;

    @JsonProperty("outerIdentityPrivacyTemporaryValue")
    protected String outerIdentityPrivacyTemporaryValue;

    @JsonProperty("proxySettings")
    protected WiFiProxySetting proxySettings;

    @JsonProperty("proxyAutomaticConfigurationUrl")
    protected String proxyAutomaticConfigurationUrl;

    protected AndroidWorkProfileEnterpriseWiFiConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidWorkProfileEnterpriseWiFiConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private String networkName;
        private String ssid;
        private Boolean connectAutomatically;
        private Boolean connectWhenNetworkNameIsHidden;
        private AndroidWiFiSecurityType wiFiSecurityType;
        private AndroidEapType eapType;
        private WiFiAuthenticationMethod authenticationMethod;
        private NonEapAuthenticationMethodForEapTtlsType innerAuthenticationProtocolForEapTtls;
        private NonEapAuthenticationMethodForPeap innerAuthenticationProtocolForPeap;
        private String outerIdentityPrivacyTemporaryValue;
        private WiFiProxySetting proxySettings;
        private String proxyAutomaticConfigurationUrl;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder networkName(String networkName) {
            this.networkName = networkName;
            this.changedFields = changedFields.add("networkName");
            return this;
        }

        public Builder ssid(String ssid) {
            this.ssid = ssid;
            this.changedFields = changedFields.add("ssid");
            return this;
        }

        public Builder connectAutomatically(Boolean connectAutomatically) {
            this.connectAutomatically = connectAutomatically;
            this.changedFields = changedFields.add("connectAutomatically");
            return this;
        }

        public Builder connectWhenNetworkNameIsHidden(Boolean connectWhenNetworkNameIsHidden) {
            this.connectWhenNetworkNameIsHidden = connectWhenNetworkNameIsHidden;
            this.changedFields = changedFields.add("connectWhenNetworkNameIsHidden");
            return this;
        }

        public Builder wiFiSecurityType(AndroidWiFiSecurityType wiFiSecurityType) {
            this.wiFiSecurityType = wiFiSecurityType;
            this.changedFields = changedFields.add("wiFiSecurityType");
            return this;
        }

        /**
         * <i>“Indicates the type of EAP protocol set on the Wi-Fi endpoint (router).”</i>
         * 
         * @param eapType
         *            value of {@code eapType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder eapType(AndroidEapType eapType) {
            this.eapType = eapType;
            this.changedFields = changedFields.add("eapType");
            return this;
        }

        /**
         * <i>“Indicates the Authentication Method the client (device) needs to use when the
         * EAP Type is configured to PEAP or EAP-TTLS.”</i>
         * 
         * @param authenticationMethod
         *            value of {@code authenticationMethod} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authenticationMethod(WiFiAuthenticationMethod authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            this.changedFields = changedFields.add("authenticationMethod");
            return this;
        }

        /**
         * <i>“Non-EAP Method for Authentication (Inner Identity) when EAP Type is EAP-TTLS and
         * Authenticationmethod is Username and Password.”</i>
         * 
         * @param innerAuthenticationProtocolForEapTtls
         *            value of {@code innerAuthenticationProtocolForEapTtls} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder innerAuthenticationProtocolForEapTtls(NonEapAuthenticationMethodForEapTtlsType innerAuthenticationProtocolForEapTtls) {
            this.innerAuthenticationProtocolForEapTtls = innerAuthenticationProtocolForEapTtls;
            this.changedFields = changedFields.add("innerAuthenticationProtocolForEapTtls");
            return this;
        }

        /**
         * <i>“Non-EAP Method for Authentication (Inner Identity) when EAP Type is PEAP and
         * Authenticationmethod is Username and Password.”</i>
         * 
         * @param innerAuthenticationProtocolForPeap
         *            value of {@code innerAuthenticationProtocolForPeap} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder innerAuthenticationProtocolForPeap(NonEapAuthenticationMethodForPeap innerAuthenticationProtocolForPeap) {
            this.innerAuthenticationProtocolForPeap = innerAuthenticationProtocolForPeap;
            this.changedFields = changedFields.add("innerAuthenticationProtocolForPeap");
            return this;
        }

        /**
         * <i>“Enable identity privacy (Outer Identity) when EAP Type is configured to EAP-TTLS
         * or PEAP. The String provided here is used to mask the username of individual
         * users when they attempt to connect to Wi-Fi network.”</i>
         * 
         * @param outerIdentityPrivacyTemporaryValue
         *            value of {@code outerIdentityPrivacyTemporaryValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder outerIdentityPrivacyTemporaryValue(String outerIdentityPrivacyTemporaryValue) {
            this.outerIdentityPrivacyTemporaryValue = outerIdentityPrivacyTemporaryValue;
            this.changedFields = changedFields.add("outerIdentityPrivacyTemporaryValue");
            return this;
        }

        /**
         * <i>“Proxy Type for this Wi-Fi connection”</i>
         * 
         * @param proxySettings
         *            value of {@code proxySettings} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder proxySettings(WiFiProxySetting proxySettings) {
            this.proxySettings = proxySettings;
            this.changedFields = changedFields.add("proxySettings");
            return this;
        }

        /**
         * <i>“URL of the proxy server automatic configuration script when automatic
         * configuration is selected. This URL is typically the location of PAC (Proxy Auto
         * Configuration) file.”</i>
         * 
         * @param proxyAutomaticConfigurationUrl
         *            value of {@code proxyAutomaticConfigurationUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder proxyAutomaticConfigurationUrl(String proxyAutomaticConfigurationUrl) {
            this.proxyAutomaticConfigurationUrl = proxyAutomaticConfigurationUrl;
            this.changedFields = changedFields.add("proxyAutomaticConfigurationUrl");
            return this;
        }

        public AndroidWorkProfileEnterpriseWiFiConfiguration build() {
            AndroidWorkProfileEnterpriseWiFiConfiguration _x = new AndroidWorkProfileEnterpriseWiFiConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.androidWorkProfileEnterpriseWiFiConfiguration";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.networkName = networkName;
            _x.ssid = ssid;
            _x.connectAutomatically = connectAutomatically;
            _x.connectWhenNetworkNameIsHidden = connectWhenNetworkNameIsHidden;
            _x.wiFiSecurityType = wiFiSecurityType;
            _x.eapType = eapType;
            _x.authenticationMethod = authenticationMethod;
            _x.innerAuthenticationProtocolForEapTtls = innerAuthenticationProtocolForEapTtls;
            _x.innerAuthenticationProtocolForPeap = innerAuthenticationProtocolForPeap;
            _x.outerIdentityPrivacyTemporaryValue = outerIdentityPrivacyTemporaryValue;
            _x.proxySettings = proxySettings;
            _x.proxyAutomaticConfigurationUrl = proxyAutomaticConfigurationUrl;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Indicates the type of EAP protocol set on the Wi-Fi endpoint (router).”</i>
     * 
     * @return property eapType
     */
    @Property(name="eapType")
    @JsonIgnore
    public Optional<AndroidEapType> getEapType() {
        return Optional.ofNullable(eapType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code eapType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicates the type of EAP protocol set on the Wi-Fi endpoint (router).”</i>
     * 
     * @param eapType
     *            new value of {@code eapType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code eapType} field changed
     */
    public AndroidWorkProfileEnterpriseWiFiConfiguration withEapType(AndroidEapType eapType) {
        AndroidWorkProfileEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("eapType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidWorkProfileEnterpriseWiFiConfiguration");
        _x.eapType = eapType;
        return _x;
    }

    /**
     * <i>“Indicates the Authentication Method the client (device) needs to use when the
     * EAP Type is configured to PEAP or EAP-TTLS.”</i>
     * 
     * @return property authenticationMethod
     */
    @Property(name="authenticationMethod")
    @JsonIgnore
    public Optional<WiFiAuthenticationMethod> getAuthenticationMethod() {
        return Optional.ofNullable(authenticationMethod);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authenticationMethod} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates the Authentication Method the client (device) needs to use when the
     * EAP Type is configured to PEAP or EAP-TTLS.”</i>
     * 
     * @param authenticationMethod
     *            new value of {@code authenticationMethod} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authenticationMethod} field changed
     */
    public AndroidWorkProfileEnterpriseWiFiConfiguration withAuthenticationMethod(WiFiAuthenticationMethod authenticationMethod) {
        AndroidWorkProfileEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authenticationMethod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidWorkProfileEnterpriseWiFiConfiguration");
        _x.authenticationMethod = authenticationMethod;
        return _x;
    }

    /**
     * <i>“Non-EAP Method for Authentication (Inner Identity) when EAP Type is EAP-TTLS and
     * Authenticationmethod is Username and Password.”</i>
     * 
     * @return property innerAuthenticationProtocolForEapTtls
     */
    @Property(name="innerAuthenticationProtocolForEapTtls")
    @JsonIgnore
    public Optional<NonEapAuthenticationMethodForEapTtlsType> getInnerAuthenticationProtocolForEapTtls() {
        return Optional.ofNullable(innerAuthenticationProtocolForEapTtls);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * innerAuthenticationProtocolForEapTtls} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Non-EAP Method for Authentication (Inner Identity) when EAP Type is EAP-TTLS and
     * Authenticationmethod is Username and Password.”</i>
     * 
     * @param innerAuthenticationProtocolForEapTtls
     *            new value of {@code innerAuthenticationProtocolForEapTtls} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code innerAuthenticationProtocolForEapTtls} field changed
     */
    public AndroidWorkProfileEnterpriseWiFiConfiguration withInnerAuthenticationProtocolForEapTtls(NonEapAuthenticationMethodForEapTtlsType innerAuthenticationProtocolForEapTtls) {
        AndroidWorkProfileEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("innerAuthenticationProtocolForEapTtls");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidWorkProfileEnterpriseWiFiConfiguration");
        _x.innerAuthenticationProtocolForEapTtls = innerAuthenticationProtocolForEapTtls;
        return _x;
    }

    /**
     * <i>“Non-EAP Method for Authentication (Inner Identity) when EAP Type is PEAP and
     * Authenticationmethod is Username and Password.”</i>
     * 
     * @return property innerAuthenticationProtocolForPeap
     */
    @Property(name="innerAuthenticationProtocolForPeap")
    @JsonIgnore
    public Optional<NonEapAuthenticationMethodForPeap> getInnerAuthenticationProtocolForPeap() {
        return Optional.ofNullable(innerAuthenticationProtocolForPeap);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * innerAuthenticationProtocolForPeap} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Non-EAP Method for Authentication (Inner Identity) when EAP Type is PEAP and
     * Authenticationmethod is Username and Password.”</i>
     * 
     * @param innerAuthenticationProtocolForPeap
     *            new value of {@code innerAuthenticationProtocolForPeap} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code innerAuthenticationProtocolForPeap} field changed
     */
    public AndroidWorkProfileEnterpriseWiFiConfiguration withInnerAuthenticationProtocolForPeap(NonEapAuthenticationMethodForPeap innerAuthenticationProtocolForPeap) {
        AndroidWorkProfileEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("innerAuthenticationProtocolForPeap");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidWorkProfileEnterpriseWiFiConfiguration");
        _x.innerAuthenticationProtocolForPeap = innerAuthenticationProtocolForPeap;
        return _x;
    }

    /**
     * <i>“Enable identity privacy (Outer Identity) when EAP Type is configured to EAP-TTLS
     * or PEAP. The String provided here is used to mask the username of individual
     * users when they attempt to connect to Wi-Fi network.”</i>
     * 
     * @return property outerIdentityPrivacyTemporaryValue
     */
    @Property(name="outerIdentityPrivacyTemporaryValue")
    @JsonIgnore
    public Optional<String> getOuterIdentityPrivacyTemporaryValue() {
        return Optional.ofNullable(outerIdentityPrivacyTemporaryValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * outerIdentityPrivacyTemporaryValue} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Enable identity privacy (Outer Identity) when EAP Type is configured to EAP-TTLS
     * or PEAP. The String provided here is used to mask the username of individual
     * users when they attempt to connect to Wi-Fi network.”</i>
     * 
     * @param outerIdentityPrivacyTemporaryValue
     *            new value of {@code outerIdentityPrivacyTemporaryValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code outerIdentityPrivacyTemporaryValue} field changed
     */
    public AndroidWorkProfileEnterpriseWiFiConfiguration withOuterIdentityPrivacyTemporaryValue(String outerIdentityPrivacyTemporaryValue) {
        AndroidWorkProfileEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("outerIdentityPrivacyTemporaryValue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidWorkProfileEnterpriseWiFiConfiguration");
        _x.outerIdentityPrivacyTemporaryValue = outerIdentityPrivacyTemporaryValue;
        return _x;
    }

    /**
     * <i>“Proxy Type for this Wi-Fi connection”</i>
     * 
     * @return property proxySettings
     */
    @Property(name="proxySettings")
    @JsonIgnore
    public Optional<WiFiProxySetting> getProxySettings() {
        return Optional.ofNullable(proxySettings);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code proxySettings}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Proxy Type for this Wi-Fi connection”</i>
     * 
     * @param proxySettings
     *            new value of {@code proxySettings} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code proxySettings} field changed
     */
    public AndroidWorkProfileEnterpriseWiFiConfiguration withProxySettings(WiFiProxySetting proxySettings) {
        AndroidWorkProfileEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("proxySettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidWorkProfileEnterpriseWiFiConfiguration");
        _x.proxySettings = proxySettings;
        return _x;
    }

    /**
     * <i>“URL of the proxy server automatic configuration script when automatic
     * configuration is selected. This URL is typically the location of PAC (Proxy Auto
     * Configuration) file.”</i>
     * 
     * @return property proxyAutomaticConfigurationUrl
     */
    @Property(name="proxyAutomaticConfigurationUrl")
    @JsonIgnore
    public Optional<String> getProxyAutomaticConfigurationUrl() {
        return Optional.ofNullable(proxyAutomaticConfigurationUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * proxyAutomaticConfigurationUrl} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“URL of the proxy server automatic configuration script when automatic
     * configuration is selected. This URL is typically the location of PAC (Proxy Auto
     * Configuration) file.”</i>
     * 
     * @param proxyAutomaticConfigurationUrl
     *            new value of {@code proxyAutomaticConfigurationUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code proxyAutomaticConfigurationUrl} field changed
     */
    public AndroidWorkProfileEnterpriseWiFiConfiguration withProxyAutomaticConfigurationUrl(String proxyAutomaticConfigurationUrl) {
        AndroidWorkProfileEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("proxyAutomaticConfigurationUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidWorkProfileEnterpriseWiFiConfiguration");
        _x.proxyAutomaticConfigurationUrl = proxyAutomaticConfigurationUrl;
        return _x;
    }

    /**
     * <i>“Trusted Root Certificate for Server Validation when EAP Type is configured to
     * EAP-TLS, EAP-TTLS or PEAP. This is the certificate presented by the Wi-Fi
     * endpoint when the device attempts to connect to Wi-Fi endpoint. The device (or
     * user) must accept this certificate to continue the connection attempt.”</i>
     * 
     * @return navigational property rootCertificateForServerValidation
     */
    @NavigationProperty(name="rootCertificateForServerValidation")
    @JsonIgnore
    public AndroidWorkProfileTrustedRootCertificateRequest getRootCertificateForServerValidation() {
        return new AndroidWorkProfileTrustedRootCertificateRequest(contextPath.addSegment("rootCertificateForServerValidation"));
    }

    /**
     * <i>“Identity Certificate for client authentication when EAP Type is configured to
     * EAP-TLS, EAP-TTLS (with Certificate Authentication), or PEAP (with Certificate
     * Authentication). This is the certificate presented by client to the Wi-Fi
     * endpoint. The authentication server sitting behind the Wi-Fi endpoint must
     * accept this certificate to successfully establish a Wi-Fi connection.”</i>
     * 
     * @return navigational property identityCertificateForClientAuthentication
     */
    @NavigationProperty(name="identityCertificateForClientAuthentication")
    @JsonIgnore
    public AndroidWorkProfileCertificateProfileBaseRequest getIdentityCertificateForClientAuthentication() {
        return new AndroidWorkProfileCertificateProfileBaseRequest(contextPath.addSegment("identityCertificateForClientAuthentication"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidWorkProfileEnterpriseWiFiConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AndroidWorkProfileEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidWorkProfileEnterpriseWiFiConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AndroidWorkProfileEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AndroidWorkProfileEnterpriseWiFiConfiguration _copy() {
        AndroidWorkProfileEnterpriseWiFiConfiguration _x = new AndroidWorkProfileEnterpriseWiFiConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.networkName = networkName;
        _x.ssid = ssid;
        _x.connectAutomatically = connectAutomatically;
        _x.connectWhenNetworkNameIsHidden = connectWhenNetworkNameIsHidden;
        _x.wiFiSecurityType = wiFiSecurityType;
        _x.eapType = eapType;
        _x.authenticationMethod = authenticationMethod;
        _x.innerAuthenticationProtocolForEapTtls = innerAuthenticationProtocolForEapTtls;
        _x.innerAuthenticationProtocolForPeap = innerAuthenticationProtocolForPeap;
        _x.outerIdentityPrivacyTemporaryValue = outerIdentityPrivacyTemporaryValue;
        _x.proxySettings = proxySettings;
        _x.proxyAutomaticConfigurationUrl = proxyAutomaticConfigurationUrl;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidWorkProfileEnterpriseWiFiConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("networkName=");
        b.append(this.networkName);
        b.append(", ");
        b.append("ssid=");
        b.append(this.ssid);
        b.append(", ");
        b.append("connectAutomatically=");
        b.append(this.connectAutomatically);
        b.append(", ");
        b.append("connectWhenNetworkNameIsHidden=");
        b.append(this.connectWhenNetworkNameIsHidden);
        b.append(", ");
        b.append("wiFiSecurityType=");
        b.append(this.wiFiSecurityType);
        b.append(", ");
        b.append("eapType=");
        b.append(this.eapType);
        b.append(", ");
        b.append("authenticationMethod=");
        b.append(this.authenticationMethod);
        b.append(", ");
        b.append("innerAuthenticationProtocolForEapTtls=");
        b.append(this.innerAuthenticationProtocolForEapTtls);
        b.append(", ");
        b.append("innerAuthenticationProtocolForPeap=");
        b.append(this.innerAuthenticationProtocolForPeap);
        b.append(", ");
        b.append("outerIdentityPrivacyTemporaryValue=");
        b.append(this.outerIdentityPrivacyTemporaryValue);
        b.append(", ");
        b.append("proxySettings=");
        b.append(this.proxySettings);
        b.append(", ");
        b.append("proxyAutomaticConfigurationUrl=");
        b.append(this.proxyAutomaticConfigurationUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
