package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.complex.KeyValue;
import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.complex.VpnServer;
import odata.msgraph.client.beta.entity.request.AndroidCertificateProfileBaseRequest;
import odata.msgraph.client.beta.enums.AndroidVpnConnectionType;
import odata.msgraph.client.beta.enums.VpnAuthenticationMethod;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“By providing the configurations in this profile you can instruct the Android
 * device to connect to desired VPN endpoint. By specifying the authentication
 * method and security types expected by VPN endpoint you can make the VPN
 * connection seamless for end user.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "connectionName", 
    "connectionType", 
    "role", 
    "realm", 
    "servers", 
    "fingerprint", 
    "customData", 
    "customKeyValueData", 
    "authenticationMethod"})
@JsonInclude(Include.NON_NULL)
public class AndroidVpnConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidVpnConfiguration";
    }

    @JsonProperty("connectionName")
    protected String connectionName;

    @JsonProperty("connectionType")
    protected AndroidVpnConnectionType connectionType;

    @JsonProperty("role")
    protected String role;

    @JsonProperty("realm")
    protected String realm;

    @JsonProperty("servers")
    protected List<VpnServer> servers;

    @JsonProperty("servers@nextLink")
    protected String serversNextLink;

    @JsonProperty("fingerprint")
    protected String fingerprint;

    @JsonProperty("customData")
    protected List<KeyValue> customData;

    @JsonProperty("customData@nextLink")
    protected String customDataNextLink;

    @JsonProperty("customKeyValueData")
    protected List<KeyValuePair> customKeyValueData;

    @JsonProperty("customKeyValueData@nextLink")
    protected String customKeyValueDataNextLink;

    @JsonProperty("authenticationMethod")
    protected VpnAuthenticationMethod authenticationMethod;

    protected AndroidVpnConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidVpnConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private String connectionName;
        private AndroidVpnConnectionType connectionType;
        private String role;
        private String realm;
        private List<VpnServer> servers;
        private String serversNextLink;
        private String fingerprint;
        private List<KeyValue> customData;
        private String customDataNextLink;
        private List<KeyValuePair> customKeyValueData;
        private String customKeyValueDataNextLink;
        private VpnAuthenticationMethod authenticationMethod;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“Connection name displayed to the user.”</i>
         * 
         * @param connectionName
         *            value of {@code connectionName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            this.changedFields = changedFields.add("connectionName");
            return this;
        }

        /**
         * <i>“Connection type.”</i>
         * 
         * @param connectionType
         *            value of {@code connectionType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder connectionType(AndroidVpnConnectionType connectionType) {
            this.connectionType = connectionType;
            this.changedFields = changedFields.add("connectionType");
            return this;
        }

        /**
         * <i>“Role when connection type is set to Pulse Secure.”</i>
         * 
         * @param role
         *            value of {@code role} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder role(String role) {
            this.role = role;
            this.changedFields = changedFields.add("role");
            return this;
        }

        /**
         * <i>“Realm when connection type is set to Pulse Secure.”</i>
         * 
         * @param realm
         *            value of {@code realm} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder realm(String realm) {
            this.realm = realm;
            this.changedFields = changedFields.add("realm");
            return this;
        }

        /**
         * <i>“List of VPN Servers on the network. Make sure end users can access these network
         * locations. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param servers
         *            value of {@code servers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder servers(List<VpnServer> servers) {
            this.servers = servers;
            this.changedFields = changedFields.add("servers");
            return this;
        }

        /**
         * <i>“List of VPN Servers on the network. Make sure end users can access these network
         * locations. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param servers
         *            value of {@code servers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder servers(VpnServer... servers) {
            return servers(Arrays.asList(servers));
        }

        /**
         * <i>“List of VPN Servers on the network. Make sure end users can access these network
         * locations. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param serversNextLink
         *            value of {@code servers@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder serversNextLink(String serversNextLink) {
            this.serversNextLink = serversNextLink;
            this.changedFields = changedFields.add("servers");
            return this;
        }

        /**
         * <i>“Fingerprint is a string that will be used to verify the VPN server can be
         * trusted, which is only applicable when connection type is Check Point Capsule
         * VPN.”</i>
         * 
         * @param fingerprint
         *            value of {@code fingerprint} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder fingerprint(String fingerprint) {
            this.fingerprint = fingerprint;
            this.changedFields = changedFields.add("fingerprint");
            return this;
        }

        /**
         * <i>“Custom data when connection type is set to Citrix. This collection can contain a
         * maximum of 25 elements.”</i>
         * 
         * @param customData
         *            value of {@code customData} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customData(List<KeyValue> customData) {
            this.customData = customData;
            this.changedFields = changedFields.add("customData");
            return this;
        }

        /**
         * <i>“Custom data when connection type is set to Citrix. This collection can contain a
         * maximum of 25 elements.”</i>
         * 
         * @param customData
         *            value of {@code customData} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customData(KeyValue... customData) {
            return customData(Arrays.asList(customData));
        }

        /**
         * <i>“Custom data when connection type is set to Citrix. This collection can contain a
         * maximum of 25 elements.”</i>
         * 
         * @param customDataNextLink
         *            value of {@code customData@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customDataNextLink(String customDataNextLink) {
            this.customDataNextLink = customDataNextLink;
            this.changedFields = changedFields.add("customData");
            return this;
        }

        /**
         * <i>“Custom data when connection type is set to Citrix. This collection can contain a
         * maximum of 25 elements.”</i>
         * 
         * @param customKeyValueData
         *            value of {@code customKeyValueData} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customKeyValueData(List<KeyValuePair> customKeyValueData) {
            this.customKeyValueData = customKeyValueData;
            this.changedFields = changedFields.add("customKeyValueData");
            return this;
        }

        /**
         * <i>“Custom data when connection type is set to Citrix. This collection can contain a
         * maximum of 25 elements.”</i>
         * 
         * @param customKeyValueData
         *            value of {@code customKeyValueData} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customKeyValueData(KeyValuePair... customKeyValueData) {
            return customKeyValueData(Arrays.asList(customKeyValueData));
        }

        /**
         * <i>“Custom data when connection type is set to Citrix. This collection can contain a
         * maximum of 25 elements.”</i>
         * 
         * @param customKeyValueDataNextLink
         *            value of {@code customKeyValueData@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customKeyValueDataNextLink(String customKeyValueDataNextLink) {
            this.customKeyValueDataNextLink = customKeyValueDataNextLink;
            this.changedFields = changedFields.add("customKeyValueData");
            return this;
        }

        /**
         * <i>“Authentication method.”</i>
         * 
         * @param authenticationMethod
         *            value of {@code authenticationMethod} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authenticationMethod(VpnAuthenticationMethod authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            this.changedFields = changedFields.add("authenticationMethod");
            return this;
        }

        public AndroidVpnConfiguration build() {
            AndroidVpnConfiguration _x = new AndroidVpnConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.androidVpnConfiguration";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.connectionName = connectionName;
            _x.connectionType = connectionType;
            _x.role = role;
            _x.realm = realm;
            _x.servers = servers;
            _x.serversNextLink = serversNextLink;
            _x.fingerprint = fingerprint;
            _x.customData = customData;
            _x.customDataNextLink = customDataNextLink;
            _x.customKeyValueData = customKeyValueData;
            _x.customKeyValueDataNextLink = customKeyValueDataNextLink;
            _x.authenticationMethod = authenticationMethod;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Connection name displayed to the user.”</i>
     * 
     * @return property connectionName
     */
    @Property(name="connectionName")
    @JsonIgnore
    public Optional<String> getConnectionName() {
        return Optional.ofNullable(connectionName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code connectionName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Connection name displayed to the user.”</i>
     * 
     * @param connectionName
     *            new value of {@code connectionName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code connectionName} field changed
     */
    public AndroidVpnConfiguration withConnectionName(String connectionName) {
        AndroidVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("connectionName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidVpnConfiguration");
        _x.connectionName = connectionName;
        return _x;
    }

    /**
     * <i>“Connection type.”</i>
     * 
     * @return property connectionType
     */
    @Property(name="connectionType")
    @JsonIgnore
    public Optional<AndroidVpnConnectionType> getConnectionType() {
        return Optional.ofNullable(connectionType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code connectionType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Connection type.”</i>
     * 
     * @param connectionType
     *            new value of {@code connectionType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code connectionType} field changed
     */
    public AndroidVpnConfiguration withConnectionType(AndroidVpnConnectionType connectionType) {
        AndroidVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("connectionType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidVpnConfiguration");
        _x.connectionType = connectionType;
        return _x;
    }

    /**
     * <i>“Role when connection type is set to Pulse Secure.”</i>
     * 
     * @return property role
     */
    @Property(name="role")
    @JsonIgnore
    public Optional<String> getRole() {
        return Optional.ofNullable(role);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code role} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Role when connection type is set to Pulse Secure.”</i>
     * 
     * @param role
     *            new value of {@code role} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code role} field changed
     */
    public AndroidVpnConfiguration withRole(String role) {
        AndroidVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("role");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidVpnConfiguration");
        _x.role = role;
        return _x;
    }

    /**
     * <i>“Realm when connection type is set to Pulse Secure.”</i>
     * 
     * @return property realm
     */
    @Property(name="realm")
    @JsonIgnore
    public Optional<String> getRealm() {
        return Optional.ofNullable(realm);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code realm} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Realm when connection type is set to Pulse Secure.”</i>
     * 
     * @param realm
     *            new value of {@code realm} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code realm} field changed
     */
    public AndroidVpnConfiguration withRealm(String realm) {
        AndroidVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("realm");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidVpnConfiguration");
        _x.realm = realm;
        return _x;
    }

    /**
     * <i>“List of VPN Servers on the network. Make sure end users can access these network
     * locations. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property servers
     */
    @Property(name="servers")
    @JsonIgnore
    public CollectionPage<VpnServer> getServers() {
        return new CollectionPage<VpnServer>(contextPath, VpnServer.class, servers, Optional.ofNullable(serversNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of VPN Servers on the network. Make sure end users can access these network
     * locations. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property servers
     */
    @Property(name="servers")
    @JsonIgnore
    public CollectionPage<VpnServer> getServers(HttpRequestOptions options) {
        return new CollectionPage<VpnServer>(contextPath, VpnServer.class, servers, Optional.ofNullable(serversNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Fingerprint is a string that will be used to verify the VPN server can be
     * trusted, which is only applicable when connection type is Check Point Capsule
     * VPN.”</i>
     * 
     * @return property fingerprint
     */
    @Property(name="fingerprint")
    @JsonIgnore
    public Optional<String> getFingerprint() {
        return Optional.ofNullable(fingerprint);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code fingerprint}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Fingerprint is a string that will be used to verify the VPN server can be
     * trusted, which is only applicable when connection type is Check Point Capsule
     * VPN.”</i>
     * 
     * @param fingerprint
     *            new value of {@code fingerprint} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code fingerprint} field changed
     */
    public AndroidVpnConfiguration withFingerprint(String fingerprint) {
        AndroidVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("fingerprint");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidVpnConfiguration");
        _x.fingerprint = fingerprint;
        return _x;
    }

    /**
     * <i>“Custom data when connection type is set to Citrix. This collection can contain a
     * maximum of 25 elements.”</i>
     * 
     * @return property customData
     */
    @Property(name="customData")
    @JsonIgnore
    public CollectionPage<KeyValue> getCustomData() {
        return new CollectionPage<KeyValue>(contextPath, KeyValue.class, customData, Optional.ofNullable(customDataNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Custom data when connection type is set to Citrix. This collection can contain a
     * maximum of 25 elements.”</i>
     * 
     * @return property customData
     */
    @Property(name="customData")
    @JsonIgnore
    public CollectionPage<KeyValue> getCustomData(HttpRequestOptions options) {
        return new CollectionPage<KeyValue>(contextPath, KeyValue.class, customData, Optional.ofNullable(customDataNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Custom data when connection type is set to Citrix. This collection can contain a
     * maximum of 25 elements.”</i>
     * 
     * @return property customKeyValueData
     */
    @Property(name="customKeyValueData")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getCustomKeyValueData() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, customKeyValueData, Optional.ofNullable(customKeyValueDataNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Custom data when connection type is set to Citrix. This collection can contain a
     * maximum of 25 elements.”</i>
     * 
     * @return property customKeyValueData
     */
    @Property(name="customKeyValueData")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getCustomKeyValueData(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, customKeyValueData, Optional.ofNullable(customKeyValueDataNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Authentication method.”</i>
     * 
     * @return property authenticationMethod
     */
    @Property(name="authenticationMethod")
    @JsonIgnore
    public Optional<VpnAuthenticationMethod> getAuthenticationMethod() {
        return Optional.ofNullable(authenticationMethod);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authenticationMethod} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Authentication method.”</i>
     * 
     * @param authenticationMethod
     *            new value of {@code authenticationMethod} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authenticationMethod} field changed
     */
    public AndroidVpnConfiguration withAuthenticationMethod(VpnAuthenticationMethod authenticationMethod) {
        AndroidVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authenticationMethod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidVpnConfiguration");
        _x.authenticationMethod = authenticationMethod;
        return _x;
    }

    /**
     * <i>“Identity certificate for client authentication when authentication method is
     * certificate.”</i>
     * 
     * @return navigational property identityCertificate
     */
    @NavigationProperty(name="identityCertificate")
    @JsonIgnore
    public AndroidCertificateProfileBaseRequest getIdentityCertificate() {
        return new AndroidCertificateProfileBaseRequest(contextPath.addSegment("identityCertificate"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidVpnConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AndroidVpnConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidVpnConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AndroidVpnConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AndroidVpnConfiguration _copy() {
        AndroidVpnConfiguration _x = new AndroidVpnConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.connectionName = connectionName;
        _x.connectionType = connectionType;
        _x.role = role;
        _x.realm = realm;
        _x.servers = servers;
        _x.fingerprint = fingerprint;
        _x.customData = customData;
        _x.customKeyValueData = customKeyValueData;
        _x.authenticationMethod = authenticationMethod;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidVpnConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("connectionName=");
        b.append(this.connectionName);
        b.append(", ");
        b.append("connectionType=");
        b.append(this.connectionType);
        b.append(", ");
        b.append("role=");
        b.append(this.role);
        b.append(", ");
        b.append("realm=");
        b.append(this.realm);
        b.append(", ");
        b.append("servers=");
        b.append(this.servers);
        b.append(", ");
        b.append("fingerprint=");
        b.append(this.fingerprint);
        b.append(", ");
        b.append("customData=");
        b.append(this.customData);
        b.append(", ");
        b.append("customKeyValueData=");
        b.append(this.customKeyValueData);
        b.append(", ");
        b.append("authenticationMethod=");
        b.append(this.authenticationMethod);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
