package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;

import odata.msgraph.client.beta.complex.AndroidManagedStoreAppTrack;
import odata.msgraph.client.beta.complex.MimeContent;
import odata.msgraph.client.beta.enums.MobileAppPublishingState;


/**
 * <i>“Contains properties and inherited properties for web apps configured to be
 * distributed via the managed Android app store.”</i>
 */@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class AndroidManagedStoreWebApp extends AndroidManagedStoreApp implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidManagedStoreWebApp";
    }

    protected AndroidManagedStoreWebApp() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidManagedStoreWebApp() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private String publisher;
        private MimeContent largeIcon;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private Boolean isFeatured;
        private String privacyInformationUrl;
        private String informationUrl;
        private String owner;
        private String developer;
        private String notes;
        private Integer uploadState;
        private MobileAppPublishingState publishingState;
        private Boolean isAssigned;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Integer dependentAppCount;
        private String packageId;
        private String appIdentifier;
        private Integer usedLicenseCount;
        private Integer totalLicenseCount;
        private String appStoreUrl;
        private Boolean isPrivate;
        private Boolean isSystemApp;
        private List<AndroidManagedStoreAppTrack> appTracks;
        private String appTracksNextLink;
        private Boolean supportsOemConfig;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder publisher(String publisher) {
            this.publisher = publisher;
            this.changedFields = changedFields.add("publisher");
            return this;
        }

        public Builder largeIcon(MimeContent largeIcon) {
            this.largeIcon = largeIcon;
            this.changedFields = changedFields.add("largeIcon");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder isFeatured(Boolean isFeatured) {
            this.isFeatured = isFeatured;
            this.changedFields = changedFields.add("isFeatured");
            return this;
        }

        public Builder privacyInformationUrl(String privacyInformationUrl) {
            this.privacyInformationUrl = privacyInformationUrl;
            this.changedFields = changedFields.add("privacyInformationUrl");
            return this;
        }

        public Builder informationUrl(String informationUrl) {
            this.informationUrl = informationUrl;
            this.changedFields = changedFields.add("informationUrl");
            return this;
        }

        public Builder owner(String owner) {
            this.owner = owner;
            this.changedFields = changedFields.add("owner");
            return this;
        }

        public Builder developer(String developer) {
            this.developer = developer;
            this.changedFields = changedFields.add("developer");
            return this;
        }

        public Builder notes(String notes) {
            this.notes = notes;
            this.changedFields = changedFields.add("notes");
            return this;
        }

        public Builder uploadState(Integer uploadState) {
            this.uploadState = uploadState;
            this.changedFields = changedFields.add("uploadState");
            return this;
        }

        public Builder publishingState(MobileAppPublishingState publishingState) {
            this.publishingState = publishingState;
            this.changedFields = changedFields.add("publishingState");
            return this;
        }

        public Builder isAssigned(Boolean isAssigned) {
            this.isAssigned = isAssigned;
            this.changedFields = changedFields.add("isAssigned");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder dependentAppCount(Integer dependentAppCount) {
            this.dependentAppCount = dependentAppCount;
            this.changedFields = changedFields.add("dependentAppCount");
            return this;
        }

        public Builder packageId(String packageId) {
            this.packageId = packageId;
            this.changedFields = changedFields.add("packageId");
            return this;
        }

        public Builder appIdentifier(String appIdentifier) {
            this.appIdentifier = appIdentifier;
            this.changedFields = changedFields.add("appIdentifier");
            return this;
        }

        public Builder usedLicenseCount(Integer usedLicenseCount) {
            this.usedLicenseCount = usedLicenseCount;
            this.changedFields = changedFields.add("usedLicenseCount");
            return this;
        }

        public Builder totalLicenseCount(Integer totalLicenseCount) {
            this.totalLicenseCount = totalLicenseCount;
            this.changedFields = changedFields.add("totalLicenseCount");
            return this;
        }

        public Builder appStoreUrl(String appStoreUrl) {
            this.appStoreUrl = appStoreUrl;
            this.changedFields = changedFields.add("appStoreUrl");
            return this;
        }

        public Builder isPrivate(Boolean isPrivate) {
            this.isPrivate = isPrivate;
            this.changedFields = changedFields.add("isPrivate");
            return this;
        }

        public Builder isSystemApp(Boolean isSystemApp) {
            this.isSystemApp = isSystemApp;
            this.changedFields = changedFields.add("isSystemApp");
            return this;
        }

        public Builder appTracks(List<AndroidManagedStoreAppTrack> appTracks) {
            this.appTracks = appTracks;
            this.changedFields = changedFields.add("appTracks");
            return this;
        }

        public Builder appTracks(AndroidManagedStoreAppTrack... appTracks) {
            return appTracks(Arrays.asList(appTracks));
        }

        public Builder appTracksNextLink(String appTracksNextLink) {
            this.appTracksNextLink = appTracksNextLink;
            this.changedFields = changedFields.add("appTracks");
            return this;
        }

        public Builder supportsOemConfig(Boolean supportsOemConfig) {
            this.supportsOemConfig = supportsOemConfig;
            this.changedFields = changedFields.add("supportsOemConfig");
            return this;
        }

        public AndroidManagedStoreWebApp build() {
            AndroidManagedStoreWebApp _x = new AndroidManagedStoreWebApp();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.androidManagedStoreWebApp";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.publisher = publisher;
            _x.largeIcon = largeIcon;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.isFeatured = isFeatured;
            _x.privacyInformationUrl = privacyInformationUrl;
            _x.informationUrl = informationUrl;
            _x.owner = owner;
            _x.developer = developer;
            _x.notes = notes;
            _x.uploadState = uploadState;
            _x.publishingState = publishingState;
            _x.isAssigned = isAssigned;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.dependentAppCount = dependentAppCount;
            _x.packageId = packageId;
            _x.appIdentifier = appIdentifier;
            _x.usedLicenseCount = usedLicenseCount;
            _x.totalLicenseCount = totalLicenseCount;
            _x.appStoreUrl = appStoreUrl;
            _x.isPrivate = isPrivate;
            _x.isSystemApp = isSystemApp;
            _x.appTracks = appTracks;
            _x.appTracksNextLink = appTracksNextLink;
            _x.supportsOemConfig = supportsOemConfig;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidManagedStoreWebApp patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AndroidManagedStoreWebApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidManagedStoreWebApp put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AndroidManagedStoreWebApp _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AndroidManagedStoreWebApp _copy() {
        AndroidManagedStoreWebApp _x = new AndroidManagedStoreWebApp();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.publisher = publisher;
        _x.largeIcon = largeIcon;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.isFeatured = isFeatured;
        _x.privacyInformationUrl = privacyInformationUrl;
        _x.informationUrl = informationUrl;
        _x.owner = owner;
        _x.developer = developer;
        _x.notes = notes;
        _x.uploadState = uploadState;
        _x.publishingState = publishingState;
        _x.isAssigned = isAssigned;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.dependentAppCount = dependentAppCount;
        _x.packageId = packageId;
        _x.appIdentifier = appIdentifier;
        _x.usedLicenseCount = usedLicenseCount;
        _x.totalLicenseCount = totalLicenseCount;
        _x.appStoreUrl = appStoreUrl;
        _x.isPrivate = isPrivate;
        _x.isSystemApp = isSystemApp;
        _x.appTracks = appTracks;
        _x.supportsOemConfig = supportsOemConfig;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidManagedStoreWebApp[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("publisher=");
        b.append(this.publisher);
        b.append(", ");
        b.append("largeIcon=");
        b.append(this.largeIcon);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("isFeatured=");
        b.append(this.isFeatured);
        b.append(", ");
        b.append("privacyInformationUrl=");
        b.append(this.privacyInformationUrl);
        b.append(", ");
        b.append("informationUrl=");
        b.append(this.informationUrl);
        b.append(", ");
        b.append("owner=");
        b.append(this.owner);
        b.append(", ");
        b.append("developer=");
        b.append(this.developer);
        b.append(", ");
        b.append("notes=");
        b.append(this.notes);
        b.append(", ");
        b.append("uploadState=");
        b.append(this.uploadState);
        b.append(", ");
        b.append("publishingState=");
        b.append(this.publishingState);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("dependentAppCount=");
        b.append(this.dependentAppCount);
        b.append(", ");
        b.append("packageId=");
        b.append(this.packageId);
        b.append(", ");
        b.append("appIdentifier=");
        b.append(this.appIdentifier);
        b.append(", ");
        b.append("usedLicenseCount=");
        b.append(this.usedLicenseCount);
        b.append(", ");
        b.append("totalLicenseCount=");
        b.append(this.totalLicenseCount);
        b.append(", ");
        b.append("appStoreUrl=");
        b.append(this.appStoreUrl);
        b.append(", ");
        b.append("isPrivate=");
        b.append(this.isPrivate);
        b.append(", ");
        b.append("isSystemApp=");
        b.append(this.isSystemApp);
        b.append(", ");
        b.append("appTracks=");
        b.append(this.appTracks);
        b.append(", ");
        b.append("supportsOemConfig=");
        b.append(this.supportsOemConfig);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
