package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AndroidManagedStoreAppConfigurationSchemaItem;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Schema describing an Android application's custom configurations.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "exampleJson", 
    "schemaItems", 
    "nestedSchemaItems"})
@JsonInclude(Include.NON_NULL)
public class AndroidManagedStoreAppConfigurationSchema extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidManagedStoreAppConfigurationSchema";
    }

    @JsonProperty("exampleJson")
    protected byte[] exampleJson;

    @JsonProperty("schemaItems")
    protected List<AndroidManagedStoreAppConfigurationSchemaItem> schemaItems;

    @JsonProperty("schemaItems@nextLink")
    protected String schemaItemsNextLink;

    @JsonProperty("nestedSchemaItems")
    protected List<AndroidManagedStoreAppConfigurationSchemaItem> nestedSchemaItems;

    @JsonProperty("nestedSchemaItems@nextLink")
    protected String nestedSchemaItemsNextLink;

    protected AndroidManagedStoreAppConfigurationSchema() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidManagedStoreAppConfigurationSchema() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private byte[] exampleJson;
        private List<AndroidManagedStoreAppConfigurationSchemaItem> schemaItems;
        private String schemaItemsNextLink;
        private List<AndroidManagedStoreAppConfigurationSchemaItem> nestedSchemaItems;
        private String nestedSchemaItemsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“UTF8 encoded byte array containing example JSON string conforming to this schema
         * that demonstrates how to set the configuration for this app”</i>
         * 
         * @param exampleJson
         *            value of {@code exampleJson} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exampleJson(byte[] exampleJson) {
            this.exampleJson = exampleJson;
            this.changedFields = changedFields.add("exampleJson");
            return this;
        }

        /**
         * <i>“Collection of items each representing a named configuration option in the schema
         * . It only contains the root-level configuration.”</i>
         * 
         * @param schemaItems
         *            value of {@code schemaItems} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder schemaItems(List<AndroidManagedStoreAppConfigurationSchemaItem> schemaItems) {
            this.schemaItems = schemaItems;
            this.changedFields = changedFields.add("schemaItems");
            return this;
        }

        /**
         * <i>“Collection of items each representing a named configuration option in the schema
         * . It only contains the root-level configuration.”</i>
         * 
         * @param schemaItems
         *            value of {@code schemaItems} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder schemaItems(AndroidManagedStoreAppConfigurationSchemaItem... schemaItems) {
            return schemaItems(Arrays.asList(schemaItems));
        }

        /**
         * <i>“Collection of items each representing a named configuration option in the schema
         * . It only contains the root-level configuration.”</i>
         * 
         * @param schemaItemsNextLink
         *            value of {@code schemaItems@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder schemaItemsNextLink(String schemaItemsNextLink) {
            this.schemaItemsNextLink = schemaItemsNextLink;
            this.changedFields = changedFields.add("schemaItems");
            return this;
        }

        /**
         * <i>“Collection of items each representing a named configuration option in the schema
         * . It contains a flat list of all configuration.”</i>
         * 
         * @param nestedSchemaItems
         *            value of {@code nestedSchemaItems} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder nestedSchemaItems(List<AndroidManagedStoreAppConfigurationSchemaItem> nestedSchemaItems) {
            this.nestedSchemaItems = nestedSchemaItems;
            this.changedFields = changedFields.add("nestedSchemaItems");
            return this;
        }

        /**
         * <i>“Collection of items each representing a named configuration option in the schema
         * . It contains a flat list of all configuration.”</i>
         * 
         * @param nestedSchemaItems
         *            value of {@code nestedSchemaItems} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder nestedSchemaItems(AndroidManagedStoreAppConfigurationSchemaItem... nestedSchemaItems) {
            return nestedSchemaItems(Arrays.asList(nestedSchemaItems));
        }

        /**
         * <i>“Collection of items each representing a named configuration option in the schema
         * . It contains a flat list of all configuration.”</i>
         * 
         * @param nestedSchemaItemsNextLink
         *            value of {@code nestedSchemaItems@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder nestedSchemaItemsNextLink(String nestedSchemaItemsNextLink) {
            this.nestedSchemaItemsNextLink = nestedSchemaItemsNextLink;
            this.changedFields = changedFields.add("nestedSchemaItems");
            return this;
        }

        public AndroidManagedStoreAppConfigurationSchema build() {
            AndroidManagedStoreAppConfigurationSchema _x = new AndroidManagedStoreAppConfigurationSchema();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.androidManagedStoreAppConfigurationSchema";
            _x.id = id;
            _x.exampleJson = exampleJson;
            _x.schemaItems = schemaItems;
            _x.schemaItemsNextLink = schemaItemsNextLink;
            _x.nestedSchemaItems = nestedSchemaItems;
            _x.nestedSchemaItemsNextLink = nestedSchemaItemsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“UTF8 encoded byte array containing example JSON string conforming to this schema
     * that demonstrates how to set the configuration for this app”</i>
     * 
     * @return property exampleJson
     */
    @Property(name="exampleJson")
    @JsonIgnore
    public Optional<byte[]> getExampleJson() {
        return Optional.ofNullable(exampleJson);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code exampleJson}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“UTF8 encoded byte array containing example JSON string conforming to this schema
     * that demonstrates how to set the configuration for this app”</i>
     * 
     * @param exampleJson
     *            new value of {@code exampleJson} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code exampleJson} field changed
     */
    public AndroidManagedStoreAppConfigurationSchema withExampleJson(byte[] exampleJson) {
        AndroidManagedStoreAppConfigurationSchema _x = _copy();
        _x.changedFields = changedFields.add("exampleJson");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedStoreAppConfigurationSchema");
        _x.exampleJson = exampleJson;
        return _x;
    }

    /**
     * <i>“Collection of items each representing a named configuration option in the schema
     * . It only contains the root-level configuration.”</i>
     * 
     * @return property schemaItems
     */
    @Property(name="schemaItems")
    @JsonIgnore
    public CollectionPage<AndroidManagedStoreAppConfigurationSchemaItem> getSchemaItems() {
        return new CollectionPage<AndroidManagedStoreAppConfigurationSchemaItem>(contextPath, AndroidManagedStoreAppConfigurationSchemaItem.class, schemaItems, Optional.ofNullable(schemaItemsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Collection of items each representing a named configuration option in the schema
     * . It only contains the root-level configuration.”</i>
     * 
     * @return property schemaItems
     */
    @Property(name="schemaItems")
    @JsonIgnore
    public CollectionPage<AndroidManagedStoreAppConfigurationSchemaItem> getSchemaItems(HttpRequestOptions options) {
        return new CollectionPage<AndroidManagedStoreAppConfigurationSchemaItem>(contextPath, AndroidManagedStoreAppConfigurationSchemaItem.class, schemaItems, Optional.ofNullable(schemaItemsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Collection of items each representing a named configuration option in the schema
     * . It contains a flat list of all configuration.”</i>
     * 
     * @return property nestedSchemaItems
     */
    @Property(name="nestedSchemaItems")
    @JsonIgnore
    public CollectionPage<AndroidManagedStoreAppConfigurationSchemaItem> getNestedSchemaItems() {
        return new CollectionPage<AndroidManagedStoreAppConfigurationSchemaItem>(contextPath, AndroidManagedStoreAppConfigurationSchemaItem.class, nestedSchemaItems, Optional.ofNullable(nestedSchemaItemsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Collection of items each representing a named configuration option in the schema
     * . It contains a flat list of all configuration.”</i>
     * 
     * @return property nestedSchemaItems
     */
    @Property(name="nestedSchemaItems")
    @JsonIgnore
    public CollectionPage<AndroidManagedStoreAppConfigurationSchemaItem> getNestedSchemaItems(HttpRequestOptions options) {
        return new CollectionPage<AndroidManagedStoreAppConfigurationSchemaItem>(contextPath, AndroidManagedStoreAppConfigurationSchemaItem.class, nestedSchemaItems, Optional.ofNullable(nestedSchemaItemsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidManagedStoreAppConfigurationSchema patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AndroidManagedStoreAppConfigurationSchema _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidManagedStoreAppConfigurationSchema put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AndroidManagedStoreAppConfigurationSchema _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AndroidManagedStoreAppConfigurationSchema _copy() {
        AndroidManagedStoreAppConfigurationSchema _x = new AndroidManagedStoreAppConfigurationSchema();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.exampleJson = exampleJson;
        _x.schemaItems = schemaItems;
        _x.nestedSchemaItems = nestedSchemaItems;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidManagedStoreAppConfigurationSchema[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("exampleJson=");
        b.append(this.exampleJson);
        b.append(", ");
        b.append("schemaItems=");
        b.append(this.schemaItems);
        b.append(", ");
        b.append("nestedSchemaItems=");
        b.append(this.nestedSchemaItems);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
