package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.KeyValuePair;
import odata.msgraph.client.beta.entity.collection.request.ManagedMobileAppCollectionRequest;
import odata.msgraph.client.beta.entity.request.ManagedAppPolicyDeploymentSummaryRequest;
import odata.msgraph.client.beta.enums.AndroidManagedAppSafetyNetAppsVerificationType;
import odata.msgraph.client.beta.enums.AndroidManagedAppSafetyNetDeviceAttestationType;
import odata.msgraph.client.beta.enums.AppManagementLevel;
import odata.msgraph.client.beta.enums.ManagedAppClipboardSharingLevel;
import odata.msgraph.client.beta.enums.ManagedAppDataIngestionLocation;
import odata.msgraph.client.beta.enums.ManagedAppDataStorageLocation;
import odata.msgraph.client.beta.enums.ManagedAppDataTransferLevel;
import odata.msgraph.client.beta.enums.ManagedAppDeviceThreatLevel;
import odata.msgraph.client.beta.enums.ManagedAppNotificationRestriction;
import odata.msgraph.client.beta.enums.ManagedAppPhoneNumberRedirectLevel;
import odata.msgraph.client.beta.enums.ManagedAppPinCharacterSet;
import odata.msgraph.client.beta.enums.ManagedAppRemediationAction;
import odata.msgraph.client.beta.enums.ManagedBrowserType;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Policy used to configure detailed management settings targeted to specific
 * security groups and for a specified set of apps on an Android device”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "screenCaptureBlocked", 
    "disableAppEncryptionIfDeviceEncryptionIsEnabled", 
    "encryptAppData", 
    "deployedAppCount", 
    "minimumRequiredPatchVersion", 
    "minimumWarningPatchVersion", 
    "exemptedAppPackages", 
    "minimumWipePatchVersion", 
    "allowedAndroidDeviceManufacturers", 
    "appActionIfAndroidDeviceManufacturerNotAllowed", 
    "requiredAndroidSafetyNetDeviceAttestationType", 
    "appActionIfAndroidSafetyNetDeviceAttestationFailed", 
    "requiredAndroidSafetyNetAppsVerificationType", 
    "appActionIfAndroidSafetyNetAppsVerificationFailed", 
    "customBrowserPackageId", 
    "customBrowserDisplayName", 
    "minimumRequiredCompanyPortalVersion", 
    "minimumWarningCompanyPortalVersion", 
    "minimumWipeCompanyPortalVersion", 
    "keyboardsRestricted", 
    "approvedKeyboards", 
    "allowedAndroidDeviceModels", 
    "appActionIfAndroidDeviceModelNotAllowed", 
    "customDialerAppPackageId", 
    "customDialerAppDisplayName"})
@JsonInclude(Include.NON_NULL)
public class AndroidManagedAppProtection extends TargetedManagedAppProtection implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidManagedAppProtection";
    }

    @JsonProperty("screenCaptureBlocked")
    protected Boolean screenCaptureBlocked;

    @JsonProperty("disableAppEncryptionIfDeviceEncryptionIsEnabled")
    protected Boolean disableAppEncryptionIfDeviceEncryptionIsEnabled;

    @JsonProperty("encryptAppData")
    protected Boolean encryptAppData;

    @JsonProperty("deployedAppCount")
    protected Integer deployedAppCount;

    @JsonProperty("minimumRequiredPatchVersion")
    protected String minimumRequiredPatchVersion;

    @JsonProperty("minimumWarningPatchVersion")
    protected String minimumWarningPatchVersion;

    @JsonProperty("exemptedAppPackages")
    protected List<KeyValuePair> exemptedAppPackages;

    @JsonProperty("exemptedAppPackages@nextLink")
    protected String exemptedAppPackagesNextLink;

    @JsonProperty("minimumWipePatchVersion")
    protected String minimumWipePatchVersion;

    @JsonProperty("allowedAndroidDeviceManufacturers")
    protected String allowedAndroidDeviceManufacturers;

    @JsonProperty("appActionIfAndroidDeviceManufacturerNotAllowed")
    protected ManagedAppRemediationAction appActionIfAndroidDeviceManufacturerNotAllowed;

    @JsonProperty("requiredAndroidSafetyNetDeviceAttestationType")
    protected AndroidManagedAppSafetyNetDeviceAttestationType requiredAndroidSafetyNetDeviceAttestationType;

    @JsonProperty("appActionIfAndroidSafetyNetDeviceAttestationFailed")
    protected ManagedAppRemediationAction appActionIfAndroidSafetyNetDeviceAttestationFailed;

    @JsonProperty("requiredAndroidSafetyNetAppsVerificationType")
    protected AndroidManagedAppSafetyNetAppsVerificationType requiredAndroidSafetyNetAppsVerificationType;

    @JsonProperty("appActionIfAndroidSafetyNetAppsVerificationFailed")
    protected ManagedAppRemediationAction appActionIfAndroidSafetyNetAppsVerificationFailed;

    @JsonProperty("customBrowserPackageId")
    protected String customBrowserPackageId;

    @JsonProperty("customBrowserDisplayName")
    protected String customBrowserDisplayName;

    @JsonProperty("minimumRequiredCompanyPortalVersion")
    protected String minimumRequiredCompanyPortalVersion;

    @JsonProperty("minimumWarningCompanyPortalVersion")
    protected String minimumWarningCompanyPortalVersion;

    @JsonProperty("minimumWipeCompanyPortalVersion")
    protected String minimumWipeCompanyPortalVersion;

    @JsonProperty("keyboardsRestricted")
    protected Boolean keyboardsRestricted;

    @JsonProperty("approvedKeyboards")
    protected List<KeyValuePair> approvedKeyboards;

    @JsonProperty("approvedKeyboards@nextLink")
    protected String approvedKeyboardsNextLink;

    @JsonProperty("allowedAndroidDeviceModels")
    protected List<String> allowedAndroidDeviceModels;

    @JsonProperty("allowedAndroidDeviceModels@nextLink")
    protected String allowedAndroidDeviceModelsNextLink;

    @JsonProperty("appActionIfAndroidDeviceModelNotAllowed")
    protected ManagedAppRemediationAction appActionIfAndroidDeviceModelNotAllowed;

    @JsonProperty("customDialerAppPackageId")
    protected String customDialerAppPackageId;

    @JsonProperty("customDialerAppDisplayName")
    protected String customDialerAppDisplayName;

    protected AndroidManagedAppProtection() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidManagedAppProtection() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private String version;
        private Duration periodOfflineBeforeAccessCheck;
        private Duration periodOnlineBeforeAccessCheck;
        private ManagedAppDataTransferLevel allowedInboundDataTransferSources;
        private ManagedAppDataTransferLevel allowedOutboundDataTransferDestinations;
        private Boolean organizationalCredentialsRequired;
        private ManagedAppClipboardSharingLevel allowedOutboundClipboardSharingLevel;
        private Boolean dataBackupBlocked;
        private Boolean deviceComplianceRequired;
        private Boolean managedBrowserToOpenLinksRequired;
        private Boolean saveAsBlocked;
        private Duration periodOfflineBeforeWipeIsEnforced;
        private Boolean pinRequired;
        private Integer maximumPinRetries;
        private Boolean simplePinBlocked;
        private Integer minimumPinLength;
        private ManagedAppPinCharacterSet pinCharacterSet;
        private Duration periodBeforePinReset;
        private List<ManagedAppDataStorageLocation> allowedDataStorageLocations;
        private String allowedDataStorageLocationsNextLink;
        private Boolean contactSyncBlocked;
        private Boolean printBlocked;
        private Boolean fingerprintBlocked;
        private Boolean disableAppPinIfDevicePinIsSet;
        private String minimumRequiredOsVersion;
        private String minimumWarningOsVersion;
        private String minimumRequiredAppVersion;
        private String minimumWarningAppVersion;
        private String minimumWipeOsVersion;
        private String minimumWipeAppVersion;
        private ManagedAppRemediationAction appActionIfDeviceComplianceRequired;
        private ManagedAppRemediationAction appActionIfMaximumPinRetriesExceeded;
        private Duration pinRequiredInsteadOfBiometricTimeout;
        private Integer allowedOutboundClipboardSharingExceptionLength;
        private ManagedAppNotificationRestriction notificationRestriction;
        private Integer previousPinBlockCount;
        private ManagedBrowserType managedBrowser;
        private ManagedAppDeviceThreatLevel maximumAllowedDeviceThreatLevel;
        private ManagedAppRemediationAction mobileThreatDefenseRemediationAction;
        private Boolean blockDataIngestionIntoOrganizationDocuments;
        private List<ManagedAppDataIngestionLocation> allowedDataIngestionLocations;
        private String allowedDataIngestionLocationsNextLink;
        private ManagedAppRemediationAction appActionIfUnableToAuthenticateUser;
        private ManagedAppPhoneNumberRedirectLevel dialerRestrictionLevel;
        private Boolean isAssigned;
        private AppManagementLevel targetedAppManagementLevels;
        private Boolean screenCaptureBlocked;
        private Boolean disableAppEncryptionIfDeviceEncryptionIsEnabled;
        private Boolean encryptAppData;
        private Integer deployedAppCount;
        private String minimumRequiredPatchVersion;
        private String minimumWarningPatchVersion;
        private List<KeyValuePair> exemptedAppPackages;
        private String exemptedAppPackagesNextLink;
        private String minimumWipePatchVersion;
        private String allowedAndroidDeviceManufacturers;
        private ManagedAppRemediationAction appActionIfAndroidDeviceManufacturerNotAllowed;
        private AndroidManagedAppSafetyNetDeviceAttestationType requiredAndroidSafetyNetDeviceAttestationType;
        private ManagedAppRemediationAction appActionIfAndroidSafetyNetDeviceAttestationFailed;
        private AndroidManagedAppSafetyNetAppsVerificationType requiredAndroidSafetyNetAppsVerificationType;
        private ManagedAppRemediationAction appActionIfAndroidSafetyNetAppsVerificationFailed;
        private String customBrowserPackageId;
        private String customBrowserDisplayName;
        private String minimumRequiredCompanyPortalVersion;
        private String minimumWarningCompanyPortalVersion;
        private String minimumWipeCompanyPortalVersion;
        private Boolean keyboardsRestricted;
        private List<KeyValuePair> approvedKeyboards;
        private String approvedKeyboardsNextLink;
        private List<String> allowedAndroidDeviceModels;
        private String allowedAndroidDeviceModelsNextLink;
        private ManagedAppRemediationAction appActionIfAndroidDeviceModelNotAllowed;
        private String customDialerAppPackageId;
        private String customDialerAppDisplayName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder version(String version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder periodOfflineBeforeAccessCheck(Duration periodOfflineBeforeAccessCheck) {
            this.periodOfflineBeforeAccessCheck = periodOfflineBeforeAccessCheck;
            this.changedFields = changedFields.add("periodOfflineBeforeAccessCheck");
            return this;
        }

        public Builder periodOnlineBeforeAccessCheck(Duration periodOnlineBeforeAccessCheck) {
            this.periodOnlineBeforeAccessCheck = periodOnlineBeforeAccessCheck;
            this.changedFields = changedFields.add("periodOnlineBeforeAccessCheck");
            return this;
        }

        public Builder allowedInboundDataTransferSources(ManagedAppDataTransferLevel allowedInboundDataTransferSources) {
            this.allowedInboundDataTransferSources = allowedInboundDataTransferSources;
            this.changedFields = changedFields.add("allowedInboundDataTransferSources");
            return this;
        }

        public Builder allowedOutboundDataTransferDestinations(ManagedAppDataTransferLevel allowedOutboundDataTransferDestinations) {
            this.allowedOutboundDataTransferDestinations = allowedOutboundDataTransferDestinations;
            this.changedFields = changedFields.add("allowedOutboundDataTransferDestinations");
            return this;
        }

        public Builder organizationalCredentialsRequired(Boolean organizationalCredentialsRequired) {
            this.organizationalCredentialsRequired = organizationalCredentialsRequired;
            this.changedFields = changedFields.add("organizationalCredentialsRequired");
            return this;
        }

        public Builder allowedOutboundClipboardSharingLevel(ManagedAppClipboardSharingLevel allowedOutboundClipboardSharingLevel) {
            this.allowedOutboundClipboardSharingLevel = allowedOutboundClipboardSharingLevel;
            this.changedFields = changedFields.add("allowedOutboundClipboardSharingLevel");
            return this;
        }

        public Builder dataBackupBlocked(Boolean dataBackupBlocked) {
            this.dataBackupBlocked = dataBackupBlocked;
            this.changedFields = changedFields.add("dataBackupBlocked");
            return this;
        }

        public Builder deviceComplianceRequired(Boolean deviceComplianceRequired) {
            this.deviceComplianceRequired = deviceComplianceRequired;
            this.changedFields = changedFields.add("deviceComplianceRequired");
            return this;
        }

        public Builder managedBrowserToOpenLinksRequired(Boolean managedBrowserToOpenLinksRequired) {
            this.managedBrowserToOpenLinksRequired = managedBrowserToOpenLinksRequired;
            this.changedFields = changedFields.add("managedBrowserToOpenLinksRequired");
            return this;
        }

        public Builder saveAsBlocked(Boolean saveAsBlocked) {
            this.saveAsBlocked = saveAsBlocked;
            this.changedFields = changedFields.add("saveAsBlocked");
            return this;
        }

        public Builder periodOfflineBeforeWipeIsEnforced(Duration periodOfflineBeforeWipeIsEnforced) {
            this.periodOfflineBeforeWipeIsEnforced = periodOfflineBeforeWipeIsEnforced;
            this.changedFields = changedFields.add("periodOfflineBeforeWipeIsEnforced");
            return this;
        }

        public Builder pinRequired(Boolean pinRequired) {
            this.pinRequired = pinRequired;
            this.changedFields = changedFields.add("pinRequired");
            return this;
        }

        public Builder maximumPinRetries(Integer maximumPinRetries) {
            this.maximumPinRetries = maximumPinRetries;
            this.changedFields = changedFields.add("maximumPinRetries");
            return this;
        }

        public Builder simplePinBlocked(Boolean simplePinBlocked) {
            this.simplePinBlocked = simplePinBlocked;
            this.changedFields = changedFields.add("simplePinBlocked");
            return this;
        }

        public Builder minimumPinLength(Integer minimumPinLength) {
            this.minimumPinLength = minimumPinLength;
            this.changedFields = changedFields.add("minimumPinLength");
            return this;
        }

        public Builder pinCharacterSet(ManagedAppPinCharacterSet pinCharacterSet) {
            this.pinCharacterSet = pinCharacterSet;
            this.changedFields = changedFields.add("pinCharacterSet");
            return this;
        }

        public Builder periodBeforePinReset(Duration periodBeforePinReset) {
            this.periodBeforePinReset = periodBeforePinReset;
            this.changedFields = changedFields.add("periodBeforePinReset");
            return this;
        }

        public Builder allowedDataStorageLocations(List<ManagedAppDataStorageLocation> allowedDataStorageLocations) {
            this.allowedDataStorageLocations = allowedDataStorageLocations;
            this.changedFields = changedFields.add("allowedDataStorageLocations");
            return this;
        }

        public Builder allowedDataStorageLocations(ManagedAppDataStorageLocation... allowedDataStorageLocations) {
            return allowedDataStorageLocations(Arrays.asList(allowedDataStorageLocations));
        }

        public Builder allowedDataStorageLocationsNextLink(String allowedDataStorageLocationsNextLink) {
            this.allowedDataStorageLocationsNextLink = allowedDataStorageLocationsNextLink;
            this.changedFields = changedFields.add("allowedDataStorageLocations");
            return this;
        }

        public Builder contactSyncBlocked(Boolean contactSyncBlocked) {
            this.contactSyncBlocked = contactSyncBlocked;
            this.changedFields = changedFields.add("contactSyncBlocked");
            return this;
        }

        public Builder printBlocked(Boolean printBlocked) {
            this.printBlocked = printBlocked;
            this.changedFields = changedFields.add("printBlocked");
            return this;
        }

        public Builder fingerprintBlocked(Boolean fingerprintBlocked) {
            this.fingerprintBlocked = fingerprintBlocked;
            this.changedFields = changedFields.add("fingerprintBlocked");
            return this;
        }

        public Builder disableAppPinIfDevicePinIsSet(Boolean disableAppPinIfDevicePinIsSet) {
            this.disableAppPinIfDevicePinIsSet = disableAppPinIfDevicePinIsSet;
            this.changedFields = changedFields.add("disableAppPinIfDevicePinIsSet");
            return this;
        }

        public Builder minimumRequiredOsVersion(String minimumRequiredOsVersion) {
            this.minimumRequiredOsVersion = minimumRequiredOsVersion;
            this.changedFields = changedFields.add("minimumRequiredOsVersion");
            return this;
        }

        public Builder minimumWarningOsVersion(String minimumWarningOsVersion) {
            this.minimumWarningOsVersion = minimumWarningOsVersion;
            this.changedFields = changedFields.add("minimumWarningOsVersion");
            return this;
        }

        public Builder minimumRequiredAppVersion(String minimumRequiredAppVersion) {
            this.minimumRequiredAppVersion = minimumRequiredAppVersion;
            this.changedFields = changedFields.add("minimumRequiredAppVersion");
            return this;
        }

        public Builder minimumWarningAppVersion(String minimumWarningAppVersion) {
            this.minimumWarningAppVersion = minimumWarningAppVersion;
            this.changedFields = changedFields.add("minimumWarningAppVersion");
            return this;
        }

        public Builder minimumWipeOsVersion(String minimumWipeOsVersion) {
            this.minimumWipeOsVersion = minimumWipeOsVersion;
            this.changedFields = changedFields.add("minimumWipeOsVersion");
            return this;
        }

        public Builder minimumWipeAppVersion(String minimumWipeAppVersion) {
            this.minimumWipeAppVersion = minimumWipeAppVersion;
            this.changedFields = changedFields.add("minimumWipeAppVersion");
            return this;
        }

        public Builder appActionIfDeviceComplianceRequired(ManagedAppRemediationAction appActionIfDeviceComplianceRequired) {
            this.appActionIfDeviceComplianceRequired = appActionIfDeviceComplianceRequired;
            this.changedFields = changedFields.add("appActionIfDeviceComplianceRequired");
            return this;
        }

        public Builder appActionIfMaximumPinRetriesExceeded(ManagedAppRemediationAction appActionIfMaximumPinRetriesExceeded) {
            this.appActionIfMaximumPinRetriesExceeded = appActionIfMaximumPinRetriesExceeded;
            this.changedFields = changedFields.add("appActionIfMaximumPinRetriesExceeded");
            return this;
        }

        public Builder pinRequiredInsteadOfBiometricTimeout(Duration pinRequiredInsteadOfBiometricTimeout) {
            this.pinRequiredInsteadOfBiometricTimeout = pinRequiredInsteadOfBiometricTimeout;
            this.changedFields = changedFields.add("pinRequiredInsteadOfBiometricTimeout");
            return this;
        }

        public Builder allowedOutboundClipboardSharingExceptionLength(Integer allowedOutboundClipboardSharingExceptionLength) {
            this.allowedOutboundClipboardSharingExceptionLength = allowedOutboundClipboardSharingExceptionLength;
            this.changedFields = changedFields.add("allowedOutboundClipboardSharingExceptionLength");
            return this;
        }

        public Builder notificationRestriction(ManagedAppNotificationRestriction notificationRestriction) {
            this.notificationRestriction = notificationRestriction;
            this.changedFields = changedFields.add("notificationRestriction");
            return this;
        }

        public Builder previousPinBlockCount(Integer previousPinBlockCount) {
            this.previousPinBlockCount = previousPinBlockCount;
            this.changedFields = changedFields.add("previousPinBlockCount");
            return this;
        }

        public Builder managedBrowser(ManagedBrowserType managedBrowser) {
            this.managedBrowser = managedBrowser;
            this.changedFields = changedFields.add("managedBrowser");
            return this;
        }

        public Builder maximumAllowedDeviceThreatLevel(ManagedAppDeviceThreatLevel maximumAllowedDeviceThreatLevel) {
            this.maximumAllowedDeviceThreatLevel = maximumAllowedDeviceThreatLevel;
            this.changedFields = changedFields.add("maximumAllowedDeviceThreatLevel");
            return this;
        }

        public Builder mobileThreatDefenseRemediationAction(ManagedAppRemediationAction mobileThreatDefenseRemediationAction) {
            this.mobileThreatDefenseRemediationAction = mobileThreatDefenseRemediationAction;
            this.changedFields = changedFields.add("mobileThreatDefenseRemediationAction");
            return this;
        }

        public Builder blockDataIngestionIntoOrganizationDocuments(Boolean blockDataIngestionIntoOrganizationDocuments) {
            this.blockDataIngestionIntoOrganizationDocuments = blockDataIngestionIntoOrganizationDocuments;
            this.changedFields = changedFields.add("blockDataIngestionIntoOrganizationDocuments");
            return this;
        }

        public Builder allowedDataIngestionLocations(List<ManagedAppDataIngestionLocation> allowedDataIngestionLocations) {
            this.allowedDataIngestionLocations = allowedDataIngestionLocations;
            this.changedFields = changedFields.add("allowedDataIngestionLocations");
            return this;
        }

        public Builder allowedDataIngestionLocations(ManagedAppDataIngestionLocation... allowedDataIngestionLocations) {
            return allowedDataIngestionLocations(Arrays.asList(allowedDataIngestionLocations));
        }

        public Builder allowedDataIngestionLocationsNextLink(String allowedDataIngestionLocationsNextLink) {
            this.allowedDataIngestionLocationsNextLink = allowedDataIngestionLocationsNextLink;
            this.changedFields = changedFields.add("allowedDataIngestionLocations");
            return this;
        }

        public Builder appActionIfUnableToAuthenticateUser(ManagedAppRemediationAction appActionIfUnableToAuthenticateUser) {
            this.appActionIfUnableToAuthenticateUser = appActionIfUnableToAuthenticateUser;
            this.changedFields = changedFields.add("appActionIfUnableToAuthenticateUser");
            return this;
        }

        public Builder dialerRestrictionLevel(ManagedAppPhoneNumberRedirectLevel dialerRestrictionLevel) {
            this.dialerRestrictionLevel = dialerRestrictionLevel;
            this.changedFields = changedFields.add("dialerRestrictionLevel");
            return this;
        }

        public Builder isAssigned(Boolean isAssigned) {
            this.isAssigned = isAssigned;
            this.changedFields = changedFields.add("isAssigned");
            return this;
        }

        public Builder targetedAppManagementLevels(AppManagementLevel targetedAppManagementLevels) {
            this.targetedAppManagementLevels = targetedAppManagementLevels;
            this.changedFields = changedFields.add("targetedAppManagementLevels");
            return this;
        }

        /**
         * <i>“Indicates whether a managed user can take screen captures of managed apps”</i>
         * 
         * @param screenCaptureBlocked
         *            value of {@code screenCaptureBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder screenCaptureBlocked(Boolean screenCaptureBlocked) {
            this.screenCaptureBlocked = screenCaptureBlocked;
            this.changedFields = changedFields.add("screenCaptureBlocked");
            return this;
        }

        /**
         * <i>“When this setting is enabled, app level encryption is disabled if device level
         * encryption is enabled”</i>
         * 
         * @param disableAppEncryptionIfDeviceEncryptionIsEnabled
         *            value of {@code disableAppEncryptionIfDeviceEncryptionIsEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder disableAppEncryptionIfDeviceEncryptionIsEnabled(Boolean disableAppEncryptionIfDeviceEncryptionIsEnabled) {
            this.disableAppEncryptionIfDeviceEncryptionIsEnabled = disableAppEncryptionIfDeviceEncryptionIsEnabled;
            this.changedFields = changedFields.add("disableAppEncryptionIfDeviceEncryptionIsEnabled");
            return this;
        }

        /**
         * <i>“Indicates whether application data for managed apps should be encrypted”</i>
         * 
         * @param encryptAppData
         *            value of {@code encryptAppData} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder encryptAppData(Boolean encryptAppData) {
            this.encryptAppData = encryptAppData;
            this.changedFields = changedFields.add("encryptAppData");
            return this;
        }

        /**
         * <i>“Count of apps to which the current policy is deployed.”</i>
         * 
         * @param deployedAppCount
         *            value of {@code deployedAppCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deployedAppCount(Integer deployedAppCount) {
            this.deployedAppCount = deployedAppCount;
            this.changedFields = changedFields.add("deployedAppCount");
            return this;
        }

        /**
         * <i>“Define the oldest required Android security patch level a user can have to gain
         * secure access to the app.”</i>
         * 
         * @param minimumRequiredPatchVersion
         *            value of {@code minimumRequiredPatchVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumRequiredPatchVersion(String minimumRequiredPatchVersion) {
            this.minimumRequiredPatchVersion = minimumRequiredPatchVersion;
            this.changedFields = changedFields.add("minimumRequiredPatchVersion");
            return this;
        }

        /**
         * <i>“Define the oldest recommended Android security patch level a user can have for
         * secure access to the app.”</i>
         * 
         * @param minimumWarningPatchVersion
         *            value of {@code minimumWarningPatchVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumWarningPatchVersion(String minimumWarningPatchVersion) {
            this.minimumWarningPatchVersion = minimumWarningPatchVersion;
            this.changedFields = changedFields.add("minimumWarningPatchVersion");
            return this;
        }

        /**
         * <i>“App packages in this list will be exempt from the policy and will be able to
         * receive data from managed apps.”</i>
         * 
         * @param exemptedAppPackages
         *            value of {@code exemptedAppPackages} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exemptedAppPackages(List<KeyValuePair> exemptedAppPackages) {
            this.exemptedAppPackages = exemptedAppPackages;
            this.changedFields = changedFields.add("exemptedAppPackages");
            return this;
        }

        /**
         * <i>“App packages in this list will be exempt from the policy and will be able to
         * receive data from managed apps.”</i>
         * 
         * @param exemptedAppPackages
         *            value of {@code exemptedAppPackages} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exemptedAppPackages(KeyValuePair... exemptedAppPackages) {
            return exemptedAppPackages(Arrays.asList(exemptedAppPackages));
        }

        /**
         * <i>“App packages in this list will be exempt from the policy and will be able to
         * receive data from managed apps.”</i>
         * 
         * @param exemptedAppPackagesNextLink
         *            value of {@code exemptedAppPackages@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exemptedAppPackagesNextLink(String exemptedAppPackagesNextLink) {
            this.exemptedAppPackagesNextLink = exemptedAppPackagesNextLink;
            this.changedFields = changedFields.add("exemptedAppPackages");
            return this;
        }

        /**
         * <i>“Android security patch level  less than or equal to the specified value will
         * wipe the managed app and the associated company data.”</i>
         * 
         * @param minimumWipePatchVersion
         *            value of {@code minimumWipePatchVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumWipePatchVersion(String minimumWipePatchVersion) {
            this.minimumWipePatchVersion = minimumWipePatchVersion;
            this.changedFields = changedFields.add("minimumWipePatchVersion");
            return this;
        }

        /**
         * <i>“Semicolon seperated list of device manufacturers allowed, as a string, for the
         * managed app to work.”</i>
         * 
         * @param allowedAndroidDeviceManufacturers
         *            value of {@code allowedAndroidDeviceManufacturers} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedAndroidDeviceManufacturers(String allowedAndroidDeviceManufacturers) {
            this.allowedAndroidDeviceManufacturers = allowedAndroidDeviceManufacturers;
            this.changedFields = changedFields.add("allowedAndroidDeviceManufacturers");
            return this;
        }

        /**
         * <i>“Defines a managed app behavior, either block or wipe, if the specified device
         * manufacturer is not allowed.”</i>
         * 
         * @param appActionIfAndroidDeviceManufacturerNotAllowed
         *            value of {@code appActionIfAndroidDeviceManufacturerNotAllowed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appActionIfAndroidDeviceManufacturerNotAllowed(ManagedAppRemediationAction appActionIfAndroidDeviceManufacturerNotAllowed) {
            this.appActionIfAndroidDeviceManufacturerNotAllowed = appActionIfAndroidDeviceManufacturerNotAllowed;
            this.changedFields = changedFields.add("appActionIfAndroidDeviceManufacturerNotAllowed");
            return this;
        }

        /**
         * <i>“Defines the Android SafetyNet Device Attestation requirement for a managed app
         * to work.”</i>
         * 
         * @param requiredAndroidSafetyNetDeviceAttestationType
         *            value of {@code requiredAndroidSafetyNetDeviceAttestationType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requiredAndroidSafetyNetDeviceAttestationType(AndroidManagedAppSafetyNetDeviceAttestationType requiredAndroidSafetyNetDeviceAttestationType) {
            this.requiredAndroidSafetyNetDeviceAttestationType = requiredAndroidSafetyNetDeviceAttestationType;
            this.changedFields = changedFields.add("requiredAndroidSafetyNetDeviceAttestationType");
            return this;
        }

        /**
         * <i>“Defines a managed app behavior, either warn or block, if the specified Android
         * SafetyNet Attestation requirment fails.”</i>
         * 
         * @param appActionIfAndroidSafetyNetDeviceAttestationFailed
         *            value of {@code appActionIfAndroidSafetyNetDeviceAttestationFailed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appActionIfAndroidSafetyNetDeviceAttestationFailed(ManagedAppRemediationAction appActionIfAndroidSafetyNetDeviceAttestationFailed) {
            this.appActionIfAndroidSafetyNetDeviceAttestationFailed = appActionIfAndroidSafetyNetDeviceAttestationFailed;
            this.changedFields = changedFields.add("appActionIfAndroidSafetyNetDeviceAttestationFailed");
            return this;
        }

        /**
         * <i>“Defines the Android SafetyNet Apps Verification requirement for a managed app to
         * work.”</i>
         * 
         * @param requiredAndroidSafetyNetAppsVerificationType
         *            value of {@code requiredAndroidSafetyNetAppsVerificationType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder requiredAndroidSafetyNetAppsVerificationType(AndroidManagedAppSafetyNetAppsVerificationType requiredAndroidSafetyNetAppsVerificationType) {
            this.requiredAndroidSafetyNetAppsVerificationType = requiredAndroidSafetyNetAppsVerificationType;
            this.changedFields = changedFields.add("requiredAndroidSafetyNetAppsVerificationType");
            return this;
        }

        /**
         * <i>“Defines a managed app behavior, either warn or block, if the specified Android
         * App Verification requirment fails.”</i>
         * 
         * @param appActionIfAndroidSafetyNetAppsVerificationFailed
         *            value of {@code appActionIfAndroidSafetyNetAppsVerificationFailed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appActionIfAndroidSafetyNetAppsVerificationFailed(ManagedAppRemediationAction appActionIfAndroidSafetyNetAppsVerificationFailed) {
            this.appActionIfAndroidSafetyNetAppsVerificationFailed = appActionIfAndroidSafetyNetAppsVerificationFailed;
            this.changedFields = changedFields.add("appActionIfAndroidSafetyNetAppsVerificationFailed");
            return this;
        }

        /**
         * <i>“Unique identifier of the preferred custom browser to open weblink on Android.
         * When this property is configured, ManagedBrowserToOpenLinksRequired should be
         * true.”</i>
         * 
         * @param customBrowserPackageId
         *            value of {@code customBrowserPackageId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customBrowserPackageId(String customBrowserPackageId) {
            this.customBrowserPackageId = customBrowserPackageId;
            this.changedFields = changedFields.add("customBrowserPackageId");
            return this;
        }

        /**
         * <i>“Friendly name of the preferred custom browser to open weblink on Android. When
         * this property is configured, ManagedBrowserToOpenLinksRequired should be true.”</i>
         * 
         * @param customBrowserDisplayName
         *            value of {@code customBrowserDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customBrowserDisplayName(String customBrowserDisplayName) {
            this.customBrowserDisplayName = customBrowserDisplayName;
            this.changedFields = changedFields.add("customBrowserDisplayName");
            return this;
        }

        /**
         * <i>“Minimum version of the Company portal that must be installed on the device or
         * app access will be blocked”</i>
         * 
         * @param minimumRequiredCompanyPortalVersion
         *            value of {@code minimumRequiredCompanyPortalVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumRequiredCompanyPortalVersion(String minimumRequiredCompanyPortalVersion) {
            this.minimumRequiredCompanyPortalVersion = minimumRequiredCompanyPortalVersion;
            this.changedFields = changedFields.add("minimumRequiredCompanyPortalVersion");
            return this;
        }

        /**
         * <i>“Minimum version of the Company portal that must be installed on the device or
         * the user will receive a warning”</i>
         * 
         * @param minimumWarningCompanyPortalVersion
         *            value of {@code minimumWarningCompanyPortalVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumWarningCompanyPortalVersion(String minimumWarningCompanyPortalVersion) {
            this.minimumWarningCompanyPortalVersion = minimumWarningCompanyPortalVersion;
            this.changedFields = changedFields.add("minimumWarningCompanyPortalVersion");
            return this;
        }

        /**
         * <i>“Minimum version of the Company portal that must be installed on the device or
         * the company data on the app will be wiped”</i>
         * 
         * @param minimumWipeCompanyPortalVersion
         *            value of {@code minimumWipeCompanyPortalVersion} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder minimumWipeCompanyPortalVersion(String minimumWipeCompanyPortalVersion) {
            this.minimumWipeCompanyPortalVersion = minimumWipeCompanyPortalVersion;
            this.changedFields = changedFields.add("minimumWipeCompanyPortalVersion");
            return this;
        }

        /**
         * <i>“Indicates if keyboard restriction is enabled. If enabled list of approved
         * keyboards must be provided as well.”</i>
         * 
         * @param keyboardsRestricted
         *            value of {@code keyboardsRestricted} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder keyboardsRestricted(Boolean keyboardsRestricted) {
            this.keyboardsRestricted = keyboardsRestricted;
            this.changedFields = changedFields.add("keyboardsRestricted");
            return this;
        }

        /**
         * <i>“If Keyboard Restriction is enabled, only keyboards in this approved list will be
         * allowed. A key should be Android package id for a keyboard and value should be a
         * friendly name”</i>
         * 
         * @param approvedKeyboards
         *            value of {@code approvedKeyboards} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder approvedKeyboards(List<KeyValuePair> approvedKeyboards) {
            this.approvedKeyboards = approvedKeyboards;
            this.changedFields = changedFields.add("approvedKeyboards");
            return this;
        }

        /**
         * <i>“If Keyboard Restriction is enabled, only keyboards in this approved list will be
         * allowed. A key should be Android package id for a keyboard and value should be a
         * friendly name”</i>
         * 
         * @param approvedKeyboards
         *            value of {@code approvedKeyboards} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder approvedKeyboards(KeyValuePair... approvedKeyboards) {
            return approvedKeyboards(Arrays.asList(approvedKeyboards));
        }

        /**
         * <i>“If Keyboard Restriction is enabled, only keyboards in this approved list will be
         * allowed. A key should be Android package id for a keyboard and value should be a
         * friendly name”</i>
         * 
         * @param approvedKeyboardsNextLink
         *            value of {@code approvedKeyboards@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder approvedKeyboardsNextLink(String approvedKeyboardsNextLink) {
            this.approvedKeyboardsNextLink = approvedKeyboardsNextLink;
            this.changedFields = changedFields.add("approvedKeyboards");
            return this;
        }

        /**
         * <i>“List of device models allowed, as a string, for the managed app to work.”</i>
         * 
         * @param allowedAndroidDeviceModels
         *            value of {@code allowedAndroidDeviceModels} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedAndroidDeviceModels(List<String> allowedAndroidDeviceModels) {
            this.allowedAndroidDeviceModels = allowedAndroidDeviceModels;
            this.changedFields = changedFields.add("allowedAndroidDeviceModels");
            return this;
        }

        /**
         * <i>“List of device models allowed, as a string, for the managed app to work.”</i>
         * 
         * @param allowedAndroidDeviceModels
         *            value of {@code allowedAndroidDeviceModels} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedAndroidDeviceModels(String... allowedAndroidDeviceModels) {
            return allowedAndroidDeviceModels(Arrays.asList(allowedAndroidDeviceModels));
        }

        /**
         * <i>“List of device models allowed, as a string, for the managed app to work.”</i>
         * 
         * @param allowedAndroidDeviceModelsNextLink
         *            value of {@code allowedAndroidDeviceModels@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder allowedAndroidDeviceModelsNextLink(String allowedAndroidDeviceModelsNextLink) {
            this.allowedAndroidDeviceModelsNextLink = allowedAndroidDeviceModelsNextLink;
            this.changedFields = changedFields.add("allowedAndroidDeviceModels");
            return this;
        }

        /**
         * <i>“Defines a managed app behavior, either block or wipe, if the specified device
         * model is not allowed.”</i>
         * 
         * @param appActionIfAndroidDeviceModelNotAllowed
         *            value of {@code appActionIfAndroidDeviceModelNotAllowed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appActionIfAndroidDeviceModelNotAllowed(ManagedAppRemediationAction appActionIfAndroidDeviceModelNotAllowed) {
            this.appActionIfAndroidDeviceModelNotAllowed = appActionIfAndroidDeviceModelNotAllowed;
            this.changedFields = changedFields.add("appActionIfAndroidDeviceModelNotAllowed");
            return this;
        }

        /**
         * <i>“PackageId of a custom dialer app to click-to-open a phone number on Android.”</i>
         * 
         * @param customDialerAppPackageId
         *            value of {@code customDialerAppPackageId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customDialerAppPackageId(String customDialerAppPackageId) {
            this.customDialerAppPackageId = customDialerAppPackageId;
            this.changedFields = changedFields.add("customDialerAppPackageId");
            return this;
        }

        /**
         * <i>“Friendly name of a custom dialer app to click-to-open a phone number on Android.”</i>
         * 
         * @param customDialerAppDisplayName
         *            value of {@code customDialerAppDisplayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customDialerAppDisplayName(String customDialerAppDisplayName) {
            this.customDialerAppDisplayName = customDialerAppDisplayName;
            this.changedFields = changedFields.add("customDialerAppDisplayName");
            return this;
        }

        public AndroidManagedAppProtection build() {
            AndroidManagedAppProtection _x = new AndroidManagedAppProtection();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.androidManagedAppProtection";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.version = version;
            _x.periodOfflineBeforeAccessCheck = periodOfflineBeforeAccessCheck;
            _x.periodOnlineBeforeAccessCheck = periodOnlineBeforeAccessCheck;
            _x.allowedInboundDataTransferSources = allowedInboundDataTransferSources;
            _x.allowedOutboundDataTransferDestinations = allowedOutboundDataTransferDestinations;
            _x.organizationalCredentialsRequired = organizationalCredentialsRequired;
            _x.allowedOutboundClipboardSharingLevel = allowedOutboundClipboardSharingLevel;
            _x.dataBackupBlocked = dataBackupBlocked;
            _x.deviceComplianceRequired = deviceComplianceRequired;
            _x.managedBrowserToOpenLinksRequired = managedBrowserToOpenLinksRequired;
            _x.saveAsBlocked = saveAsBlocked;
            _x.periodOfflineBeforeWipeIsEnforced = periodOfflineBeforeWipeIsEnforced;
            _x.pinRequired = pinRequired;
            _x.maximumPinRetries = maximumPinRetries;
            _x.simplePinBlocked = simplePinBlocked;
            _x.minimumPinLength = minimumPinLength;
            _x.pinCharacterSet = pinCharacterSet;
            _x.periodBeforePinReset = periodBeforePinReset;
            _x.allowedDataStorageLocations = allowedDataStorageLocations;
            _x.allowedDataStorageLocationsNextLink = allowedDataStorageLocationsNextLink;
            _x.contactSyncBlocked = contactSyncBlocked;
            _x.printBlocked = printBlocked;
            _x.fingerprintBlocked = fingerprintBlocked;
            _x.disableAppPinIfDevicePinIsSet = disableAppPinIfDevicePinIsSet;
            _x.minimumRequiredOsVersion = minimumRequiredOsVersion;
            _x.minimumWarningOsVersion = minimumWarningOsVersion;
            _x.minimumRequiredAppVersion = minimumRequiredAppVersion;
            _x.minimumWarningAppVersion = minimumWarningAppVersion;
            _x.minimumWipeOsVersion = minimumWipeOsVersion;
            _x.minimumWipeAppVersion = minimumWipeAppVersion;
            _x.appActionIfDeviceComplianceRequired = appActionIfDeviceComplianceRequired;
            _x.appActionIfMaximumPinRetriesExceeded = appActionIfMaximumPinRetriesExceeded;
            _x.pinRequiredInsteadOfBiometricTimeout = pinRequiredInsteadOfBiometricTimeout;
            _x.allowedOutboundClipboardSharingExceptionLength = allowedOutboundClipboardSharingExceptionLength;
            _x.notificationRestriction = notificationRestriction;
            _x.previousPinBlockCount = previousPinBlockCount;
            _x.managedBrowser = managedBrowser;
            _x.maximumAllowedDeviceThreatLevel = maximumAllowedDeviceThreatLevel;
            _x.mobileThreatDefenseRemediationAction = mobileThreatDefenseRemediationAction;
            _x.blockDataIngestionIntoOrganizationDocuments = blockDataIngestionIntoOrganizationDocuments;
            _x.allowedDataIngestionLocations = allowedDataIngestionLocations;
            _x.allowedDataIngestionLocationsNextLink = allowedDataIngestionLocationsNextLink;
            _x.appActionIfUnableToAuthenticateUser = appActionIfUnableToAuthenticateUser;
            _x.dialerRestrictionLevel = dialerRestrictionLevel;
            _x.isAssigned = isAssigned;
            _x.targetedAppManagementLevels = targetedAppManagementLevels;
            _x.screenCaptureBlocked = screenCaptureBlocked;
            _x.disableAppEncryptionIfDeviceEncryptionIsEnabled = disableAppEncryptionIfDeviceEncryptionIsEnabled;
            _x.encryptAppData = encryptAppData;
            _x.deployedAppCount = deployedAppCount;
            _x.minimumRequiredPatchVersion = minimumRequiredPatchVersion;
            _x.minimumWarningPatchVersion = minimumWarningPatchVersion;
            _x.exemptedAppPackages = exemptedAppPackages;
            _x.exemptedAppPackagesNextLink = exemptedAppPackagesNextLink;
            _x.minimumWipePatchVersion = minimumWipePatchVersion;
            _x.allowedAndroidDeviceManufacturers = allowedAndroidDeviceManufacturers;
            _x.appActionIfAndroidDeviceManufacturerNotAllowed = appActionIfAndroidDeviceManufacturerNotAllowed;
            _x.requiredAndroidSafetyNetDeviceAttestationType = requiredAndroidSafetyNetDeviceAttestationType;
            _x.appActionIfAndroidSafetyNetDeviceAttestationFailed = appActionIfAndroidSafetyNetDeviceAttestationFailed;
            _x.requiredAndroidSafetyNetAppsVerificationType = requiredAndroidSafetyNetAppsVerificationType;
            _x.appActionIfAndroidSafetyNetAppsVerificationFailed = appActionIfAndroidSafetyNetAppsVerificationFailed;
            _x.customBrowserPackageId = customBrowserPackageId;
            _x.customBrowserDisplayName = customBrowserDisplayName;
            _x.minimumRequiredCompanyPortalVersion = minimumRequiredCompanyPortalVersion;
            _x.minimumWarningCompanyPortalVersion = minimumWarningCompanyPortalVersion;
            _x.minimumWipeCompanyPortalVersion = minimumWipeCompanyPortalVersion;
            _x.keyboardsRestricted = keyboardsRestricted;
            _x.approvedKeyboards = approvedKeyboards;
            _x.approvedKeyboardsNextLink = approvedKeyboardsNextLink;
            _x.allowedAndroidDeviceModels = allowedAndroidDeviceModels;
            _x.allowedAndroidDeviceModelsNextLink = allowedAndroidDeviceModelsNextLink;
            _x.appActionIfAndroidDeviceModelNotAllowed = appActionIfAndroidDeviceModelNotAllowed;
            _x.customDialerAppPackageId = customDialerAppPackageId;
            _x.customDialerAppDisplayName = customDialerAppDisplayName;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Indicates whether a managed user can take screen captures of managed apps”</i>
     * 
     * @return property screenCaptureBlocked
     */
    @Property(name="screenCaptureBlocked")
    @JsonIgnore
    public Optional<Boolean> getScreenCaptureBlocked() {
        return Optional.ofNullable(screenCaptureBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * screenCaptureBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether a managed user can take screen captures of managed apps”</i>
     * 
     * @param screenCaptureBlocked
     *            new value of {@code screenCaptureBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code screenCaptureBlocked} field changed
     */
    public AndroidManagedAppProtection withScreenCaptureBlocked(Boolean screenCaptureBlocked) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("screenCaptureBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.screenCaptureBlocked = screenCaptureBlocked;
        return _x;
    }

    /**
     * <i>“When this setting is enabled, app level encryption is disabled if device level
     * encryption is enabled”</i>
     * 
     * @return property disableAppEncryptionIfDeviceEncryptionIsEnabled
     */
    @Property(name="disableAppEncryptionIfDeviceEncryptionIsEnabled")
    @JsonIgnore
    public Optional<Boolean> getDisableAppEncryptionIfDeviceEncryptionIsEnabled() {
        return Optional.ofNullable(disableAppEncryptionIfDeviceEncryptionIsEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * disableAppEncryptionIfDeviceEncryptionIsEnabled} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“When this setting is enabled, app level encryption is disabled if device level
     * encryption is enabled”</i>
     * 
     * @param disableAppEncryptionIfDeviceEncryptionIsEnabled
     *            new value of {@code disableAppEncryptionIfDeviceEncryptionIsEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code disableAppEncryptionIfDeviceEncryptionIsEnabled} field changed
     */
    public AndroidManagedAppProtection withDisableAppEncryptionIfDeviceEncryptionIsEnabled(Boolean disableAppEncryptionIfDeviceEncryptionIsEnabled) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("disableAppEncryptionIfDeviceEncryptionIsEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.disableAppEncryptionIfDeviceEncryptionIsEnabled = disableAppEncryptionIfDeviceEncryptionIsEnabled;
        return _x;
    }

    /**
     * <i>“Indicates whether application data for managed apps should be encrypted”</i>
     * 
     * @return property encryptAppData
     */
    @Property(name="encryptAppData")
    @JsonIgnore
    public Optional<Boolean> getEncryptAppData() {
        return Optional.ofNullable(encryptAppData);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code encryptAppData}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether application data for managed apps should be encrypted”</i>
     * 
     * @param encryptAppData
     *            new value of {@code encryptAppData} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code encryptAppData} field changed
     */
    public AndroidManagedAppProtection withEncryptAppData(Boolean encryptAppData) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("encryptAppData");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.encryptAppData = encryptAppData;
        return _x;
    }

    /**
     * <i>“Count of apps to which the current policy is deployed.”</i>
     * 
     * @return property deployedAppCount
     */
    @Property(name="deployedAppCount")
    @JsonIgnore
    public Optional<Integer> getDeployedAppCount() {
        return Optional.ofNullable(deployedAppCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code deployedAppCount}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Count of apps to which the current policy is deployed.”</i>
     * 
     * @param deployedAppCount
     *            new value of {@code deployedAppCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deployedAppCount} field changed
     */
    public AndroidManagedAppProtection withDeployedAppCount(Integer deployedAppCount) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("deployedAppCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.deployedAppCount = deployedAppCount;
        return _x;
    }

    /**
     * <i>“Define the oldest required Android security patch level a user can have to gain
     * secure access to the app.”</i>
     * 
     * @return property minimumRequiredPatchVersion
     */
    @Property(name="minimumRequiredPatchVersion")
    @JsonIgnore
    public Optional<String> getMinimumRequiredPatchVersion() {
        return Optional.ofNullable(minimumRequiredPatchVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumRequiredPatchVersion} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Define the oldest required Android security patch level a user can have to gain
     * secure access to the app.”</i>
     * 
     * @param minimumRequiredPatchVersion
     *            new value of {@code minimumRequiredPatchVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumRequiredPatchVersion} field changed
     */
    public AndroidManagedAppProtection withMinimumRequiredPatchVersion(String minimumRequiredPatchVersion) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("minimumRequiredPatchVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.minimumRequiredPatchVersion = minimumRequiredPatchVersion;
        return _x;
    }

    /**
     * <i>“Define the oldest recommended Android security patch level a user can have for
     * secure access to the app.”</i>
     * 
     * @return property minimumWarningPatchVersion
     */
    @Property(name="minimumWarningPatchVersion")
    @JsonIgnore
    public Optional<String> getMinimumWarningPatchVersion() {
        return Optional.ofNullable(minimumWarningPatchVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumWarningPatchVersion} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Define the oldest recommended Android security patch level a user can have for
     * secure access to the app.”</i>
     * 
     * @param minimumWarningPatchVersion
     *            new value of {@code minimumWarningPatchVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumWarningPatchVersion} field changed
     */
    public AndroidManagedAppProtection withMinimumWarningPatchVersion(String minimumWarningPatchVersion) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("minimumWarningPatchVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.minimumWarningPatchVersion = minimumWarningPatchVersion;
        return _x;
    }

    /**
     * <i>“App packages in this list will be exempt from the policy and will be able to
     * receive data from managed apps.”</i>
     * 
     * @return property exemptedAppPackages
     */
    @Property(name="exemptedAppPackages")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getExemptedAppPackages() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, exemptedAppPackages, Optional.ofNullable(exemptedAppPackagesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“App packages in this list will be exempt from the policy and will be able to
     * receive data from managed apps.”</i>
     * 
     * @return property exemptedAppPackages
     */
    @Property(name="exemptedAppPackages")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getExemptedAppPackages(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, exemptedAppPackages, Optional.ofNullable(exemptedAppPackagesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Android security patch level  less than or equal to the specified value will
     * wipe the managed app and the associated company data.”</i>
     * 
     * @return property minimumWipePatchVersion
     */
    @Property(name="minimumWipePatchVersion")
    @JsonIgnore
    public Optional<String> getMinimumWipePatchVersion() {
        return Optional.ofNullable(minimumWipePatchVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumWipePatchVersion} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Android security patch level  less than or equal to the specified value will
     * wipe the managed app and the associated company data.”</i>
     * 
     * @param minimumWipePatchVersion
     *            new value of {@code minimumWipePatchVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumWipePatchVersion} field changed
     */
    public AndroidManagedAppProtection withMinimumWipePatchVersion(String minimumWipePatchVersion) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("minimumWipePatchVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.minimumWipePatchVersion = minimumWipePatchVersion;
        return _x;
    }

    /**
     * <i>“Semicolon seperated list of device manufacturers allowed, as a string, for the
     * managed app to work.”</i>
     * 
     * @return property allowedAndroidDeviceManufacturers
     */
    @Property(name="allowedAndroidDeviceManufacturers")
    @JsonIgnore
    public Optional<String> getAllowedAndroidDeviceManufacturers() {
        return Optional.ofNullable(allowedAndroidDeviceManufacturers);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * allowedAndroidDeviceManufacturers} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Semicolon seperated list of device manufacturers allowed, as a string, for the
     * managed app to work.”</i>
     * 
     * @param allowedAndroidDeviceManufacturers
     *            new value of {@code allowedAndroidDeviceManufacturers} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code allowedAndroidDeviceManufacturers} field changed
     */
    public AndroidManagedAppProtection withAllowedAndroidDeviceManufacturers(String allowedAndroidDeviceManufacturers) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("allowedAndroidDeviceManufacturers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.allowedAndroidDeviceManufacturers = allowedAndroidDeviceManufacturers;
        return _x;
    }

    /**
     * <i>“Defines a managed app behavior, either block or wipe, if the specified device
     * manufacturer is not allowed.”</i>
     * 
     * @return property appActionIfAndroidDeviceManufacturerNotAllowed
     */
    @Property(name="appActionIfAndroidDeviceManufacturerNotAllowed")
    @JsonIgnore
    public Optional<ManagedAppRemediationAction> getAppActionIfAndroidDeviceManufacturerNotAllowed() {
        return Optional.ofNullable(appActionIfAndroidDeviceManufacturerNotAllowed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appActionIfAndroidDeviceManufacturerNotAllowed} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Defines a managed app behavior, either block or wipe, if the specified device
     * manufacturer is not allowed.”</i>
     * 
     * @param appActionIfAndroidDeviceManufacturerNotAllowed
     *            new value of {@code appActionIfAndroidDeviceManufacturerNotAllowed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appActionIfAndroidDeviceManufacturerNotAllowed} field changed
     */
    public AndroidManagedAppProtection withAppActionIfAndroidDeviceManufacturerNotAllowed(ManagedAppRemediationAction appActionIfAndroidDeviceManufacturerNotAllowed) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("appActionIfAndroidDeviceManufacturerNotAllowed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.appActionIfAndroidDeviceManufacturerNotAllowed = appActionIfAndroidDeviceManufacturerNotAllowed;
        return _x;
    }

    /**
     * <i>“Defines the Android SafetyNet Device Attestation requirement for a managed app
     * to work.”</i>
     * 
     * @return property requiredAndroidSafetyNetDeviceAttestationType
     */
    @Property(name="requiredAndroidSafetyNetDeviceAttestationType")
    @JsonIgnore
    public Optional<AndroidManagedAppSafetyNetDeviceAttestationType> getRequiredAndroidSafetyNetDeviceAttestationType() {
        return Optional.ofNullable(requiredAndroidSafetyNetDeviceAttestationType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * requiredAndroidSafetyNetDeviceAttestationType} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Defines the Android SafetyNet Device Attestation requirement for a managed app
     * to work.”</i>
     * 
     * @param requiredAndroidSafetyNetDeviceAttestationType
     *            new value of {@code requiredAndroidSafetyNetDeviceAttestationType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requiredAndroidSafetyNetDeviceAttestationType} field changed
     */
    public AndroidManagedAppProtection withRequiredAndroidSafetyNetDeviceAttestationType(AndroidManagedAppSafetyNetDeviceAttestationType requiredAndroidSafetyNetDeviceAttestationType) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("requiredAndroidSafetyNetDeviceAttestationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.requiredAndroidSafetyNetDeviceAttestationType = requiredAndroidSafetyNetDeviceAttestationType;
        return _x;
    }

    /**
     * <i>“Defines a managed app behavior, either warn or block, if the specified Android
     * SafetyNet Attestation requirment fails.”</i>
     * 
     * @return property appActionIfAndroidSafetyNetDeviceAttestationFailed
     */
    @Property(name="appActionIfAndroidSafetyNetDeviceAttestationFailed")
    @JsonIgnore
    public Optional<ManagedAppRemediationAction> getAppActionIfAndroidSafetyNetDeviceAttestationFailed() {
        return Optional.ofNullable(appActionIfAndroidSafetyNetDeviceAttestationFailed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appActionIfAndroidSafetyNetDeviceAttestationFailed} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Defines a managed app behavior, either warn or block, if the specified Android
     * SafetyNet Attestation requirment fails.”</i>
     * 
     * @param appActionIfAndroidSafetyNetDeviceAttestationFailed
     *            new value of {@code appActionIfAndroidSafetyNetDeviceAttestationFailed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appActionIfAndroidSafetyNetDeviceAttestationFailed} field changed
     */
    public AndroidManagedAppProtection withAppActionIfAndroidSafetyNetDeviceAttestationFailed(ManagedAppRemediationAction appActionIfAndroidSafetyNetDeviceAttestationFailed) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("appActionIfAndroidSafetyNetDeviceAttestationFailed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.appActionIfAndroidSafetyNetDeviceAttestationFailed = appActionIfAndroidSafetyNetDeviceAttestationFailed;
        return _x;
    }

    /**
     * <i>“Defines the Android SafetyNet Apps Verification requirement for a managed app to
     * work.”</i>
     * 
     * @return property requiredAndroidSafetyNetAppsVerificationType
     */
    @Property(name="requiredAndroidSafetyNetAppsVerificationType")
    @JsonIgnore
    public Optional<AndroidManagedAppSafetyNetAppsVerificationType> getRequiredAndroidSafetyNetAppsVerificationType() {
        return Optional.ofNullable(requiredAndroidSafetyNetAppsVerificationType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * requiredAndroidSafetyNetAppsVerificationType} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Defines the Android SafetyNet Apps Verification requirement for a managed app to
     * work.”</i>
     * 
     * @param requiredAndroidSafetyNetAppsVerificationType
     *            new value of {@code requiredAndroidSafetyNetAppsVerificationType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code requiredAndroidSafetyNetAppsVerificationType} field changed
     */
    public AndroidManagedAppProtection withRequiredAndroidSafetyNetAppsVerificationType(AndroidManagedAppSafetyNetAppsVerificationType requiredAndroidSafetyNetAppsVerificationType) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("requiredAndroidSafetyNetAppsVerificationType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.requiredAndroidSafetyNetAppsVerificationType = requiredAndroidSafetyNetAppsVerificationType;
        return _x;
    }

    /**
     * <i>“Defines a managed app behavior, either warn or block, if the specified Android
     * App Verification requirment fails.”</i>
     * 
     * @return property appActionIfAndroidSafetyNetAppsVerificationFailed
     */
    @Property(name="appActionIfAndroidSafetyNetAppsVerificationFailed")
    @JsonIgnore
    public Optional<ManagedAppRemediationAction> getAppActionIfAndroidSafetyNetAppsVerificationFailed() {
        return Optional.ofNullable(appActionIfAndroidSafetyNetAppsVerificationFailed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appActionIfAndroidSafetyNetAppsVerificationFailed} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Defines a managed app behavior, either warn or block, if the specified Android
     * App Verification requirment fails.”</i>
     * 
     * @param appActionIfAndroidSafetyNetAppsVerificationFailed
     *            new value of {@code appActionIfAndroidSafetyNetAppsVerificationFailed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appActionIfAndroidSafetyNetAppsVerificationFailed} field changed
     */
    public AndroidManagedAppProtection withAppActionIfAndroidSafetyNetAppsVerificationFailed(ManagedAppRemediationAction appActionIfAndroidSafetyNetAppsVerificationFailed) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("appActionIfAndroidSafetyNetAppsVerificationFailed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.appActionIfAndroidSafetyNetAppsVerificationFailed = appActionIfAndroidSafetyNetAppsVerificationFailed;
        return _x;
    }

    /**
     * <i>“Unique identifier of the preferred custom browser to open weblink on Android.
     * When this property is configured, ManagedBrowserToOpenLinksRequired should be
     * true.”</i>
     * 
     * @return property customBrowserPackageId
     */
    @Property(name="customBrowserPackageId")
    @JsonIgnore
    public Optional<String> getCustomBrowserPackageId() {
        return Optional.ofNullable(customBrowserPackageId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * customBrowserPackageId} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Unique identifier of the preferred custom browser to open weblink on Android.
     * When this property is configured, ManagedBrowserToOpenLinksRequired should be
     * true.”</i>
     * 
     * @param customBrowserPackageId
     *            new value of {@code customBrowserPackageId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customBrowserPackageId} field changed
     */
    public AndroidManagedAppProtection withCustomBrowserPackageId(String customBrowserPackageId) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("customBrowserPackageId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.customBrowserPackageId = customBrowserPackageId;
        return _x;
    }

    /**
     * <i>“Friendly name of the preferred custom browser to open weblink on Android. When
     * this property is configured, ManagedBrowserToOpenLinksRequired should be true.”</i>
     * 
     * @return property customBrowserDisplayName
     */
    @Property(name="customBrowserDisplayName")
    @JsonIgnore
    public Optional<String> getCustomBrowserDisplayName() {
        return Optional.ofNullable(customBrowserDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * customBrowserDisplayName} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Friendly name of the preferred custom browser to open weblink on Android. When
     * this property is configured, ManagedBrowserToOpenLinksRequired should be true.”</i>
     * 
     * @param customBrowserDisplayName
     *            new value of {@code customBrowserDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customBrowserDisplayName} field changed
     */
    public AndroidManagedAppProtection withCustomBrowserDisplayName(String customBrowserDisplayName) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("customBrowserDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.customBrowserDisplayName = customBrowserDisplayName;
        return _x;
    }

    /**
     * <i>“Minimum version of the Company portal that must be installed on the device or
     * app access will be blocked”</i>
     * 
     * @return property minimumRequiredCompanyPortalVersion
     */
    @Property(name="minimumRequiredCompanyPortalVersion")
    @JsonIgnore
    public Optional<String> getMinimumRequiredCompanyPortalVersion() {
        return Optional.ofNullable(minimumRequiredCompanyPortalVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumRequiredCompanyPortalVersion} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Minimum version of the Company portal that must be installed on the device or
     * app access will be blocked”</i>
     * 
     * @param minimumRequiredCompanyPortalVersion
     *            new value of {@code minimumRequiredCompanyPortalVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumRequiredCompanyPortalVersion} field changed
     */
    public AndroidManagedAppProtection withMinimumRequiredCompanyPortalVersion(String minimumRequiredCompanyPortalVersion) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("minimumRequiredCompanyPortalVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.minimumRequiredCompanyPortalVersion = minimumRequiredCompanyPortalVersion;
        return _x;
    }

    /**
     * <i>“Minimum version of the Company portal that must be installed on the device or
     * the user will receive a warning”</i>
     * 
     * @return property minimumWarningCompanyPortalVersion
     */
    @Property(name="minimumWarningCompanyPortalVersion")
    @JsonIgnore
    public Optional<String> getMinimumWarningCompanyPortalVersion() {
        return Optional.ofNullable(minimumWarningCompanyPortalVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumWarningCompanyPortalVersion} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Minimum version of the Company portal that must be installed on the device or
     * the user will receive a warning”</i>
     * 
     * @param minimumWarningCompanyPortalVersion
     *            new value of {@code minimumWarningCompanyPortalVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumWarningCompanyPortalVersion} field changed
     */
    public AndroidManagedAppProtection withMinimumWarningCompanyPortalVersion(String minimumWarningCompanyPortalVersion) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("minimumWarningCompanyPortalVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.minimumWarningCompanyPortalVersion = minimumWarningCompanyPortalVersion;
        return _x;
    }

    /**
     * <i>“Minimum version of the Company portal that must be installed on the device or
     * the company data on the app will be wiped”</i>
     * 
     * @return property minimumWipeCompanyPortalVersion
     */
    @Property(name="minimumWipeCompanyPortalVersion")
    @JsonIgnore
    public Optional<String> getMinimumWipeCompanyPortalVersion() {
        return Optional.ofNullable(minimumWipeCompanyPortalVersion);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * minimumWipeCompanyPortalVersion} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Minimum version of the Company portal that must be installed on the device or
     * the company data on the app will be wiped”</i>
     * 
     * @param minimumWipeCompanyPortalVersion
     *            new value of {@code minimumWipeCompanyPortalVersion} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code minimumWipeCompanyPortalVersion} field changed
     */
    public AndroidManagedAppProtection withMinimumWipeCompanyPortalVersion(String minimumWipeCompanyPortalVersion) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("minimumWipeCompanyPortalVersion");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.minimumWipeCompanyPortalVersion = minimumWipeCompanyPortalVersion;
        return _x;
    }

    /**
     * <i>“Indicates if keyboard restriction is enabled. If enabled list of approved
     * keyboards must be provided as well.”</i>
     * 
     * @return property keyboardsRestricted
     */
    @Property(name="keyboardsRestricted")
    @JsonIgnore
    public Optional<Boolean> getKeyboardsRestricted() {
        return Optional.ofNullable(keyboardsRestricted);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * keyboardsRestricted} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates if keyboard restriction is enabled. If enabled list of approved
     * keyboards must be provided as well.”</i>
     * 
     * @param keyboardsRestricted
     *            new value of {@code keyboardsRestricted} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code keyboardsRestricted} field changed
     */
    public AndroidManagedAppProtection withKeyboardsRestricted(Boolean keyboardsRestricted) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("keyboardsRestricted");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.keyboardsRestricted = keyboardsRestricted;
        return _x;
    }

    /**
     * <i>“If Keyboard Restriction is enabled, only keyboards in this approved list will be
     * allowed. A key should be Android package id for a keyboard and value should be a
     * friendly name”</i>
     * 
     * @return property approvedKeyboards
     */
    @Property(name="approvedKeyboards")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getApprovedKeyboards() {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, approvedKeyboards, Optional.ofNullable(approvedKeyboardsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“If Keyboard Restriction is enabled, only keyboards in this approved list will be
     * allowed. A key should be Android package id for a keyboard and value should be a
     * friendly name”</i>
     * 
     * @return property approvedKeyboards
     */
    @Property(name="approvedKeyboards")
    @JsonIgnore
    public CollectionPage<KeyValuePair> getApprovedKeyboards(HttpRequestOptions options) {
        return new CollectionPage<KeyValuePair>(contextPath, KeyValuePair.class, approvedKeyboards, Optional.ofNullable(approvedKeyboardsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“List of device models allowed, as a string, for the managed app to work.”</i>
     * 
     * @return property allowedAndroidDeviceModels
     */
    @Property(name="allowedAndroidDeviceModels")
    @JsonIgnore
    public CollectionPage<String> getAllowedAndroidDeviceModels() {
        return new CollectionPage<String>(contextPath, String.class, allowedAndroidDeviceModels, Optional.ofNullable(allowedAndroidDeviceModelsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of device models allowed, as a string, for the managed app to work.”</i>
     * 
     * @return property allowedAndroidDeviceModels
     */
    @Property(name="allowedAndroidDeviceModels")
    @JsonIgnore
    public CollectionPage<String> getAllowedAndroidDeviceModels(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, allowedAndroidDeviceModels, Optional.ofNullable(allowedAndroidDeviceModelsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Defines a managed app behavior, either block or wipe, if the specified device
     * model is not allowed.”</i>
     * 
     * @return property appActionIfAndroidDeviceModelNotAllowed
     */
    @Property(name="appActionIfAndroidDeviceModelNotAllowed")
    @JsonIgnore
    public Optional<ManagedAppRemediationAction> getAppActionIfAndroidDeviceModelNotAllowed() {
        return Optional.ofNullable(appActionIfAndroidDeviceModelNotAllowed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appActionIfAndroidDeviceModelNotAllowed} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Defines a managed app behavior, either block or wipe, if the specified device
     * model is not allowed.”</i>
     * 
     * @param appActionIfAndroidDeviceModelNotAllowed
     *            new value of {@code appActionIfAndroidDeviceModelNotAllowed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appActionIfAndroidDeviceModelNotAllowed} field changed
     */
    public AndroidManagedAppProtection withAppActionIfAndroidDeviceModelNotAllowed(ManagedAppRemediationAction appActionIfAndroidDeviceModelNotAllowed) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("appActionIfAndroidDeviceModelNotAllowed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.appActionIfAndroidDeviceModelNotAllowed = appActionIfAndroidDeviceModelNotAllowed;
        return _x;
    }

    /**
     * <i>“PackageId of a custom dialer app to click-to-open a phone number on Android.”</i>
     * 
     * @return property customDialerAppPackageId
     */
    @Property(name="customDialerAppPackageId")
    @JsonIgnore
    public Optional<String> getCustomDialerAppPackageId() {
        return Optional.ofNullable(customDialerAppPackageId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * customDialerAppPackageId} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“PackageId of a custom dialer app to click-to-open a phone number on Android.”</i>
     * 
     * @param customDialerAppPackageId
     *            new value of {@code customDialerAppPackageId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customDialerAppPackageId} field changed
     */
    public AndroidManagedAppProtection withCustomDialerAppPackageId(String customDialerAppPackageId) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("customDialerAppPackageId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.customDialerAppPackageId = customDialerAppPackageId;
        return _x;
    }

    /**
     * <i>“Friendly name of a custom dialer app to click-to-open a phone number on Android.”</i>
     * 
     * @return property customDialerAppDisplayName
     */
    @Property(name="customDialerAppDisplayName")
    @JsonIgnore
    public Optional<String> getCustomDialerAppDisplayName() {
        return Optional.ofNullable(customDialerAppDisplayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * customDialerAppDisplayName} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Friendly name of a custom dialer app to click-to-open a phone number on Android.”</i>
     * 
     * @param customDialerAppDisplayName
     *            new value of {@code customDialerAppDisplayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code customDialerAppDisplayName} field changed
     */
    public AndroidManagedAppProtection withCustomDialerAppDisplayName(String customDialerAppDisplayName) {
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = changedFields.add("customDialerAppDisplayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidManagedAppProtection");
        _x.customDialerAppDisplayName = customDialerAppDisplayName;
        return _x;
    }

    /**
     * <i>“List of apps to which the policy is deployed.”</i>
     * 
     * @return navigational property apps
     */
    @NavigationProperty(name="apps")
    @JsonIgnore
    public ManagedMobileAppCollectionRequest getApps() {
        return new ManagedMobileAppCollectionRequest(
                        contextPath.addSegment("apps"));
    }

    /**
     * <i>“Navigation property to deployment summary of the configuration.”</i>
     * 
     * @return navigational property deploymentSummary
     */
    @NavigationProperty(name="deploymentSummary")
    @JsonIgnore
    public ManagedAppPolicyDeploymentSummaryRequest getDeploymentSummary() {
        return new ManagedAppPolicyDeploymentSummaryRequest(contextPath.addSegment("deploymentSummary"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidManagedAppProtection patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidManagedAppProtection put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AndroidManagedAppProtection _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AndroidManagedAppProtection _copy() {
        AndroidManagedAppProtection _x = new AndroidManagedAppProtection();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.version = version;
        _x.periodOfflineBeforeAccessCheck = periodOfflineBeforeAccessCheck;
        _x.periodOnlineBeforeAccessCheck = periodOnlineBeforeAccessCheck;
        _x.allowedInboundDataTransferSources = allowedInboundDataTransferSources;
        _x.allowedOutboundDataTransferDestinations = allowedOutboundDataTransferDestinations;
        _x.organizationalCredentialsRequired = organizationalCredentialsRequired;
        _x.allowedOutboundClipboardSharingLevel = allowedOutboundClipboardSharingLevel;
        _x.dataBackupBlocked = dataBackupBlocked;
        _x.deviceComplianceRequired = deviceComplianceRequired;
        _x.managedBrowserToOpenLinksRequired = managedBrowserToOpenLinksRequired;
        _x.saveAsBlocked = saveAsBlocked;
        _x.periodOfflineBeforeWipeIsEnforced = periodOfflineBeforeWipeIsEnforced;
        _x.pinRequired = pinRequired;
        _x.maximumPinRetries = maximumPinRetries;
        _x.simplePinBlocked = simplePinBlocked;
        _x.minimumPinLength = minimumPinLength;
        _x.pinCharacterSet = pinCharacterSet;
        _x.periodBeforePinReset = periodBeforePinReset;
        _x.allowedDataStorageLocations = allowedDataStorageLocations;
        _x.contactSyncBlocked = contactSyncBlocked;
        _x.printBlocked = printBlocked;
        _x.fingerprintBlocked = fingerprintBlocked;
        _x.disableAppPinIfDevicePinIsSet = disableAppPinIfDevicePinIsSet;
        _x.minimumRequiredOsVersion = minimumRequiredOsVersion;
        _x.minimumWarningOsVersion = minimumWarningOsVersion;
        _x.minimumRequiredAppVersion = minimumRequiredAppVersion;
        _x.minimumWarningAppVersion = minimumWarningAppVersion;
        _x.minimumWipeOsVersion = minimumWipeOsVersion;
        _x.minimumWipeAppVersion = minimumWipeAppVersion;
        _x.appActionIfDeviceComplianceRequired = appActionIfDeviceComplianceRequired;
        _x.appActionIfMaximumPinRetriesExceeded = appActionIfMaximumPinRetriesExceeded;
        _x.pinRequiredInsteadOfBiometricTimeout = pinRequiredInsteadOfBiometricTimeout;
        _x.allowedOutboundClipboardSharingExceptionLength = allowedOutboundClipboardSharingExceptionLength;
        _x.notificationRestriction = notificationRestriction;
        _x.previousPinBlockCount = previousPinBlockCount;
        _x.managedBrowser = managedBrowser;
        _x.maximumAllowedDeviceThreatLevel = maximumAllowedDeviceThreatLevel;
        _x.mobileThreatDefenseRemediationAction = mobileThreatDefenseRemediationAction;
        _x.blockDataIngestionIntoOrganizationDocuments = blockDataIngestionIntoOrganizationDocuments;
        _x.allowedDataIngestionLocations = allowedDataIngestionLocations;
        _x.appActionIfUnableToAuthenticateUser = appActionIfUnableToAuthenticateUser;
        _x.dialerRestrictionLevel = dialerRestrictionLevel;
        _x.isAssigned = isAssigned;
        _x.targetedAppManagementLevels = targetedAppManagementLevels;
        _x.screenCaptureBlocked = screenCaptureBlocked;
        _x.disableAppEncryptionIfDeviceEncryptionIsEnabled = disableAppEncryptionIfDeviceEncryptionIsEnabled;
        _x.encryptAppData = encryptAppData;
        _x.deployedAppCount = deployedAppCount;
        _x.minimumRequiredPatchVersion = minimumRequiredPatchVersion;
        _x.minimumWarningPatchVersion = minimumWarningPatchVersion;
        _x.exemptedAppPackages = exemptedAppPackages;
        _x.minimumWipePatchVersion = minimumWipePatchVersion;
        _x.allowedAndroidDeviceManufacturers = allowedAndroidDeviceManufacturers;
        _x.appActionIfAndroidDeviceManufacturerNotAllowed = appActionIfAndroidDeviceManufacturerNotAllowed;
        _x.requiredAndroidSafetyNetDeviceAttestationType = requiredAndroidSafetyNetDeviceAttestationType;
        _x.appActionIfAndroidSafetyNetDeviceAttestationFailed = appActionIfAndroidSafetyNetDeviceAttestationFailed;
        _x.requiredAndroidSafetyNetAppsVerificationType = requiredAndroidSafetyNetAppsVerificationType;
        _x.appActionIfAndroidSafetyNetAppsVerificationFailed = appActionIfAndroidSafetyNetAppsVerificationFailed;
        _x.customBrowserPackageId = customBrowserPackageId;
        _x.customBrowserDisplayName = customBrowserDisplayName;
        _x.minimumRequiredCompanyPortalVersion = minimumRequiredCompanyPortalVersion;
        _x.minimumWarningCompanyPortalVersion = minimumWarningCompanyPortalVersion;
        _x.minimumWipeCompanyPortalVersion = minimumWipeCompanyPortalVersion;
        _x.keyboardsRestricted = keyboardsRestricted;
        _x.approvedKeyboards = approvedKeyboards;
        _x.allowedAndroidDeviceModels = allowedAndroidDeviceModels;
        _x.appActionIfAndroidDeviceModelNotAllowed = appActionIfAndroidDeviceModelNotAllowed;
        _x.customDialerAppPackageId = customDialerAppPackageId;
        _x.customDialerAppDisplayName = customDialerAppDisplayName;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidManagedAppProtection[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("periodOfflineBeforeAccessCheck=");
        b.append(this.periodOfflineBeforeAccessCheck);
        b.append(", ");
        b.append("periodOnlineBeforeAccessCheck=");
        b.append(this.periodOnlineBeforeAccessCheck);
        b.append(", ");
        b.append("allowedInboundDataTransferSources=");
        b.append(this.allowedInboundDataTransferSources);
        b.append(", ");
        b.append("allowedOutboundDataTransferDestinations=");
        b.append(this.allowedOutboundDataTransferDestinations);
        b.append(", ");
        b.append("organizationalCredentialsRequired=");
        b.append(this.organizationalCredentialsRequired);
        b.append(", ");
        b.append("allowedOutboundClipboardSharingLevel=");
        b.append(this.allowedOutboundClipboardSharingLevel);
        b.append(", ");
        b.append("dataBackupBlocked=");
        b.append(this.dataBackupBlocked);
        b.append(", ");
        b.append("deviceComplianceRequired=");
        b.append(this.deviceComplianceRequired);
        b.append(", ");
        b.append("managedBrowserToOpenLinksRequired=");
        b.append(this.managedBrowserToOpenLinksRequired);
        b.append(", ");
        b.append("saveAsBlocked=");
        b.append(this.saveAsBlocked);
        b.append(", ");
        b.append("periodOfflineBeforeWipeIsEnforced=");
        b.append(this.periodOfflineBeforeWipeIsEnforced);
        b.append(", ");
        b.append("pinRequired=");
        b.append(this.pinRequired);
        b.append(", ");
        b.append("maximumPinRetries=");
        b.append(this.maximumPinRetries);
        b.append(", ");
        b.append("simplePinBlocked=");
        b.append(this.simplePinBlocked);
        b.append(", ");
        b.append("minimumPinLength=");
        b.append(this.minimumPinLength);
        b.append(", ");
        b.append("pinCharacterSet=");
        b.append(this.pinCharacterSet);
        b.append(", ");
        b.append("periodBeforePinReset=");
        b.append(this.periodBeforePinReset);
        b.append(", ");
        b.append("allowedDataStorageLocations=");
        b.append(this.allowedDataStorageLocations);
        b.append(", ");
        b.append("contactSyncBlocked=");
        b.append(this.contactSyncBlocked);
        b.append(", ");
        b.append("printBlocked=");
        b.append(this.printBlocked);
        b.append(", ");
        b.append("fingerprintBlocked=");
        b.append(this.fingerprintBlocked);
        b.append(", ");
        b.append("disableAppPinIfDevicePinIsSet=");
        b.append(this.disableAppPinIfDevicePinIsSet);
        b.append(", ");
        b.append("minimumRequiredOsVersion=");
        b.append(this.minimumRequiredOsVersion);
        b.append(", ");
        b.append("minimumWarningOsVersion=");
        b.append(this.minimumWarningOsVersion);
        b.append(", ");
        b.append("minimumRequiredAppVersion=");
        b.append(this.minimumRequiredAppVersion);
        b.append(", ");
        b.append("minimumWarningAppVersion=");
        b.append(this.minimumWarningAppVersion);
        b.append(", ");
        b.append("minimumWipeOsVersion=");
        b.append(this.minimumWipeOsVersion);
        b.append(", ");
        b.append("minimumWipeAppVersion=");
        b.append(this.minimumWipeAppVersion);
        b.append(", ");
        b.append("appActionIfDeviceComplianceRequired=");
        b.append(this.appActionIfDeviceComplianceRequired);
        b.append(", ");
        b.append("appActionIfMaximumPinRetriesExceeded=");
        b.append(this.appActionIfMaximumPinRetriesExceeded);
        b.append(", ");
        b.append("pinRequiredInsteadOfBiometricTimeout=");
        b.append(this.pinRequiredInsteadOfBiometricTimeout);
        b.append(", ");
        b.append("allowedOutboundClipboardSharingExceptionLength=");
        b.append(this.allowedOutboundClipboardSharingExceptionLength);
        b.append(", ");
        b.append("notificationRestriction=");
        b.append(this.notificationRestriction);
        b.append(", ");
        b.append("previousPinBlockCount=");
        b.append(this.previousPinBlockCount);
        b.append(", ");
        b.append("managedBrowser=");
        b.append(this.managedBrowser);
        b.append(", ");
        b.append("maximumAllowedDeviceThreatLevel=");
        b.append(this.maximumAllowedDeviceThreatLevel);
        b.append(", ");
        b.append("mobileThreatDefenseRemediationAction=");
        b.append(this.mobileThreatDefenseRemediationAction);
        b.append(", ");
        b.append("blockDataIngestionIntoOrganizationDocuments=");
        b.append(this.blockDataIngestionIntoOrganizationDocuments);
        b.append(", ");
        b.append("allowedDataIngestionLocations=");
        b.append(this.allowedDataIngestionLocations);
        b.append(", ");
        b.append("appActionIfUnableToAuthenticateUser=");
        b.append(this.appActionIfUnableToAuthenticateUser);
        b.append(", ");
        b.append("dialerRestrictionLevel=");
        b.append(this.dialerRestrictionLevel);
        b.append(", ");
        b.append("isAssigned=");
        b.append(this.isAssigned);
        b.append(", ");
        b.append("targetedAppManagementLevels=");
        b.append(this.targetedAppManagementLevels);
        b.append(", ");
        b.append("screenCaptureBlocked=");
        b.append(this.screenCaptureBlocked);
        b.append(", ");
        b.append("disableAppEncryptionIfDeviceEncryptionIsEnabled=");
        b.append(this.disableAppEncryptionIfDeviceEncryptionIsEnabled);
        b.append(", ");
        b.append("encryptAppData=");
        b.append(this.encryptAppData);
        b.append(", ");
        b.append("deployedAppCount=");
        b.append(this.deployedAppCount);
        b.append(", ");
        b.append("minimumRequiredPatchVersion=");
        b.append(this.minimumRequiredPatchVersion);
        b.append(", ");
        b.append("minimumWarningPatchVersion=");
        b.append(this.minimumWarningPatchVersion);
        b.append(", ");
        b.append("exemptedAppPackages=");
        b.append(this.exemptedAppPackages);
        b.append(", ");
        b.append("minimumWipePatchVersion=");
        b.append(this.minimumWipePatchVersion);
        b.append(", ");
        b.append("allowedAndroidDeviceManufacturers=");
        b.append(this.allowedAndroidDeviceManufacturers);
        b.append(", ");
        b.append("appActionIfAndroidDeviceManufacturerNotAllowed=");
        b.append(this.appActionIfAndroidDeviceManufacturerNotAllowed);
        b.append(", ");
        b.append("requiredAndroidSafetyNetDeviceAttestationType=");
        b.append(this.requiredAndroidSafetyNetDeviceAttestationType);
        b.append(", ");
        b.append("appActionIfAndroidSafetyNetDeviceAttestationFailed=");
        b.append(this.appActionIfAndroidSafetyNetDeviceAttestationFailed);
        b.append(", ");
        b.append("requiredAndroidSafetyNetAppsVerificationType=");
        b.append(this.requiredAndroidSafetyNetAppsVerificationType);
        b.append(", ");
        b.append("appActionIfAndroidSafetyNetAppsVerificationFailed=");
        b.append(this.appActionIfAndroidSafetyNetAppsVerificationFailed);
        b.append(", ");
        b.append("customBrowserPackageId=");
        b.append(this.customBrowserPackageId);
        b.append(", ");
        b.append("customBrowserDisplayName=");
        b.append(this.customBrowserDisplayName);
        b.append(", ");
        b.append("minimumRequiredCompanyPortalVersion=");
        b.append(this.minimumRequiredCompanyPortalVersion);
        b.append(", ");
        b.append("minimumWarningCompanyPortalVersion=");
        b.append(this.minimumWarningCompanyPortalVersion);
        b.append(", ");
        b.append("minimumWipeCompanyPortalVersion=");
        b.append(this.minimumWipeCompanyPortalVersion);
        b.append(", ");
        b.append("keyboardsRestricted=");
        b.append(this.keyboardsRestricted);
        b.append(", ");
        b.append("approvedKeyboards=");
        b.append(this.approvedKeyboards);
        b.append(", ");
        b.append("allowedAndroidDeviceModels=");
        b.append(this.allowedAndroidDeviceModels);
        b.append(", ");
        b.append("appActionIfAndroidDeviceModelNotAllowed=");
        b.append(this.appActionIfAndroidDeviceModelNotAllowed);
        b.append(", ");
        b.append("customDialerAppPackageId=");
        b.append(this.customDialerAppPackageId);
        b.append(", ");
        b.append("customDialerAppDisplayName=");
        b.append(this.customDialerAppDisplayName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
