package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.enums.AndroidWiFiSecurityType;


/**
 * <i>“By providing the configurations in this profile you can instruct the Android for
 * Work device to connect to desired Wi-Fi endpoint. By specifying the
 * authentication method and security types expected by Wi-Fi endpoint you can make
 * the Wi-Fi connection seamless for end user. This profile provides limited and
 * simpler security types than Enterprise Wi-Fi profile.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "networkName", 
    "ssid", 
    "connectAutomatically", 
    "connectWhenNetworkNameIsHidden", 
    "wiFiSecurityType"})
@JsonInclude(Include.NON_NULL)
public class AndroidForWorkWiFiConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidForWorkWiFiConfiguration";
    }

    @JsonProperty("networkName")
    protected String networkName;

    @JsonProperty("ssid")
    protected String ssid;

    @JsonProperty("connectAutomatically")
    protected Boolean connectAutomatically;

    @JsonProperty("connectWhenNetworkNameIsHidden")
    protected Boolean connectWhenNetworkNameIsHidden;

    @JsonProperty("wiFiSecurityType")
    protected AndroidWiFiSecurityType wiFiSecurityType;

    protected AndroidForWorkWiFiConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidForWorkWiFiConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private String networkName;
        private String ssid;
        private Boolean connectAutomatically;
        private Boolean connectWhenNetworkNameIsHidden;
        private AndroidWiFiSecurityType wiFiSecurityType;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“Network Name”</i>
         * 
         * @param networkName
         *            value of {@code networkName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder networkName(String networkName) {
            this.networkName = networkName;
            this.changedFields = changedFields.add("networkName");
            return this;
        }

        /**
         * <i>“This is the name of the Wi-Fi network that is broadcast to all devices.”</i>
         * 
         * @param ssid
         *            value of {@code ssid} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ssid(String ssid) {
            this.ssid = ssid;
            this.changedFields = changedFields.add("ssid");
            return this;
        }

        /**
         * <i>“Connect automatically when this network is in range. Setting this to true will
         * skip the user prompt and automatically connect the device to Wi-Fi network.”</i>
         * 
         * @param connectAutomatically
         *            value of {@code connectAutomatically} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder connectAutomatically(Boolean connectAutomatically) {
            this.connectAutomatically = connectAutomatically;
            this.changedFields = changedFields.add("connectAutomatically");
            return this;
        }

        /**
         * <i>“When set to true, this profile forces the device to connect to a network that
         * doesn't broadcast its SSID to all devices.”</i>
         * 
         * @param connectWhenNetworkNameIsHidden
         *            value of {@code connectWhenNetworkNameIsHidden} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder connectWhenNetworkNameIsHidden(Boolean connectWhenNetworkNameIsHidden) {
            this.connectWhenNetworkNameIsHidden = connectWhenNetworkNameIsHidden;
            this.changedFields = changedFields.add("connectWhenNetworkNameIsHidden");
            return this;
        }

        /**
         * <i>“Indicates whether Wi-Fi endpoint uses an EAP based security type.”</i>
         * 
         * @param wiFiSecurityType
         *            value of {@code wiFiSecurityType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wiFiSecurityType(AndroidWiFiSecurityType wiFiSecurityType) {
            this.wiFiSecurityType = wiFiSecurityType;
            this.changedFields = changedFields.add("wiFiSecurityType");
            return this;
        }

        public AndroidForWorkWiFiConfiguration build() {
            AndroidForWorkWiFiConfiguration _x = new AndroidForWorkWiFiConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.androidForWorkWiFiConfiguration";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.networkName = networkName;
            _x.ssid = ssid;
            _x.connectAutomatically = connectAutomatically;
            _x.connectWhenNetworkNameIsHidden = connectWhenNetworkNameIsHidden;
            _x.wiFiSecurityType = wiFiSecurityType;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Network Name”</i>
     * 
     * @return property networkName
     */
    @Property(name="networkName")
    @JsonIgnore
    public Optional<String> getNetworkName() {
        return Optional.ofNullable(networkName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code networkName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Network Name”</i>
     * 
     * @param networkName
     *            new value of {@code networkName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code networkName} field changed
     */
    public AndroidForWorkWiFiConfiguration withNetworkName(String networkName) {
        AndroidForWorkWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("networkName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkWiFiConfiguration");
        _x.networkName = networkName;
        return _x;
    }

    /**
     * <i>“This is the name of the Wi-Fi network that is broadcast to all devices.”</i>
     * 
     * @return property ssid
     */
    @Property(name="ssid")
    @JsonIgnore
    public Optional<String> getSsid() {
        return Optional.ofNullable(ssid);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code ssid} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“This is the name of the Wi-Fi network that is broadcast to all devices.”</i>
     * 
     * @param ssid
     *            new value of {@code ssid} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ssid} field changed
     */
    public AndroidForWorkWiFiConfiguration withSsid(String ssid) {
        AndroidForWorkWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("ssid");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkWiFiConfiguration");
        _x.ssid = ssid;
        return _x;
    }

    /**
     * <i>“Connect automatically when this network is in range. Setting this to true will
     * skip the user prompt and automatically connect the device to Wi-Fi network.”</i>
     * 
     * @return property connectAutomatically
     */
    @Property(name="connectAutomatically")
    @JsonIgnore
    public Optional<Boolean> getConnectAutomatically() {
        return Optional.ofNullable(connectAutomatically);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * connectAutomatically} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Connect automatically when this network is in range. Setting this to true will
     * skip the user prompt and automatically connect the device to Wi-Fi network.”</i>
     * 
     * @param connectAutomatically
     *            new value of {@code connectAutomatically} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code connectAutomatically} field changed
     */
    public AndroidForWorkWiFiConfiguration withConnectAutomatically(Boolean connectAutomatically) {
        AndroidForWorkWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("connectAutomatically");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkWiFiConfiguration");
        _x.connectAutomatically = connectAutomatically;
        return _x;
    }

    /**
     * <i>“When set to true, this profile forces the device to connect to a network that
     * doesn't broadcast its SSID to all devices.”</i>
     * 
     * @return property connectWhenNetworkNameIsHidden
     */
    @Property(name="connectWhenNetworkNameIsHidden")
    @JsonIgnore
    public Optional<Boolean> getConnectWhenNetworkNameIsHidden() {
        return Optional.ofNullable(connectWhenNetworkNameIsHidden);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * connectWhenNetworkNameIsHidden} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“When set to true, this profile forces the device to connect to a network that
     * doesn't broadcast its SSID to all devices.”</i>
     * 
     * @param connectWhenNetworkNameIsHidden
     *            new value of {@code connectWhenNetworkNameIsHidden} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code connectWhenNetworkNameIsHidden} field changed
     */
    public AndroidForWorkWiFiConfiguration withConnectWhenNetworkNameIsHidden(Boolean connectWhenNetworkNameIsHidden) {
        AndroidForWorkWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("connectWhenNetworkNameIsHidden");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkWiFiConfiguration");
        _x.connectWhenNetworkNameIsHidden = connectWhenNetworkNameIsHidden;
        return _x;
    }

    /**
     * <i>“Indicates whether Wi-Fi endpoint uses an EAP based security type.”</i>
     * 
     * @return property wiFiSecurityType
     */
    @Property(name="wiFiSecurityType")
    @JsonIgnore
    public Optional<AndroidWiFiSecurityType> getWiFiSecurityType() {
        return Optional.ofNullable(wiFiSecurityType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code wiFiSecurityType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether Wi-Fi endpoint uses an EAP based security type.”</i>
     * 
     * @param wiFiSecurityType
     *            new value of {@code wiFiSecurityType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wiFiSecurityType} field changed
     */
    public AndroidForWorkWiFiConfiguration withWiFiSecurityType(AndroidWiFiSecurityType wiFiSecurityType) {
        AndroidForWorkWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("wiFiSecurityType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkWiFiConfiguration");
        _x.wiFiSecurityType = wiFiSecurityType;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidForWorkWiFiConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AndroidForWorkWiFiConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidForWorkWiFiConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AndroidForWorkWiFiConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AndroidForWorkWiFiConfiguration _copy() {
        AndroidForWorkWiFiConfiguration _x = new AndroidForWorkWiFiConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.networkName = networkName;
        _x.ssid = ssid;
        _x.connectAutomatically = connectAutomatically;
        _x.connectWhenNetworkNameIsHidden = connectWhenNetworkNameIsHidden;
        _x.wiFiSecurityType = wiFiSecurityType;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidForWorkWiFiConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("networkName=");
        b.append(this.networkName);
        b.append(", ");
        b.append("ssid=");
        b.append(this.ssid);
        b.append(", ");
        b.append("connectAutomatically=");
        b.append(this.connectAutomatically);
        b.append(", ");
        b.append("connectWhenNetworkNameIsHidden=");
        b.append(this.connectWhenNetworkNameIsHidden);
        b.append(", ");
        b.append("wiFiSecurityType=");
        b.append(this.wiFiSecurityType);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
