package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AndroidForWorkBindStatus;
import odata.msgraph.client.beta.enums.AndroidForWorkEnrollmentTarget;
import odata.msgraph.client.beta.enums.AndroidForWorkSyncStatus;


/**
 * <i>“Settings for Android For Work.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "bindStatus", 
    "lastAppSyncDateTime", 
    "lastAppSyncStatus", 
    "ownerUserPrincipalName", 
    "ownerOrganizationName", 
    "lastModifiedDateTime", 
    "enrollmentTarget", 
    "targetGroupIds", 
    "deviceOwnerManagementEnabled"})
@JsonInclude(Include.NON_NULL)
public class AndroidForWorkSettings extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidForWorkSettings";
    }

    @JsonProperty("bindStatus")
    protected AndroidForWorkBindStatus bindStatus;

    @JsonProperty("lastAppSyncDateTime")
    protected OffsetDateTime lastAppSyncDateTime;

    @JsonProperty("lastAppSyncStatus")
    protected AndroidForWorkSyncStatus lastAppSyncStatus;

    @JsonProperty("ownerUserPrincipalName")
    protected String ownerUserPrincipalName;

    @JsonProperty("ownerOrganizationName")
    protected String ownerOrganizationName;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("enrollmentTarget")
    protected AndroidForWorkEnrollmentTarget enrollmentTarget;

    @JsonProperty("targetGroupIds")
    protected List<String> targetGroupIds;

    @JsonProperty("targetGroupIds@nextLink")
    protected String targetGroupIdsNextLink;

    @JsonProperty("deviceOwnerManagementEnabled")
    protected Boolean deviceOwnerManagementEnabled;

    protected AndroidForWorkSettings() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidForWorkSettings() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private AndroidForWorkBindStatus bindStatus;
        private OffsetDateTime lastAppSyncDateTime;
        private AndroidForWorkSyncStatus lastAppSyncStatus;
        private String ownerUserPrincipalName;
        private String ownerOrganizationName;
        private OffsetDateTime lastModifiedDateTime;
        private AndroidForWorkEnrollmentTarget enrollmentTarget;
        private List<String> targetGroupIds;
        private String targetGroupIdsNextLink;
        private Boolean deviceOwnerManagementEnabled;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Bind status of the tenant with the Google EMM API”</i>
         * 
         * @param bindStatus
         *            value of {@code bindStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bindStatus(AndroidForWorkBindStatus bindStatus) {
            this.bindStatus = bindStatus;
            this.changedFields = changedFields.add("bindStatus");
            return this;
        }

        /**
         * <i>“Last completion time for app sync”</i>
         * 
         * @param lastAppSyncDateTime
         *            value of {@code lastAppSyncDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastAppSyncDateTime(OffsetDateTime lastAppSyncDateTime) {
            this.lastAppSyncDateTime = lastAppSyncDateTime;
            this.changedFields = changedFields.add("lastAppSyncDateTime");
            return this;
        }

        /**
         * <i>“Last application sync result”</i>
         * 
         * @param lastAppSyncStatus
         *            value of {@code lastAppSyncStatus} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastAppSyncStatus(AndroidForWorkSyncStatus lastAppSyncStatus) {
            this.lastAppSyncStatus = lastAppSyncStatus;
            this.changedFields = changedFields.add("lastAppSyncStatus");
            return this;
        }

        /**
         * <i>“Owner UPN that created the enterprise”</i>
         * 
         * @param ownerUserPrincipalName
         *            value of {@code ownerUserPrincipalName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ownerUserPrincipalName(String ownerUserPrincipalName) {
            this.ownerUserPrincipalName = ownerUserPrincipalName;
            this.changedFields = changedFields.add("ownerUserPrincipalName");
            return this;
        }

        /**
         * <i>“Organization name used when onboarding Android for Work”</i>
         * 
         * @param ownerOrganizationName
         *            value of {@code ownerOrganizationName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder ownerOrganizationName(String ownerOrganizationName) {
            this.ownerOrganizationName = ownerOrganizationName;
            this.changedFields = changedFields.add("ownerOrganizationName");
            return this;
        }

        /**
         * <i>“Last modification time for Android for Work settings”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“Indicates which users can enroll devices in Android for Work device management”</i>
         * 
         * @param enrollmentTarget
         *            value of {@code enrollmentTarget} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enrollmentTarget(AndroidForWorkEnrollmentTarget enrollmentTarget) {
            this.enrollmentTarget = enrollmentTarget;
            this.changedFields = changedFields.add("enrollmentTarget");
            return this;
        }

        /**
         * <i>“Specifies which AAD groups can enroll devices in Android for Work device
         * management if enrollmentTarget is set to 'Targeted'”</i>
         * 
         * @param targetGroupIds
         *            value of {@code targetGroupIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetGroupIds(List<String> targetGroupIds) {
            this.targetGroupIds = targetGroupIds;
            this.changedFields = changedFields.add("targetGroupIds");
            return this;
        }

        /**
         * <i>“Specifies which AAD groups can enroll devices in Android for Work device
         * management if enrollmentTarget is set to 'Targeted'”</i>
         * 
         * @param targetGroupIds
         *            value of {@code targetGroupIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetGroupIds(String... targetGroupIds) {
            return targetGroupIds(Arrays.asList(targetGroupIds));
        }

        /**
         * <i>“Specifies which AAD groups can enroll devices in Android for Work device
         * management if enrollmentTarget is set to 'Targeted'”</i>
         * 
         * @param targetGroupIdsNextLink
         *            value of {@code targetGroupIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetGroupIdsNextLink(String targetGroupIdsNextLink) {
            this.targetGroupIdsNextLink = targetGroupIdsNextLink;
            this.changedFields = changedFields.add("targetGroupIds");
            return this;
        }

        /**
         * <i>“Indicates if this account is flighting for Android Device Owner Management with
         * CloudDPC.”</i>
         * 
         * @param deviceOwnerManagementEnabled
         *            value of {@code deviceOwnerManagementEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder deviceOwnerManagementEnabled(Boolean deviceOwnerManagementEnabled) {
            this.deviceOwnerManagementEnabled = deviceOwnerManagementEnabled;
            this.changedFields = changedFields.add("deviceOwnerManagementEnabled");
            return this;
        }

        public AndroidForWorkSettings build() {
            AndroidForWorkSettings _x = new AndroidForWorkSettings();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.androidForWorkSettings";
            _x.id = id;
            _x.bindStatus = bindStatus;
            _x.lastAppSyncDateTime = lastAppSyncDateTime;
            _x.lastAppSyncStatus = lastAppSyncStatus;
            _x.ownerUserPrincipalName = ownerUserPrincipalName;
            _x.ownerOrganizationName = ownerOrganizationName;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.enrollmentTarget = enrollmentTarget;
            _x.targetGroupIds = targetGroupIds;
            _x.targetGroupIdsNextLink = targetGroupIdsNextLink;
            _x.deviceOwnerManagementEnabled = deviceOwnerManagementEnabled;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Bind status of the tenant with the Google EMM API”</i>
     * 
     * @return property bindStatus
     */
    @Property(name="bindStatus")
    @JsonIgnore
    public Optional<AndroidForWorkBindStatus> getBindStatus() {
        return Optional.ofNullable(bindStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code bindStatus} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Bind status of the tenant with the Google EMM API”</i>
     * 
     * @param bindStatus
     *            new value of {@code bindStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bindStatus} field changed
     */
    public AndroidForWorkSettings withBindStatus(AndroidForWorkBindStatus bindStatus) {
        AndroidForWorkSettings _x = _copy();
        _x.changedFields = changedFields.add("bindStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkSettings");
        _x.bindStatus = bindStatus;
        return _x;
    }

    /**
     * <i>“Last completion time for app sync”</i>
     * 
     * @return property lastAppSyncDateTime
     */
    @Property(name="lastAppSyncDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastAppSyncDateTime() {
        return Optional.ofNullable(lastAppSyncDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastAppSyncDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last completion time for app sync”</i>
     * 
     * @param lastAppSyncDateTime
     *            new value of {@code lastAppSyncDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastAppSyncDateTime} field changed
     */
    public AndroidForWorkSettings withLastAppSyncDateTime(OffsetDateTime lastAppSyncDateTime) {
        AndroidForWorkSettings _x = _copy();
        _x.changedFields = changedFields.add("lastAppSyncDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkSettings");
        _x.lastAppSyncDateTime = lastAppSyncDateTime;
        return _x;
    }

    /**
     * <i>“Last application sync result”</i>
     * 
     * @return property lastAppSyncStatus
     */
    @Property(name="lastAppSyncStatus")
    @JsonIgnore
    public Optional<AndroidForWorkSyncStatus> getLastAppSyncStatus() {
        return Optional.ofNullable(lastAppSyncStatus);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code lastAppSyncStatus
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Last application sync result”</i>
     * 
     * @param lastAppSyncStatus
     *            new value of {@code lastAppSyncStatus} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastAppSyncStatus} field changed
     */
    public AndroidForWorkSettings withLastAppSyncStatus(AndroidForWorkSyncStatus lastAppSyncStatus) {
        AndroidForWorkSettings _x = _copy();
        _x.changedFields = changedFields.add("lastAppSyncStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkSettings");
        _x.lastAppSyncStatus = lastAppSyncStatus;
        return _x;
    }

    /**
     * <i>“Owner UPN that created the enterprise”</i>
     * 
     * @return property ownerUserPrincipalName
     */
    @Property(name="ownerUserPrincipalName")
    @JsonIgnore
    public Optional<String> getOwnerUserPrincipalName() {
        return Optional.ofNullable(ownerUserPrincipalName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * ownerUserPrincipalName} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Owner UPN that created the enterprise”</i>
     * 
     * @param ownerUserPrincipalName
     *            new value of {@code ownerUserPrincipalName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ownerUserPrincipalName} field changed
     */
    public AndroidForWorkSettings withOwnerUserPrincipalName(String ownerUserPrincipalName) {
        AndroidForWorkSettings _x = _copy();
        _x.changedFields = changedFields.add("ownerUserPrincipalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkSettings");
        _x.ownerUserPrincipalName = ownerUserPrincipalName;
        return _x;
    }

    /**
     * <i>“Organization name used when onboarding Android for Work”</i>
     * 
     * @return property ownerOrganizationName
     */
    @Property(name="ownerOrganizationName")
    @JsonIgnore
    public Optional<String> getOwnerOrganizationName() {
        return Optional.ofNullable(ownerOrganizationName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * ownerOrganizationName} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Organization name used when onboarding Android for Work”</i>
     * 
     * @param ownerOrganizationName
     *            new value of {@code ownerOrganizationName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code ownerOrganizationName} field changed
     */
    public AndroidForWorkSettings withOwnerOrganizationName(String ownerOrganizationName) {
        AndroidForWorkSettings _x = _copy();
        _x.changedFields = changedFields.add("ownerOrganizationName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkSettings");
        _x.ownerOrganizationName = ownerOrganizationName;
        return _x;
    }

    /**
     * <i>“Last modification time for Android for Work settings”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Last modification time for Android for Work settings”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public AndroidForWorkSettings withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        AndroidForWorkSettings _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkSettings");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“Indicates which users can enroll devices in Android for Work device management”</i>
     * 
     * @return property enrollmentTarget
     */
    @Property(name="enrollmentTarget")
    @JsonIgnore
    public Optional<AndroidForWorkEnrollmentTarget> getEnrollmentTarget() {
        return Optional.ofNullable(enrollmentTarget);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code enrollmentTarget}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates which users can enroll devices in Android for Work device management”</i>
     * 
     * @param enrollmentTarget
     *            new value of {@code enrollmentTarget} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enrollmentTarget} field changed
     */
    public AndroidForWorkSettings withEnrollmentTarget(AndroidForWorkEnrollmentTarget enrollmentTarget) {
        AndroidForWorkSettings _x = _copy();
        _x.changedFields = changedFields.add("enrollmentTarget");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkSettings");
        _x.enrollmentTarget = enrollmentTarget;
        return _x;
    }

    /**
     * <i>“Specifies which AAD groups can enroll devices in Android for Work device
     * management if enrollmentTarget is set to 'Targeted'”</i>
     * 
     * @return property targetGroupIds
     */
    @Property(name="targetGroupIds")
    @JsonIgnore
    public CollectionPage<String> getTargetGroupIds() {
        return new CollectionPage<String>(contextPath, String.class, targetGroupIds, Optional.ofNullable(targetGroupIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Specifies which AAD groups can enroll devices in Android for Work device
     * management if enrollmentTarget is set to 'Targeted'”</i>
     * 
     * @return property targetGroupIds
     */
    @Property(name="targetGroupIds")
    @JsonIgnore
    public CollectionPage<String> getTargetGroupIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, targetGroupIds, Optional.ofNullable(targetGroupIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Indicates if this account is flighting for Android Device Owner Management with
     * CloudDPC.”</i>
     * 
     * @return property deviceOwnerManagementEnabled
     */
    @Property(name="deviceOwnerManagementEnabled")
    @JsonIgnore
    public Optional<Boolean> getDeviceOwnerManagementEnabled() {
        return Optional.ofNullable(deviceOwnerManagementEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * deviceOwnerManagementEnabled} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates if this account is flighting for Android Device Owner Management with
     * CloudDPC.”</i>
     * 
     * @param deviceOwnerManagementEnabled
     *            new value of {@code deviceOwnerManagementEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code deviceOwnerManagementEnabled} field changed
     */
    public AndroidForWorkSettings withDeviceOwnerManagementEnabled(Boolean deviceOwnerManagementEnabled) {
        AndroidForWorkSettings _x = _copy();
        _x.changedFields = changedFields.add("deviceOwnerManagementEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkSettings");
        _x.deviceOwnerManagementEnabled = deviceOwnerManagementEnabled;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidForWorkSettings patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AndroidForWorkSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidForWorkSettings put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AndroidForWorkSettings _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AndroidForWorkSettings _copy() {
        AndroidForWorkSettings _x = new AndroidForWorkSettings();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.bindStatus = bindStatus;
        _x.lastAppSyncDateTime = lastAppSyncDateTime;
        _x.lastAppSyncStatus = lastAppSyncStatus;
        _x.ownerUserPrincipalName = ownerUserPrincipalName;
        _x.ownerOrganizationName = ownerOrganizationName;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.enrollmentTarget = enrollmentTarget;
        _x.targetGroupIds = targetGroupIds;
        _x.deviceOwnerManagementEnabled = deviceOwnerManagementEnabled;
        return _x;
    }

    @Action(name = "requestSignupUrl")
    @JsonIgnore
    public ActionRequestReturningNonCollection<String> requestSignupUrl(String hostName) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("hostName", "Edm.String", Checks.checkIsAscii(hostName))
            .build();
        return new ActionRequestReturningNonCollection<String>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.requestSignupUrl"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

    @Action(name = "completeSignup")
    @JsonIgnore
    public ActionRequestNoReturn completeSignup(String enterpriseToken) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("enterpriseToken", "Edm.String", Checks.checkIsAscii(enterpriseToken))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.completeSignup"), _parameters);
    }

    @Action(name = "syncApps")
    @JsonIgnore
    public ActionRequestNoReturn syncApps() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.syncApps"), _parameters);
    }

    @Action(name = "unbind")
    @JsonIgnore
    public ActionRequestNoReturn unbind() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.unbind"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidForWorkSettings[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("bindStatus=");
        b.append(this.bindStatus);
        b.append(", ");
        b.append("lastAppSyncDateTime=");
        b.append(this.lastAppSyncDateTime);
        b.append(", ");
        b.append("lastAppSyncStatus=");
        b.append(this.lastAppSyncStatus);
        b.append(", ");
        b.append("ownerUserPrincipalName=");
        b.append(this.ownerUserPrincipalName);
        b.append(", ");
        b.append("ownerOrganizationName=");
        b.append(this.ownerOrganizationName);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("enrollmentTarget=");
        b.append(this.enrollmentTarget);
        b.append(", ");
        b.append("targetGroupIds=");
        b.append(this.targetGroupIds);
        b.append(", ");
        b.append("deviceOwnerManagementEnabled=");
        b.append(this.deviceOwnerManagementEnabled);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
