package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AndroidForWorkAppConfigurationSchemaItem;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Schema describing an Android for Work application's custom configurations.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "exampleJson", 
    "schemaItems"})
@JsonInclude(Include.NON_NULL)
public class AndroidForWorkAppConfigurationSchema extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidForWorkAppConfigurationSchema";
    }

    @JsonProperty("exampleJson")
    protected byte[] exampleJson;

    @JsonProperty("schemaItems")
    protected List<AndroidForWorkAppConfigurationSchemaItem> schemaItems;

    @JsonProperty("schemaItems@nextLink")
    protected String schemaItemsNextLink;

    protected AndroidForWorkAppConfigurationSchema() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidForWorkAppConfigurationSchema() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private byte[] exampleJson;
        private List<AndroidForWorkAppConfigurationSchemaItem> schemaItems;
        private String schemaItemsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“UTF8 encoded byte array containing example JSON string conforming to this schema
         * that demonstrates how to set the configuration for this app”</i>
         * 
         * @param exampleJson
         *            value of {@code exampleJson} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder exampleJson(byte[] exampleJson) {
            this.exampleJson = exampleJson;
            this.changedFields = changedFields.add("exampleJson");
            return this;
        }

        /**
         * <i>“Collection of items each representing a named configuration option in the schema”</i>
         * 
         * @param schemaItems
         *            value of {@code schemaItems} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder schemaItems(List<AndroidForWorkAppConfigurationSchemaItem> schemaItems) {
            this.schemaItems = schemaItems;
            this.changedFields = changedFields.add("schemaItems");
            return this;
        }

        /**
         * <i>“Collection of items each representing a named configuration option in the schema”</i>
         * 
         * @param schemaItems
         *            value of {@code schemaItems} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder schemaItems(AndroidForWorkAppConfigurationSchemaItem... schemaItems) {
            return schemaItems(Arrays.asList(schemaItems));
        }

        /**
         * <i>“Collection of items each representing a named configuration option in the schema”</i>
         * 
         * @param schemaItemsNextLink
         *            value of {@code schemaItems@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder schemaItemsNextLink(String schemaItemsNextLink) {
            this.schemaItemsNextLink = schemaItemsNextLink;
            this.changedFields = changedFields.add("schemaItems");
            return this;
        }

        public AndroidForWorkAppConfigurationSchema build() {
            AndroidForWorkAppConfigurationSchema _x = new AndroidForWorkAppConfigurationSchema();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.androidForWorkAppConfigurationSchema";
            _x.id = id;
            _x.exampleJson = exampleJson;
            _x.schemaItems = schemaItems;
            _x.schemaItemsNextLink = schemaItemsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“UTF8 encoded byte array containing example JSON string conforming to this schema
     * that demonstrates how to set the configuration for this app”</i>
     * 
     * @return property exampleJson
     */
    @Property(name="exampleJson")
    @JsonIgnore
    public Optional<byte[]> getExampleJson() {
        return Optional.ofNullable(exampleJson);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code exampleJson}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“UTF8 encoded byte array containing example JSON string conforming to this schema
     * that demonstrates how to set the configuration for this app”</i>
     * 
     * @param exampleJson
     *            new value of {@code exampleJson} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code exampleJson} field changed
     */
    public AndroidForWorkAppConfigurationSchema withExampleJson(byte[] exampleJson) {
        AndroidForWorkAppConfigurationSchema _x = _copy();
        _x.changedFields = changedFields.add("exampleJson");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidForWorkAppConfigurationSchema");
        _x.exampleJson = exampleJson;
        return _x;
    }

    /**
     * <i>“Collection of items each representing a named configuration option in the schema”</i>
     * 
     * @return property schemaItems
     */
    @Property(name="schemaItems")
    @JsonIgnore
    public CollectionPage<AndroidForWorkAppConfigurationSchemaItem> getSchemaItems() {
        return new CollectionPage<AndroidForWorkAppConfigurationSchemaItem>(contextPath, AndroidForWorkAppConfigurationSchemaItem.class, schemaItems, Optional.ofNullable(schemaItemsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Collection of items each representing a named configuration option in the schema”</i>
     * 
     * @return property schemaItems
     */
    @Property(name="schemaItems")
    @JsonIgnore
    public CollectionPage<AndroidForWorkAppConfigurationSchemaItem> getSchemaItems(HttpRequestOptions options) {
        return new CollectionPage<AndroidForWorkAppConfigurationSchemaItem>(contextPath, AndroidForWorkAppConfigurationSchemaItem.class, schemaItems, Optional.ofNullable(schemaItemsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidForWorkAppConfigurationSchema patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AndroidForWorkAppConfigurationSchema _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidForWorkAppConfigurationSchema put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AndroidForWorkAppConfigurationSchema _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AndroidForWorkAppConfigurationSchema _copy() {
        AndroidForWorkAppConfigurationSchema _x = new AndroidForWorkAppConfigurationSchema();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.exampleJson = exampleJson;
        _x.schemaItems = schemaItems;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidForWorkAppConfigurationSchema[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("exampleJson=");
        b.append(this.exampleJson);
        b.append(", ");
        b.append("schemaItems=");
        b.append(this.schemaItems);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
