package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.entity.request.AndroidCertificateProfileBaseRequest;
import odata.msgraph.client.beta.entity.request.AndroidTrustedRootCertificateRequest;
import odata.msgraph.client.beta.enums.AndroidEapType;
import odata.msgraph.client.beta.enums.AndroidWiFiSecurityType;
import odata.msgraph.client.beta.enums.NonEapAuthenticationMethodForEapTtlsType;
import odata.msgraph.client.beta.enums.NonEapAuthenticationMethodForPeap;
import odata.msgraph.client.beta.enums.WiFiAuthenticationMethod;


/**
 * <i>“By providing the configurations in this profile you can instruct the Android
 * device to connect to desired Wi-Fi endpoint. By specifying the authentication
 * method and security types expected by Wi-Fi endpoint you can make the Wi-Fi
 * connection seamless for end user.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "eapType", 
    "authenticationMethod", 
    "innerAuthenticationProtocolForEapTtls", 
    "innerAuthenticationProtocolForPeap", 
    "outerIdentityPrivacyTemporaryValue", 
    "usernameFormatString", 
    "passwordFormatString", 
    "preSharedKey"})
@JsonInclude(Include.NON_NULL)
public class AndroidEnterpriseWiFiConfiguration extends AndroidWiFiConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidEnterpriseWiFiConfiguration";
    }

    @JsonProperty("eapType")
    protected AndroidEapType eapType;

    @JsonProperty("authenticationMethod")
    protected WiFiAuthenticationMethod authenticationMethod;

    @JsonProperty("innerAuthenticationProtocolForEapTtls")
    protected NonEapAuthenticationMethodForEapTtlsType innerAuthenticationProtocolForEapTtls;

    @JsonProperty("innerAuthenticationProtocolForPeap")
    protected NonEapAuthenticationMethodForPeap innerAuthenticationProtocolForPeap;

    @JsonProperty("outerIdentityPrivacyTemporaryValue")
    protected String outerIdentityPrivacyTemporaryValue;

    @JsonProperty("usernameFormatString")
    protected String usernameFormatString;

    @JsonProperty("passwordFormatString")
    protected String passwordFormatString;

    @JsonProperty("preSharedKey")
    protected String preSharedKey;

    protected AndroidEnterpriseWiFiConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidEnterpriseWiFiConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private String networkName;
        private String ssid;
        private Boolean connectAutomatically;
        private Boolean connectWhenNetworkNameIsHidden;
        private AndroidWiFiSecurityType wiFiSecurityType;
        private AndroidEapType eapType;
        private WiFiAuthenticationMethod authenticationMethod;
        private NonEapAuthenticationMethodForEapTtlsType innerAuthenticationProtocolForEapTtls;
        private NonEapAuthenticationMethodForPeap innerAuthenticationProtocolForPeap;
        private String outerIdentityPrivacyTemporaryValue;
        private String usernameFormatString;
        private String passwordFormatString;
        private String preSharedKey;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder networkName(String networkName) {
            this.networkName = networkName;
            this.changedFields = changedFields.add("networkName");
            return this;
        }

        public Builder ssid(String ssid) {
            this.ssid = ssid;
            this.changedFields = changedFields.add("ssid");
            return this;
        }

        public Builder connectAutomatically(Boolean connectAutomatically) {
            this.connectAutomatically = connectAutomatically;
            this.changedFields = changedFields.add("connectAutomatically");
            return this;
        }

        public Builder connectWhenNetworkNameIsHidden(Boolean connectWhenNetworkNameIsHidden) {
            this.connectWhenNetworkNameIsHidden = connectWhenNetworkNameIsHidden;
            this.changedFields = changedFields.add("connectWhenNetworkNameIsHidden");
            return this;
        }

        public Builder wiFiSecurityType(AndroidWiFiSecurityType wiFiSecurityType) {
            this.wiFiSecurityType = wiFiSecurityType;
            this.changedFields = changedFields.add("wiFiSecurityType");
            return this;
        }

        /**
         * <i>“Indicates the type of EAP protocol set on the Wi-Fi endpoint (router).”</i>
         * 
         * @param eapType
         *            value of {@code eapType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder eapType(AndroidEapType eapType) {
            this.eapType = eapType;
            this.changedFields = changedFields.add("eapType");
            return this;
        }

        /**
         * <i>“Indicates the Authentication Method the client (device) needs to use when the
         * EAP Type is configured to PEAP or EAP-TTLS.”</i>
         * 
         * @param authenticationMethod
         *            value of {@code authenticationMethod} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder authenticationMethod(WiFiAuthenticationMethod authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            this.changedFields = changedFields.add("authenticationMethod");
            return this;
        }

        /**
         * <i>“Non-EAP Method for Authentication (Inner Identity) when EAP Type is EAP-TTLS and
         * Authenticationmethod is Username and Password.”</i>
         * 
         * @param innerAuthenticationProtocolForEapTtls
         *            value of {@code innerAuthenticationProtocolForEapTtls} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder innerAuthenticationProtocolForEapTtls(NonEapAuthenticationMethodForEapTtlsType innerAuthenticationProtocolForEapTtls) {
            this.innerAuthenticationProtocolForEapTtls = innerAuthenticationProtocolForEapTtls;
            this.changedFields = changedFields.add("innerAuthenticationProtocolForEapTtls");
            return this;
        }

        /**
         * <i>“Non-EAP Method for Authentication (Inner Identity) when EAP Type is PEAP and
         * Authenticationmethod is Username and Password.”</i>
         * 
         * @param innerAuthenticationProtocolForPeap
         *            value of {@code innerAuthenticationProtocolForPeap} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder innerAuthenticationProtocolForPeap(NonEapAuthenticationMethodForPeap innerAuthenticationProtocolForPeap) {
            this.innerAuthenticationProtocolForPeap = innerAuthenticationProtocolForPeap;
            this.changedFields = changedFields.add("innerAuthenticationProtocolForPeap");
            return this;
        }

        /**
         * <i>“Enable identity privacy (Outer Identity) when EAP Type is configured to EAP-TTLS
         * or PEAP. The String provided here is used to mask the username of individual
         * users when they attempt to connect to Wi-Fi network.”</i>
         * 
         * @param outerIdentityPrivacyTemporaryValue
         *            value of {@code outerIdentityPrivacyTemporaryValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder outerIdentityPrivacyTemporaryValue(String outerIdentityPrivacyTemporaryValue) {
            this.outerIdentityPrivacyTemporaryValue = outerIdentityPrivacyTemporaryValue;
            this.changedFields = changedFields.add("outerIdentityPrivacyTemporaryValue");
            return this;
        }

        /**
         * <i>“Username format string used to build the username to connect to wifi”</i>
         * 
         * @param usernameFormatString
         *            value of {@code usernameFormatString} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder usernameFormatString(String usernameFormatString) {
            this.usernameFormatString = usernameFormatString;
            this.changedFields = changedFields.add("usernameFormatString");
            return this;
        }

        /**
         * <i>“Password format string used to build the password to connect to wifi”</i>
         * 
         * @param passwordFormatString
         *            value of {@code passwordFormatString} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordFormatString(String passwordFormatString) {
            this.passwordFormatString = passwordFormatString;
            this.changedFields = changedFields.add("passwordFormatString");
            return this;
        }

        /**
         * <i>“PreSharedKey used to build the password to connect to wifi”</i>
         * 
         * @param preSharedKey
         *            value of {@code preSharedKey} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder preSharedKey(String preSharedKey) {
            this.preSharedKey = preSharedKey;
            this.changedFields = changedFields.add("preSharedKey");
            return this;
        }

        public AndroidEnterpriseWiFiConfiguration build() {
            AndroidEnterpriseWiFiConfiguration _x = new AndroidEnterpriseWiFiConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.androidEnterpriseWiFiConfiguration";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.networkName = networkName;
            _x.ssid = ssid;
            _x.connectAutomatically = connectAutomatically;
            _x.connectWhenNetworkNameIsHidden = connectWhenNetworkNameIsHidden;
            _x.wiFiSecurityType = wiFiSecurityType;
            _x.eapType = eapType;
            _x.authenticationMethod = authenticationMethod;
            _x.innerAuthenticationProtocolForEapTtls = innerAuthenticationProtocolForEapTtls;
            _x.innerAuthenticationProtocolForPeap = innerAuthenticationProtocolForPeap;
            _x.outerIdentityPrivacyTemporaryValue = outerIdentityPrivacyTemporaryValue;
            _x.usernameFormatString = usernameFormatString;
            _x.passwordFormatString = passwordFormatString;
            _x.preSharedKey = preSharedKey;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Indicates the type of EAP protocol set on the Wi-Fi endpoint (router).”</i>
     * 
     * @return property eapType
     */
    @Property(name="eapType")
    @JsonIgnore
    public Optional<AndroidEapType> getEapType() {
        return Optional.ofNullable(eapType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code eapType} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Indicates the type of EAP protocol set on the Wi-Fi endpoint (router).”</i>
     * 
     * @param eapType
     *            new value of {@code eapType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code eapType} field changed
     */
    public AndroidEnterpriseWiFiConfiguration withEapType(AndroidEapType eapType) {
        AndroidEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("eapType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidEnterpriseWiFiConfiguration");
        _x.eapType = eapType;
        return _x;
    }

    /**
     * <i>“Indicates the Authentication Method the client (device) needs to use when the
     * EAP Type is configured to PEAP or EAP-TTLS.”</i>
     * 
     * @return property authenticationMethod
     */
    @Property(name="authenticationMethod")
    @JsonIgnore
    public Optional<WiFiAuthenticationMethod> getAuthenticationMethod() {
        return Optional.ofNullable(authenticationMethod);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * authenticationMethod} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates the Authentication Method the client (device) needs to use when the
     * EAP Type is configured to PEAP or EAP-TTLS.”</i>
     * 
     * @param authenticationMethod
     *            new value of {@code authenticationMethod} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code authenticationMethod} field changed
     */
    public AndroidEnterpriseWiFiConfiguration withAuthenticationMethod(WiFiAuthenticationMethod authenticationMethod) {
        AndroidEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("authenticationMethod");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidEnterpriseWiFiConfiguration");
        _x.authenticationMethod = authenticationMethod;
        return _x;
    }

    /**
     * <i>“Non-EAP Method for Authentication (Inner Identity) when EAP Type is EAP-TTLS and
     * Authenticationmethod is Username and Password.”</i>
     * 
     * @return property innerAuthenticationProtocolForEapTtls
     */
    @Property(name="innerAuthenticationProtocolForEapTtls")
    @JsonIgnore
    public Optional<NonEapAuthenticationMethodForEapTtlsType> getInnerAuthenticationProtocolForEapTtls() {
        return Optional.ofNullable(innerAuthenticationProtocolForEapTtls);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * innerAuthenticationProtocolForEapTtls} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Non-EAP Method for Authentication (Inner Identity) when EAP Type is EAP-TTLS and
     * Authenticationmethod is Username and Password.”</i>
     * 
     * @param innerAuthenticationProtocolForEapTtls
     *            new value of {@code innerAuthenticationProtocolForEapTtls} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code innerAuthenticationProtocolForEapTtls} field changed
     */
    public AndroidEnterpriseWiFiConfiguration withInnerAuthenticationProtocolForEapTtls(NonEapAuthenticationMethodForEapTtlsType innerAuthenticationProtocolForEapTtls) {
        AndroidEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("innerAuthenticationProtocolForEapTtls");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidEnterpriseWiFiConfiguration");
        _x.innerAuthenticationProtocolForEapTtls = innerAuthenticationProtocolForEapTtls;
        return _x;
    }

    /**
     * <i>“Non-EAP Method for Authentication (Inner Identity) when EAP Type is PEAP and
     * Authenticationmethod is Username and Password.”</i>
     * 
     * @return property innerAuthenticationProtocolForPeap
     */
    @Property(name="innerAuthenticationProtocolForPeap")
    @JsonIgnore
    public Optional<NonEapAuthenticationMethodForPeap> getInnerAuthenticationProtocolForPeap() {
        return Optional.ofNullable(innerAuthenticationProtocolForPeap);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * innerAuthenticationProtocolForPeap} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Non-EAP Method for Authentication (Inner Identity) when EAP Type is PEAP and
     * Authenticationmethod is Username and Password.”</i>
     * 
     * @param innerAuthenticationProtocolForPeap
     *            new value of {@code innerAuthenticationProtocolForPeap} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code innerAuthenticationProtocolForPeap} field changed
     */
    public AndroidEnterpriseWiFiConfiguration withInnerAuthenticationProtocolForPeap(NonEapAuthenticationMethodForPeap innerAuthenticationProtocolForPeap) {
        AndroidEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("innerAuthenticationProtocolForPeap");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidEnterpriseWiFiConfiguration");
        _x.innerAuthenticationProtocolForPeap = innerAuthenticationProtocolForPeap;
        return _x;
    }

    /**
     * <i>“Enable identity privacy (Outer Identity) when EAP Type is configured to EAP-TTLS
     * or PEAP. The String provided here is used to mask the username of individual
     * users when they attempt to connect to Wi-Fi network.”</i>
     * 
     * @return property outerIdentityPrivacyTemporaryValue
     */
    @Property(name="outerIdentityPrivacyTemporaryValue")
    @JsonIgnore
    public Optional<String> getOuterIdentityPrivacyTemporaryValue() {
        return Optional.ofNullable(outerIdentityPrivacyTemporaryValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * outerIdentityPrivacyTemporaryValue} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Enable identity privacy (Outer Identity) when EAP Type is configured to EAP-TTLS
     * or PEAP. The String provided here is used to mask the username of individual
     * users when they attempt to connect to Wi-Fi network.”</i>
     * 
     * @param outerIdentityPrivacyTemporaryValue
     *            new value of {@code outerIdentityPrivacyTemporaryValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code outerIdentityPrivacyTemporaryValue} field changed
     */
    public AndroidEnterpriseWiFiConfiguration withOuterIdentityPrivacyTemporaryValue(String outerIdentityPrivacyTemporaryValue) {
        AndroidEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("outerIdentityPrivacyTemporaryValue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidEnterpriseWiFiConfiguration");
        _x.outerIdentityPrivacyTemporaryValue = outerIdentityPrivacyTemporaryValue;
        return _x;
    }

    /**
     * <i>“Username format string used to build the username to connect to wifi”</i>
     * 
     * @return property usernameFormatString
     */
    @Property(name="usernameFormatString")
    @JsonIgnore
    public Optional<String> getUsernameFormatString() {
        return Optional.ofNullable(usernameFormatString);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * usernameFormatString} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Username format string used to build the username to connect to wifi”</i>
     * 
     * @param usernameFormatString
     *            new value of {@code usernameFormatString} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code usernameFormatString} field changed
     */
    public AndroidEnterpriseWiFiConfiguration withUsernameFormatString(String usernameFormatString) {
        AndroidEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("usernameFormatString");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidEnterpriseWiFiConfiguration");
        _x.usernameFormatString = usernameFormatString;
        return _x;
    }

    /**
     * <i>“Password format string used to build the password to connect to wifi”</i>
     * 
     * @return property passwordFormatString
     */
    @Property(name="passwordFormatString")
    @JsonIgnore
    public Optional<String> getPasswordFormatString() {
        return Optional.ofNullable(passwordFormatString);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordFormatString} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Password format string used to build the password to connect to wifi”</i>
     * 
     * @param passwordFormatString
     *            new value of {@code passwordFormatString} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordFormatString} field changed
     */
    public AndroidEnterpriseWiFiConfiguration withPasswordFormatString(String passwordFormatString) {
        AndroidEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordFormatString");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidEnterpriseWiFiConfiguration");
        _x.passwordFormatString = passwordFormatString;
        return _x;
    }

    /**
     * <i>“PreSharedKey used to build the password to connect to wifi”</i>
     * 
     * @return property preSharedKey
     */
    @Property(name="preSharedKey")
    @JsonIgnore
    public Optional<String> getPreSharedKey() {
        return Optional.ofNullable(preSharedKey);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code preSharedKey}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“PreSharedKey used to build the password to connect to wifi”</i>
     * 
     * @param preSharedKey
     *            new value of {@code preSharedKey} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code preSharedKey} field changed
     */
    public AndroidEnterpriseWiFiConfiguration withPreSharedKey(String preSharedKey) {
        AndroidEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = changedFields.add("preSharedKey");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidEnterpriseWiFiConfiguration");
        _x.preSharedKey = preSharedKey;
        return _x;
    }

    /**
     * <i>“Trusted Root Certificate for Server Validation when EAP Type is configured to
     * EAP-TLS, EAP-TTLS or PEAP. This is the certificate presented by the Wi-Fi
     * endpoint when the device attempts to connect to Wi-Fi endpoint. The device (or
     * user) must accept this certificate to continue the connection attempt.”</i>
     * 
     * @return navigational property rootCertificateForServerValidation
     */
    @NavigationProperty(name="rootCertificateForServerValidation")
    @JsonIgnore
    public AndroidTrustedRootCertificateRequest getRootCertificateForServerValidation() {
        return new AndroidTrustedRootCertificateRequest(contextPath.addSegment("rootCertificateForServerValidation"));
    }

    /**
     * <i>“Identity Certificate for client authentication when EAP Type is configured to
     * EAP-TLS, EAP-TTLS (with Certificate Authentication), or PEAP (with Certificate
     * Authentication). This is the certificate presented by client to the Wi-Fi
     * endpoint. The authentication server sitting behind the Wi-Fi endpoint must
     * accept this certificate to successfully establish a Wi-Fi connection.”</i>
     * 
     * @return navigational property identityCertificateForClientAuthentication
     */
    @NavigationProperty(name="identityCertificateForClientAuthentication")
    @JsonIgnore
    public AndroidCertificateProfileBaseRequest getIdentityCertificateForClientAuthentication() {
        return new AndroidCertificateProfileBaseRequest(contextPath.addSegment("identityCertificateForClientAuthentication"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidEnterpriseWiFiConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AndroidEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidEnterpriseWiFiConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AndroidEnterpriseWiFiConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AndroidEnterpriseWiFiConfiguration _copy() {
        AndroidEnterpriseWiFiConfiguration _x = new AndroidEnterpriseWiFiConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.networkName = networkName;
        _x.ssid = ssid;
        _x.connectAutomatically = connectAutomatically;
        _x.connectWhenNetworkNameIsHidden = connectWhenNetworkNameIsHidden;
        _x.wiFiSecurityType = wiFiSecurityType;
        _x.eapType = eapType;
        _x.authenticationMethod = authenticationMethod;
        _x.innerAuthenticationProtocolForEapTtls = innerAuthenticationProtocolForEapTtls;
        _x.innerAuthenticationProtocolForPeap = innerAuthenticationProtocolForPeap;
        _x.outerIdentityPrivacyTemporaryValue = outerIdentityPrivacyTemporaryValue;
        _x.usernameFormatString = usernameFormatString;
        _x.passwordFormatString = passwordFormatString;
        _x.preSharedKey = preSharedKey;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidEnterpriseWiFiConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("networkName=");
        b.append(this.networkName);
        b.append(", ");
        b.append("ssid=");
        b.append(this.ssid);
        b.append(", ");
        b.append("connectAutomatically=");
        b.append(this.connectAutomatically);
        b.append(", ");
        b.append("connectWhenNetworkNameIsHidden=");
        b.append(this.connectWhenNetworkNameIsHidden);
        b.append(", ");
        b.append("wiFiSecurityType=");
        b.append(this.wiFiSecurityType);
        b.append(", ");
        b.append("eapType=");
        b.append(this.eapType);
        b.append(", ");
        b.append("authenticationMethod=");
        b.append(this.authenticationMethod);
        b.append(", ");
        b.append("innerAuthenticationProtocolForEapTtls=");
        b.append(this.innerAuthenticationProtocolForEapTtls);
        b.append(", ");
        b.append("innerAuthenticationProtocolForPeap=");
        b.append(this.innerAuthenticationProtocolForPeap);
        b.append(", ");
        b.append("outerIdentityPrivacyTemporaryValue=");
        b.append(this.outerIdentityPrivacyTemporaryValue);
        b.append(", ");
        b.append("usernameFormatString=");
        b.append(this.usernameFormatString);
        b.append(", ");
        b.append("passwordFormatString=");
        b.append(this.passwordFormatString);
        b.append(", ");
        b.append("preSharedKey=");
        b.append(this.preSharedKey);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
