package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.complex.VpnProxyServer;
import odata.msgraph.client.beta.complex.VpnServer;
import odata.msgraph.client.beta.entity.request.AndroidDeviceOwnerCertificateProfileBaseRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementDerivedCredentialSettingsRequest;
import odata.msgraph.client.beta.enums.AndroidVpnConnectionType;
import odata.msgraph.client.beta.enums.VpnAuthenticationMethod;


/**
 * <i>“By providing the configurations in this profile you can instruct the Android
 * Fully Managed device to connect to desired VPN endpoint. By specifying the
 * authentication method and security types expected by VPN endpoint you can make
 * the VPN connection seamless for end user.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "connectionType", 
    "proxyServer", 
    "targetedPackageIds", 
    "alwaysOn", 
    "alwaysOnLockdown"})
@JsonInclude(Include.NON_NULL)
public class AndroidDeviceOwnerVpnConfiguration extends VpnConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidDeviceOwnerVpnConfiguration";
    }

    @JsonProperty("connectionType")
    protected AndroidVpnConnectionType connectionType;

    @JsonProperty("proxyServer")
    protected VpnProxyServer proxyServer;

    @JsonProperty("targetedPackageIds")
    protected List<String> targetedPackageIds;

    @JsonProperty("targetedPackageIds@nextLink")
    protected String targetedPackageIdsNextLink;

    @JsonProperty("alwaysOn")
    protected Boolean alwaysOn;

    @JsonProperty("alwaysOnLockdown")
    protected Boolean alwaysOnLockdown;

    protected AndroidDeviceOwnerVpnConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidDeviceOwnerVpnConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private VpnAuthenticationMethod authenticationMethod;
        private String connectionName;
        private String role;
        private String realm;
        private List<VpnServer> servers;
        private String serversNextLink;
        private AndroidVpnConnectionType connectionType;
        private VpnProxyServer proxyServer;
        private List<String> targetedPackageIds;
        private String targetedPackageIdsNextLink;
        private Boolean alwaysOn;
        private Boolean alwaysOnLockdown;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder authenticationMethod(VpnAuthenticationMethod authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            this.changedFields = changedFields.add("authenticationMethod");
            return this;
        }

        public Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            this.changedFields = changedFields.add("connectionName");
            return this;
        }

        public Builder role(String role) {
            this.role = role;
            this.changedFields = changedFields.add("role");
            return this;
        }

        public Builder realm(String realm) {
            this.realm = realm;
            this.changedFields = changedFields.add("realm");
            return this;
        }

        public Builder servers(List<VpnServer> servers) {
            this.servers = servers;
            this.changedFields = changedFields.add("servers");
            return this;
        }

        public Builder servers(VpnServer... servers) {
            return servers(Arrays.asList(servers));
        }

        public Builder serversNextLink(String serversNextLink) {
            this.serversNextLink = serversNextLink;
            this.changedFields = changedFields.add("servers");
            return this;
        }

        /**
         * <i>“Connection type.”</i>
         * 
         * @param connectionType
         *            value of {@code connectionType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder connectionType(AndroidVpnConnectionType connectionType) {
            this.connectionType = connectionType;
            this.changedFields = changedFields.add("connectionType");
            return this;
        }

        /**
         * <i>“Proxy server.”</i>
         * 
         * @param proxyServer
         *            value of {@code proxyServer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder proxyServer(VpnProxyServer proxyServer) {
            this.proxyServer = proxyServer;
            this.changedFields = changedFields.add("proxyServer");
            return this;
        }

        /**
         * <i>“Targeted App package IDs.”</i>
         * 
         * @param targetedPackageIds
         *            value of {@code targetedPackageIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetedPackageIds(List<String> targetedPackageIds) {
            this.targetedPackageIds = targetedPackageIds;
            this.changedFields = changedFields.add("targetedPackageIds");
            return this;
        }

        /**
         * <i>“Targeted App package IDs.”</i>
         * 
         * @param targetedPackageIds
         *            value of {@code targetedPackageIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetedPackageIds(String... targetedPackageIds) {
            return targetedPackageIds(Arrays.asList(targetedPackageIds));
        }

        /**
         * <i>“Targeted App package IDs.”</i>
         * 
         * @param targetedPackageIdsNextLink
         *            value of {@code targetedPackageIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder targetedPackageIdsNextLink(String targetedPackageIdsNextLink) {
            this.targetedPackageIdsNextLink = targetedPackageIdsNextLink;
            this.changedFields = changedFields.add("targetedPackageIds");
            return this;
        }

        /**
         * <i>“Whether or not to enable always-on VPN connection.”</i>
         * 
         * @param alwaysOn
         *            value of {@code alwaysOn} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder alwaysOn(Boolean alwaysOn) {
            this.alwaysOn = alwaysOn;
            this.changedFields = changedFields.add("alwaysOn");
            return this;
        }

        /**
         * <i>“If always-on VPN connection is enabled, whether or not to lock network traffic
         * when that VPN is disconnected.”</i>
         * 
         * @param alwaysOnLockdown
         *            value of {@code alwaysOnLockdown} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder alwaysOnLockdown(Boolean alwaysOnLockdown) {
            this.alwaysOnLockdown = alwaysOnLockdown;
            this.changedFields = changedFields.add("alwaysOnLockdown");
            return this;
        }

        public AndroidDeviceOwnerVpnConfiguration build() {
            AndroidDeviceOwnerVpnConfiguration _x = new AndroidDeviceOwnerVpnConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.androidDeviceOwnerVpnConfiguration";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.authenticationMethod = authenticationMethod;
            _x.connectionName = connectionName;
            _x.role = role;
            _x.realm = realm;
            _x.servers = servers;
            _x.serversNextLink = serversNextLink;
            _x.connectionType = connectionType;
            _x.proxyServer = proxyServer;
            _x.targetedPackageIds = targetedPackageIds;
            _x.targetedPackageIdsNextLink = targetedPackageIdsNextLink;
            _x.alwaysOn = alwaysOn;
            _x.alwaysOnLockdown = alwaysOnLockdown;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Connection type.”</i>
     * 
     * @return property connectionType
     */
    @Property(name="connectionType")
    @JsonIgnore
    public Optional<AndroidVpnConnectionType> getConnectionType() {
        return Optional.ofNullable(connectionType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code connectionType}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Connection type.”</i>
     * 
     * @param connectionType
     *            new value of {@code connectionType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code connectionType} field changed
     */
    public AndroidDeviceOwnerVpnConfiguration withConnectionType(AndroidVpnConnectionType connectionType) {
        AndroidDeviceOwnerVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("connectionType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerVpnConfiguration");
        _x.connectionType = connectionType;
        return _x;
    }

    /**
     * <i>“Proxy server.”</i>
     * 
     * @return property proxyServer
     */
    @Property(name="proxyServer")
    @JsonIgnore
    public Optional<VpnProxyServer> getProxyServer() {
        return Optional.ofNullable(proxyServer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code proxyServer}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Proxy server.”</i>
     * 
     * @param proxyServer
     *            new value of {@code proxyServer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code proxyServer} field changed
     */
    public AndroidDeviceOwnerVpnConfiguration withProxyServer(VpnProxyServer proxyServer) {
        AndroidDeviceOwnerVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("proxyServer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerVpnConfiguration");
        _x.proxyServer = proxyServer;
        return _x;
    }

    /**
     * <i>“Targeted App package IDs.”</i>
     * 
     * @return property targetedPackageIds
     */
    @Property(name="targetedPackageIds")
    @JsonIgnore
    public CollectionPage<String> getTargetedPackageIds() {
        return new CollectionPage<String>(contextPath, String.class, targetedPackageIds, Optional.ofNullable(targetedPackageIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Targeted App package IDs.”</i>
     * 
     * @return property targetedPackageIds
     */
    @Property(name="targetedPackageIds")
    @JsonIgnore
    public CollectionPage<String> getTargetedPackageIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, targetedPackageIds, Optional.ofNullable(targetedPackageIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Whether or not to enable always-on VPN connection.”</i>
     * 
     * @return property alwaysOn
     */
    @Property(name="alwaysOn")
    @JsonIgnore
    public Optional<Boolean> getAlwaysOn() {
        return Optional.ofNullable(alwaysOn);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code alwaysOn} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Whether or not to enable always-on VPN connection.”</i>
     * 
     * @param alwaysOn
     *            new value of {@code alwaysOn} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code alwaysOn} field changed
     */
    public AndroidDeviceOwnerVpnConfiguration withAlwaysOn(Boolean alwaysOn) {
        AndroidDeviceOwnerVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("alwaysOn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerVpnConfiguration");
        _x.alwaysOn = alwaysOn;
        return _x;
    }

    /**
     * <i>“If always-on VPN connection is enabled, whether or not to lock network traffic
     * when that VPN is disconnected.”</i>
     * 
     * @return property alwaysOnLockdown
     */
    @Property(name="alwaysOnLockdown")
    @JsonIgnore
    public Optional<Boolean> getAlwaysOnLockdown() {
        return Optional.ofNullable(alwaysOnLockdown);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code alwaysOnLockdown}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“If always-on VPN connection is enabled, whether or not to lock network traffic
     * when that VPN is disconnected.”</i>
     * 
     * @param alwaysOnLockdown
     *            new value of {@code alwaysOnLockdown} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code alwaysOnLockdown} field changed
     */
    public AndroidDeviceOwnerVpnConfiguration withAlwaysOnLockdown(Boolean alwaysOnLockdown) {
        AndroidDeviceOwnerVpnConfiguration _x = _copy();
        _x.changedFields = changedFields.add("alwaysOnLockdown");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerVpnConfiguration");
        _x.alwaysOnLockdown = alwaysOnLockdown;
        return _x;
    }

    /**
     * <i>“Identity certificate for client authentication when authentication method is
     * certificate.”</i>
     * 
     * @return navigational property identityCertificate
     */
    @NavigationProperty(name="identityCertificate")
    @JsonIgnore
    public AndroidDeviceOwnerCertificateProfileBaseRequest getIdentityCertificate() {
        return new AndroidDeviceOwnerCertificateProfileBaseRequest(contextPath.addSegment("identityCertificate"));
    }

    /**
     * <i>“Tenant level settings for the Derived Credentials to be used for authentication.”</i>
     * 
     * @return navigational property derivedCredentialSettings
     */
    @NavigationProperty(name="derivedCredentialSettings")
    @JsonIgnore
    public DeviceManagementDerivedCredentialSettingsRequest getDerivedCredentialSettings() {
        return new DeviceManagementDerivedCredentialSettingsRequest(contextPath.addSegment("derivedCredentialSettings"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidDeviceOwnerVpnConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AndroidDeviceOwnerVpnConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidDeviceOwnerVpnConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AndroidDeviceOwnerVpnConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AndroidDeviceOwnerVpnConfiguration _copy() {
        AndroidDeviceOwnerVpnConfiguration _x = new AndroidDeviceOwnerVpnConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.authenticationMethod = authenticationMethod;
        _x.connectionName = connectionName;
        _x.role = role;
        _x.realm = realm;
        _x.servers = servers;
        _x.connectionType = connectionType;
        _x.proxyServer = proxyServer;
        _x.targetedPackageIds = targetedPackageIds;
        _x.alwaysOn = alwaysOn;
        _x.alwaysOnLockdown = alwaysOnLockdown;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidDeviceOwnerVpnConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("authenticationMethod=");
        b.append(this.authenticationMethod);
        b.append(", ");
        b.append("connectionName=");
        b.append(this.connectionName);
        b.append(", ");
        b.append("role=");
        b.append(this.role);
        b.append(", ");
        b.append("realm=");
        b.append(this.realm);
        b.append(", ");
        b.append("servers=");
        b.append(this.servers);
        b.append(", ");
        b.append("connectionType=");
        b.append(this.connectionType);
        b.append(", ");
        b.append("proxyServer=");
        b.append(this.proxyServer);
        b.append(", ");
        b.append("targetedPackageIds=");
        b.append(this.targetedPackageIds);
        b.append(", ");
        b.append("alwaysOn=");
        b.append(this.alwaysOn);
        b.append(", ");
        b.append("alwaysOnLockdown=");
        b.append(this.alwaysOnLockdown);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
