package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.CustomSubjectAlternativeName;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.complex.ExtendedKeyUsage;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceCertificateStateCollectionRequest;
import odata.msgraph.client.beta.enums.CertificateStore;
import odata.msgraph.client.beta.enums.CertificateValidityPeriodScale;
import odata.msgraph.client.beta.enums.DeviceManagementCertificationAuthority;
import odata.msgraph.client.beta.enums.SubjectAlternativeNameType;
import odata.msgraph.client.beta.enums.SubjectNameFormat;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“Android Device Owner PKCS certificate profile”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "certificationAuthority", 
    "certificationAuthorityName", 
    "certificationAuthorityType", 
    "certificateTemplateName", 
    "subjectAlternativeNameFormatString", 
    "subjectNameFormatString", 
    "certificateStore", 
    "customSubjectAlternativeNames"})
@JsonInclude(Include.NON_NULL)
public class AndroidDeviceOwnerPkcsCertificateProfile extends AndroidDeviceOwnerCertificateProfileBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidDeviceOwnerPkcsCertificateProfile";
    }

    @JsonProperty("certificationAuthority")
    protected String certificationAuthority;

    @JsonProperty("certificationAuthorityName")
    protected String certificationAuthorityName;

    @JsonProperty("certificationAuthorityType")
    protected DeviceManagementCertificationAuthority certificationAuthorityType;

    @JsonProperty("certificateTemplateName")
    protected String certificateTemplateName;

    @JsonProperty("subjectAlternativeNameFormatString")
    protected String subjectAlternativeNameFormatString;

    @JsonProperty("subjectNameFormatString")
    protected String subjectNameFormatString;

    @JsonProperty("certificateStore")
    protected CertificateStore certificateStore;

    @JsonProperty("customSubjectAlternativeNames")
    protected List<CustomSubjectAlternativeName> customSubjectAlternativeNames;

    @JsonProperty("customSubjectAlternativeNames@nextLink")
    protected String customSubjectAlternativeNamesNextLink;

    protected AndroidDeviceOwnerPkcsCertificateProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidDeviceOwnerPkcsCertificateProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private Integer renewalThresholdPercentage;
        private SubjectNameFormat subjectNameFormat;
        private Integer certificateValidityPeriodValue;
        private CertificateValidityPeriodScale certificateValidityPeriodScale;
        private List<ExtendedKeyUsage> extendedKeyUsages;
        private String extendedKeyUsagesNextLink;
        private SubjectAlternativeNameType subjectAlternativeNameType;
        private String certificationAuthority;
        private String certificationAuthorityName;
        private DeviceManagementCertificationAuthority certificationAuthorityType;
        private String certificateTemplateName;
        private String subjectAlternativeNameFormatString;
        private String subjectNameFormatString;
        private CertificateStore certificateStore;
        private List<CustomSubjectAlternativeName> customSubjectAlternativeNames;
        private String customSubjectAlternativeNamesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder renewalThresholdPercentage(Integer renewalThresholdPercentage) {
            this.renewalThresholdPercentage = renewalThresholdPercentage;
            this.changedFields = changedFields.add("renewalThresholdPercentage");
            return this;
        }

        public Builder subjectNameFormat(SubjectNameFormat subjectNameFormat) {
            this.subjectNameFormat = subjectNameFormat;
            this.changedFields = changedFields.add("subjectNameFormat");
            return this;
        }

        public Builder certificateValidityPeriodValue(Integer certificateValidityPeriodValue) {
            this.certificateValidityPeriodValue = certificateValidityPeriodValue;
            this.changedFields = changedFields.add("certificateValidityPeriodValue");
            return this;
        }

        public Builder certificateValidityPeriodScale(CertificateValidityPeriodScale certificateValidityPeriodScale) {
            this.certificateValidityPeriodScale = certificateValidityPeriodScale;
            this.changedFields = changedFields.add("certificateValidityPeriodScale");
            return this;
        }

        public Builder extendedKeyUsages(List<ExtendedKeyUsage> extendedKeyUsages) {
            this.extendedKeyUsages = extendedKeyUsages;
            this.changedFields = changedFields.add("extendedKeyUsages");
            return this;
        }

        public Builder extendedKeyUsages(ExtendedKeyUsage... extendedKeyUsages) {
            return extendedKeyUsages(Arrays.asList(extendedKeyUsages));
        }

        public Builder extendedKeyUsagesNextLink(String extendedKeyUsagesNextLink) {
            this.extendedKeyUsagesNextLink = extendedKeyUsagesNextLink;
            this.changedFields = changedFields.add("extendedKeyUsages");
            return this;
        }

        public Builder subjectAlternativeNameType(SubjectAlternativeNameType subjectAlternativeNameType) {
            this.subjectAlternativeNameType = subjectAlternativeNameType;
            this.changedFields = changedFields.add("subjectAlternativeNameType");
            return this;
        }

        /**
         * <i>“PKCS Certification Authority”</i>
         * 
         * @param certificationAuthority
         *            value of {@code certificationAuthority} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificationAuthority(String certificationAuthority) {
            this.certificationAuthority = certificationAuthority;
            this.changedFields = changedFields.add("certificationAuthority");
            return this;
        }

        /**
         * <i>“PKCS Certification Authority Name”</i>
         * 
         * @param certificationAuthorityName
         *            value of {@code certificationAuthorityName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificationAuthorityName(String certificationAuthorityName) {
            this.certificationAuthorityName = certificationAuthorityName;
            this.changedFields = changedFields.add("certificationAuthorityName");
            return this;
        }

        /**
         * <i>“Certification authority type”</i>
         * 
         * @param certificationAuthorityType
         *            value of {@code certificationAuthorityType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificationAuthorityType(DeviceManagementCertificationAuthority certificationAuthorityType) {
            this.certificationAuthorityType = certificationAuthorityType;
            this.changedFields = changedFields.add("certificationAuthorityType");
            return this;
        }

        /**
         * <i>“PKCS Certificate Template Name”</i>
         * 
         * @param certificateTemplateName
         *            value of {@code certificateTemplateName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateTemplateName(String certificateTemplateName) {
            this.certificateTemplateName = certificateTemplateName;
            this.changedFields = changedFields.add("certificateTemplateName");
            return this;
        }

        /**
         * <i>“Custom String that defines the AAD Attribute.”</i>
         * 
         * @param subjectAlternativeNameFormatString
         *            value of {@code subjectAlternativeNameFormatString} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder subjectAlternativeNameFormatString(String subjectAlternativeNameFormatString) {
            this.subjectAlternativeNameFormatString = subjectAlternativeNameFormatString;
            this.changedFields = changedFields.add("subjectAlternativeNameFormatString");
            return this;
        }

        /**
         * <i>“Custom format to use with SubjectNameFormat = Custom. Example: CN={{EmailAddress
         * }},E={{EmailAddress}},OU=Enterprise Users,O=Contoso Corporation,L=Redmond,ST=WA,
         * C=US”</i>
         * 
         * @param subjectNameFormatString
         *            value of {@code subjectNameFormatString} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder subjectNameFormatString(String subjectNameFormatString) {
            this.subjectNameFormatString = subjectNameFormatString;
            this.changedFields = changedFields.add("subjectNameFormatString");
            return this;
        }

        /**
         * <i>“Target store certificate”</i>
         * 
         * @param certificateStore
         *            value of {@code certificateStore} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateStore(CertificateStore certificateStore) {
            this.certificateStore = certificateStore;
            this.changedFields = changedFields.add("certificateStore");
            return this;
        }

        /**
         * <i>“Custom Subject Alternative Name Settings. This collection can contain a maximum
         * of 500 elements.”</i>
         * 
         * @param customSubjectAlternativeNames
         *            value of {@code customSubjectAlternativeNames} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customSubjectAlternativeNames(List<CustomSubjectAlternativeName> customSubjectAlternativeNames) {
            this.customSubjectAlternativeNames = customSubjectAlternativeNames;
            this.changedFields = changedFields.add("customSubjectAlternativeNames");
            return this;
        }

        /**
         * <i>“Custom Subject Alternative Name Settings. This collection can contain a maximum
         * of 500 elements.”</i>
         * 
         * @param customSubjectAlternativeNames
         *            value of {@code customSubjectAlternativeNames} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customSubjectAlternativeNames(CustomSubjectAlternativeName... customSubjectAlternativeNames) {
            return customSubjectAlternativeNames(Arrays.asList(customSubjectAlternativeNames));
        }

        /**
         * <i>“Custom Subject Alternative Name Settings. This collection can contain a maximum
         * of 500 elements.”</i>
         * 
         * @param customSubjectAlternativeNamesNextLink
         *            value of {@code customSubjectAlternativeNames@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder customSubjectAlternativeNamesNextLink(String customSubjectAlternativeNamesNextLink) {
            this.customSubjectAlternativeNamesNextLink = customSubjectAlternativeNamesNextLink;
            this.changedFields = changedFields.add("customSubjectAlternativeNames");
            return this;
        }

        public AndroidDeviceOwnerPkcsCertificateProfile build() {
            AndroidDeviceOwnerPkcsCertificateProfile _x = new AndroidDeviceOwnerPkcsCertificateProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.androidDeviceOwnerPkcsCertificateProfile";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.renewalThresholdPercentage = renewalThresholdPercentage;
            _x.subjectNameFormat = subjectNameFormat;
            _x.certificateValidityPeriodValue = certificateValidityPeriodValue;
            _x.certificateValidityPeriodScale = certificateValidityPeriodScale;
            _x.extendedKeyUsages = extendedKeyUsages;
            _x.extendedKeyUsagesNextLink = extendedKeyUsagesNextLink;
            _x.subjectAlternativeNameType = subjectAlternativeNameType;
            _x.certificationAuthority = certificationAuthority;
            _x.certificationAuthorityName = certificationAuthorityName;
            _x.certificationAuthorityType = certificationAuthorityType;
            _x.certificateTemplateName = certificateTemplateName;
            _x.subjectAlternativeNameFormatString = subjectAlternativeNameFormatString;
            _x.subjectNameFormatString = subjectNameFormatString;
            _x.certificateStore = certificateStore;
            _x.customSubjectAlternativeNames = customSubjectAlternativeNames;
            _x.customSubjectAlternativeNamesNextLink = customSubjectAlternativeNamesNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“PKCS Certification Authority”</i>
     * 
     * @return property certificationAuthority
     */
    @Property(name="certificationAuthority")
    @JsonIgnore
    public Optional<String> getCertificationAuthority() {
        return Optional.ofNullable(certificationAuthority);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificationAuthority} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“PKCS Certification Authority”</i>
     * 
     * @param certificationAuthority
     *            new value of {@code certificationAuthority} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificationAuthority} field changed
     */
    public AndroidDeviceOwnerPkcsCertificateProfile withCertificationAuthority(String certificationAuthority) {
        AndroidDeviceOwnerPkcsCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("certificationAuthority");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerPkcsCertificateProfile");
        _x.certificationAuthority = certificationAuthority;
        return _x;
    }

    /**
     * <i>“PKCS Certification Authority Name”</i>
     * 
     * @return property certificationAuthorityName
     */
    @Property(name="certificationAuthorityName")
    @JsonIgnore
    public Optional<String> getCertificationAuthorityName() {
        return Optional.ofNullable(certificationAuthorityName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificationAuthorityName} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“PKCS Certification Authority Name”</i>
     * 
     * @param certificationAuthorityName
     *            new value of {@code certificationAuthorityName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificationAuthorityName} field changed
     */
    public AndroidDeviceOwnerPkcsCertificateProfile withCertificationAuthorityName(String certificationAuthorityName) {
        AndroidDeviceOwnerPkcsCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("certificationAuthorityName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerPkcsCertificateProfile");
        _x.certificationAuthorityName = certificationAuthorityName;
        return _x;
    }

    /**
     * <i>“Certification authority type”</i>
     * 
     * @return property certificationAuthorityType
     */
    @Property(name="certificationAuthorityType")
    @JsonIgnore
    public Optional<DeviceManagementCertificationAuthority> getCertificationAuthorityType() {
        return Optional.ofNullable(certificationAuthorityType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificationAuthorityType} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Certification authority type”</i>
     * 
     * @param certificationAuthorityType
     *            new value of {@code certificationAuthorityType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificationAuthorityType} field changed
     */
    public AndroidDeviceOwnerPkcsCertificateProfile withCertificationAuthorityType(DeviceManagementCertificationAuthority certificationAuthorityType) {
        AndroidDeviceOwnerPkcsCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("certificationAuthorityType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerPkcsCertificateProfile");
        _x.certificationAuthorityType = certificationAuthorityType;
        return _x;
    }

    /**
     * <i>“PKCS Certificate Template Name”</i>
     * 
     * @return property certificateTemplateName
     */
    @Property(name="certificateTemplateName")
    @JsonIgnore
    public Optional<String> getCertificateTemplateName() {
        return Optional.ofNullable(certificateTemplateName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateTemplateName} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“PKCS Certificate Template Name”</i>
     * 
     * @param certificateTemplateName
     *            new value of {@code certificateTemplateName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateTemplateName} field changed
     */
    public AndroidDeviceOwnerPkcsCertificateProfile withCertificateTemplateName(String certificateTemplateName) {
        AndroidDeviceOwnerPkcsCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("certificateTemplateName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerPkcsCertificateProfile");
        _x.certificateTemplateName = certificateTemplateName;
        return _x;
    }

    /**
     * <i>“Custom String that defines the AAD Attribute.”</i>
     * 
     * @return property subjectAlternativeNameFormatString
     */
    @Property(name="subjectAlternativeNameFormatString")
    @JsonIgnore
    public Optional<String> getSubjectAlternativeNameFormatString() {
        return Optional.ofNullable(subjectAlternativeNameFormatString);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * subjectAlternativeNameFormatString} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Custom String that defines the AAD Attribute.”</i>
     * 
     * @param subjectAlternativeNameFormatString
     *            new value of {@code subjectAlternativeNameFormatString} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code subjectAlternativeNameFormatString} field changed
     */
    public AndroidDeviceOwnerPkcsCertificateProfile withSubjectAlternativeNameFormatString(String subjectAlternativeNameFormatString) {
        AndroidDeviceOwnerPkcsCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("subjectAlternativeNameFormatString");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerPkcsCertificateProfile");
        _x.subjectAlternativeNameFormatString = subjectAlternativeNameFormatString;
        return _x;
    }

    /**
     * <i>“Custom format to use with SubjectNameFormat = Custom. Example: CN={{EmailAddress
     * }},E={{EmailAddress}},OU=Enterprise Users,O=Contoso Corporation,L=Redmond,ST=WA,
     * C=US”</i>
     * 
     * @return property subjectNameFormatString
     */
    @Property(name="subjectNameFormatString")
    @JsonIgnore
    public Optional<String> getSubjectNameFormatString() {
        return Optional.ofNullable(subjectNameFormatString);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * subjectNameFormatString} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Custom format to use with SubjectNameFormat = Custom. Example: CN={{EmailAddress
     * }},E={{EmailAddress}},OU=Enterprise Users,O=Contoso Corporation,L=Redmond,ST=WA,
     * C=US”</i>
     * 
     * @param subjectNameFormatString
     *            new value of {@code subjectNameFormatString} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code subjectNameFormatString} field changed
     */
    public AndroidDeviceOwnerPkcsCertificateProfile withSubjectNameFormatString(String subjectNameFormatString) {
        AndroidDeviceOwnerPkcsCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("subjectNameFormatString");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerPkcsCertificateProfile");
        _x.subjectNameFormatString = subjectNameFormatString;
        return _x;
    }

    /**
     * <i>“Target store certificate”</i>
     * 
     * @return property certificateStore
     */
    @Property(name="certificateStore")
    @JsonIgnore
    public Optional<CertificateStore> getCertificateStore() {
        return Optional.ofNullable(certificateStore);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code certificateStore}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Target store certificate”</i>
     * 
     * @param certificateStore
     *            new value of {@code certificateStore} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateStore} field changed
     */
    public AndroidDeviceOwnerPkcsCertificateProfile withCertificateStore(CertificateStore certificateStore) {
        AndroidDeviceOwnerPkcsCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("certificateStore");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerPkcsCertificateProfile");
        _x.certificateStore = certificateStore;
        return _x;
    }

    /**
     * <i>“Custom Subject Alternative Name Settings. This collection can contain a maximum
     * of 500 elements.”</i>
     * 
     * @return property customSubjectAlternativeNames
     */
    @Property(name="customSubjectAlternativeNames")
    @JsonIgnore
    public CollectionPage<CustomSubjectAlternativeName> getCustomSubjectAlternativeNames() {
        return new CollectionPage<CustomSubjectAlternativeName>(contextPath, CustomSubjectAlternativeName.class, customSubjectAlternativeNames, Optional.ofNullable(customSubjectAlternativeNamesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“Custom Subject Alternative Name Settings. This collection can contain a maximum
     * of 500 elements.”</i>
     * 
     * @return property customSubjectAlternativeNames
     */
    @Property(name="customSubjectAlternativeNames")
    @JsonIgnore
    public CollectionPage<CustomSubjectAlternativeName> getCustomSubjectAlternativeNames(HttpRequestOptions options) {
        return new CollectionPage<CustomSubjectAlternativeName>(contextPath, CustomSubjectAlternativeName.class, customSubjectAlternativeNames, Optional.ofNullable(customSubjectAlternativeNamesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Certificate state for devices”</i>
     * 
     * @return navigational property managedDeviceCertificateStates
     */
    @NavigationProperty(name="managedDeviceCertificateStates")
    @JsonIgnore
    public ManagedDeviceCertificateStateCollectionRequest getManagedDeviceCertificateStates() {
        return new ManagedDeviceCertificateStateCollectionRequest(
                        contextPath.addSegment("managedDeviceCertificateStates"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidDeviceOwnerPkcsCertificateProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AndroidDeviceOwnerPkcsCertificateProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidDeviceOwnerPkcsCertificateProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AndroidDeviceOwnerPkcsCertificateProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AndroidDeviceOwnerPkcsCertificateProfile _copy() {
        AndroidDeviceOwnerPkcsCertificateProfile _x = new AndroidDeviceOwnerPkcsCertificateProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.renewalThresholdPercentage = renewalThresholdPercentage;
        _x.subjectNameFormat = subjectNameFormat;
        _x.certificateValidityPeriodValue = certificateValidityPeriodValue;
        _x.certificateValidityPeriodScale = certificateValidityPeriodScale;
        _x.extendedKeyUsages = extendedKeyUsages;
        _x.subjectAlternativeNameType = subjectAlternativeNameType;
        _x.certificationAuthority = certificationAuthority;
        _x.certificationAuthorityName = certificationAuthorityName;
        _x.certificationAuthorityType = certificationAuthorityType;
        _x.certificateTemplateName = certificateTemplateName;
        _x.subjectAlternativeNameFormatString = subjectAlternativeNameFormatString;
        _x.subjectNameFormatString = subjectNameFormatString;
        _x.certificateStore = certificateStore;
        _x.customSubjectAlternativeNames = customSubjectAlternativeNames;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidDeviceOwnerPkcsCertificateProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("renewalThresholdPercentage=");
        b.append(this.renewalThresholdPercentage);
        b.append(", ");
        b.append("subjectNameFormat=");
        b.append(this.subjectNameFormat);
        b.append(", ");
        b.append("certificateValidityPeriodValue=");
        b.append(this.certificateValidityPeriodValue);
        b.append(", ");
        b.append("certificateValidityPeriodScale=");
        b.append(this.certificateValidityPeriodScale);
        b.append(", ");
        b.append("extendedKeyUsages=");
        b.append(this.extendedKeyUsages);
        b.append(", ");
        b.append("subjectAlternativeNameType=");
        b.append(this.subjectAlternativeNameType);
        b.append(", ");
        b.append("certificationAuthority=");
        b.append(this.certificationAuthority);
        b.append(", ");
        b.append("certificationAuthorityName=");
        b.append(this.certificationAuthorityName);
        b.append(", ");
        b.append("certificationAuthorityType=");
        b.append(this.certificationAuthorityType);
        b.append(", ");
        b.append("certificateTemplateName=");
        b.append(this.certificateTemplateName);
        b.append(", ");
        b.append("subjectAlternativeNameFormatString=");
        b.append(this.subjectAlternativeNameFormatString);
        b.append(", ");
        b.append("subjectNameFormatString=");
        b.append(this.subjectNameFormatString);
        b.append(", ");
        b.append("certificateStore=");
        b.append(this.certificateStore);
        b.append(", ");
        b.append("customSubjectAlternativeNames=");
        b.append(this.customSubjectAlternativeNames);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
