package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.complex.ExtendedKeyUsage;
import odata.msgraph.client.beta.entity.collection.request.ManagedDeviceCertificateStateCollectionRequest;
import odata.msgraph.client.beta.enums.CertificateValidityPeriodScale;
import odata.msgraph.client.beta.enums.IntendedPurpose;
import odata.msgraph.client.beta.enums.SubjectAlternativeNameType;
import odata.msgraph.client.beta.enums.SubjectNameFormat;


/**
 * <i>“Android Device Owner PFX Import certificate profile”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "intendedPurpose"})
@JsonInclude(Include.NON_NULL)
public class AndroidDeviceOwnerImportedPFXCertificateProfile extends AndroidDeviceOwnerCertificateProfileBase implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidDeviceOwnerImportedPFXCertificateProfile";
    }

    @JsonProperty("intendedPurpose")
    protected IntendedPurpose intendedPurpose;

    protected AndroidDeviceOwnerImportedPFXCertificateProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidDeviceOwnerImportedPFXCertificateProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private Integer renewalThresholdPercentage;
        private SubjectNameFormat subjectNameFormat;
        private Integer certificateValidityPeriodValue;
        private CertificateValidityPeriodScale certificateValidityPeriodScale;
        private List<ExtendedKeyUsage> extendedKeyUsages;
        private String extendedKeyUsagesNextLink;
        private SubjectAlternativeNameType subjectAlternativeNameType;
        private IntendedPurpose intendedPurpose;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        public Builder renewalThresholdPercentage(Integer renewalThresholdPercentage) {
            this.renewalThresholdPercentage = renewalThresholdPercentage;
            this.changedFields = changedFields.add("renewalThresholdPercentage");
            return this;
        }

        public Builder subjectNameFormat(SubjectNameFormat subjectNameFormat) {
            this.subjectNameFormat = subjectNameFormat;
            this.changedFields = changedFields.add("subjectNameFormat");
            return this;
        }

        public Builder certificateValidityPeriodValue(Integer certificateValidityPeriodValue) {
            this.certificateValidityPeriodValue = certificateValidityPeriodValue;
            this.changedFields = changedFields.add("certificateValidityPeriodValue");
            return this;
        }

        public Builder certificateValidityPeriodScale(CertificateValidityPeriodScale certificateValidityPeriodScale) {
            this.certificateValidityPeriodScale = certificateValidityPeriodScale;
            this.changedFields = changedFields.add("certificateValidityPeriodScale");
            return this;
        }

        public Builder extendedKeyUsages(List<ExtendedKeyUsage> extendedKeyUsages) {
            this.extendedKeyUsages = extendedKeyUsages;
            this.changedFields = changedFields.add("extendedKeyUsages");
            return this;
        }

        public Builder extendedKeyUsages(ExtendedKeyUsage... extendedKeyUsages) {
            return extendedKeyUsages(Arrays.asList(extendedKeyUsages));
        }

        public Builder extendedKeyUsagesNextLink(String extendedKeyUsagesNextLink) {
            this.extendedKeyUsagesNextLink = extendedKeyUsagesNextLink;
            this.changedFields = changedFields.add("extendedKeyUsages");
            return this;
        }

        public Builder subjectAlternativeNameType(SubjectAlternativeNameType subjectAlternativeNameType) {
            this.subjectAlternativeNameType = subjectAlternativeNameType;
            this.changedFields = changedFields.add("subjectAlternativeNameType");
            return this;
        }

        /**
         * <i>“Intended Purpose of the Certificate Profile - which could be Unassigned,
         * SmimeEncryption, SmimeSigning etc.”</i>
         * 
         * @param intendedPurpose
         *            value of {@code intendedPurpose} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder intendedPurpose(IntendedPurpose intendedPurpose) {
            this.intendedPurpose = intendedPurpose;
            this.changedFields = changedFields.add("intendedPurpose");
            return this;
        }

        public AndroidDeviceOwnerImportedPFXCertificateProfile build() {
            AndroidDeviceOwnerImportedPFXCertificateProfile _x = new AndroidDeviceOwnerImportedPFXCertificateProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.androidDeviceOwnerImportedPFXCertificateProfile";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.renewalThresholdPercentage = renewalThresholdPercentage;
            _x.subjectNameFormat = subjectNameFormat;
            _x.certificateValidityPeriodValue = certificateValidityPeriodValue;
            _x.certificateValidityPeriodScale = certificateValidityPeriodScale;
            _x.extendedKeyUsages = extendedKeyUsages;
            _x.extendedKeyUsagesNextLink = extendedKeyUsagesNextLink;
            _x.subjectAlternativeNameType = subjectAlternativeNameType;
            _x.intendedPurpose = intendedPurpose;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Intended Purpose of the Certificate Profile - which could be Unassigned,
     * SmimeEncryption, SmimeSigning etc.”</i>
     * 
     * @return property intendedPurpose
     */
    @Property(name="intendedPurpose")
    @JsonIgnore
    public Optional<IntendedPurpose> getIntendedPurpose() {
        return Optional.ofNullable(intendedPurpose);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code intendedPurpose}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Intended Purpose of the Certificate Profile - which could be Unassigned,
     * SmimeEncryption, SmimeSigning etc.”</i>
     * 
     * @param intendedPurpose
     *            new value of {@code intendedPurpose} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code intendedPurpose} field changed
     */
    public AndroidDeviceOwnerImportedPFXCertificateProfile withIntendedPurpose(IntendedPurpose intendedPurpose) {
        AndroidDeviceOwnerImportedPFXCertificateProfile _x = _copy();
        _x.changedFields = changedFields.add("intendedPurpose");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerImportedPFXCertificateProfile");
        _x.intendedPurpose = intendedPurpose;
        return _x;
    }

    /**
     * <i>“Certificate state for devices”</i>
     * 
     * @return navigational property managedDeviceCertificateStates
     */
    @NavigationProperty(name="managedDeviceCertificateStates")
    @JsonIgnore
    public ManagedDeviceCertificateStateCollectionRequest getManagedDeviceCertificateStates() {
        return new ManagedDeviceCertificateStateCollectionRequest(
                        contextPath.addSegment("managedDeviceCertificateStates"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidDeviceOwnerImportedPFXCertificateProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AndroidDeviceOwnerImportedPFXCertificateProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidDeviceOwnerImportedPFXCertificateProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AndroidDeviceOwnerImportedPFXCertificateProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AndroidDeviceOwnerImportedPFXCertificateProfile _copy() {
        AndroidDeviceOwnerImportedPFXCertificateProfile _x = new AndroidDeviceOwnerImportedPFXCertificateProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.renewalThresholdPercentage = renewalThresholdPercentage;
        _x.subjectNameFormat = subjectNameFormat;
        _x.certificateValidityPeriodValue = certificateValidityPeriodValue;
        _x.certificateValidityPeriodScale = certificateValidityPeriodScale;
        _x.extendedKeyUsages = extendedKeyUsages;
        _x.subjectAlternativeNameType = subjectAlternativeNameType;
        _x.intendedPurpose = intendedPurpose;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidDeviceOwnerImportedPFXCertificateProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("renewalThresholdPercentage=");
        b.append(this.renewalThresholdPercentage);
        b.append(", ");
        b.append("subjectNameFormat=");
        b.append(this.subjectNameFormat);
        b.append(", ");
        b.append("certificateValidityPeriodValue=");
        b.append(this.certificateValidityPeriodValue);
        b.append(", ");
        b.append("certificateValidityPeriodScale=");
        b.append(this.certificateValidityPeriodScale);
        b.append(", ");
        b.append("extendedKeyUsages=");
        b.append(this.extendedKeyUsages);
        b.append(", ");
        b.append("subjectAlternativeNameType=");
        b.append(this.subjectAlternativeNameType);
        b.append(", ");
        b.append("intendedPurpose=");
        b.append(this.intendedPurpose);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
