package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AndroidDeviceOwnerGlobalProxy;
import odata.msgraph.client.beta.complex.AppListItem;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleDeviceMode;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsEdition;
import odata.msgraph.client.beta.complex.DeviceManagementApplicabilityRuleOsVersion;
import odata.msgraph.client.beta.enums.AndroidDeviceOwnerAppAutoUpdatePolicyType;
import odata.msgraph.client.beta.enums.AndroidDeviceOwnerBatteryPluggedMode;
import odata.msgraph.client.beta.enums.AndroidDeviceOwnerDefaultAppPermissionPolicyType;
import odata.msgraph.client.beta.enums.AndroidDeviceOwnerEnrollmentProfileType;
import odata.msgraph.client.beta.enums.AndroidDeviceOwnerKioskModeFolderIcon;
import odata.msgraph.client.beta.enums.AndroidDeviceOwnerKioskModeIconSize;
import odata.msgraph.client.beta.enums.AndroidDeviceOwnerKioskModeScreenOrientation;
import odata.msgraph.client.beta.enums.AndroidDeviceOwnerPlayStoreMode;
import odata.msgraph.client.beta.enums.AndroidDeviceOwnerRequiredPasswordType;
import odata.msgraph.client.beta.enums.AndroidDeviceOwnerSystemUpdateInstallType;
import odata.msgraph.client.beta.enums.AndroidDeviceOwnerVirtualHomeButtonType;
import odata.msgraph.client.beta.enums.AndroidKeyguardFeature;
import odata.msgraph.client.beta.enums.MicrosoftLauncherDockPresence;
import odata.msgraph.client.beta.enums.MicrosoftLauncherSearchBarPlacement;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <i>“This topic provides descriptions of the declared methods, properties and
 * relationships exposed by the androidDeviceOwnerGeneralDeviceConfiguration
 * resource.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "accountsBlockModification", 
    "appsAllowInstallFromUnknownSources", 
    "appsAutoUpdatePolicy", 
    "appsDefaultPermissionPolicy", 
    "appsRecommendSkippingFirstUseHints", 
    "bluetoothBlockConfiguration", 
    "bluetoothBlockContactSharing", 
    "cameraBlocked", 
    "cellularBlockWiFiTethering", 
    "certificateCredentialConfigurationDisabled", 
    "microsoftLauncherConfigurationEnabled", 
    "microsoftLauncherCustomWallpaperEnabled", 
    "microsoftLauncherCustomWallpaperImageUrl", 
    "microsoftLauncherCustomWallpaperAllowUserModification", 
    "microsoftLauncherFeedEnabled", 
    "microsoftLauncherFeedAllowUserModification", 
    "microsoftLauncherDockPresenceConfiguration", 
    "microsoftLauncherDockPresenceAllowUserModification", 
    "microsoftLauncherSearchBarPlacementConfiguration", 
    "enrollmentProfile", 
    "dataRoamingBlocked", 
    "dateTimeConfigurationBlocked", 
    "factoryResetDeviceAdministratorEmails", 
    "factoryResetBlocked", 
    "globalProxy", 
    "googleAccountsBlocked", 
    "kioskModeScreenSaverConfigurationEnabled", 
    "kioskModeScreenSaverImageUrl", 
    "kioskModeScreenSaverDisplayTimeInSeconds", 
    "kioskModeScreenSaverStartDelayInSeconds", 
    "kioskModeScreenSaverDetectMediaDisabled", 
    "kioskModeApps", 
    "kioskModeWallpaperUrl", 
    "kioskModeExitCode", 
    "kioskModeVirtualHomeButtonEnabled", 
    "kioskModeVirtualHomeButtonType", 
    "kioskModeBluetoothConfigurationEnabled", 
    "kioskModeWiFiConfigurationEnabled", 
    "kioskModeFlashlightConfigurationEnabled", 
    "kioskModeMediaVolumeConfigurationEnabled", 
    "kioskModeShowDeviceInfo", 
    "kioskModeManagedSettingsEntryDisabled", 
    "kioskModeDebugMenuEasyAccessEnabled", 
    "kioskModeShowAppNotificationBadge", 
    "kioskModeScreenOrientation", 
    "kioskModeIconSize", 
    "kioskModeFolderIcon", 
    "kioskModeWifiAllowedSsids", 
    "microphoneForceMute", 
    "networkEscapeHatchAllowed", 
    "nfcBlockOutgoingBeam", 
    "passwordBlockKeyguard", 
    "passwordBlockKeyguardFeatures", 
    "passwordExpirationDays", 
    "passwordMinimumLength", 
    "passwordMinimumLetterCharacters", 
    "passwordMinimumLowerCaseCharacters", 
    "passwordMinimumNonLetterCharacters", 
    "passwordMinimumNumericCharacters", 
    "passwordMinimumSymbolCharacters", 
    "passwordMinimumUpperCaseCharacters", 
    "passwordMinutesOfInactivityBeforeScreenTimeout", 
    "passwordPreviousPasswordCountToBlock", 
    "passwordRequiredType", 
    "passwordSignInFailureCountBeforeFactoryReset", 
    "playStoreMode", 
    "safeBootBlocked", 
    "screenCaptureBlocked", 
    "securityAllowDebuggingFeatures", 
    "securityRequireVerifyApps", 
    "statusBarBlocked", 
    "stayOnModes", 
    "storageAllowUsb", 
    "storageBlockExternalMedia", 
    "storageBlockUsbFileTransfer", 
    "systemUpdateWindowStartMinutesAfterMidnight", 
    "systemUpdateWindowEndMinutesAfterMidnight", 
    "systemUpdateInstallType", 
    "systemWindowsBlocked", 
    "usersBlockAdd", 
    "usersBlockRemove", 
    "volumeBlockAdjustment", 
    "vpnAlwaysOnLockdownMode", 
    "vpnAlwaysOnPackageIdentifier", 
    "wifiBlockEditConfigurations", 
    "wifiBlockEditPolicyDefinedConfigurations"})
@JsonInclude(Include.NON_NULL)
public class AndroidDeviceOwnerGeneralDeviceConfiguration extends DeviceConfiguration implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration";
    }

    @JsonProperty("accountsBlockModification")
    protected Boolean accountsBlockModification;

    @JsonProperty("appsAllowInstallFromUnknownSources")
    protected Boolean appsAllowInstallFromUnknownSources;

    @JsonProperty("appsAutoUpdatePolicy")
    protected AndroidDeviceOwnerAppAutoUpdatePolicyType appsAutoUpdatePolicy;

    @JsonProperty("appsDefaultPermissionPolicy")
    protected AndroidDeviceOwnerDefaultAppPermissionPolicyType appsDefaultPermissionPolicy;

    @JsonProperty("appsRecommendSkippingFirstUseHints")
    protected Boolean appsRecommendSkippingFirstUseHints;

    @JsonProperty("bluetoothBlockConfiguration")
    protected Boolean bluetoothBlockConfiguration;

    @JsonProperty("bluetoothBlockContactSharing")
    protected Boolean bluetoothBlockContactSharing;

    @JsonProperty("cameraBlocked")
    protected Boolean cameraBlocked;

    @JsonProperty("cellularBlockWiFiTethering")
    protected Boolean cellularBlockWiFiTethering;

    @JsonProperty("certificateCredentialConfigurationDisabled")
    protected Boolean certificateCredentialConfigurationDisabled;

    @JsonProperty("microsoftLauncherConfigurationEnabled")
    protected Boolean microsoftLauncherConfigurationEnabled;

    @JsonProperty("microsoftLauncherCustomWallpaperEnabled")
    protected Boolean microsoftLauncherCustomWallpaperEnabled;

    @JsonProperty("microsoftLauncherCustomWallpaperImageUrl")
    protected String microsoftLauncherCustomWallpaperImageUrl;

    @JsonProperty("microsoftLauncherCustomWallpaperAllowUserModification")
    protected Boolean microsoftLauncherCustomWallpaperAllowUserModification;

    @JsonProperty("microsoftLauncherFeedEnabled")
    protected Boolean microsoftLauncherFeedEnabled;

    @JsonProperty("microsoftLauncherFeedAllowUserModification")
    protected Boolean microsoftLauncherFeedAllowUserModification;

    @JsonProperty("microsoftLauncherDockPresenceConfiguration")
    protected MicrosoftLauncherDockPresence microsoftLauncherDockPresenceConfiguration;

    @JsonProperty("microsoftLauncherDockPresenceAllowUserModification")
    protected Boolean microsoftLauncherDockPresenceAllowUserModification;

    @JsonProperty("microsoftLauncherSearchBarPlacementConfiguration")
    protected MicrosoftLauncherSearchBarPlacement microsoftLauncherSearchBarPlacementConfiguration;

    @JsonProperty("enrollmentProfile")
    protected AndroidDeviceOwnerEnrollmentProfileType enrollmentProfile;

    @JsonProperty("dataRoamingBlocked")
    protected Boolean dataRoamingBlocked;

    @JsonProperty("dateTimeConfigurationBlocked")
    protected Boolean dateTimeConfigurationBlocked;

    @JsonProperty("factoryResetDeviceAdministratorEmails")
    protected List<String> factoryResetDeviceAdministratorEmails;

    @JsonProperty("factoryResetDeviceAdministratorEmails@nextLink")
    protected String factoryResetDeviceAdministratorEmailsNextLink;

    @JsonProperty("factoryResetBlocked")
    protected Boolean factoryResetBlocked;

    @JsonProperty("globalProxy")
    protected AndroidDeviceOwnerGlobalProxy globalProxy;

    @JsonProperty("googleAccountsBlocked")
    protected Boolean googleAccountsBlocked;

    @JsonProperty("kioskModeScreenSaverConfigurationEnabled")
    protected Boolean kioskModeScreenSaverConfigurationEnabled;

    @JsonProperty("kioskModeScreenSaverImageUrl")
    protected String kioskModeScreenSaverImageUrl;

    @JsonProperty("kioskModeScreenSaverDisplayTimeInSeconds")
    protected Integer kioskModeScreenSaverDisplayTimeInSeconds;

    @JsonProperty("kioskModeScreenSaverStartDelayInSeconds")
    protected Integer kioskModeScreenSaverStartDelayInSeconds;

    @JsonProperty("kioskModeScreenSaverDetectMediaDisabled")
    protected Boolean kioskModeScreenSaverDetectMediaDisabled;

    @JsonProperty("kioskModeApps")
    protected List<AppListItem> kioskModeApps;

    @JsonProperty("kioskModeApps@nextLink")
    protected String kioskModeAppsNextLink;

    @JsonProperty("kioskModeWallpaperUrl")
    protected String kioskModeWallpaperUrl;

    @JsonProperty("kioskModeExitCode")
    protected String kioskModeExitCode;

    @JsonProperty("kioskModeVirtualHomeButtonEnabled")
    protected Boolean kioskModeVirtualHomeButtonEnabled;

    @JsonProperty("kioskModeVirtualHomeButtonType")
    protected AndroidDeviceOwnerVirtualHomeButtonType kioskModeVirtualHomeButtonType;

    @JsonProperty("kioskModeBluetoothConfigurationEnabled")
    protected Boolean kioskModeBluetoothConfigurationEnabled;

    @JsonProperty("kioskModeWiFiConfigurationEnabled")
    protected Boolean kioskModeWiFiConfigurationEnabled;

    @JsonProperty("kioskModeFlashlightConfigurationEnabled")
    protected Boolean kioskModeFlashlightConfigurationEnabled;

    @JsonProperty("kioskModeMediaVolumeConfigurationEnabled")
    protected Boolean kioskModeMediaVolumeConfigurationEnabled;

    @JsonProperty("kioskModeShowDeviceInfo")
    protected Boolean kioskModeShowDeviceInfo;

    @JsonProperty("kioskModeManagedSettingsEntryDisabled")
    protected Boolean kioskModeManagedSettingsEntryDisabled;

    @JsonProperty("kioskModeDebugMenuEasyAccessEnabled")
    protected Boolean kioskModeDebugMenuEasyAccessEnabled;

    @JsonProperty("kioskModeShowAppNotificationBadge")
    protected Boolean kioskModeShowAppNotificationBadge;

    @JsonProperty("kioskModeScreenOrientation")
    protected AndroidDeviceOwnerKioskModeScreenOrientation kioskModeScreenOrientation;

    @JsonProperty("kioskModeIconSize")
    protected AndroidDeviceOwnerKioskModeIconSize kioskModeIconSize;

    @JsonProperty("kioskModeFolderIcon")
    protected AndroidDeviceOwnerKioskModeFolderIcon kioskModeFolderIcon;

    @JsonProperty("kioskModeWifiAllowedSsids")
    protected List<String> kioskModeWifiAllowedSsids;

    @JsonProperty("kioskModeWifiAllowedSsids@nextLink")
    protected String kioskModeWifiAllowedSsidsNextLink;

    @JsonProperty("microphoneForceMute")
    protected Boolean microphoneForceMute;

    @JsonProperty("networkEscapeHatchAllowed")
    protected Boolean networkEscapeHatchAllowed;

    @JsonProperty("nfcBlockOutgoingBeam")
    protected Boolean nfcBlockOutgoingBeam;

    @JsonProperty("passwordBlockKeyguard")
    protected Boolean passwordBlockKeyguard;

    @JsonProperty("passwordBlockKeyguardFeatures")
    protected List<AndroidKeyguardFeature> passwordBlockKeyguardFeatures;

    @JsonProperty("passwordBlockKeyguardFeatures@nextLink")
    protected String passwordBlockKeyguardFeaturesNextLink;

    @JsonProperty("passwordExpirationDays")
    protected Integer passwordExpirationDays;

    @JsonProperty("passwordMinimumLength")
    protected Integer passwordMinimumLength;

    @JsonProperty("passwordMinimumLetterCharacters")
    protected Integer passwordMinimumLetterCharacters;

    @JsonProperty("passwordMinimumLowerCaseCharacters")
    protected Integer passwordMinimumLowerCaseCharacters;

    @JsonProperty("passwordMinimumNonLetterCharacters")
    protected Integer passwordMinimumNonLetterCharacters;

    @JsonProperty("passwordMinimumNumericCharacters")
    protected Integer passwordMinimumNumericCharacters;

    @JsonProperty("passwordMinimumSymbolCharacters")
    protected Integer passwordMinimumSymbolCharacters;

    @JsonProperty("passwordMinimumUpperCaseCharacters")
    protected Integer passwordMinimumUpperCaseCharacters;

    @JsonProperty("passwordMinutesOfInactivityBeforeScreenTimeout")
    protected Integer passwordMinutesOfInactivityBeforeScreenTimeout;

    @JsonProperty("passwordPreviousPasswordCountToBlock")
    protected Integer passwordPreviousPasswordCountToBlock;

    @JsonProperty("passwordRequiredType")
    protected AndroidDeviceOwnerRequiredPasswordType passwordRequiredType;

    @JsonProperty("passwordSignInFailureCountBeforeFactoryReset")
    protected Integer passwordSignInFailureCountBeforeFactoryReset;

    @JsonProperty("playStoreMode")
    protected AndroidDeviceOwnerPlayStoreMode playStoreMode;

    @JsonProperty("safeBootBlocked")
    protected Boolean safeBootBlocked;

    @JsonProperty("screenCaptureBlocked")
    protected Boolean screenCaptureBlocked;

    @JsonProperty("securityAllowDebuggingFeatures")
    protected Boolean securityAllowDebuggingFeatures;

    @JsonProperty("securityRequireVerifyApps")
    protected Boolean securityRequireVerifyApps;

    @JsonProperty("statusBarBlocked")
    protected Boolean statusBarBlocked;

    @JsonProperty("stayOnModes")
    protected List<AndroidDeviceOwnerBatteryPluggedMode> stayOnModes;

    @JsonProperty("stayOnModes@nextLink")
    protected String stayOnModesNextLink;

    @JsonProperty("storageAllowUsb")
    protected Boolean storageAllowUsb;

    @JsonProperty("storageBlockExternalMedia")
    protected Boolean storageBlockExternalMedia;

    @JsonProperty("storageBlockUsbFileTransfer")
    protected Boolean storageBlockUsbFileTransfer;

    @JsonProperty("systemUpdateWindowStartMinutesAfterMidnight")
    protected Integer systemUpdateWindowStartMinutesAfterMidnight;

    @JsonProperty("systemUpdateWindowEndMinutesAfterMidnight")
    protected Integer systemUpdateWindowEndMinutesAfterMidnight;

    @JsonProperty("systemUpdateInstallType")
    protected AndroidDeviceOwnerSystemUpdateInstallType systemUpdateInstallType;

    @JsonProperty("systemWindowsBlocked")
    protected Boolean systemWindowsBlocked;

    @JsonProperty("usersBlockAdd")
    protected Boolean usersBlockAdd;

    @JsonProperty("usersBlockRemove")
    protected Boolean usersBlockRemove;

    @JsonProperty("volumeBlockAdjustment")
    protected Boolean volumeBlockAdjustment;

    @JsonProperty("vpnAlwaysOnLockdownMode")
    protected Boolean vpnAlwaysOnLockdownMode;

    @JsonProperty("vpnAlwaysOnPackageIdentifier")
    protected String vpnAlwaysOnPackageIdentifier;

    @JsonProperty("wifiBlockEditConfigurations")
    protected Boolean wifiBlockEditConfigurations;

    @JsonProperty("wifiBlockEditPolicyDefinedConfigurations")
    protected Boolean wifiBlockEditPolicyDefinedConfigurations;

    protected AndroidDeviceOwnerGeneralDeviceConfiguration() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidDeviceOwnerGeneralDeviceConfiguration() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime lastModifiedDateTime;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private Boolean supportsScopeTags;
        private DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition;
        private DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion;
        private DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode;
        private OffsetDateTime createdDateTime;
        private String description;
        private String displayName;
        private Integer version;
        private Boolean accountsBlockModification;
        private Boolean appsAllowInstallFromUnknownSources;
        private AndroidDeviceOwnerAppAutoUpdatePolicyType appsAutoUpdatePolicy;
        private AndroidDeviceOwnerDefaultAppPermissionPolicyType appsDefaultPermissionPolicy;
        private Boolean appsRecommendSkippingFirstUseHints;
        private Boolean bluetoothBlockConfiguration;
        private Boolean bluetoothBlockContactSharing;
        private Boolean cameraBlocked;
        private Boolean cellularBlockWiFiTethering;
        private Boolean certificateCredentialConfigurationDisabled;
        private Boolean microsoftLauncherConfigurationEnabled;
        private Boolean microsoftLauncherCustomWallpaperEnabled;
        private String microsoftLauncherCustomWallpaperImageUrl;
        private Boolean microsoftLauncherCustomWallpaperAllowUserModification;
        private Boolean microsoftLauncherFeedEnabled;
        private Boolean microsoftLauncherFeedAllowUserModification;
        private MicrosoftLauncherDockPresence microsoftLauncherDockPresenceConfiguration;
        private Boolean microsoftLauncherDockPresenceAllowUserModification;
        private MicrosoftLauncherSearchBarPlacement microsoftLauncherSearchBarPlacementConfiguration;
        private AndroidDeviceOwnerEnrollmentProfileType enrollmentProfile;
        private Boolean dataRoamingBlocked;
        private Boolean dateTimeConfigurationBlocked;
        private List<String> factoryResetDeviceAdministratorEmails;
        private String factoryResetDeviceAdministratorEmailsNextLink;
        private Boolean factoryResetBlocked;
        private AndroidDeviceOwnerGlobalProxy globalProxy;
        private Boolean googleAccountsBlocked;
        private Boolean kioskModeScreenSaverConfigurationEnabled;
        private String kioskModeScreenSaverImageUrl;
        private Integer kioskModeScreenSaverDisplayTimeInSeconds;
        private Integer kioskModeScreenSaverStartDelayInSeconds;
        private Boolean kioskModeScreenSaverDetectMediaDisabled;
        private List<AppListItem> kioskModeApps;
        private String kioskModeAppsNextLink;
        private String kioskModeWallpaperUrl;
        private String kioskModeExitCode;
        private Boolean kioskModeVirtualHomeButtonEnabled;
        private AndroidDeviceOwnerVirtualHomeButtonType kioskModeVirtualHomeButtonType;
        private Boolean kioskModeBluetoothConfigurationEnabled;
        private Boolean kioskModeWiFiConfigurationEnabled;
        private Boolean kioskModeFlashlightConfigurationEnabled;
        private Boolean kioskModeMediaVolumeConfigurationEnabled;
        private Boolean kioskModeShowDeviceInfo;
        private Boolean kioskModeManagedSettingsEntryDisabled;
        private Boolean kioskModeDebugMenuEasyAccessEnabled;
        private Boolean kioskModeShowAppNotificationBadge;
        private AndroidDeviceOwnerKioskModeScreenOrientation kioskModeScreenOrientation;
        private AndroidDeviceOwnerKioskModeIconSize kioskModeIconSize;
        private AndroidDeviceOwnerKioskModeFolderIcon kioskModeFolderIcon;
        private List<String> kioskModeWifiAllowedSsids;
        private String kioskModeWifiAllowedSsidsNextLink;
        private Boolean microphoneForceMute;
        private Boolean networkEscapeHatchAllowed;
        private Boolean nfcBlockOutgoingBeam;
        private Boolean passwordBlockKeyguard;
        private List<AndroidKeyguardFeature> passwordBlockKeyguardFeatures;
        private String passwordBlockKeyguardFeaturesNextLink;
        private Integer passwordExpirationDays;
        private Integer passwordMinimumLength;
        private Integer passwordMinimumLetterCharacters;
        private Integer passwordMinimumLowerCaseCharacters;
        private Integer passwordMinimumNonLetterCharacters;
        private Integer passwordMinimumNumericCharacters;
        private Integer passwordMinimumSymbolCharacters;
        private Integer passwordMinimumUpperCaseCharacters;
        private Integer passwordMinutesOfInactivityBeforeScreenTimeout;
        private Integer passwordPreviousPasswordCountToBlock;
        private AndroidDeviceOwnerRequiredPasswordType passwordRequiredType;
        private Integer passwordSignInFailureCountBeforeFactoryReset;
        private AndroidDeviceOwnerPlayStoreMode playStoreMode;
        private Boolean safeBootBlocked;
        private Boolean screenCaptureBlocked;
        private Boolean securityAllowDebuggingFeatures;
        private Boolean securityRequireVerifyApps;
        private Boolean statusBarBlocked;
        private List<AndroidDeviceOwnerBatteryPluggedMode> stayOnModes;
        private String stayOnModesNextLink;
        private Boolean storageAllowUsb;
        private Boolean storageBlockExternalMedia;
        private Boolean storageBlockUsbFileTransfer;
        private Integer systemUpdateWindowStartMinutesAfterMidnight;
        private Integer systemUpdateWindowEndMinutesAfterMidnight;
        private AndroidDeviceOwnerSystemUpdateInstallType systemUpdateInstallType;
        private Boolean systemWindowsBlocked;
        private Boolean usersBlockAdd;
        private Boolean usersBlockRemove;
        private Boolean volumeBlockAdjustment;
        private Boolean vpnAlwaysOnLockdownMode;
        private String vpnAlwaysOnPackageIdentifier;
        private Boolean wifiBlockEditConfigurations;
        private Boolean wifiBlockEditPolicyDefinedConfigurations;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public Builder supportsScopeTags(Boolean supportsScopeTags) {
            this.supportsScopeTags = supportsScopeTags;
            this.changedFields = changedFields.add("supportsScopeTags");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsEdition(DeviceManagementApplicabilityRuleOsEdition deviceManagementApplicabilityRuleOsEdition) {
            this.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsEdition");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleOsVersion(DeviceManagementApplicabilityRuleOsVersion deviceManagementApplicabilityRuleOsVersion) {
            this.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleOsVersion");
            return this;
        }

        public Builder deviceManagementApplicabilityRuleDeviceMode(DeviceManagementApplicabilityRuleDeviceMode deviceManagementApplicabilityRuleDeviceMode) {
            this.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            this.changedFields = changedFields.add("deviceManagementApplicabilityRuleDeviceMode");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder version(Integer version) {
            this.version = version;
            this.changedFields = changedFields.add("version");
            return this;
        }

        /**
         * <i>“Indicates whether or not adding or removing accounts is disabled.”</i>
         * 
         * @param accountsBlockModification
         *            value of {@code accountsBlockModification} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder accountsBlockModification(Boolean accountsBlockModification) {
            this.accountsBlockModification = accountsBlockModification;
            this.changedFields = changedFields.add("accountsBlockModification");
            return this;
        }

        /**
         * <i>“Indicates whether or not the user is allowed to enable to unknown sources
         * setting.”</i>
         * 
         * @param appsAllowInstallFromUnknownSources
         *            value of {@code appsAllowInstallFromUnknownSources} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsAllowInstallFromUnknownSources(Boolean appsAllowInstallFromUnknownSources) {
            this.appsAllowInstallFromUnknownSources = appsAllowInstallFromUnknownSources;
            this.changedFields = changedFields.add("appsAllowInstallFromUnknownSources");
            return this;
        }

        /**
         * <i>“Indicates the value of the app auto update policy.”</i>
         * 
         * @param appsAutoUpdatePolicy
         *            value of {@code appsAutoUpdatePolicy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsAutoUpdatePolicy(AndroidDeviceOwnerAppAutoUpdatePolicyType appsAutoUpdatePolicy) {
            this.appsAutoUpdatePolicy = appsAutoUpdatePolicy;
            this.changedFields = changedFields.add("appsAutoUpdatePolicy");
            return this;
        }

        /**
         * <i>“Indicates the permission policy for requests for runtime permissions if one is
         * not defined for the app specifically.”</i>
         * 
         * @param appsDefaultPermissionPolicy
         *            value of {@code appsDefaultPermissionPolicy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsDefaultPermissionPolicy(AndroidDeviceOwnerDefaultAppPermissionPolicyType appsDefaultPermissionPolicy) {
            this.appsDefaultPermissionPolicy = appsDefaultPermissionPolicy;
            this.changedFields = changedFields.add("appsDefaultPermissionPolicy");
            return this;
        }

        /**
         * <i>“Whether or not to recommend all apps skip any first-time-use hints they may have
         * added.”</i>
         * 
         * @param appsRecommendSkippingFirstUseHints
         *            value of {@code appsRecommendSkippingFirstUseHints} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder appsRecommendSkippingFirstUseHints(Boolean appsRecommendSkippingFirstUseHints) {
            this.appsRecommendSkippingFirstUseHints = appsRecommendSkippingFirstUseHints;
            this.changedFields = changedFields.add("appsRecommendSkippingFirstUseHints");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block a user from configuring bluetooth.”</i>
         * 
         * @param bluetoothBlockConfiguration
         *            value of {@code bluetoothBlockConfiguration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bluetoothBlockConfiguration(Boolean bluetoothBlockConfiguration) {
            this.bluetoothBlockConfiguration = bluetoothBlockConfiguration;
            this.changedFields = changedFields.add("bluetoothBlockConfiguration");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block a user from sharing contacts via bluetooth.”</i>
         * 
         * @param bluetoothBlockContactSharing
         *            value of {@code bluetoothBlockContactSharing} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder bluetoothBlockContactSharing(Boolean bluetoothBlockContactSharing) {
            this.bluetoothBlockContactSharing = bluetoothBlockContactSharing;
            this.changedFields = changedFields.add("bluetoothBlockContactSharing");
            return this;
        }

        /**
         * <i>“Indicates whether or not to disable the use of the camera.”</i>
         * 
         * @param cameraBlocked
         *            value of {@code cameraBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cameraBlocked(Boolean cameraBlocked) {
            this.cameraBlocked = cameraBlocked;
            this.changedFields = changedFields.add("cameraBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block Wi-Fi tethering.”</i>
         * 
         * @param cellularBlockWiFiTethering
         *            value of {@code cellularBlockWiFiTethering} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder cellularBlockWiFiTethering(Boolean cellularBlockWiFiTethering) {
            this.cellularBlockWiFiTethering = cellularBlockWiFiTethering;
            this.changedFields = changedFields.add("cellularBlockWiFiTethering");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block users from any certificate credential
         * configuration.”</i>
         * 
         * @param certificateCredentialConfigurationDisabled
         *            value of {@code certificateCredentialConfigurationDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder certificateCredentialConfigurationDisabled(Boolean certificateCredentialConfigurationDisabled) {
            this.certificateCredentialConfigurationDisabled = certificateCredentialConfigurationDisabled;
            this.changedFields = changedFields.add("certificateCredentialConfigurationDisabled");
            return this;
        }

        /**
         * <i>“Indicates whether or not to you want configure Microsoft Launcher.”</i>
         * 
         * @param microsoftLauncherConfigurationEnabled
         *            value of {@code microsoftLauncherConfigurationEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftLauncherConfigurationEnabled(Boolean microsoftLauncherConfigurationEnabled) {
            this.microsoftLauncherConfigurationEnabled = microsoftLauncherConfigurationEnabled;
            this.changedFields = changedFields.add("microsoftLauncherConfigurationEnabled");
            return this;
        }

        /**
         * <i>“Indicates whether or not to configure the wallpaper on the targeted devices.”</i>
         * 
         * @param microsoftLauncherCustomWallpaperEnabled
         *            value of {@code microsoftLauncherCustomWallpaperEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftLauncherCustomWallpaperEnabled(Boolean microsoftLauncherCustomWallpaperEnabled) {
            this.microsoftLauncherCustomWallpaperEnabled = microsoftLauncherCustomWallpaperEnabled;
            this.changedFields = changedFields.add("microsoftLauncherCustomWallpaperEnabled");
            return this;
        }

        /**
         * <i>“Indicates the URL for the image file to use as the wallpaper on the targeted
         * devices.”</i>
         * 
         * @param microsoftLauncherCustomWallpaperImageUrl
         *            value of {@code microsoftLauncherCustomWallpaperImageUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftLauncherCustomWallpaperImageUrl(String microsoftLauncherCustomWallpaperImageUrl) {
            this.microsoftLauncherCustomWallpaperImageUrl = microsoftLauncherCustomWallpaperImageUrl;
            this.changedFields = changedFields.add("microsoftLauncherCustomWallpaperImageUrl");
            return this;
        }

        /**
         * <i>“Indicates whether or not the user can modify the wallpaper to personalize their
         * device.”</i>
         * 
         * @param microsoftLauncherCustomWallpaperAllowUserModification
         *            value of {@code microsoftLauncherCustomWallpaperAllowUserModification} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftLauncherCustomWallpaperAllowUserModification(Boolean microsoftLauncherCustomWallpaperAllowUserModification) {
            this.microsoftLauncherCustomWallpaperAllowUserModification = microsoftLauncherCustomWallpaperAllowUserModification;
            this.changedFields = changedFields.add("microsoftLauncherCustomWallpaperAllowUserModification");
            return this;
        }

        /**
         * <i>“Indicates whether or not you want to enable the launcher feed on the device.”</i>
         * 
         * @param microsoftLauncherFeedEnabled
         *            value of {@code microsoftLauncherFeedEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftLauncherFeedEnabled(Boolean microsoftLauncherFeedEnabled) {
            this.microsoftLauncherFeedEnabled = microsoftLauncherFeedEnabled;
            this.changedFields = changedFields.add("microsoftLauncherFeedEnabled");
            return this;
        }

        /**
         * <i>“Indicates whether or not the user can modify the launcher feed on the device.”</i>
         * 
         * @param microsoftLauncherFeedAllowUserModification
         *            value of {@code microsoftLauncherFeedAllowUserModification} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftLauncherFeedAllowUserModification(Boolean microsoftLauncherFeedAllowUserModification) {
            this.microsoftLauncherFeedAllowUserModification = microsoftLauncherFeedAllowUserModification;
            this.changedFields = changedFields.add("microsoftLauncherFeedAllowUserModification");
            return this;
        }

        /**
         * <i>“Indicates whether or not you want to configure the device dock.”</i>
         * 
         * @param microsoftLauncherDockPresenceConfiguration
         *            value of {@code microsoftLauncherDockPresenceConfiguration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftLauncherDockPresenceConfiguration(MicrosoftLauncherDockPresence microsoftLauncherDockPresenceConfiguration) {
            this.microsoftLauncherDockPresenceConfiguration = microsoftLauncherDockPresenceConfiguration;
            this.changedFields = changedFields.add("microsoftLauncherDockPresenceConfiguration");
            return this;
        }

        /**
         * <i>“Indicates whether or not the user can modify the device dock configuration on
         * the device.”</i>
         * 
         * @param microsoftLauncherDockPresenceAllowUserModification
         *            value of {@code microsoftLauncherDockPresenceAllowUserModification} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftLauncherDockPresenceAllowUserModification(Boolean microsoftLauncherDockPresenceAllowUserModification) {
            this.microsoftLauncherDockPresenceAllowUserModification = microsoftLauncherDockPresenceAllowUserModification;
            this.changedFields = changedFields.add("microsoftLauncherDockPresenceAllowUserModification");
            return this;
        }

        /**
         * <i>“Indicates the search bar placement configuration on the device.”</i>
         * 
         * @param microsoftLauncherSearchBarPlacementConfiguration
         *            value of {@code microsoftLauncherSearchBarPlacementConfiguration} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microsoftLauncherSearchBarPlacementConfiguration(MicrosoftLauncherSearchBarPlacement microsoftLauncherSearchBarPlacementConfiguration) {
            this.microsoftLauncherSearchBarPlacementConfiguration = microsoftLauncherSearchBarPlacementConfiguration;
            this.changedFields = changedFields.add("microsoftLauncherSearchBarPlacementConfiguration");
            return this;
        }

        /**
         * <i>“Indicates which enrollment profile you want to configure.”</i>
         * 
         * @param enrollmentProfile
         *            value of {@code enrollmentProfile} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enrollmentProfile(AndroidDeviceOwnerEnrollmentProfileType enrollmentProfile) {
            this.enrollmentProfile = enrollmentProfile;
            this.changedFields = changedFields.add("enrollmentProfile");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block a user from data roaming.”</i>
         * 
         * @param dataRoamingBlocked
         *            value of {@code dataRoamingBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dataRoamingBlocked(Boolean dataRoamingBlocked) {
            this.dataRoamingBlocked = dataRoamingBlocked;
            this.changedFields = changedFields.add("dataRoamingBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from manually changing the date or
         * time on the device”</i>
         * 
         * @param dateTimeConfigurationBlocked
         *            value of {@code dateTimeConfigurationBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder dateTimeConfigurationBlocked(Boolean dateTimeConfigurationBlocked) {
            this.dateTimeConfigurationBlocked = dateTimeConfigurationBlocked;
            this.changedFields = changedFields.add("dateTimeConfigurationBlocked");
            return this;
        }

        /**
         * <i>“List of Google account emails that will be required to authenticate after a
         * device is factory reset before it can be set up.”</i>
         * 
         * @param factoryResetDeviceAdministratorEmails
         *            value of {@code factoryResetDeviceAdministratorEmails} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder factoryResetDeviceAdministratorEmails(List<String> factoryResetDeviceAdministratorEmails) {
            this.factoryResetDeviceAdministratorEmails = factoryResetDeviceAdministratorEmails;
            this.changedFields = changedFields.add("factoryResetDeviceAdministratorEmails");
            return this;
        }

        /**
         * <i>“List of Google account emails that will be required to authenticate after a
         * device is factory reset before it can be set up.”</i>
         * 
         * @param factoryResetDeviceAdministratorEmails
         *            value of {@code factoryResetDeviceAdministratorEmails} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder factoryResetDeviceAdministratorEmails(String... factoryResetDeviceAdministratorEmails) {
            return factoryResetDeviceAdministratorEmails(Arrays.asList(factoryResetDeviceAdministratorEmails));
        }

        /**
         * <i>“List of Google account emails that will be required to authenticate after a
         * device is factory reset before it can be set up.”</i>
         * 
         * @param factoryResetDeviceAdministratorEmailsNextLink
         *            value of {@code factoryResetDeviceAdministratorEmails@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder factoryResetDeviceAdministratorEmailsNextLink(String factoryResetDeviceAdministratorEmailsNextLink) {
            this.factoryResetDeviceAdministratorEmailsNextLink = factoryResetDeviceAdministratorEmailsNextLink;
            this.changedFields = changedFields.add("factoryResetDeviceAdministratorEmails");
            return this;
        }

        /**
         * <i>“Indicates whether or not the factory reset option in settings is disabled.”</i>
         * 
         * @param factoryResetBlocked
         *            value of {@code factoryResetBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder factoryResetBlocked(Boolean factoryResetBlocked) {
            this.factoryResetBlocked = factoryResetBlocked;
            this.changedFields = changedFields.add("factoryResetBlocked");
            return this;
        }

        /**
         * <i>“Proxy is set up directly with host, port and excluded hosts.”</i>
         * 
         * @param globalProxy
         *            value of {@code globalProxy} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder globalProxy(AndroidDeviceOwnerGlobalProxy globalProxy) {
            this.globalProxy = globalProxy;
            this.changedFields = changedFields.add("globalProxy");
            return this;
        }

        /**
         * <i>“Indicates whether or not google accounts will be blocked.”</i>
         * 
         * @param googleAccountsBlocked
         *            value of {@code googleAccountsBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder googleAccountsBlocked(Boolean googleAccountsBlocked) {
            this.googleAccountsBlocked = googleAccountsBlocked;
            this.changedFields = changedFields.add("googleAccountsBlocked");
            return this;
        }

        /**
         * <i>“Whether or not to enable screen saver mode or not in Kiosk Mode.”</i>
         * 
         * @param kioskModeScreenSaverConfigurationEnabled
         *            value of {@code kioskModeScreenSaverConfigurationEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeScreenSaverConfigurationEnabled(Boolean kioskModeScreenSaverConfigurationEnabled) {
            this.kioskModeScreenSaverConfigurationEnabled = kioskModeScreenSaverConfigurationEnabled;
            this.changedFields = changedFields.add("kioskModeScreenSaverConfigurationEnabled");
            return this;
        }

        /**
         * <i>“URL for an image that will be the device's screen saver in Kiosk Mode.”</i>
         * 
         * @param kioskModeScreenSaverImageUrl
         *            value of {@code kioskModeScreenSaverImageUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeScreenSaverImageUrl(String kioskModeScreenSaverImageUrl) {
            this.kioskModeScreenSaverImageUrl = kioskModeScreenSaverImageUrl;
            this.changedFields = changedFields.add("kioskModeScreenSaverImageUrl");
            return this;
        }

        /**
         * <i>“The number of seconds that the device will display the screen saver for in Kiosk
         * Mode. Valid values 0 to 9999999”</i>
         * 
         * @param kioskModeScreenSaverDisplayTimeInSeconds
         *            value of {@code kioskModeScreenSaverDisplayTimeInSeconds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeScreenSaverDisplayTimeInSeconds(Integer kioskModeScreenSaverDisplayTimeInSeconds) {
            this.kioskModeScreenSaverDisplayTimeInSeconds = kioskModeScreenSaverDisplayTimeInSeconds;
            this.changedFields = changedFields.add("kioskModeScreenSaverDisplayTimeInSeconds");
            return this;
        }

        /**
         * <i>“The number of seconds the device needs to be inactive for before the screen
         * saver is shown in Kiosk Mode. Valid values 1 to 9999999”</i>
         * 
         * @param kioskModeScreenSaverStartDelayInSeconds
         *            value of {@code kioskModeScreenSaverStartDelayInSeconds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeScreenSaverStartDelayInSeconds(Integer kioskModeScreenSaverStartDelayInSeconds) {
            this.kioskModeScreenSaverStartDelayInSeconds = kioskModeScreenSaverStartDelayInSeconds;
            this.changedFields = changedFields.add("kioskModeScreenSaverStartDelayInSeconds");
            return this;
        }

        /**
         * <i>“Whether or not the device screen should show the screen saver if audio/video is
         * playing in Kiosk Mode.”</i>
         * 
         * @param kioskModeScreenSaverDetectMediaDisabled
         *            value of {@code kioskModeScreenSaverDetectMediaDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeScreenSaverDetectMediaDisabled(Boolean kioskModeScreenSaverDetectMediaDisabled) {
            this.kioskModeScreenSaverDetectMediaDisabled = kioskModeScreenSaverDetectMediaDisabled;
            this.changedFields = changedFields.add("kioskModeScreenSaverDetectMediaDisabled");
            return this;
        }

        /**
         * <i>“A list of managed apps that will be shown when the device is in Kiosk Mode. This
         * collection can contain a maximum of 500 elements.”</i>
         * 
         * @param kioskModeApps
         *            value of {@code kioskModeApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeApps(List<AppListItem> kioskModeApps) {
            this.kioskModeApps = kioskModeApps;
            this.changedFields = changedFields.add("kioskModeApps");
            return this;
        }

        /**
         * <i>“A list of managed apps that will be shown when the device is in Kiosk Mode. This
         * collection can contain a maximum of 500 elements.”</i>
         * 
         * @param kioskModeApps
         *            value of {@code kioskModeApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeApps(AppListItem... kioskModeApps) {
            return kioskModeApps(Arrays.asList(kioskModeApps));
        }

        /**
         * <i>“A list of managed apps that will be shown when the device is in Kiosk Mode. This
         * collection can contain a maximum of 500 elements.”</i>
         * 
         * @param kioskModeAppsNextLink
         *            value of {@code kioskModeApps@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeAppsNextLink(String kioskModeAppsNextLink) {
            this.kioskModeAppsNextLink = kioskModeAppsNextLink;
            this.changedFields = changedFields.add("kioskModeApps");
            return this;
        }

        /**
         * <i>“URL to a publicly accessible image to use for the wallpaper when the device is
         * in Kiosk Mode.”</i>
         * 
         * @param kioskModeWallpaperUrl
         *            value of {@code kioskModeWallpaperUrl} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeWallpaperUrl(String kioskModeWallpaperUrl) {
            this.kioskModeWallpaperUrl = kioskModeWallpaperUrl;
            this.changedFields = changedFields.add("kioskModeWallpaperUrl");
            return this;
        }

        /**
         * <i>“Exit code to allow a user to escape from Kiosk Mode when the device is in Kiosk
         * Mode.”</i>
         * 
         * @param kioskModeExitCode
         *            value of {@code kioskModeExitCode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeExitCode(String kioskModeExitCode) {
            this.kioskModeExitCode = kioskModeExitCode;
            this.changedFields = changedFields.add("kioskModeExitCode");
            return this;
        }

        /**
         * <i>“Whether or not to display a virtual home button when the device is in Kiosk Mode
         * .”</i>
         * 
         * @param kioskModeVirtualHomeButtonEnabled
         *            value of {@code kioskModeVirtualHomeButtonEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeVirtualHomeButtonEnabled(Boolean kioskModeVirtualHomeButtonEnabled) {
            this.kioskModeVirtualHomeButtonEnabled = kioskModeVirtualHomeButtonEnabled;
            this.changedFields = changedFields.add("kioskModeVirtualHomeButtonEnabled");
            return this;
        }

        /**
         * <i>“Indicates whether the virtual home button is a swipe up home button or a
         * floating home button.”</i>
         * 
         * @param kioskModeVirtualHomeButtonType
         *            value of {@code kioskModeVirtualHomeButtonType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeVirtualHomeButtonType(AndroidDeviceOwnerVirtualHomeButtonType kioskModeVirtualHomeButtonType) {
            this.kioskModeVirtualHomeButtonType = kioskModeVirtualHomeButtonType;
            this.changedFields = changedFields.add("kioskModeVirtualHomeButtonType");
            return this;
        }

        /**
         * <i>“Whether or not to allow a user to configure Bluetooth settings in Kiosk Mode.”</i>
         * 
         * @param kioskModeBluetoothConfigurationEnabled
         *            value of {@code kioskModeBluetoothConfigurationEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeBluetoothConfigurationEnabled(Boolean kioskModeBluetoothConfigurationEnabled) {
            this.kioskModeBluetoothConfigurationEnabled = kioskModeBluetoothConfigurationEnabled;
            this.changedFields = changedFields.add("kioskModeBluetoothConfigurationEnabled");
            return this;
        }

        /**
         * <i>“Whether or not to allow a user to configure Wi-Fi settings in Kiosk Mode.”</i>
         * 
         * @param kioskModeWiFiConfigurationEnabled
         *            value of {@code kioskModeWiFiConfigurationEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeWiFiConfigurationEnabled(Boolean kioskModeWiFiConfigurationEnabled) {
            this.kioskModeWiFiConfigurationEnabled = kioskModeWiFiConfigurationEnabled;
            this.changedFields = changedFields.add("kioskModeWiFiConfigurationEnabled");
            return this;
        }

        /**
         * <i>“Whether or not to allow a user to use the flashlight in Kiosk Mode.”</i>
         * 
         * @param kioskModeFlashlightConfigurationEnabled
         *            value of {@code kioskModeFlashlightConfigurationEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeFlashlightConfigurationEnabled(Boolean kioskModeFlashlightConfigurationEnabled) {
            this.kioskModeFlashlightConfigurationEnabled = kioskModeFlashlightConfigurationEnabled;
            this.changedFields = changedFields.add("kioskModeFlashlightConfigurationEnabled");
            return this;
        }

        /**
         * <i>“Whether or not to allow a user to change the media volume in Kiosk Mode.”</i>
         * 
         * @param kioskModeMediaVolumeConfigurationEnabled
         *            value of {@code kioskModeMediaVolumeConfigurationEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeMediaVolumeConfigurationEnabled(Boolean kioskModeMediaVolumeConfigurationEnabled) {
            this.kioskModeMediaVolumeConfigurationEnabled = kioskModeMediaVolumeConfigurationEnabled;
            this.changedFields = changedFields.add("kioskModeMediaVolumeConfigurationEnabled");
            return this;
        }

        /**
         * <i>“Whether or not to allow a user to access basic device information.”</i>
         * 
         * @param kioskModeShowDeviceInfo
         *            value of {@code kioskModeShowDeviceInfo} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeShowDeviceInfo(Boolean kioskModeShowDeviceInfo) {
            this.kioskModeShowDeviceInfo = kioskModeShowDeviceInfo;
            this.changedFields = changedFields.add("kioskModeShowDeviceInfo");
            return this;
        }

        /**
         * <i>“Whether or not to display the Managed Settings entry point on the managed home
         * screen in Kiosk Mode.”</i>
         * 
         * @param kioskModeManagedSettingsEntryDisabled
         *            value of {@code kioskModeManagedSettingsEntryDisabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeManagedSettingsEntryDisabled(Boolean kioskModeManagedSettingsEntryDisabled) {
            this.kioskModeManagedSettingsEntryDisabled = kioskModeManagedSettingsEntryDisabled;
            this.changedFields = changedFields.add("kioskModeManagedSettingsEntryDisabled");
            return this;
        }

        /**
         * <i>“Whether or not to allow a user to easy access to the debug menu in Kiosk Mode.”</i>
         * 
         * @param kioskModeDebugMenuEasyAccessEnabled
         *            value of {@code kioskModeDebugMenuEasyAccessEnabled} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeDebugMenuEasyAccessEnabled(Boolean kioskModeDebugMenuEasyAccessEnabled) {
            this.kioskModeDebugMenuEasyAccessEnabled = kioskModeDebugMenuEasyAccessEnabled;
            this.changedFields = changedFields.add("kioskModeDebugMenuEasyAccessEnabled");
            return this;
        }

        /**
         * <i>“Whether or not to display application notification badges in Kiosk Mode.”</i>
         * 
         * @param kioskModeShowAppNotificationBadge
         *            value of {@code kioskModeShowAppNotificationBadge} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeShowAppNotificationBadge(Boolean kioskModeShowAppNotificationBadge) {
            this.kioskModeShowAppNotificationBadge = kioskModeShowAppNotificationBadge;
            this.changedFields = changedFields.add("kioskModeShowAppNotificationBadge");
            return this;
        }

        /**
         * <i>“Screen orientation configuration for managed home screen in Kiosk Mode.”</i>
         * 
         * @param kioskModeScreenOrientation
         *            value of {@code kioskModeScreenOrientation} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeScreenOrientation(AndroidDeviceOwnerKioskModeScreenOrientation kioskModeScreenOrientation) {
            this.kioskModeScreenOrientation = kioskModeScreenOrientation;
            this.changedFields = changedFields.add("kioskModeScreenOrientation");
            return this;
        }

        /**
         * <i>“Icon size configuration for managed home screen in Kiosk Mode.”</i>
         * 
         * @param kioskModeIconSize
         *            value of {@code kioskModeIconSize} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeIconSize(AndroidDeviceOwnerKioskModeIconSize kioskModeIconSize) {
            this.kioskModeIconSize = kioskModeIconSize;
            this.changedFields = changedFields.add("kioskModeIconSize");
            return this;
        }

        /**
         * <i>“Folder icon configuration for managed home screen in Kiosk Mode.”</i>
         * 
         * @param kioskModeFolderIcon
         *            value of {@code kioskModeFolderIcon} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeFolderIcon(AndroidDeviceOwnerKioskModeFolderIcon kioskModeFolderIcon) {
            this.kioskModeFolderIcon = kioskModeFolderIcon;
            this.changedFields = changedFields.add("kioskModeFolderIcon");
            return this;
        }

        /**
         * <i>“The restricted set of WIFI SSIDs available for the user to configure in Kiosk
         * Mode. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param kioskModeWifiAllowedSsids
         *            value of {@code kioskModeWifiAllowedSsids} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeWifiAllowedSsids(List<String> kioskModeWifiAllowedSsids) {
            this.kioskModeWifiAllowedSsids = kioskModeWifiAllowedSsids;
            this.changedFields = changedFields.add("kioskModeWifiAllowedSsids");
            return this;
        }

        /**
         * <i>“The restricted set of WIFI SSIDs available for the user to configure in Kiosk
         * Mode. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param kioskModeWifiAllowedSsids
         *            value of {@code kioskModeWifiAllowedSsids} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeWifiAllowedSsids(String... kioskModeWifiAllowedSsids) {
            return kioskModeWifiAllowedSsids(Arrays.asList(kioskModeWifiAllowedSsids));
        }

        /**
         * <i>“The restricted set of WIFI SSIDs available for the user to configure in Kiosk
         * Mode. This collection can contain a maximum of 500 elements.”</i>
         * 
         * @param kioskModeWifiAllowedSsidsNextLink
         *            value of {@code kioskModeWifiAllowedSsids@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder kioskModeWifiAllowedSsidsNextLink(String kioskModeWifiAllowedSsidsNextLink) {
            this.kioskModeWifiAllowedSsidsNextLink = kioskModeWifiAllowedSsidsNextLink;
            this.changedFields = changedFields.add("kioskModeWifiAllowedSsids");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block unmuting the microphone on the device.”</i>
         * 
         * @param microphoneForceMute
         *            value of {@code microphoneForceMute} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder microphoneForceMute(Boolean microphoneForceMute) {
            this.microphoneForceMute = microphoneForceMute;
            this.changedFields = changedFields.add("microphoneForceMute");
            return this;
        }

        /**
         * <i>“Indicates whether or not the device will allow connecting to a temporary network
         * connection at boot time.”</i>
         * 
         * @param networkEscapeHatchAllowed
         *            value of {@code networkEscapeHatchAllowed} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder networkEscapeHatchAllowed(Boolean networkEscapeHatchAllowed) {
            this.networkEscapeHatchAllowed = networkEscapeHatchAllowed;
            this.changedFields = changedFields.add("networkEscapeHatchAllowed");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block NFC outgoing beam.”</i>
         * 
         * @param nfcBlockOutgoingBeam
         *            value of {@code nfcBlockOutgoingBeam} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder nfcBlockOutgoingBeam(Boolean nfcBlockOutgoingBeam) {
            this.nfcBlockOutgoingBeam = nfcBlockOutgoingBeam;
            this.changedFields = changedFields.add("nfcBlockOutgoingBeam");
            return this;
        }

        /**
         * <i>“Indicates whether or not the keyguard is disabled.”</i>
         * 
         * @param passwordBlockKeyguard
         *            value of {@code passwordBlockKeyguard} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordBlockKeyguard(Boolean passwordBlockKeyguard) {
            this.passwordBlockKeyguard = passwordBlockKeyguard;
            this.changedFields = changedFields.add("passwordBlockKeyguard");
            return this;
        }

        /**
         * <i>“List of device keyguard features to block. This collection can contain a maximum
         * of 7 elements.”</i>
         * 
         * @param passwordBlockKeyguardFeatures
         *            value of {@code passwordBlockKeyguardFeatures} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordBlockKeyguardFeatures(List<AndroidKeyguardFeature> passwordBlockKeyguardFeatures) {
            this.passwordBlockKeyguardFeatures = passwordBlockKeyguardFeatures;
            this.changedFields = changedFields.add("passwordBlockKeyguardFeatures");
            return this;
        }

        /**
         * <i>“List of device keyguard features to block. This collection can contain a maximum
         * of 7 elements.”</i>
         * 
         * @param passwordBlockKeyguardFeatures
         *            value of {@code passwordBlockKeyguardFeatures} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordBlockKeyguardFeatures(AndroidKeyguardFeature... passwordBlockKeyguardFeatures) {
            return passwordBlockKeyguardFeatures(Arrays.asList(passwordBlockKeyguardFeatures));
        }

        /**
         * <i>“List of device keyguard features to block. This collection can contain a maximum
         * of 7 elements.”</i>
         * 
         * @param passwordBlockKeyguardFeaturesNextLink
         *            value of {@code passwordBlockKeyguardFeatures@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordBlockKeyguardFeaturesNextLink(String passwordBlockKeyguardFeaturesNextLink) {
            this.passwordBlockKeyguardFeaturesNextLink = passwordBlockKeyguardFeaturesNextLink;
            this.changedFields = changedFields.add("passwordBlockKeyguardFeatures");
            return this;
        }

        /**
         * <i>“Indicates the amount of time in seconds that a password can be set for before it
         * expires and a new password will be required. Valid values 1 to 365”</i>
         * 
         * @param passwordExpirationDays
         *            value of {@code passwordExpirationDays} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordExpirationDays(Integer passwordExpirationDays) {
            this.passwordExpirationDays = passwordExpirationDays;
            this.changedFields = changedFields.add("passwordExpirationDays");
            return this;
        }

        /**
         * <i>“Indicates the minimum length of the password required on the device. Valid
         * values 4 to 16”</i>
         * 
         * @param passwordMinimumLength
         *            value of {@code passwordMinimumLength} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumLength(Integer passwordMinimumLength) {
            this.passwordMinimumLength = passwordMinimumLength;
            this.changedFields = changedFields.add("passwordMinimumLength");
            return this;
        }

        /**
         * <i>“Indicates the minimum number of letter characters required for device password.
         * Valid values 1 to 16”</i>
         * 
         * @param passwordMinimumLetterCharacters
         *            value of {@code passwordMinimumLetterCharacters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumLetterCharacters(Integer passwordMinimumLetterCharacters) {
            this.passwordMinimumLetterCharacters = passwordMinimumLetterCharacters;
            this.changedFields = changedFields.add("passwordMinimumLetterCharacters");
            return this;
        }

        /**
         * <i>“Indicates the minimum number of lower case characters required for device
         * password. Valid values 1 to 16”</i>
         * 
         * @param passwordMinimumLowerCaseCharacters
         *            value of {@code passwordMinimumLowerCaseCharacters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumLowerCaseCharacters(Integer passwordMinimumLowerCaseCharacters) {
            this.passwordMinimumLowerCaseCharacters = passwordMinimumLowerCaseCharacters;
            this.changedFields = changedFields.add("passwordMinimumLowerCaseCharacters");
            return this;
        }

        /**
         * <i>“Indicates the minimum number of non-letter characters required for device
         * password. Valid values 1 to 16”</i>
         * 
         * @param passwordMinimumNonLetterCharacters
         *            value of {@code passwordMinimumNonLetterCharacters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumNonLetterCharacters(Integer passwordMinimumNonLetterCharacters) {
            this.passwordMinimumNonLetterCharacters = passwordMinimumNonLetterCharacters;
            this.changedFields = changedFields.add("passwordMinimumNonLetterCharacters");
            return this;
        }

        /**
         * <i>“Indicates the minimum number of numeric characters required for device password.
         * Valid values 1 to 16”</i>
         * 
         * @param passwordMinimumNumericCharacters
         *            value of {@code passwordMinimumNumericCharacters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumNumericCharacters(Integer passwordMinimumNumericCharacters) {
            this.passwordMinimumNumericCharacters = passwordMinimumNumericCharacters;
            this.changedFields = changedFields.add("passwordMinimumNumericCharacters");
            return this;
        }

        /**
         * <i>“Indicates the minimum number of symbol characters required for device password.
         * Valid values 1 to 16”</i>
         * 
         * @param passwordMinimumSymbolCharacters
         *            value of {@code passwordMinimumSymbolCharacters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumSymbolCharacters(Integer passwordMinimumSymbolCharacters) {
            this.passwordMinimumSymbolCharacters = passwordMinimumSymbolCharacters;
            this.changedFields = changedFields.add("passwordMinimumSymbolCharacters");
            return this;
        }

        /**
         * <i>“Indicates the minimum number of upper caseletter characters required for device
         * password. Valid values 1 to 16”</i>
         * 
         * @param passwordMinimumUpperCaseCharacters
         *            value of {@code passwordMinimumUpperCaseCharacters} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinimumUpperCaseCharacters(Integer passwordMinimumUpperCaseCharacters) {
            this.passwordMinimumUpperCaseCharacters = passwordMinimumUpperCaseCharacters;
            this.changedFields = changedFields.add("passwordMinimumUpperCaseCharacters");
            return this;
        }

        /**
         * <i>“Milliseconds of inactivity before the screen times out.”</i>
         * 
         * @param passwordMinutesOfInactivityBeforeScreenTimeout
         *            value of {@code passwordMinutesOfInactivityBeforeScreenTimeout} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordMinutesOfInactivityBeforeScreenTimeout(Integer passwordMinutesOfInactivityBeforeScreenTimeout) {
            this.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
            this.changedFields = changedFields.add("passwordMinutesOfInactivityBeforeScreenTimeout");
            return this;
        }

        /**
         * <i>“Indicates the length of password history, where the user will not be able to
         * enter a new password that is the same as any password in the history. Valid
         * values 0 to 24”</i>
         * 
         * @param passwordPreviousPasswordCountToBlock
         *            value of {@code passwordPreviousPasswordCountToBlock} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordPreviousPasswordCountToBlock(Integer passwordPreviousPasswordCountToBlock) {
            this.passwordPreviousPasswordCountToBlock = passwordPreviousPasswordCountToBlock;
            this.changedFields = changedFields.add("passwordPreviousPasswordCountToBlock");
            return this;
        }

        /**
         * <i>“Indicates the minimum password quality required on the device.”</i>
         * 
         * @param passwordRequiredType
         *            value of {@code passwordRequiredType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordRequiredType(AndroidDeviceOwnerRequiredPasswordType passwordRequiredType) {
            this.passwordRequiredType = passwordRequiredType;
            this.changedFields = changedFields.add("passwordRequiredType");
            return this;
        }

        /**
         * <i>“Indicates the number of times a user can enter an incorrect password before the
         * device is wiped. Valid values 4 to 11”</i>
         * 
         * @param passwordSignInFailureCountBeforeFactoryReset
         *            value of {@code passwordSignInFailureCountBeforeFactoryReset} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder passwordSignInFailureCountBeforeFactoryReset(Integer passwordSignInFailureCountBeforeFactoryReset) {
            this.passwordSignInFailureCountBeforeFactoryReset = passwordSignInFailureCountBeforeFactoryReset;
            this.changedFields = changedFields.add("passwordSignInFailureCountBeforeFactoryReset");
            return this;
        }

        /**
         * <i>“Indicates the Play Store mode of the device.”</i>
         * 
         * @param playStoreMode
         *            value of {@code playStoreMode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder playStoreMode(AndroidDeviceOwnerPlayStoreMode playStoreMode) {
            this.playStoreMode = playStoreMode;
            this.changedFields = changedFields.add("playStoreMode");
            return this;
        }

        /**
         * <i>“Indicates whether or not rebooting the device into safe boot is disabled.”</i>
         * 
         * @param safeBootBlocked
         *            value of {@code safeBootBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder safeBootBlocked(Boolean safeBootBlocked) {
            this.safeBootBlocked = safeBootBlocked;
            this.changedFields = changedFields.add("safeBootBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to disable the capability to take screenshots.”</i>
         * 
         * @param screenCaptureBlocked
         *            value of {@code screenCaptureBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder screenCaptureBlocked(Boolean screenCaptureBlocked) {
            this.screenCaptureBlocked = screenCaptureBlocked;
            this.changedFields = changedFields.add("screenCaptureBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from enabling debugging features on
         * the device.”</i>
         * 
         * @param securityAllowDebuggingFeatures
         *            value of {@code securityAllowDebuggingFeatures} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder securityAllowDebuggingFeatures(Boolean securityAllowDebuggingFeatures) {
            this.securityAllowDebuggingFeatures = securityAllowDebuggingFeatures;
            this.changedFields = changedFields.add("securityAllowDebuggingFeatures");
            return this;
        }

        /**
         * <i>“Indicates whether or not verify apps is required.”</i>
         * 
         * @param securityRequireVerifyApps
         *            value of {@code securityRequireVerifyApps} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder securityRequireVerifyApps(Boolean securityRequireVerifyApps) {
            this.securityRequireVerifyApps = securityRequireVerifyApps;
            this.changedFields = changedFields.add("securityRequireVerifyApps");
            return this;
        }

        /**
         * <i>“Indicates whether or the status bar is disabled, including notifications, quick
         * settings and other screen overlays.”</i>
         * 
         * @param statusBarBlocked
         *            value of {@code statusBarBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder statusBarBlocked(Boolean statusBarBlocked) {
            this.statusBarBlocked = statusBarBlocked;
            this.changedFields = changedFields.add("statusBarBlocked");
            return this;
        }

        /**
         * <i>“List of modes in which the device's display will stay powered-on. This
         * collection can contain a maximum of 4 elements.”</i>
         * 
         * @param stayOnModes
         *            value of {@code stayOnModes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder stayOnModes(List<AndroidDeviceOwnerBatteryPluggedMode> stayOnModes) {
            this.stayOnModes = stayOnModes;
            this.changedFields = changedFields.add("stayOnModes");
            return this;
        }

        /**
         * <i>“List of modes in which the device's display will stay powered-on. This
         * collection can contain a maximum of 4 elements.”</i>
         * 
         * @param stayOnModes
         *            value of {@code stayOnModes} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder stayOnModes(AndroidDeviceOwnerBatteryPluggedMode... stayOnModes) {
            return stayOnModes(Arrays.asList(stayOnModes));
        }

        /**
         * <i>“List of modes in which the device's display will stay powered-on. This
         * collection can contain a maximum of 4 elements.”</i>
         * 
         * @param stayOnModesNextLink
         *            value of {@code stayOnModes@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder stayOnModesNextLink(String stayOnModesNextLink) {
            this.stayOnModesNextLink = stayOnModesNextLink;
            this.changedFields = changedFields.add("stayOnModes");
            return this;
        }

        /**
         * <i>“Indicates whether or not to allow USB mass storage.”</i>
         * 
         * @param storageAllowUsb
         *            value of {@code storageAllowUsb} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder storageAllowUsb(Boolean storageAllowUsb) {
            this.storageAllowUsb = storageAllowUsb;
            this.changedFields = changedFields.add("storageAllowUsb");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block external media.”</i>
         * 
         * @param storageBlockExternalMedia
         *            value of {@code storageBlockExternalMedia} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder storageBlockExternalMedia(Boolean storageBlockExternalMedia) {
            this.storageBlockExternalMedia = storageBlockExternalMedia;
            this.changedFields = changedFields.add("storageBlockExternalMedia");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block USB file transfer.”</i>
         * 
         * @param storageBlockUsbFileTransfer
         *            value of {@code storageBlockUsbFileTransfer} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder storageBlockUsbFileTransfer(Boolean storageBlockUsbFileTransfer) {
            this.storageBlockUsbFileTransfer = storageBlockUsbFileTransfer;
            this.changedFields = changedFields.add("storageBlockUsbFileTransfer");
            return this;
        }

        /**
         * <i>“Indicates the number of minutes after midnight that the system update window
         * starts. Valid values 0 to 1440”</i>
         * 
         * @param systemUpdateWindowStartMinutesAfterMidnight
         *            value of {@code systemUpdateWindowStartMinutesAfterMidnight} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder systemUpdateWindowStartMinutesAfterMidnight(Integer systemUpdateWindowStartMinutesAfterMidnight) {
            this.systemUpdateWindowStartMinutesAfterMidnight = systemUpdateWindowStartMinutesAfterMidnight;
            this.changedFields = changedFields.add("systemUpdateWindowStartMinutesAfterMidnight");
            return this;
        }

        /**
         * <i>“Indicates the number of minutes after midnight that the system update window
         * ends. Valid values 0 to 1440”</i>
         * 
         * @param systemUpdateWindowEndMinutesAfterMidnight
         *            value of {@code systemUpdateWindowEndMinutesAfterMidnight} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder systemUpdateWindowEndMinutesAfterMidnight(Integer systemUpdateWindowEndMinutesAfterMidnight) {
            this.systemUpdateWindowEndMinutesAfterMidnight = systemUpdateWindowEndMinutesAfterMidnight;
            this.changedFields = changedFields.add("systemUpdateWindowEndMinutesAfterMidnight");
            return this;
        }

        /**
         * <i>“The type of system update configuration.”</i>
         * 
         * @param systemUpdateInstallType
         *            value of {@code systemUpdateInstallType} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder systemUpdateInstallType(AndroidDeviceOwnerSystemUpdateInstallType systemUpdateInstallType) {
            this.systemUpdateInstallType = systemUpdateInstallType;
            this.changedFields = changedFields.add("systemUpdateInstallType");
            return this;
        }

        /**
         * <i>“Whether or not to block Android system prompt windows, like toasts, phone
         * activities, and system alerts.”</i>
         * 
         * @param systemWindowsBlocked
         *            value of {@code systemWindowsBlocked} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder systemWindowsBlocked(Boolean systemWindowsBlocked) {
            this.systemWindowsBlocked = systemWindowsBlocked;
            this.changedFields = changedFields.add("systemWindowsBlocked");
            return this;
        }

        /**
         * <i>“Indicates whether or not adding users and profiles is disabled.”</i>
         * 
         * @param usersBlockAdd
         *            value of {@code usersBlockAdd} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder usersBlockAdd(Boolean usersBlockAdd) {
            this.usersBlockAdd = usersBlockAdd;
            this.changedFields = changedFields.add("usersBlockAdd");
            return this;
        }

        /**
         * <i>“Indicates whether or not to disable removing other users from the device.”</i>
         * 
         * @param usersBlockRemove
         *            value of {@code usersBlockRemove} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder usersBlockRemove(Boolean usersBlockRemove) {
            this.usersBlockRemove = usersBlockRemove;
            this.changedFields = changedFields.add("usersBlockRemove");
            return this;
        }

        /**
         * <i>“Indicates whether or not adjusting the master volume is disabled.”</i>
         * 
         * @param volumeBlockAdjustment
         *            value of {@code volumeBlockAdjustment} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder volumeBlockAdjustment(Boolean volumeBlockAdjustment) {
            this.volumeBlockAdjustment = volumeBlockAdjustment;
            this.changedFields = changedFields.add("volumeBlockAdjustment");
            return this;
        }

        /**
         * <i>“If an always on VPN package name is specified, whether or not to lock network
         * traffic when that VPN is disconnected.”</i>
         * 
         * @param vpnAlwaysOnLockdownMode
         *            value of {@code vpnAlwaysOnLockdownMode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder vpnAlwaysOnLockdownMode(Boolean vpnAlwaysOnLockdownMode) {
            this.vpnAlwaysOnLockdownMode = vpnAlwaysOnLockdownMode;
            this.changedFields = changedFields.add("vpnAlwaysOnLockdownMode");
            return this;
        }

        /**
         * <i>“Android app package name for app that will handle an always-on VPN connection.”</i>
         * 
         * @param vpnAlwaysOnPackageIdentifier
         *            value of {@code vpnAlwaysOnPackageIdentifier} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder vpnAlwaysOnPackageIdentifier(String vpnAlwaysOnPackageIdentifier) {
            this.vpnAlwaysOnPackageIdentifier = vpnAlwaysOnPackageIdentifier;
            this.changedFields = changedFields.add("vpnAlwaysOnPackageIdentifier");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from editing the wifi connection
         * settings.”</i>
         * 
         * @param wifiBlockEditConfigurations
         *            value of {@code wifiBlockEditConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wifiBlockEditConfigurations(Boolean wifiBlockEditConfigurations) {
            this.wifiBlockEditConfigurations = wifiBlockEditConfigurations;
            this.changedFields = changedFields.add("wifiBlockEditConfigurations");
            return this;
        }

        /**
         * <i>“Indicates whether or not to block the user from editing just the networks
         * defined by the policy.”</i>
         * 
         * @param wifiBlockEditPolicyDefinedConfigurations
         *            value of {@code wifiBlockEditPolicyDefinedConfigurations} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder wifiBlockEditPolicyDefinedConfigurations(Boolean wifiBlockEditPolicyDefinedConfigurations) {
            this.wifiBlockEditPolicyDefinedConfigurations = wifiBlockEditPolicyDefinedConfigurations;
            this.changedFields = changedFields.add("wifiBlockEditPolicyDefinedConfigurations");
            return this;
        }

        public AndroidDeviceOwnerGeneralDeviceConfiguration build() {
            AndroidDeviceOwnerGeneralDeviceConfiguration _x = new AndroidDeviceOwnerGeneralDeviceConfiguration();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration";
            _x.id = id;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            _x.supportsScopeTags = supportsScopeTags;
            _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
            _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
            _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.version = version;
            _x.accountsBlockModification = accountsBlockModification;
            _x.appsAllowInstallFromUnknownSources = appsAllowInstallFromUnknownSources;
            _x.appsAutoUpdatePolicy = appsAutoUpdatePolicy;
            _x.appsDefaultPermissionPolicy = appsDefaultPermissionPolicy;
            _x.appsRecommendSkippingFirstUseHints = appsRecommendSkippingFirstUseHints;
            _x.bluetoothBlockConfiguration = bluetoothBlockConfiguration;
            _x.bluetoothBlockContactSharing = bluetoothBlockContactSharing;
            _x.cameraBlocked = cameraBlocked;
            _x.cellularBlockWiFiTethering = cellularBlockWiFiTethering;
            _x.certificateCredentialConfigurationDisabled = certificateCredentialConfigurationDisabled;
            _x.microsoftLauncherConfigurationEnabled = microsoftLauncherConfigurationEnabled;
            _x.microsoftLauncherCustomWallpaperEnabled = microsoftLauncherCustomWallpaperEnabled;
            _x.microsoftLauncherCustomWallpaperImageUrl = microsoftLauncherCustomWallpaperImageUrl;
            _x.microsoftLauncherCustomWallpaperAllowUserModification = microsoftLauncherCustomWallpaperAllowUserModification;
            _x.microsoftLauncherFeedEnabled = microsoftLauncherFeedEnabled;
            _x.microsoftLauncherFeedAllowUserModification = microsoftLauncherFeedAllowUserModification;
            _x.microsoftLauncherDockPresenceConfiguration = microsoftLauncherDockPresenceConfiguration;
            _x.microsoftLauncherDockPresenceAllowUserModification = microsoftLauncherDockPresenceAllowUserModification;
            _x.microsoftLauncherSearchBarPlacementConfiguration = microsoftLauncherSearchBarPlacementConfiguration;
            _x.enrollmentProfile = enrollmentProfile;
            _x.dataRoamingBlocked = dataRoamingBlocked;
            _x.dateTimeConfigurationBlocked = dateTimeConfigurationBlocked;
            _x.factoryResetDeviceAdministratorEmails = factoryResetDeviceAdministratorEmails;
            _x.factoryResetDeviceAdministratorEmailsNextLink = factoryResetDeviceAdministratorEmailsNextLink;
            _x.factoryResetBlocked = factoryResetBlocked;
            _x.globalProxy = globalProxy;
            _x.googleAccountsBlocked = googleAccountsBlocked;
            _x.kioskModeScreenSaverConfigurationEnabled = kioskModeScreenSaverConfigurationEnabled;
            _x.kioskModeScreenSaverImageUrl = kioskModeScreenSaverImageUrl;
            _x.kioskModeScreenSaverDisplayTimeInSeconds = kioskModeScreenSaverDisplayTimeInSeconds;
            _x.kioskModeScreenSaverStartDelayInSeconds = kioskModeScreenSaverStartDelayInSeconds;
            _x.kioskModeScreenSaverDetectMediaDisabled = kioskModeScreenSaverDetectMediaDisabled;
            _x.kioskModeApps = kioskModeApps;
            _x.kioskModeAppsNextLink = kioskModeAppsNextLink;
            _x.kioskModeWallpaperUrl = kioskModeWallpaperUrl;
            _x.kioskModeExitCode = kioskModeExitCode;
            _x.kioskModeVirtualHomeButtonEnabled = kioskModeVirtualHomeButtonEnabled;
            _x.kioskModeVirtualHomeButtonType = kioskModeVirtualHomeButtonType;
            _x.kioskModeBluetoothConfigurationEnabled = kioskModeBluetoothConfigurationEnabled;
            _x.kioskModeWiFiConfigurationEnabled = kioskModeWiFiConfigurationEnabled;
            _x.kioskModeFlashlightConfigurationEnabled = kioskModeFlashlightConfigurationEnabled;
            _x.kioskModeMediaVolumeConfigurationEnabled = kioskModeMediaVolumeConfigurationEnabled;
            _x.kioskModeShowDeviceInfo = kioskModeShowDeviceInfo;
            _x.kioskModeManagedSettingsEntryDisabled = kioskModeManagedSettingsEntryDisabled;
            _x.kioskModeDebugMenuEasyAccessEnabled = kioskModeDebugMenuEasyAccessEnabled;
            _x.kioskModeShowAppNotificationBadge = kioskModeShowAppNotificationBadge;
            _x.kioskModeScreenOrientation = kioskModeScreenOrientation;
            _x.kioskModeIconSize = kioskModeIconSize;
            _x.kioskModeFolderIcon = kioskModeFolderIcon;
            _x.kioskModeWifiAllowedSsids = kioskModeWifiAllowedSsids;
            _x.kioskModeWifiAllowedSsidsNextLink = kioskModeWifiAllowedSsidsNextLink;
            _x.microphoneForceMute = microphoneForceMute;
            _x.networkEscapeHatchAllowed = networkEscapeHatchAllowed;
            _x.nfcBlockOutgoingBeam = nfcBlockOutgoingBeam;
            _x.passwordBlockKeyguard = passwordBlockKeyguard;
            _x.passwordBlockKeyguardFeatures = passwordBlockKeyguardFeatures;
            _x.passwordBlockKeyguardFeaturesNextLink = passwordBlockKeyguardFeaturesNextLink;
            _x.passwordExpirationDays = passwordExpirationDays;
            _x.passwordMinimumLength = passwordMinimumLength;
            _x.passwordMinimumLetterCharacters = passwordMinimumLetterCharacters;
            _x.passwordMinimumLowerCaseCharacters = passwordMinimumLowerCaseCharacters;
            _x.passwordMinimumNonLetterCharacters = passwordMinimumNonLetterCharacters;
            _x.passwordMinimumNumericCharacters = passwordMinimumNumericCharacters;
            _x.passwordMinimumSymbolCharacters = passwordMinimumSymbolCharacters;
            _x.passwordMinimumUpperCaseCharacters = passwordMinimumUpperCaseCharacters;
            _x.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
            _x.passwordPreviousPasswordCountToBlock = passwordPreviousPasswordCountToBlock;
            _x.passwordRequiredType = passwordRequiredType;
            _x.passwordSignInFailureCountBeforeFactoryReset = passwordSignInFailureCountBeforeFactoryReset;
            _x.playStoreMode = playStoreMode;
            _x.safeBootBlocked = safeBootBlocked;
            _x.screenCaptureBlocked = screenCaptureBlocked;
            _x.securityAllowDebuggingFeatures = securityAllowDebuggingFeatures;
            _x.securityRequireVerifyApps = securityRequireVerifyApps;
            _x.statusBarBlocked = statusBarBlocked;
            _x.stayOnModes = stayOnModes;
            _x.stayOnModesNextLink = stayOnModesNextLink;
            _x.storageAllowUsb = storageAllowUsb;
            _x.storageBlockExternalMedia = storageBlockExternalMedia;
            _x.storageBlockUsbFileTransfer = storageBlockUsbFileTransfer;
            _x.systemUpdateWindowStartMinutesAfterMidnight = systemUpdateWindowStartMinutesAfterMidnight;
            _x.systemUpdateWindowEndMinutesAfterMidnight = systemUpdateWindowEndMinutesAfterMidnight;
            _x.systemUpdateInstallType = systemUpdateInstallType;
            _x.systemWindowsBlocked = systemWindowsBlocked;
            _x.usersBlockAdd = usersBlockAdd;
            _x.usersBlockRemove = usersBlockRemove;
            _x.volumeBlockAdjustment = volumeBlockAdjustment;
            _x.vpnAlwaysOnLockdownMode = vpnAlwaysOnLockdownMode;
            _x.vpnAlwaysOnPackageIdentifier = vpnAlwaysOnPackageIdentifier;
            _x.wifiBlockEditConfigurations = wifiBlockEditConfigurations;
            _x.wifiBlockEditPolicyDefinedConfigurations = wifiBlockEditPolicyDefinedConfigurations;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Indicates whether or not adding or removing accounts is disabled.”</i>
     * 
     * @return property accountsBlockModification
     */
    @Property(name="accountsBlockModification")
    @JsonIgnore
    public Optional<Boolean> getAccountsBlockModification() {
        return Optional.ofNullable(accountsBlockModification);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * accountsBlockModification} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not adding or removing accounts is disabled.”</i>
     * 
     * @param accountsBlockModification
     *            new value of {@code accountsBlockModification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code accountsBlockModification} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withAccountsBlockModification(Boolean accountsBlockModification) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("accountsBlockModification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.accountsBlockModification = accountsBlockModification;
        return _x;
    }

    /**
     * <i>“Indicates whether or not the user is allowed to enable to unknown sources
     * setting.”</i>
     * 
     * @return property appsAllowInstallFromUnknownSources
     */
    @Property(name="appsAllowInstallFromUnknownSources")
    @JsonIgnore
    public Optional<Boolean> getAppsAllowInstallFromUnknownSources() {
        return Optional.ofNullable(appsAllowInstallFromUnknownSources);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appsAllowInstallFromUnknownSources} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not the user is allowed to enable to unknown sources
     * setting.”</i>
     * 
     * @param appsAllowInstallFromUnknownSources
     *            new value of {@code appsAllowInstallFromUnknownSources} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appsAllowInstallFromUnknownSources} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withAppsAllowInstallFromUnknownSources(Boolean appsAllowInstallFromUnknownSources) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appsAllowInstallFromUnknownSources");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.appsAllowInstallFromUnknownSources = appsAllowInstallFromUnknownSources;
        return _x;
    }

    /**
     * <i>“Indicates the value of the app auto update policy.”</i>
     * 
     * @return property appsAutoUpdatePolicy
     */
    @Property(name="appsAutoUpdatePolicy")
    @JsonIgnore
    public Optional<AndroidDeviceOwnerAppAutoUpdatePolicyType> getAppsAutoUpdatePolicy() {
        return Optional.ofNullable(appsAutoUpdatePolicy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appsAutoUpdatePolicy} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates the value of the app auto update policy.”</i>
     * 
     * @param appsAutoUpdatePolicy
     *            new value of {@code appsAutoUpdatePolicy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appsAutoUpdatePolicy} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withAppsAutoUpdatePolicy(AndroidDeviceOwnerAppAutoUpdatePolicyType appsAutoUpdatePolicy) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appsAutoUpdatePolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.appsAutoUpdatePolicy = appsAutoUpdatePolicy;
        return _x;
    }

    /**
     * <i>“Indicates the permission policy for requests for runtime permissions if one is
     * not defined for the app specifically.”</i>
     * 
     * @return property appsDefaultPermissionPolicy
     */
    @Property(name="appsDefaultPermissionPolicy")
    @JsonIgnore
    public Optional<AndroidDeviceOwnerDefaultAppPermissionPolicyType> getAppsDefaultPermissionPolicy() {
        return Optional.ofNullable(appsDefaultPermissionPolicy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appsDefaultPermissionPolicy} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates the permission policy for requests for runtime permissions if one is
     * not defined for the app specifically.”</i>
     * 
     * @param appsDefaultPermissionPolicy
     *            new value of {@code appsDefaultPermissionPolicy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appsDefaultPermissionPolicy} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withAppsDefaultPermissionPolicy(AndroidDeviceOwnerDefaultAppPermissionPolicyType appsDefaultPermissionPolicy) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appsDefaultPermissionPolicy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.appsDefaultPermissionPolicy = appsDefaultPermissionPolicy;
        return _x;
    }

    /**
     * <i>“Whether or not to recommend all apps skip any first-time-use hints they may have
     * added.”</i>
     * 
     * @return property appsRecommendSkippingFirstUseHints
     */
    @Property(name="appsRecommendSkippingFirstUseHints")
    @JsonIgnore
    public Optional<Boolean> getAppsRecommendSkippingFirstUseHints() {
        return Optional.ofNullable(appsRecommendSkippingFirstUseHints);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * appsRecommendSkippingFirstUseHints} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Whether or not to recommend all apps skip any first-time-use hints they may have
     * added.”</i>
     * 
     * @param appsRecommendSkippingFirstUseHints
     *            new value of {@code appsRecommendSkippingFirstUseHints} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code appsRecommendSkippingFirstUseHints} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withAppsRecommendSkippingFirstUseHints(Boolean appsRecommendSkippingFirstUseHints) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("appsRecommendSkippingFirstUseHints");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.appsRecommendSkippingFirstUseHints = appsRecommendSkippingFirstUseHints;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block a user from configuring bluetooth.”</i>
     * 
     * @return property bluetoothBlockConfiguration
     */
    @Property(name="bluetoothBlockConfiguration")
    @JsonIgnore
    public Optional<Boolean> getBluetoothBlockConfiguration() {
        return Optional.ofNullable(bluetoothBlockConfiguration);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bluetoothBlockConfiguration} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block a user from configuring bluetooth.”</i>
     * 
     * @param bluetoothBlockConfiguration
     *            new value of {@code bluetoothBlockConfiguration} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bluetoothBlockConfiguration} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withBluetoothBlockConfiguration(Boolean bluetoothBlockConfiguration) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("bluetoothBlockConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.bluetoothBlockConfiguration = bluetoothBlockConfiguration;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block a user from sharing contacts via bluetooth.”</i>
     * 
     * @return property bluetoothBlockContactSharing
     */
    @Property(name="bluetoothBlockContactSharing")
    @JsonIgnore
    public Optional<Boolean> getBluetoothBlockContactSharing() {
        return Optional.ofNullable(bluetoothBlockContactSharing);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * bluetoothBlockContactSharing} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block a user from sharing contacts via bluetooth.”</i>
     * 
     * @param bluetoothBlockContactSharing
     *            new value of {@code bluetoothBlockContactSharing} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code bluetoothBlockContactSharing} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withBluetoothBlockContactSharing(Boolean bluetoothBlockContactSharing) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("bluetoothBlockContactSharing");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.bluetoothBlockContactSharing = bluetoothBlockContactSharing;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to disable the use of the camera.”</i>
     * 
     * @return property cameraBlocked
     */
    @Property(name="cameraBlocked")
    @JsonIgnore
    public Optional<Boolean> getCameraBlocked() {
        return Optional.ofNullable(cameraBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code cameraBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to disable the use of the camera.”</i>
     * 
     * @param cameraBlocked
     *            new value of {@code cameraBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cameraBlocked} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withCameraBlocked(Boolean cameraBlocked) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cameraBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.cameraBlocked = cameraBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block Wi-Fi tethering.”</i>
     * 
     * @return property cellularBlockWiFiTethering
     */
    @Property(name="cellularBlockWiFiTethering")
    @JsonIgnore
    public Optional<Boolean> getCellularBlockWiFiTethering() {
        return Optional.ofNullable(cellularBlockWiFiTethering);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * cellularBlockWiFiTethering} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block Wi-Fi tethering.”</i>
     * 
     * @param cellularBlockWiFiTethering
     *            new value of {@code cellularBlockWiFiTethering} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code cellularBlockWiFiTethering} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withCellularBlockWiFiTethering(Boolean cellularBlockWiFiTethering) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("cellularBlockWiFiTethering");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.cellularBlockWiFiTethering = cellularBlockWiFiTethering;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block users from any certificate credential
     * configuration.”</i>
     * 
     * @return property certificateCredentialConfigurationDisabled
     */
    @Property(name="certificateCredentialConfigurationDisabled")
    @JsonIgnore
    public Optional<Boolean> getCertificateCredentialConfigurationDisabled() {
        return Optional.ofNullable(certificateCredentialConfigurationDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * certificateCredentialConfigurationDisabled} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block users from any certificate credential
     * configuration.”</i>
     * 
     * @param certificateCredentialConfigurationDisabled
     *            new value of {@code certificateCredentialConfigurationDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code certificateCredentialConfigurationDisabled} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withCertificateCredentialConfigurationDisabled(Boolean certificateCredentialConfigurationDisabled) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("certificateCredentialConfigurationDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.certificateCredentialConfigurationDisabled = certificateCredentialConfigurationDisabled;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to you want configure Microsoft Launcher.”</i>
     * 
     * @return property microsoftLauncherConfigurationEnabled
     */
    @Property(name="microsoftLauncherConfigurationEnabled")
    @JsonIgnore
    public Optional<Boolean> getMicrosoftLauncherConfigurationEnabled() {
        return Optional.ofNullable(microsoftLauncherConfigurationEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftLauncherConfigurationEnabled} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to you want configure Microsoft Launcher.”</i>
     * 
     * @param microsoftLauncherConfigurationEnabled
     *            new value of {@code microsoftLauncherConfigurationEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftLauncherConfigurationEnabled} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withMicrosoftLauncherConfigurationEnabled(Boolean microsoftLauncherConfigurationEnabled) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("microsoftLauncherConfigurationEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.microsoftLauncherConfigurationEnabled = microsoftLauncherConfigurationEnabled;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to configure the wallpaper on the targeted devices.”</i>
     * 
     * @return property microsoftLauncherCustomWallpaperEnabled
     */
    @Property(name="microsoftLauncherCustomWallpaperEnabled")
    @JsonIgnore
    public Optional<Boolean> getMicrosoftLauncherCustomWallpaperEnabled() {
        return Optional.ofNullable(microsoftLauncherCustomWallpaperEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftLauncherCustomWallpaperEnabled} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to configure the wallpaper on the targeted devices.”</i>
     * 
     * @param microsoftLauncherCustomWallpaperEnabled
     *            new value of {@code microsoftLauncherCustomWallpaperEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftLauncherCustomWallpaperEnabled} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withMicrosoftLauncherCustomWallpaperEnabled(Boolean microsoftLauncherCustomWallpaperEnabled) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("microsoftLauncherCustomWallpaperEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.microsoftLauncherCustomWallpaperEnabled = microsoftLauncherCustomWallpaperEnabled;
        return _x;
    }

    /**
     * <i>“Indicates the URL for the image file to use as the wallpaper on the targeted
     * devices.”</i>
     * 
     * @return property microsoftLauncherCustomWallpaperImageUrl
     */
    @Property(name="microsoftLauncherCustomWallpaperImageUrl")
    @JsonIgnore
    public Optional<String> getMicrosoftLauncherCustomWallpaperImageUrl() {
        return Optional.ofNullable(microsoftLauncherCustomWallpaperImageUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftLauncherCustomWallpaperImageUrl} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates the URL for the image file to use as the wallpaper on the targeted
     * devices.”</i>
     * 
     * @param microsoftLauncherCustomWallpaperImageUrl
     *            new value of {@code microsoftLauncherCustomWallpaperImageUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftLauncherCustomWallpaperImageUrl} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withMicrosoftLauncherCustomWallpaperImageUrl(String microsoftLauncherCustomWallpaperImageUrl) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("microsoftLauncherCustomWallpaperImageUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.microsoftLauncherCustomWallpaperImageUrl = microsoftLauncherCustomWallpaperImageUrl;
        return _x;
    }

    /**
     * <i>“Indicates whether or not the user can modify the wallpaper to personalize their
     * device.”</i>
     * 
     * @return property microsoftLauncherCustomWallpaperAllowUserModification
     */
    @Property(name="microsoftLauncherCustomWallpaperAllowUserModification")
    @JsonIgnore
    public Optional<Boolean> getMicrosoftLauncherCustomWallpaperAllowUserModification() {
        return Optional.ofNullable(microsoftLauncherCustomWallpaperAllowUserModification);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftLauncherCustomWallpaperAllowUserModification} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not the user can modify the wallpaper to personalize their
     * device.”</i>
     * 
     * @param microsoftLauncherCustomWallpaperAllowUserModification
     *            new value of {@code microsoftLauncherCustomWallpaperAllowUserModification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftLauncherCustomWallpaperAllowUserModification} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withMicrosoftLauncherCustomWallpaperAllowUserModification(Boolean microsoftLauncherCustomWallpaperAllowUserModification) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("microsoftLauncherCustomWallpaperAllowUserModification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.microsoftLauncherCustomWallpaperAllowUserModification = microsoftLauncherCustomWallpaperAllowUserModification;
        return _x;
    }

    /**
     * <i>“Indicates whether or not you want to enable the launcher feed on the device.”</i>
     * 
     * @return property microsoftLauncherFeedEnabled
     */
    @Property(name="microsoftLauncherFeedEnabled")
    @JsonIgnore
    public Optional<Boolean> getMicrosoftLauncherFeedEnabled() {
        return Optional.ofNullable(microsoftLauncherFeedEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftLauncherFeedEnabled} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not you want to enable the launcher feed on the device.”</i>
     * 
     * @param microsoftLauncherFeedEnabled
     *            new value of {@code microsoftLauncherFeedEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftLauncherFeedEnabled} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withMicrosoftLauncherFeedEnabled(Boolean microsoftLauncherFeedEnabled) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("microsoftLauncherFeedEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.microsoftLauncherFeedEnabled = microsoftLauncherFeedEnabled;
        return _x;
    }

    /**
     * <i>“Indicates whether or not the user can modify the launcher feed on the device.”</i>
     * 
     * @return property microsoftLauncherFeedAllowUserModification
     */
    @Property(name="microsoftLauncherFeedAllowUserModification")
    @JsonIgnore
    public Optional<Boolean> getMicrosoftLauncherFeedAllowUserModification() {
        return Optional.ofNullable(microsoftLauncherFeedAllowUserModification);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftLauncherFeedAllowUserModification} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not the user can modify the launcher feed on the device.”</i>
     * 
     * @param microsoftLauncherFeedAllowUserModification
     *            new value of {@code microsoftLauncherFeedAllowUserModification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftLauncherFeedAllowUserModification} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withMicrosoftLauncherFeedAllowUserModification(Boolean microsoftLauncherFeedAllowUserModification) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("microsoftLauncherFeedAllowUserModification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.microsoftLauncherFeedAllowUserModification = microsoftLauncherFeedAllowUserModification;
        return _x;
    }

    /**
     * <i>“Indicates whether or not you want to configure the device dock.”</i>
     * 
     * @return property microsoftLauncherDockPresenceConfiguration
     */
    @Property(name="microsoftLauncherDockPresenceConfiguration")
    @JsonIgnore
    public Optional<MicrosoftLauncherDockPresence> getMicrosoftLauncherDockPresenceConfiguration() {
        return Optional.ofNullable(microsoftLauncherDockPresenceConfiguration);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftLauncherDockPresenceConfiguration} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not you want to configure the device dock.”</i>
     * 
     * @param microsoftLauncherDockPresenceConfiguration
     *            new value of {@code microsoftLauncherDockPresenceConfiguration} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftLauncherDockPresenceConfiguration} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withMicrosoftLauncherDockPresenceConfiguration(MicrosoftLauncherDockPresence microsoftLauncherDockPresenceConfiguration) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("microsoftLauncherDockPresenceConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.microsoftLauncherDockPresenceConfiguration = microsoftLauncherDockPresenceConfiguration;
        return _x;
    }

    /**
     * <i>“Indicates whether or not the user can modify the device dock configuration on
     * the device.”</i>
     * 
     * @return property microsoftLauncherDockPresenceAllowUserModification
     */
    @Property(name="microsoftLauncherDockPresenceAllowUserModification")
    @JsonIgnore
    public Optional<Boolean> getMicrosoftLauncherDockPresenceAllowUserModification() {
        return Optional.ofNullable(microsoftLauncherDockPresenceAllowUserModification);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftLauncherDockPresenceAllowUserModification} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not the user can modify the device dock configuration on
     * the device.”</i>
     * 
     * @param microsoftLauncherDockPresenceAllowUserModification
     *            new value of {@code microsoftLauncherDockPresenceAllowUserModification} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftLauncherDockPresenceAllowUserModification} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withMicrosoftLauncherDockPresenceAllowUserModification(Boolean microsoftLauncherDockPresenceAllowUserModification) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("microsoftLauncherDockPresenceAllowUserModification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.microsoftLauncherDockPresenceAllowUserModification = microsoftLauncherDockPresenceAllowUserModification;
        return _x;
    }

    /**
     * <i>“Indicates the search bar placement configuration on the device.”</i>
     * 
     * @return property microsoftLauncherSearchBarPlacementConfiguration
     */
    @Property(name="microsoftLauncherSearchBarPlacementConfiguration")
    @JsonIgnore
    public Optional<MicrosoftLauncherSearchBarPlacement> getMicrosoftLauncherSearchBarPlacementConfiguration() {
        return Optional.ofNullable(microsoftLauncherSearchBarPlacementConfiguration);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microsoftLauncherSearchBarPlacementConfiguration} field changed. Field
     * description below. The field name is also added to an internal map of changed
     * fields in the returned object so that when {@code this.patch()} is called (if
     * available)on the returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates the search bar placement configuration on the device.”</i>
     * 
     * @param microsoftLauncherSearchBarPlacementConfiguration
     *            new value of {@code microsoftLauncherSearchBarPlacementConfiguration} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microsoftLauncherSearchBarPlacementConfiguration} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withMicrosoftLauncherSearchBarPlacementConfiguration(MicrosoftLauncherSearchBarPlacement microsoftLauncherSearchBarPlacementConfiguration) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("microsoftLauncherSearchBarPlacementConfiguration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.microsoftLauncherSearchBarPlacementConfiguration = microsoftLauncherSearchBarPlacementConfiguration;
        return _x;
    }

    /**
     * <i>“Indicates which enrollment profile you want to configure.”</i>
     * 
     * @return property enrollmentProfile
     */
    @Property(name="enrollmentProfile")
    @JsonIgnore
    public Optional<AndroidDeviceOwnerEnrollmentProfileType> getEnrollmentProfile() {
        return Optional.ofNullable(enrollmentProfile);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code enrollmentProfile
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates which enrollment profile you want to configure.”</i>
     * 
     * @param enrollmentProfile
     *            new value of {@code enrollmentProfile} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enrollmentProfile} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withEnrollmentProfile(AndroidDeviceOwnerEnrollmentProfileType enrollmentProfile) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("enrollmentProfile");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.enrollmentProfile = enrollmentProfile;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block a user from data roaming.”</i>
     * 
     * @return property dataRoamingBlocked
     */
    @Property(name="dataRoamingBlocked")
    @JsonIgnore
    public Optional<Boolean> getDataRoamingBlocked() {
        return Optional.ofNullable(dataRoamingBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * dataRoamingBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block a user from data roaming.”</i>
     * 
     * @param dataRoamingBlocked
     *            new value of {@code dataRoamingBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dataRoamingBlocked} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withDataRoamingBlocked(Boolean dataRoamingBlocked) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("dataRoamingBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.dataRoamingBlocked = dataRoamingBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from manually changing the date or
     * time on the device”</i>
     * 
     * @return property dateTimeConfigurationBlocked
     */
    @Property(name="dateTimeConfigurationBlocked")
    @JsonIgnore
    public Optional<Boolean> getDateTimeConfigurationBlocked() {
        return Optional.ofNullable(dateTimeConfigurationBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * dateTimeConfigurationBlocked} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from manually changing the date or
     * time on the device”</i>
     * 
     * @param dateTimeConfigurationBlocked
     *            new value of {@code dateTimeConfigurationBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code dateTimeConfigurationBlocked} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withDateTimeConfigurationBlocked(Boolean dateTimeConfigurationBlocked) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("dateTimeConfigurationBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.dateTimeConfigurationBlocked = dateTimeConfigurationBlocked;
        return _x;
    }

    /**
     * <i>“List of Google account emails that will be required to authenticate after a
     * device is factory reset before it can be set up.”</i>
     * 
     * @return property factoryResetDeviceAdministratorEmails
     */
    @Property(name="factoryResetDeviceAdministratorEmails")
    @JsonIgnore
    public CollectionPage<String> getFactoryResetDeviceAdministratorEmails() {
        return new CollectionPage<String>(contextPath, String.class, factoryResetDeviceAdministratorEmails, Optional.ofNullable(factoryResetDeviceAdministratorEmailsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of Google account emails that will be required to authenticate after a
     * device is factory reset before it can be set up.”</i>
     * 
     * @return property factoryResetDeviceAdministratorEmails
     */
    @Property(name="factoryResetDeviceAdministratorEmails")
    @JsonIgnore
    public CollectionPage<String> getFactoryResetDeviceAdministratorEmails(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, factoryResetDeviceAdministratorEmails, Optional.ofNullable(factoryResetDeviceAdministratorEmailsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Indicates whether or not the factory reset option in settings is disabled.”</i>
     * 
     * @return property factoryResetBlocked
     */
    @Property(name="factoryResetBlocked")
    @JsonIgnore
    public Optional<Boolean> getFactoryResetBlocked() {
        return Optional.ofNullable(factoryResetBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * factoryResetBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not the factory reset option in settings is disabled.”</i>
     * 
     * @param factoryResetBlocked
     *            new value of {@code factoryResetBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code factoryResetBlocked} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withFactoryResetBlocked(Boolean factoryResetBlocked) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("factoryResetBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.factoryResetBlocked = factoryResetBlocked;
        return _x;
    }

    /**
     * <i>“Proxy is set up directly with host, port and excluded hosts.”</i>
     * 
     * @return property globalProxy
     */
    @Property(name="globalProxy")
    @JsonIgnore
    public Optional<AndroidDeviceOwnerGlobalProxy> getGlobalProxy() {
        return Optional.ofNullable(globalProxy);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code globalProxy}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Proxy is set up directly with host, port and excluded hosts.”</i>
     * 
     * @param globalProxy
     *            new value of {@code globalProxy} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code globalProxy} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withGlobalProxy(AndroidDeviceOwnerGlobalProxy globalProxy) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("globalProxy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.globalProxy = globalProxy;
        return _x;
    }

    /**
     * <i>“Indicates whether or not google accounts will be blocked.”</i>
     * 
     * @return property googleAccountsBlocked
     */
    @Property(name="googleAccountsBlocked")
    @JsonIgnore
    public Optional<Boolean> getGoogleAccountsBlocked() {
        return Optional.ofNullable(googleAccountsBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * googleAccountsBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not google accounts will be blocked.”</i>
     * 
     * @param googleAccountsBlocked
     *            new value of {@code googleAccountsBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code googleAccountsBlocked} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withGoogleAccountsBlocked(Boolean googleAccountsBlocked) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("googleAccountsBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.googleAccountsBlocked = googleAccountsBlocked;
        return _x;
    }

    /**
     * <i>“Whether or not to enable screen saver mode or not in Kiosk Mode.”</i>
     * 
     * @return property kioskModeScreenSaverConfigurationEnabled
     */
    @Property(name="kioskModeScreenSaverConfigurationEnabled")
    @JsonIgnore
    public Optional<Boolean> getKioskModeScreenSaverConfigurationEnabled() {
        return Optional.ofNullable(kioskModeScreenSaverConfigurationEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeScreenSaverConfigurationEnabled} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Whether or not to enable screen saver mode or not in Kiosk Mode.”</i>
     * 
     * @param kioskModeScreenSaverConfigurationEnabled
     *            new value of {@code kioskModeScreenSaverConfigurationEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeScreenSaverConfigurationEnabled} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withKioskModeScreenSaverConfigurationEnabled(Boolean kioskModeScreenSaverConfigurationEnabled) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeScreenSaverConfigurationEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.kioskModeScreenSaverConfigurationEnabled = kioskModeScreenSaverConfigurationEnabled;
        return _x;
    }

    /**
     * <i>“URL for an image that will be the device's screen saver in Kiosk Mode.”</i>
     * 
     * @return property kioskModeScreenSaverImageUrl
     */
    @Property(name="kioskModeScreenSaverImageUrl")
    @JsonIgnore
    public Optional<String> getKioskModeScreenSaverImageUrl() {
        return Optional.ofNullable(kioskModeScreenSaverImageUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeScreenSaverImageUrl} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“URL for an image that will be the device's screen saver in Kiosk Mode.”</i>
     * 
     * @param kioskModeScreenSaverImageUrl
     *            new value of {@code kioskModeScreenSaverImageUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeScreenSaverImageUrl} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withKioskModeScreenSaverImageUrl(String kioskModeScreenSaverImageUrl) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeScreenSaverImageUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.kioskModeScreenSaverImageUrl = kioskModeScreenSaverImageUrl;
        return _x;
    }

    /**
     * <i>“The number of seconds that the device will display the screen saver for in Kiosk
     * Mode. Valid values 0 to 9999999”</i>
     * 
     * @return property kioskModeScreenSaverDisplayTimeInSeconds
     */
    @Property(name="kioskModeScreenSaverDisplayTimeInSeconds")
    @JsonIgnore
    public Optional<Integer> getKioskModeScreenSaverDisplayTimeInSeconds() {
        return Optional.ofNullable(kioskModeScreenSaverDisplayTimeInSeconds);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeScreenSaverDisplayTimeInSeconds} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The number of seconds that the device will display the screen saver for in Kiosk
     * Mode. Valid values 0 to 9999999”</i>
     * 
     * @param kioskModeScreenSaverDisplayTimeInSeconds
     *            new value of {@code kioskModeScreenSaverDisplayTimeInSeconds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeScreenSaverDisplayTimeInSeconds} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withKioskModeScreenSaverDisplayTimeInSeconds(Integer kioskModeScreenSaverDisplayTimeInSeconds) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeScreenSaverDisplayTimeInSeconds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.kioskModeScreenSaverDisplayTimeInSeconds = kioskModeScreenSaverDisplayTimeInSeconds;
        return _x;
    }

    /**
     * <i>“The number of seconds the device needs to be inactive for before the screen
     * saver is shown in Kiosk Mode. Valid values 1 to 9999999”</i>
     * 
     * @return property kioskModeScreenSaverStartDelayInSeconds
     */
    @Property(name="kioskModeScreenSaverStartDelayInSeconds")
    @JsonIgnore
    public Optional<Integer> getKioskModeScreenSaverStartDelayInSeconds() {
        return Optional.ofNullable(kioskModeScreenSaverStartDelayInSeconds);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeScreenSaverStartDelayInSeconds} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“The number of seconds the device needs to be inactive for before the screen
     * saver is shown in Kiosk Mode. Valid values 1 to 9999999”</i>
     * 
     * @param kioskModeScreenSaverStartDelayInSeconds
     *            new value of {@code kioskModeScreenSaverStartDelayInSeconds} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeScreenSaverStartDelayInSeconds} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withKioskModeScreenSaverStartDelayInSeconds(Integer kioskModeScreenSaverStartDelayInSeconds) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeScreenSaverStartDelayInSeconds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.kioskModeScreenSaverStartDelayInSeconds = kioskModeScreenSaverStartDelayInSeconds;
        return _x;
    }

    /**
     * <i>“Whether or not the device screen should show the screen saver if audio/video is
     * playing in Kiosk Mode.”</i>
     * 
     * @return property kioskModeScreenSaverDetectMediaDisabled
     */
    @Property(name="kioskModeScreenSaverDetectMediaDisabled")
    @JsonIgnore
    public Optional<Boolean> getKioskModeScreenSaverDetectMediaDisabled() {
        return Optional.ofNullable(kioskModeScreenSaverDetectMediaDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeScreenSaverDetectMediaDisabled} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Whether or not the device screen should show the screen saver if audio/video is
     * playing in Kiosk Mode.”</i>
     * 
     * @param kioskModeScreenSaverDetectMediaDisabled
     *            new value of {@code kioskModeScreenSaverDetectMediaDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeScreenSaverDetectMediaDisabled} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withKioskModeScreenSaverDetectMediaDisabled(Boolean kioskModeScreenSaverDetectMediaDisabled) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeScreenSaverDetectMediaDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.kioskModeScreenSaverDetectMediaDisabled = kioskModeScreenSaverDetectMediaDisabled;
        return _x;
    }

    /**
     * <i>“A list of managed apps that will be shown when the device is in Kiosk Mode. This
     * collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property kioskModeApps
     */
    @Property(name="kioskModeApps")
    @JsonIgnore
    public CollectionPage<AppListItem> getKioskModeApps() {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, kioskModeApps, Optional.ofNullable(kioskModeAppsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“A list of managed apps that will be shown when the device is in Kiosk Mode. This
     * collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property kioskModeApps
     */
    @Property(name="kioskModeApps")
    @JsonIgnore
    public CollectionPage<AppListItem> getKioskModeApps(HttpRequestOptions options) {
        return new CollectionPage<AppListItem>(contextPath, AppListItem.class, kioskModeApps, Optional.ofNullable(kioskModeAppsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“URL to a publicly accessible image to use for the wallpaper when the device is
     * in Kiosk Mode.”</i>
     * 
     * @return property kioskModeWallpaperUrl
     */
    @Property(name="kioskModeWallpaperUrl")
    @JsonIgnore
    public Optional<String> getKioskModeWallpaperUrl() {
        return Optional.ofNullable(kioskModeWallpaperUrl);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeWallpaperUrl} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“URL to a publicly accessible image to use for the wallpaper when the device is
     * in Kiosk Mode.”</i>
     * 
     * @param kioskModeWallpaperUrl
     *            new value of {@code kioskModeWallpaperUrl} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeWallpaperUrl} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withKioskModeWallpaperUrl(String kioskModeWallpaperUrl) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeWallpaperUrl");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.kioskModeWallpaperUrl = kioskModeWallpaperUrl;
        return _x;
    }

    /**
     * <i>“Exit code to allow a user to escape from Kiosk Mode when the device is in Kiosk
     * Mode.”</i>
     * 
     * @return property kioskModeExitCode
     */
    @Property(name="kioskModeExitCode")
    @JsonIgnore
    public Optional<String> getKioskModeExitCode() {
        return Optional.ofNullable(kioskModeExitCode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code kioskModeExitCode
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Exit code to allow a user to escape from Kiosk Mode when the device is in Kiosk
     * Mode.”</i>
     * 
     * @param kioskModeExitCode
     *            new value of {@code kioskModeExitCode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeExitCode} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withKioskModeExitCode(String kioskModeExitCode) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeExitCode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.kioskModeExitCode = kioskModeExitCode;
        return _x;
    }

    /**
     * <i>“Whether or not to display a virtual home button when the device is in Kiosk Mode
     * .”</i>
     * 
     * @return property kioskModeVirtualHomeButtonEnabled
     */
    @Property(name="kioskModeVirtualHomeButtonEnabled")
    @JsonIgnore
    public Optional<Boolean> getKioskModeVirtualHomeButtonEnabled() {
        return Optional.ofNullable(kioskModeVirtualHomeButtonEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeVirtualHomeButtonEnabled} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Whether or not to display a virtual home button when the device is in Kiosk Mode
     * .”</i>
     * 
     * @param kioskModeVirtualHomeButtonEnabled
     *            new value of {@code kioskModeVirtualHomeButtonEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeVirtualHomeButtonEnabled} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withKioskModeVirtualHomeButtonEnabled(Boolean kioskModeVirtualHomeButtonEnabled) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeVirtualHomeButtonEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.kioskModeVirtualHomeButtonEnabled = kioskModeVirtualHomeButtonEnabled;
        return _x;
    }

    /**
     * <i>“Indicates whether the virtual home button is a swipe up home button or a
     * floating home button.”</i>
     * 
     * @return property kioskModeVirtualHomeButtonType
     */
    @Property(name="kioskModeVirtualHomeButtonType")
    @JsonIgnore
    public Optional<AndroidDeviceOwnerVirtualHomeButtonType> getKioskModeVirtualHomeButtonType() {
        return Optional.ofNullable(kioskModeVirtualHomeButtonType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeVirtualHomeButtonType} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether the virtual home button is a swipe up home button or a
     * floating home button.”</i>
     * 
     * @param kioskModeVirtualHomeButtonType
     *            new value of {@code kioskModeVirtualHomeButtonType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeVirtualHomeButtonType} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withKioskModeVirtualHomeButtonType(AndroidDeviceOwnerVirtualHomeButtonType kioskModeVirtualHomeButtonType) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeVirtualHomeButtonType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.kioskModeVirtualHomeButtonType = kioskModeVirtualHomeButtonType;
        return _x;
    }

    /**
     * <i>“Whether or not to allow a user to configure Bluetooth settings in Kiosk Mode.”</i>
     * 
     * @return property kioskModeBluetoothConfigurationEnabled
     */
    @Property(name="kioskModeBluetoothConfigurationEnabled")
    @JsonIgnore
    public Optional<Boolean> getKioskModeBluetoothConfigurationEnabled() {
        return Optional.ofNullable(kioskModeBluetoothConfigurationEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeBluetoothConfigurationEnabled} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Whether or not to allow a user to configure Bluetooth settings in Kiosk Mode.”</i>
     * 
     * @param kioskModeBluetoothConfigurationEnabled
     *            new value of {@code kioskModeBluetoothConfigurationEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeBluetoothConfigurationEnabled} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withKioskModeBluetoothConfigurationEnabled(Boolean kioskModeBluetoothConfigurationEnabled) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeBluetoothConfigurationEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.kioskModeBluetoothConfigurationEnabled = kioskModeBluetoothConfigurationEnabled;
        return _x;
    }

    /**
     * <i>“Whether or not to allow a user to configure Wi-Fi settings in Kiosk Mode.”</i>
     * 
     * @return property kioskModeWiFiConfigurationEnabled
     */
    @Property(name="kioskModeWiFiConfigurationEnabled")
    @JsonIgnore
    public Optional<Boolean> getKioskModeWiFiConfigurationEnabled() {
        return Optional.ofNullable(kioskModeWiFiConfigurationEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeWiFiConfigurationEnabled} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Whether or not to allow a user to configure Wi-Fi settings in Kiosk Mode.”</i>
     * 
     * @param kioskModeWiFiConfigurationEnabled
     *            new value of {@code kioskModeWiFiConfigurationEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeWiFiConfigurationEnabled} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withKioskModeWiFiConfigurationEnabled(Boolean kioskModeWiFiConfigurationEnabled) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeWiFiConfigurationEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.kioskModeWiFiConfigurationEnabled = kioskModeWiFiConfigurationEnabled;
        return _x;
    }

    /**
     * <i>“Whether or not to allow a user to use the flashlight in Kiosk Mode.”</i>
     * 
     * @return property kioskModeFlashlightConfigurationEnabled
     */
    @Property(name="kioskModeFlashlightConfigurationEnabled")
    @JsonIgnore
    public Optional<Boolean> getKioskModeFlashlightConfigurationEnabled() {
        return Optional.ofNullable(kioskModeFlashlightConfigurationEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeFlashlightConfigurationEnabled} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Whether or not to allow a user to use the flashlight in Kiosk Mode.”</i>
     * 
     * @param kioskModeFlashlightConfigurationEnabled
     *            new value of {@code kioskModeFlashlightConfigurationEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeFlashlightConfigurationEnabled} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withKioskModeFlashlightConfigurationEnabled(Boolean kioskModeFlashlightConfigurationEnabled) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeFlashlightConfigurationEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.kioskModeFlashlightConfigurationEnabled = kioskModeFlashlightConfigurationEnabled;
        return _x;
    }

    /**
     * <i>“Whether or not to allow a user to change the media volume in Kiosk Mode.”</i>
     * 
     * @return property kioskModeMediaVolumeConfigurationEnabled
     */
    @Property(name="kioskModeMediaVolumeConfigurationEnabled")
    @JsonIgnore
    public Optional<Boolean> getKioskModeMediaVolumeConfigurationEnabled() {
        return Optional.ofNullable(kioskModeMediaVolumeConfigurationEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeMediaVolumeConfigurationEnabled} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Whether or not to allow a user to change the media volume in Kiosk Mode.”</i>
     * 
     * @param kioskModeMediaVolumeConfigurationEnabled
     *            new value of {@code kioskModeMediaVolumeConfigurationEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeMediaVolumeConfigurationEnabled} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withKioskModeMediaVolumeConfigurationEnabled(Boolean kioskModeMediaVolumeConfigurationEnabled) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeMediaVolumeConfigurationEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.kioskModeMediaVolumeConfigurationEnabled = kioskModeMediaVolumeConfigurationEnabled;
        return _x;
    }

    /**
     * <i>“Whether or not to allow a user to access basic device information.”</i>
     * 
     * @return property kioskModeShowDeviceInfo
     */
    @Property(name="kioskModeShowDeviceInfo")
    @JsonIgnore
    public Optional<Boolean> getKioskModeShowDeviceInfo() {
        return Optional.ofNullable(kioskModeShowDeviceInfo);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeShowDeviceInfo} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Whether or not to allow a user to access basic device information.”</i>
     * 
     * @param kioskModeShowDeviceInfo
     *            new value of {@code kioskModeShowDeviceInfo} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeShowDeviceInfo} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withKioskModeShowDeviceInfo(Boolean kioskModeShowDeviceInfo) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeShowDeviceInfo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.kioskModeShowDeviceInfo = kioskModeShowDeviceInfo;
        return _x;
    }

    /**
     * <i>“Whether or not to display the Managed Settings entry point on the managed home
     * screen in Kiosk Mode.”</i>
     * 
     * @return property kioskModeManagedSettingsEntryDisabled
     */
    @Property(name="kioskModeManagedSettingsEntryDisabled")
    @JsonIgnore
    public Optional<Boolean> getKioskModeManagedSettingsEntryDisabled() {
        return Optional.ofNullable(kioskModeManagedSettingsEntryDisabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeManagedSettingsEntryDisabled} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Whether or not to display the Managed Settings entry point on the managed home
     * screen in Kiosk Mode.”</i>
     * 
     * @param kioskModeManagedSettingsEntryDisabled
     *            new value of {@code kioskModeManagedSettingsEntryDisabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeManagedSettingsEntryDisabled} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withKioskModeManagedSettingsEntryDisabled(Boolean kioskModeManagedSettingsEntryDisabled) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeManagedSettingsEntryDisabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.kioskModeManagedSettingsEntryDisabled = kioskModeManagedSettingsEntryDisabled;
        return _x;
    }

    /**
     * <i>“Whether or not to allow a user to easy access to the debug menu in Kiosk Mode.”</i>
     * 
     * @return property kioskModeDebugMenuEasyAccessEnabled
     */
    @Property(name="kioskModeDebugMenuEasyAccessEnabled")
    @JsonIgnore
    public Optional<Boolean> getKioskModeDebugMenuEasyAccessEnabled() {
        return Optional.ofNullable(kioskModeDebugMenuEasyAccessEnabled);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeDebugMenuEasyAccessEnabled} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Whether or not to allow a user to easy access to the debug menu in Kiosk Mode.”</i>
     * 
     * @param kioskModeDebugMenuEasyAccessEnabled
     *            new value of {@code kioskModeDebugMenuEasyAccessEnabled} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeDebugMenuEasyAccessEnabled} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withKioskModeDebugMenuEasyAccessEnabled(Boolean kioskModeDebugMenuEasyAccessEnabled) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeDebugMenuEasyAccessEnabled");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.kioskModeDebugMenuEasyAccessEnabled = kioskModeDebugMenuEasyAccessEnabled;
        return _x;
    }

    /**
     * <i>“Whether or not to display application notification badges in Kiosk Mode.”</i>
     * 
     * @return property kioskModeShowAppNotificationBadge
     */
    @Property(name="kioskModeShowAppNotificationBadge")
    @JsonIgnore
    public Optional<Boolean> getKioskModeShowAppNotificationBadge() {
        return Optional.ofNullable(kioskModeShowAppNotificationBadge);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeShowAppNotificationBadge} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Whether or not to display application notification badges in Kiosk Mode.”</i>
     * 
     * @param kioskModeShowAppNotificationBadge
     *            new value of {@code kioskModeShowAppNotificationBadge} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeShowAppNotificationBadge} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withKioskModeShowAppNotificationBadge(Boolean kioskModeShowAppNotificationBadge) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeShowAppNotificationBadge");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.kioskModeShowAppNotificationBadge = kioskModeShowAppNotificationBadge;
        return _x;
    }

    /**
     * <i>“Screen orientation configuration for managed home screen in Kiosk Mode.”</i>
     * 
     * @return property kioskModeScreenOrientation
     */
    @Property(name="kioskModeScreenOrientation")
    @JsonIgnore
    public Optional<AndroidDeviceOwnerKioskModeScreenOrientation> getKioskModeScreenOrientation() {
        return Optional.ofNullable(kioskModeScreenOrientation);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeScreenOrientation} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Screen orientation configuration for managed home screen in Kiosk Mode.”</i>
     * 
     * @param kioskModeScreenOrientation
     *            new value of {@code kioskModeScreenOrientation} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeScreenOrientation} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withKioskModeScreenOrientation(AndroidDeviceOwnerKioskModeScreenOrientation kioskModeScreenOrientation) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeScreenOrientation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.kioskModeScreenOrientation = kioskModeScreenOrientation;
        return _x;
    }

    /**
     * <i>“Icon size configuration for managed home screen in Kiosk Mode.”</i>
     * 
     * @return property kioskModeIconSize
     */
    @Property(name="kioskModeIconSize")
    @JsonIgnore
    public Optional<AndroidDeviceOwnerKioskModeIconSize> getKioskModeIconSize() {
        return Optional.ofNullable(kioskModeIconSize);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code kioskModeIconSize
     * } field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Icon size configuration for managed home screen in Kiosk Mode.”</i>
     * 
     * @param kioskModeIconSize
     *            new value of {@code kioskModeIconSize} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeIconSize} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withKioskModeIconSize(AndroidDeviceOwnerKioskModeIconSize kioskModeIconSize) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeIconSize");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.kioskModeIconSize = kioskModeIconSize;
        return _x;
    }

    /**
     * <i>“Folder icon configuration for managed home screen in Kiosk Mode.”</i>
     * 
     * @return property kioskModeFolderIcon
     */
    @Property(name="kioskModeFolderIcon")
    @JsonIgnore
    public Optional<AndroidDeviceOwnerKioskModeFolderIcon> getKioskModeFolderIcon() {
        return Optional.ofNullable(kioskModeFolderIcon);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * kioskModeFolderIcon} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Folder icon configuration for managed home screen in Kiosk Mode.”</i>
     * 
     * @param kioskModeFolderIcon
     *            new value of {@code kioskModeFolderIcon} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code kioskModeFolderIcon} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withKioskModeFolderIcon(AndroidDeviceOwnerKioskModeFolderIcon kioskModeFolderIcon) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("kioskModeFolderIcon");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.kioskModeFolderIcon = kioskModeFolderIcon;
        return _x;
    }

    /**
     * <i>“The restricted set of WIFI SSIDs available for the user to configure in Kiosk
     * Mode. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property kioskModeWifiAllowedSsids
     */
    @Property(name="kioskModeWifiAllowedSsids")
    @JsonIgnore
    public CollectionPage<String> getKioskModeWifiAllowedSsids() {
        return new CollectionPage<String>(contextPath, String.class, kioskModeWifiAllowedSsids, Optional.ofNullable(kioskModeWifiAllowedSsidsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“The restricted set of WIFI SSIDs available for the user to configure in Kiosk
     * Mode. This collection can contain a maximum of 500 elements.”</i>
     * 
     * @return property kioskModeWifiAllowedSsids
     */
    @Property(name="kioskModeWifiAllowedSsids")
    @JsonIgnore
    public CollectionPage<String> getKioskModeWifiAllowedSsids(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, kioskModeWifiAllowedSsids, Optional.ofNullable(kioskModeWifiAllowedSsidsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Indicates whether or not to block unmuting the microphone on the device.”</i>
     * 
     * @return property microphoneForceMute
     */
    @Property(name="microphoneForceMute")
    @JsonIgnore
    public Optional<Boolean> getMicrophoneForceMute() {
        return Optional.ofNullable(microphoneForceMute);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * microphoneForceMute} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block unmuting the microphone on the device.”</i>
     * 
     * @param microphoneForceMute
     *            new value of {@code microphoneForceMute} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code microphoneForceMute} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withMicrophoneForceMute(Boolean microphoneForceMute) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("microphoneForceMute");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.microphoneForceMute = microphoneForceMute;
        return _x;
    }

    /**
     * <i>“Indicates whether or not the device will allow connecting to a temporary network
     * connection at boot time.”</i>
     * 
     * @return property networkEscapeHatchAllowed
     */
    @Property(name="networkEscapeHatchAllowed")
    @JsonIgnore
    public Optional<Boolean> getNetworkEscapeHatchAllowed() {
        return Optional.ofNullable(networkEscapeHatchAllowed);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * networkEscapeHatchAllowed} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not the device will allow connecting to a temporary network
     * connection at boot time.”</i>
     * 
     * @param networkEscapeHatchAllowed
     *            new value of {@code networkEscapeHatchAllowed} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code networkEscapeHatchAllowed} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withNetworkEscapeHatchAllowed(Boolean networkEscapeHatchAllowed) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("networkEscapeHatchAllowed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.networkEscapeHatchAllowed = networkEscapeHatchAllowed;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block NFC outgoing beam.”</i>
     * 
     * @return property nfcBlockOutgoingBeam
     */
    @Property(name="nfcBlockOutgoingBeam")
    @JsonIgnore
    public Optional<Boolean> getNfcBlockOutgoingBeam() {
        return Optional.ofNullable(nfcBlockOutgoingBeam);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * nfcBlockOutgoingBeam} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block NFC outgoing beam.”</i>
     * 
     * @param nfcBlockOutgoingBeam
     *            new value of {@code nfcBlockOutgoingBeam} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code nfcBlockOutgoingBeam} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withNfcBlockOutgoingBeam(Boolean nfcBlockOutgoingBeam) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("nfcBlockOutgoingBeam");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.nfcBlockOutgoingBeam = nfcBlockOutgoingBeam;
        return _x;
    }

    /**
     * <i>“Indicates whether or not the keyguard is disabled.”</i>
     * 
     * @return property passwordBlockKeyguard
     */
    @Property(name="passwordBlockKeyguard")
    @JsonIgnore
    public Optional<Boolean> getPasswordBlockKeyguard() {
        return Optional.ofNullable(passwordBlockKeyguard);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordBlockKeyguard} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not the keyguard is disabled.”</i>
     * 
     * @param passwordBlockKeyguard
     *            new value of {@code passwordBlockKeyguard} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordBlockKeyguard} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withPasswordBlockKeyguard(Boolean passwordBlockKeyguard) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordBlockKeyguard");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.passwordBlockKeyguard = passwordBlockKeyguard;
        return _x;
    }

    /**
     * <i>“List of device keyguard features to block. This collection can contain a maximum
     * of 7 elements.”</i>
     * 
     * @return property passwordBlockKeyguardFeatures
     */
    @Property(name="passwordBlockKeyguardFeatures")
    @JsonIgnore
    public CollectionPage<AndroidKeyguardFeature> getPasswordBlockKeyguardFeatures() {
        return new CollectionPage<AndroidKeyguardFeature>(contextPath, AndroidKeyguardFeature.class, passwordBlockKeyguardFeatures, Optional.ofNullable(passwordBlockKeyguardFeaturesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of device keyguard features to block. This collection can contain a maximum
     * of 7 elements.”</i>
     * 
     * @return property passwordBlockKeyguardFeatures
     */
    @Property(name="passwordBlockKeyguardFeatures")
    @JsonIgnore
    public CollectionPage<AndroidKeyguardFeature> getPasswordBlockKeyguardFeatures(HttpRequestOptions options) {
        return new CollectionPage<AndroidKeyguardFeature>(contextPath, AndroidKeyguardFeature.class, passwordBlockKeyguardFeatures, Optional.ofNullable(passwordBlockKeyguardFeaturesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Indicates the amount of time in seconds that a password can be set for before it
     * expires and a new password will be required. Valid values 1 to 365”</i>
     * 
     * @return property passwordExpirationDays
     */
    @Property(name="passwordExpirationDays")
    @JsonIgnore
    public Optional<Integer> getPasswordExpirationDays() {
        return Optional.ofNullable(passwordExpirationDays);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordExpirationDays} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates the amount of time in seconds that a password can be set for before it
     * expires and a new password will be required. Valid values 1 to 365”</i>
     * 
     * @param passwordExpirationDays
     *            new value of {@code passwordExpirationDays} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordExpirationDays} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withPasswordExpirationDays(Integer passwordExpirationDays) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordExpirationDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.passwordExpirationDays = passwordExpirationDays;
        return _x;
    }

    /**
     * <i>“Indicates the minimum length of the password required on the device. Valid
     * values 4 to 16”</i>
     * 
     * @return property passwordMinimumLength
     */
    @Property(name="passwordMinimumLength")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumLength() {
        return Optional.ofNullable(passwordMinimumLength);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumLength} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates the minimum length of the password required on the device. Valid
     * values 4 to 16”</i>
     * 
     * @param passwordMinimumLength
     *            new value of {@code passwordMinimumLength} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumLength} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withPasswordMinimumLength(Integer passwordMinimumLength) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumLength");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.passwordMinimumLength = passwordMinimumLength;
        return _x;
    }

    /**
     * <i>“Indicates the minimum number of letter characters required for device password.
     * Valid values 1 to 16”</i>
     * 
     * @return property passwordMinimumLetterCharacters
     */
    @Property(name="passwordMinimumLetterCharacters")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumLetterCharacters() {
        return Optional.ofNullable(passwordMinimumLetterCharacters);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumLetterCharacters} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates the minimum number of letter characters required for device password.
     * Valid values 1 to 16”</i>
     * 
     * @param passwordMinimumLetterCharacters
     *            new value of {@code passwordMinimumLetterCharacters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumLetterCharacters} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withPasswordMinimumLetterCharacters(Integer passwordMinimumLetterCharacters) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumLetterCharacters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.passwordMinimumLetterCharacters = passwordMinimumLetterCharacters;
        return _x;
    }

    /**
     * <i>“Indicates the minimum number of lower case characters required for device
     * password. Valid values 1 to 16”</i>
     * 
     * @return property passwordMinimumLowerCaseCharacters
     */
    @Property(name="passwordMinimumLowerCaseCharacters")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumLowerCaseCharacters() {
        return Optional.ofNullable(passwordMinimumLowerCaseCharacters);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumLowerCaseCharacters} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates the minimum number of lower case characters required for device
     * password. Valid values 1 to 16”</i>
     * 
     * @param passwordMinimumLowerCaseCharacters
     *            new value of {@code passwordMinimumLowerCaseCharacters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumLowerCaseCharacters} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withPasswordMinimumLowerCaseCharacters(Integer passwordMinimumLowerCaseCharacters) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumLowerCaseCharacters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.passwordMinimumLowerCaseCharacters = passwordMinimumLowerCaseCharacters;
        return _x;
    }

    /**
     * <i>“Indicates the minimum number of non-letter characters required for device
     * password. Valid values 1 to 16”</i>
     * 
     * @return property passwordMinimumNonLetterCharacters
     */
    @Property(name="passwordMinimumNonLetterCharacters")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumNonLetterCharacters() {
        return Optional.ofNullable(passwordMinimumNonLetterCharacters);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumNonLetterCharacters} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates the minimum number of non-letter characters required for device
     * password. Valid values 1 to 16”</i>
     * 
     * @param passwordMinimumNonLetterCharacters
     *            new value of {@code passwordMinimumNonLetterCharacters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumNonLetterCharacters} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withPasswordMinimumNonLetterCharacters(Integer passwordMinimumNonLetterCharacters) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumNonLetterCharacters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.passwordMinimumNonLetterCharacters = passwordMinimumNonLetterCharacters;
        return _x;
    }

    /**
     * <i>“Indicates the minimum number of numeric characters required for device password.
     * Valid values 1 to 16”</i>
     * 
     * @return property passwordMinimumNumericCharacters
     */
    @Property(name="passwordMinimumNumericCharacters")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumNumericCharacters() {
        return Optional.ofNullable(passwordMinimumNumericCharacters);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumNumericCharacters} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates the minimum number of numeric characters required for device password.
     * Valid values 1 to 16”</i>
     * 
     * @param passwordMinimumNumericCharacters
     *            new value of {@code passwordMinimumNumericCharacters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumNumericCharacters} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withPasswordMinimumNumericCharacters(Integer passwordMinimumNumericCharacters) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumNumericCharacters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.passwordMinimumNumericCharacters = passwordMinimumNumericCharacters;
        return _x;
    }

    /**
     * <i>“Indicates the minimum number of symbol characters required for device password.
     * Valid values 1 to 16”</i>
     * 
     * @return property passwordMinimumSymbolCharacters
     */
    @Property(name="passwordMinimumSymbolCharacters")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumSymbolCharacters() {
        return Optional.ofNullable(passwordMinimumSymbolCharacters);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumSymbolCharacters} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates the minimum number of symbol characters required for device password.
     * Valid values 1 to 16”</i>
     * 
     * @param passwordMinimumSymbolCharacters
     *            new value of {@code passwordMinimumSymbolCharacters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumSymbolCharacters} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withPasswordMinimumSymbolCharacters(Integer passwordMinimumSymbolCharacters) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumSymbolCharacters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.passwordMinimumSymbolCharacters = passwordMinimumSymbolCharacters;
        return _x;
    }

    /**
     * <i>“Indicates the minimum number of upper caseletter characters required for device
     * password. Valid values 1 to 16”</i>
     * 
     * @return property passwordMinimumUpperCaseCharacters
     */
    @Property(name="passwordMinimumUpperCaseCharacters")
    @JsonIgnore
    public Optional<Integer> getPasswordMinimumUpperCaseCharacters() {
        return Optional.ofNullable(passwordMinimumUpperCaseCharacters);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinimumUpperCaseCharacters} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates the minimum number of upper caseletter characters required for device
     * password. Valid values 1 to 16”</i>
     * 
     * @param passwordMinimumUpperCaseCharacters
     *            new value of {@code passwordMinimumUpperCaseCharacters} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinimumUpperCaseCharacters} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withPasswordMinimumUpperCaseCharacters(Integer passwordMinimumUpperCaseCharacters) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordMinimumUpperCaseCharacters");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.passwordMinimumUpperCaseCharacters = passwordMinimumUpperCaseCharacters;
        return _x;
    }

    /**
     * <i>“Milliseconds of inactivity before the screen times out.”</i>
     * 
     * @return property passwordMinutesOfInactivityBeforeScreenTimeout
     */
    @Property(name="passwordMinutesOfInactivityBeforeScreenTimeout")
    @JsonIgnore
    public Optional<Integer> getPasswordMinutesOfInactivityBeforeScreenTimeout() {
        return Optional.ofNullable(passwordMinutesOfInactivityBeforeScreenTimeout);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordMinutesOfInactivityBeforeScreenTimeout} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Milliseconds of inactivity before the screen times out.”</i>
     * 
     * @param passwordMinutesOfInactivityBeforeScreenTimeout
     *            new value of {@code passwordMinutesOfInactivityBeforeScreenTimeout} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordMinutesOfInactivityBeforeScreenTimeout} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withPasswordMinutesOfInactivityBeforeScreenTimeout(Integer passwordMinutesOfInactivityBeforeScreenTimeout) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordMinutesOfInactivityBeforeScreenTimeout");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
        return _x;
    }

    /**
     * <i>“Indicates the length of password history, where the user will not be able to
     * enter a new password that is the same as any password in the history. Valid
     * values 0 to 24”</i>
     * 
     * @return property passwordPreviousPasswordCountToBlock
     */
    @Property(name="passwordPreviousPasswordCountToBlock")
    @JsonIgnore
    public Optional<Integer> getPasswordPreviousPasswordCountToBlock() {
        return Optional.ofNullable(passwordPreviousPasswordCountToBlock);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordPreviousPasswordCountToBlock} field changed. Field description below.
     * The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates the length of password history, where the user will not be able to
     * enter a new password that is the same as any password in the history. Valid
     * values 0 to 24”</i>
     * 
     * @param passwordPreviousPasswordCountToBlock
     *            new value of {@code passwordPreviousPasswordCountToBlock} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordPreviousPasswordCountToBlock} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withPasswordPreviousPasswordCountToBlock(Integer passwordPreviousPasswordCountToBlock) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordPreviousPasswordCountToBlock");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.passwordPreviousPasswordCountToBlock = passwordPreviousPasswordCountToBlock;
        return _x;
    }

    /**
     * <i>“Indicates the minimum password quality required on the device.”</i>
     * 
     * @return property passwordRequiredType
     */
    @Property(name="passwordRequiredType")
    @JsonIgnore
    public Optional<AndroidDeviceOwnerRequiredPasswordType> getPasswordRequiredType() {
        return Optional.ofNullable(passwordRequiredType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordRequiredType} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates the minimum password quality required on the device.”</i>
     * 
     * @param passwordRequiredType
     *            new value of {@code passwordRequiredType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordRequiredType} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withPasswordRequiredType(AndroidDeviceOwnerRequiredPasswordType passwordRequiredType) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordRequiredType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.passwordRequiredType = passwordRequiredType;
        return _x;
    }

    /**
     * <i>“Indicates the number of times a user can enter an incorrect password before the
     * device is wiped. Valid values 4 to 11”</i>
     * 
     * @return property passwordSignInFailureCountBeforeFactoryReset
     */
    @Property(name="passwordSignInFailureCountBeforeFactoryReset")
    @JsonIgnore
    public Optional<Integer> getPasswordSignInFailureCountBeforeFactoryReset() {
        return Optional.ofNullable(passwordSignInFailureCountBeforeFactoryReset);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * passwordSignInFailureCountBeforeFactoryReset} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates the number of times a user can enter an incorrect password before the
     * device is wiped. Valid values 4 to 11”</i>
     * 
     * @param passwordSignInFailureCountBeforeFactoryReset
     *            new value of {@code passwordSignInFailureCountBeforeFactoryReset} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code passwordSignInFailureCountBeforeFactoryReset} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withPasswordSignInFailureCountBeforeFactoryReset(Integer passwordSignInFailureCountBeforeFactoryReset) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("passwordSignInFailureCountBeforeFactoryReset");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.passwordSignInFailureCountBeforeFactoryReset = passwordSignInFailureCountBeforeFactoryReset;
        return _x;
    }

    /**
     * <i>“Indicates the Play Store mode of the device.”</i>
     * 
     * @return property playStoreMode
     */
    @Property(name="playStoreMode")
    @JsonIgnore
    public Optional<AndroidDeviceOwnerPlayStoreMode> getPlayStoreMode() {
        return Optional.ofNullable(playStoreMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code playStoreMode}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates the Play Store mode of the device.”</i>
     * 
     * @param playStoreMode
     *            new value of {@code playStoreMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code playStoreMode} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withPlayStoreMode(AndroidDeviceOwnerPlayStoreMode playStoreMode) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("playStoreMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.playStoreMode = playStoreMode;
        return _x;
    }

    /**
     * <i>“Indicates whether or not rebooting the device into safe boot is disabled.”</i>
     * 
     * @return property safeBootBlocked
     */
    @Property(name="safeBootBlocked")
    @JsonIgnore
    public Optional<Boolean> getSafeBootBlocked() {
        return Optional.ofNullable(safeBootBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code safeBootBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not rebooting the device into safe boot is disabled.”</i>
     * 
     * @param safeBootBlocked
     *            new value of {@code safeBootBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code safeBootBlocked} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withSafeBootBlocked(Boolean safeBootBlocked) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("safeBootBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.safeBootBlocked = safeBootBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to disable the capability to take screenshots.”</i>
     * 
     * @return property screenCaptureBlocked
     */
    @Property(name="screenCaptureBlocked")
    @JsonIgnore
    public Optional<Boolean> getScreenCaptureBlocked() {
        return Optional.ofNullable(screenCaptureBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * screenCaptureBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to disable the capability to take screenshots.”</i>
     * 
     * @param screenCaptureBlocked
     *            new value of {@code screenCaptureBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code screenCaptureBlocked} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withScreenCaptureBlocked(Boolean screenCaptureBlocked) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("screenCaptureBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.screenCaptureBlocked = screenCaptureBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from enabling debugging features on
     * the device.”</i>
     * 
     * @return property securityAllowDebuggingFeatures
     */
    @Property(name="securityAllowDebuggingFeatures")
    @JsonIgnore
    public Optional<Boolean> getSecurityAllowDebuggingFeatures() {
        return Optional.ofNullable(securityAllowDebuggingFeatures);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * securityAllowDebuggingFeatures} field changed. Field description below. The
     * field name is also added to an internal map of changed fields in the returned
     * object so that when {@code this.patch()} is called (if available)on the returned
     * object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from enabling debugging features on
     * the device.”</i>
     * 
     * @param securityAllowDebuggingFeatures
     *            new value of {@code securityAllowDebuggingFeatures} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code securityAllowDebuggingFeatures} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withSecurityAllowDebuggingFeatures(Boolean securityAllowDebuggingFeatures) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("securityAllowDebuggingFeatures");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.securityAllowDebuggingFeatures = securityAllowDebuggingFeatures;
        return _x;
    }

    /**
     * <i>“Indicates whether or not verify apps is required.”</i>
     * 
     * @return property securityRequireVerifyApps
     */
    @Property(name="securityRequireVerifyApps")
    @JsonIgnore
    public Optional<Boolean> getSecurityRequireVerifyApps() {
        return Optional.ofNullable(securityRequireVerifyApps);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * securityRequireVerifyApps} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not verify apps is required.”</i>
     * 
     * @param securityRequireVerifyApps
     *            new value of {@code securityRequireVerifyApps} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code securityRequireVerifyApps} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withSecurityRequireVerifyApps(Boolean securityRequireVerifyApps) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("securityRequireVerifyApps");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.securityRequireVerifyApps = securityRequireVerifyApps;
        return _x;
    }

    /**
     * <i>“Indicates whether or the status bar is disabled, including notifications, quick
     * settings and other screen overlays.”</i>
     * 
     * @return property statusBarBlocked
     */
    @Property(name="statusBarBlocked")
    @JsonIgnore
    public Optional<Boolean> getStatusBarBlocked() {
        return Optional.ofNullable(statusBarBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code statusBarBlocked}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or the status bar is disabled, including notifications, quick
     * settings and other screen overlays.”</i>
     * 
     * @param statusBarBlocked
     *            new value of {@code statusBarBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code statusBarBlocked} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withStatusBarBlocked(Boolean statusBarBlocked) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("statusBarBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.statusBarBlocked = statusBarBlocked;
        return _x;
    }

    /**
     * <i>“List of modes in which the device's display will stay powered-on. This
     * collection can contain a maximum of 4 elements.”</i>
     * 
     * @return property stayOnModes
     */
    @Property(name="stayOnModes")
    @JsonIgnore
    public CollectionPage<AndroidDeviceOwnerBatteryPluggedMode> getStayOnModes() {
        return new CollectionPage<AndroidDeviceOwnerBatteryPluggedMode>(contextPath, AndroidDeviceOwnerBatteryPluggedMode.class, stayOnModes, Optional.ofNullable(stayOnModesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of modes in which the device's display will stay powered-on. This
     * collection can contain a maximum of 4 elements.”</i>
     * 
     * @return property stayOnModes
     */
    @Property(name="stayOnModes")
    @JsonIgnore
    public CollectionPage<AndroidDeviceOwnerBatteryPluggedMode> getStayOnModes(HttpRequestOptions options) {
        return new CollectionPage<AndroidDeviceOwnerBatteryPluggedMode>(contextPath, AndroidDeviceOwnerBatteryPluggedMode.class, stayOnModes, Optional.ofNullable(stayOnModesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    /**
     * <i>“Indicates whether or not to allow USB mass storage.”</i>
     * 
     * @return property storageAllowUsb
     */
    @Property(name="storageAllowUsb")
    @JsonIgnore
    public Optional<Boolean> getStorageAllowUsb() {
        return Optional.ofNullable(storageAllowUsb);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code storageAllowUsb}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to allow USB mass storage.”</i>
     * 
     * @param storageAllowUsb
     *            new value of {@code storageAllowUsb} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code storageAllowUsb} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withStorageAllowUsb(Boolean storageAllowUsb) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("storageAllowUsb");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.storageAllowUsb = storageAllowUsb;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block external media.”</i>
     * 
     * @return property storageBlockExternalMedia
     */
    @Property(name="storageBlockExternalMedia")
    @JsonIgnore
    public Optional<Boolean> getStorageBlockExternalMedia() {
        return Optional.ofNullable(storageBlockExternalMedia);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * storageBlockExternalMedia} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block external media.”</i>
     * 
     * @param storageBlockExternalMedia
     *            new value of {@code storageBlockExternalMedia} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code storageBlockExternalMedia} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withStorageBlockExternalMedia(Boolean storageBlockExternalMedia) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("storageBlockExternalMedia");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.storageBlockExternalMedia = storageBlockExternalMedia;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block USB file transfer.”</i>
     * 
     * @return property storageBlockUsbFileTransfer
     */
    @Property(name="storageBlockUsbFileTransfer")
    @JsonIgnore
    public Optional<Boolean> getStorageBlockUsbFileTransfer() {
        return Optional.ofNullable(storageBlockUsbFileTransfer);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * storageBlockUsbFileTransfer} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block USB file transfer.”</i>
     * 
     * @param storageBlockUsbFileTransfer
     *            new value of {@code storageBlockUsbFileTransfer} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code storageBlockUsbFileTransfer} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withStorageBlockUsbFileTransfer(Boolean storageBlockUsbFileTransfer) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("storageBlockUsbFileTransfer");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.storageBlockUsbFileTransfer = storageBlockUsbFileTransfer;
        return _x;
    }

    /**
     * <i>“Indicates the number of minutes after midnight that the system update window
     * starts. Valid values 0 to 1440”</i>
     * 
     * @return property systemUpdateWindowStartMinutesAfterMidnight
     */
    @Property(name="systemUpdateWindowStartMinutesAfterMidnight")
    @JsonIgnore
    public Optional<Integer> getSystemUpdateWindowStartMinutesAfterMidnight() {
        return Optional.ofNullable(systemUpdateWindowStartMinutesAfterMidnight);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * systemUpdateWindowStartMinutesAfterMidnight} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates the number of minutes after midnight that the system update window
     * starts. Valid values 0 to 1440”</i>
     * 
     * @param systemUpdateWindowStartMinutesAfterMidnight
     *            new value of {@code systemUpdateWindowStartMinutesAfterMidnight} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code systemUpdateWindowStartMinutesAfterMidnight} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withSystemUpdateWindowStartMinutesAfterMidnight(Integer systemUpdateWindowStartMinutesAfterMidnight) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("systemUpdateWindowStartMinutesAfterMidnight");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.systemUpdateWindowStartMinutesAfterMidnight = systemUpdateWindowStartMinutesAfterMidnight;
        return _x;
    }

    /**
     * <i>“Indicates the number of minutes after midnight that the system update window
     * ends. Valid values 0 to 1440”</i>
     * 
     * @return property systemUpdateWindowEndMinutesAfterMidnight
     */
    @Property(name="systemUpdateWindowEndMinutesAfterMidnight")
    @JsonIgnore
    public Optional<Integer> getSystemUpdateWindowEndMinutesAfterMidnight() {
        return Optional.ofNullable(systemUpdateWindowEndMinutesAfterMidnight);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * systemUpdateWindowEndMinutesAfterMidnight} field changed. Field description
     * below. The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates the number of minutes after midnight that the system update window
     * ends. Valid values 0 to 1440”</i>
     * 
     * @param systemUpdateWindowEndMinutesAfterMidnight
     *            new value of {@code systemUpdateWindowEndMinutesAfterMidnight} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code systemUpdateWindowEndMinutesAfterMidnight} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withSystemUpdateWindowEndMinutesAfterMidnight(Integer systemUpdateWindowEndMinutesAfterMidnight) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("systemUpdateWindowEndMinutesAfterMidnight");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.systemUpdateWindowEndMinutesAfterMidnight = systemUpdateWindowEndMinutesAfterMidnight;
        return _x;
    }

    /**
     * <i>“The type of system update configuration.”</i>
     * 
     * @return property systemUpdateInstallType
     */
    @Property(name="systemUpdateInstallType")
    @JsonIgnore
    public Optional<AndroidDeviceOwnerSystemUpdateInstallType> getSystemUpdateInstallType() {
        return Optional.ofNullable(systemUpdateInstallType);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * systemUpdateInstallType} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“The type of system update configuration.”</i>
     * 
     * @param systemUpdateInstallType
     *            new value of {@code systemUpdateInstallType} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code systemUpdateInstallType} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withSystemUpdateInstallType(AndroidDeviceOwnerSystemUpdateInstallType systemUpdateInstallType) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("systemUpdateInstallType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.systemUpdateInstallType = systemUpdateInstallType;
        return _x;
    }

    /**
     * <i>“Whether or not to block Android system prompt windows, like toasts, phone
     * activities, and system alerts.”</i>
     * 
     * @return property systemWindowsBlocked
     */
    @Property(name="systemWindowsBlocked")
    @JsonIgnore
    public Optional<Boolean> getSystemWindowsBlocked() {
        return Optional.ofNullable(systemWindowsBlocked);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * systemWindowsBlocked} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Whether or not to block Android system prompt windows, like toasts, phone
     * activities, and system alerts.”</i>
     * 
     * @param systemWindowsBlocked
     *            new value of {@code systemWindowsBlocked} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code systemWindowsBlocked} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withSystemWindowsBlocked(Boolean systemWindowsBlocked) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("systemWindowsBlocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.systemWindowsBlocked = systemWindowsBlocked;
        return _x;
    }

    /**
     * <i>“Indicates whether or not adding users and profiles is disabled.”</i>
     * 
     * @return property usersBlockAdd
     */
    @Property(name="usersBlockAdd")
    @JsonIgnore
    public Optional<Boolean> getUsersBlockAdd() {
        return Optional.ofNullable(usersBlockAdd);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code usersBlockAdd}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not adding users and profiles is disabled.”</i>
     * 
     * @param usersBlockAdd
     *            new value of {@code usersBlockAdd} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code usersBlockAdd} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withUsersBlockAdd(Boolean usersBlockAdd) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("usersBlockAdd");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.usersBlockAdd = usersBlockAdd;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to disable removing other users from the device.”</i>
     * 
     * @return property usersBlockRemove
     */
    @Property(name="usersBlockRemove")
    @JsonIgnore
    public Optional<Boolean> getUsersBlockRemove() {
        return Optional.ofNullable(usersBlockRemove);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code usersBlockRemove}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Indicates whether or not to disable removing other users from the device.”</i>
     * 
     * @param usersBlockRemove
     *            new value of {@code usersBlockRemove} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code usersBlockRemove} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withUsersBlockRemove(Boolean usersBlockRemove) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("usersBlockRemove");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.usersBlockRemove = usersBlockRemove;
        return _x;
    }

    /**
     * <i>“Indicates whether or not adjusting the master volume is disabled.”</i>
     * 
     * @return property volumeBlockAdjustment
     */
    @Property(name="volumeBlockAdjustment")
    @JsonIgnore
    public Optional<Boolean> getVolumeBlockAdjustment() {
        return Optional.ofNullable(volumeBlockAdjustment);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * volumeBlockAdjustment} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not adjusting the master volume is disabled.”</i>
     * 
     * @param volumeBlockAdjustment
     *            new value of {@code volumeBlockAdjustment} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code volumeBlockAdjustment} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withVolumeBlockAdjustment(Boolean volumeBlockAdjustment) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("volumeBlockAdjustment");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.volumeBlockAdjustment = volumeBlockAdjustment;
        return _x;
    }

    /**
     * <i>“If an always on VPN package name is specified, whether or not to lock network
     * traffic when that VPN is disconnected.”</i>
     * 
     * @return property vpnAlwaysOnLockdownMode
     */
    @Property(name="vpnAlwaysOnLockdownMode")
    @JsonIgnore
    public Optional<Boolean> getVpnAlwaysOnLockdownMode() {
        return Optional.ofNullable(vpnAlwaysOnLockdownMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * vpnAlwaysOnLockdownMode} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“If an always on VPN package name is specified, whether or not to lock network
     * traffic when that VPN is disconnected.”</i>
     * 
     * @param vpnAlwaysOnLockdownMode
     *            new value of {@code vpnAlwaysOnLockdownMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code vpnAlwaysOnLockdownMode} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withVpnAlwaysOnLockdownMode(Boolean vpnAlwaysOnLockdownMode) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("vpnAlwaysOnLockdownMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.vpnAlwaysOnLockdownMode = vpnAlwaysOnLockdownMode;
        return _x;
    }

    /**
     * <i>“Android app package name for app that will handle an always-on VPN connection.”</i>
     * 
     * @return property vpnAlwaysOnPackageIdentifier
     */
    @Property(name="vpnAlwaysOnPackageIdentifier")
    @JsonIgnore
    public Optional<String> getVpnAlwaysOnPackageIdentifier() {
        return Optional.ofNullable(vpnAlwaysOnPackageIdentifier);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * vpnAlwaysOnPackageIdentifier} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Android app package name for app that will handle an always-on VPN connection.”</i>
     * 
     * @param vpnAlwaysOnPackageIdentifier
     *            new value of {@code vpnAlwaysOnPackageIdentifier} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code vpnAlwaysOnPackageIdentifier} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withVpnAlwaysOnPackageIdentifier(String vpnAlwaysOnPackageIdentifier) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("vpnAlwaysOnPackageIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.vpnAlwaysOnPackageIdentifier = vpnAlwaysOnPackageIdentifier;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from editing the wifi connection
     * settings.”</i>
     * 
     * @return property wifiBlockEditConfigurations
     */
    @Property(name="wifiBlockEditConfigurations")
    @JsonIgnore
    public Optional<Boolean> getWifiBlockEditConfigurations() {
        return Optional.ofNullable(wifiBlockEditConfigurations);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * wifiBlockEditConfigurations} field changed. Field description below. The field
     * name is also added to an internal map of changed fields in the returned object
     * so that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from editing the wifi connection
     * settings.”</i>
     * 
     * @param wifiBlockEditConfigurations
     *            new value of {@code wifiBlockEditConfigurations} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wifiBlockEditConfigurations} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withWifiBlockEditConfigurations(Boolean wifiBlockEditConfigurations) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("wifiBlockEditConfigurations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.wifiBlockEditConfigurations = wifiBlockEditConfigurations;
        return _x;
    }

    /**
     * <i>“Indicates whether or not to block the user from editing just the networks
     * defined by the policy.”</i>
     * 
     * @return property wifiBlockEditPolicyDefinedConfigurations
     */
    @Property(name="wifiBlockEditPolicyDefinedConfigurations")
    @JsonIgnore
    public Optional<Boolean> getWifiBlockEditPolicyDefinedConfigurations() {
        return Optional.ofNullable(wifiBlockEditPolicyDefinedConfigurations);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * wifiBlockEditPolicyDefinedConfigurations} field changed. Field description below
     * . The field name is also added to an internal map of changed fields in the
     * returned object so that when {@code this.patch()} is called (if available)on the
     * returned object only the changed fields are submitted.
     * <p>
     * <i>“Indicates whether or not to block the user from editing just the networks
     * defined by the policy.”</i>
     * 
     * @param wifiBlockEditPolicyDefinedConfigurations
     *            new value of {@code wifiBlockEditPolicyDefinedConfigurations} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code wifiBlockEditPolicyDefinedConfigurations} field changed
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration withWifiBlockEditPolicyDefinedConfigurations(Boolean wifiBlockEditPolicyDefinedConfigurations) {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = changedFields.add("wifiBlockEditPolicyDefinedConfigurations");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerGeneralDeviceConfiguration");
        _x.wifiBlockEditPolicyDefinedConfigurations = wifiBlockEditPolicyDefinedConfigurations;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidDeviceOwnerGeneralDeviceConfiguration put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AndroidDeviceOwnerGeneralDeviceConfiguration _copy() {
        AndroidDeviceOwnerGeneralDeviceConfiguration _x = new AndroidDeviceOwnerGeneralDeviceConfiguration();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.roleScopeTagIds = roleScopeTagIds;
        _x.supportsScopeTags = supportsScopeTags;
        _x.deviceManagementApplicabilityRuleOsEdition = deviceManagementApplicabilityRuleOsEdition;
        _x.deviceManagementApplicabilityRuleOsVersion = deviceManagementApplicabilityRuleOsVersion;
        _x.deviceManagementApplicabilityRuleDeviceMode = deviceManagementApplicabilityRuleDeviceMode;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.version = version;
        _x.accountsBlockModification = accountsBlockModification;
        _x.appsAllowInstallFromUnknownSources = appsAllowInstallFromUnknownSources;
        _x.appsAutoUpdatePolicy = appsAutoUpdatePolicy;
        _x.appsDefaultPermissionPolicy = appsDefaultPermissionPolicy;
        _x.appsRecommendSkippingFirstUseHints = appsRecommendSkippingFirstUseHints;
        _x.bluetoothBlockConfiguration = bluetoothBlockConfiguration;
        _x.bluetoothBlockContactSharing = bluetoothBlockContactSharing;
        _x.cameraBlocked = cameraBlocked;
        _x.cellularBlockWiFiTethering = cellularBlockWiFiTethering;
        _x.certificateCredentialConfigurationDisabled = certificateCredentialConfigurationDisabled;
        _x.microsoftLauncherConfigurationEnabled = microsoftLauncherConfigurationEnabled;
        _x.microsoftLauncherCustomWallpaperEnabled = microsoftLauncherCustomWallpaperEnabled;
        _x.microsoftLauncherCustomWallpaperImageUrl = microsoftLauncherCustomWallpaperImageUrl;
        _x.microsoftLauncherCustomWallpaperAllowUserModification = microsoftLauncherCustomWallpaperAllowUserModification;
        _x.microsoftLauncherFeedEnabled = microsoftLauncherFeedEnabled;
        _x.microsoftLauncherFeedAllowUserModification = microsoftLauncherFeedAllowUserModification;
        _x.microsoftLauncherDockPresenceConfiguration = microsoftLauncherDockPresenceConfiguration;
        _x.microsoftLauncherDockPresenceAllowUserModification = microsoftLauncherDockPresenceAllowUserModification;
        _x.microsoftLauncherSearchBarPlacementConfiguration = microsoftLauncherSearchBarPlacementConfiguration;
        _x.enrollmentProfile = enrollmentProfile;
        _x.dataRoamingBlocked = dataRoamingBlocked;
        _x.dateTimeConfigurationBlocked = dateTimeConfigurationBlocked;
        _x.factoryResetDeviceAdministratorEmails = factoryResetDeviceAdministratorEmails;
        _x.factoryResetBlocked = factoryResetBlocked;
        _x.globalProxy = globalProxy;
        _x.googleAccountsBlocked = googleAccountsBlocked;
        _x.kioskModeScreenSaverConfigurationEnabled = kioskModeScreenSaverConfigurationEnabled;
        _x.kioskModeScreenSaverImageUrl = kioskModeScreenSaverImageUrl;
        _x.kioskModeScreenSaverDisplayTimeInSeconds = kioskModeScreenSaverDisplayTimeInSeconds;
        _x.kioskModeScreenSaverStartDelayInSeconds = kioskModeScreenSaverStartDelayInSeconds;
        _x.kioskModeScreenSaverDetectMediaDisabled = kioskModeScreenSaverDetectMediaDisabled;
        _x.kioskModeApps = kioskModeApps;
        _x.kioskModeWallpaperUrl = kioskModeWallpaperUrl;
        _x.kioskModeExitCode = kioskModeExitCode;
        _x.kioskModeVirtualHomeButtonEnabled = kioskModeVirtualHomeButtonEnabled;
        _x.kioskModeVirtualHomeButtonType = kioskModeVirtualHomeButtonType;
        _x.kioskModeBluetoothConfigurationEnabled = kioskModeBluetoothConfigurationEnabled;
        _x.kioskModeWiFiConfigurationEnabled = kioskModeWiFiConfigurationEnabled;
        _x.kioskModeFlashlightConfigurationEnabled = kioskModeFlashlightConfigurationEnabled;
        _x.kioskModeMediaVolumeConfigurationEnabled = kioskModeMediaVolumeConfigurationEnabled;
        _x.kioskModeShowDeviceInfo = kioskModeShowDeviceInfo;
        _x.kioskModeManagedSettingsEntryDisabled = kioskModeManagedSettingsEntryDisabled;
        _x.kioskModeDebugMenuEasyAccessEnabled = kioskModeDebugMenuEasyAccessEnabled;
        _x.kioskModeShowAppNotificationBadge = kioskModeShowAppNotificationBadge;
        _x.kioskModeScreenOrientation = kioskModeScreenOrientation;
        _x.kioskModeIconSize = kioskModeIconSize;
        _x.kioskModeFolderIcon = kioskModeFolderIcon;
        _x.kioskModeWifiAllowedSsids = kioskModeWifiAllowedSsids;
        _x.microphoneForceMute = microphoneForceMute;
        _x.networkEscapeHatchAllowed = networkEscapeHatchAllowed;
        _x.nfcBlockOutgoingBeam = nfcBlockOutgoingBeam;
        _x.passwordBlockKeyguard = passwordBlockKeyguard;
        _x.passwordBlockKeyguardFeatures = passwordBlockKeyguardFeatures;
        _x.passwordExpirationDays = passwordExpirationDays;
        _x.passwordMinimumLength = passwordMinimumLength;
        _x.passwordMinimumLetterCharacters = passwordMinimumLetterCharacters;
        _x.passwordMinimumLowerCaseCharacters = passwordMinimumLowerCaseCharacters;
        _x.passwordMinimumNonLetterCharacters = passwordMinimumNonLetterCharacters;
        _x.passwordMinimumNumericCharacters = passwordMinimumNumericCharacters;
        _x.passwordMinimumSymbolCharacters = passwordMinimumSymbolCharacters;
        _x.passwordMinimumUpperCaseCharacters = passwordMinimumUpperCaseCharacters;
        _x.passwordMinutesOfInactivityBeforeScreenTimeout = passwordMinutesOfInactivityBeforeScreenTimeout;
        _x.passwordPreviousPasswordCountToBlock = passwordPreviousPasswordCountToBlock;
        _x.passwordRequiredType = passwordRequiredType;
        _x.passwordSignInFailureCountBeforeFactoryReset = passwordSignInFailureCountBeforeFactoryReset;
        _x.playStoreMode = playStoreMode;
        _x.safeBootBlocked = safeBootBlocked;
        _x.screenCaptureBlocked = screenCaptureBlocked;
        _x.securityAllowDebuggingFeatures = securityAllowDebuggingFeatures;
        _x.securityRequireVerifyApps = securityRequireVerifyApps;
        _x.statusBarBlocked = statusBarBlocked;
        _x.stayOnModes = stayOnModes;
        _x.storageAllowUsb = storageAllowUsb;
        _x.storageBlockExternalMedia = storageBlockExternalMedia;
        _x.storageBlockUsbFileTransfer = storageBlockUsbFileTransfer;
        _x.systemUpdateWindowStartMinutesAfterMidnight = systemUpdateWindowStartMinutesAfterMidnight;
        _x.systemUpdateWindowEndMinutesAfterMidnight = systemUpdateWindowEndMinutesAfterMidnight;
        _x.systemUpdateInstallType = systemUpdateInstallType;
        _x.systemWindowsBlocked = systemWindowsBlocked;
        _x.usersBlockAdd = usersBlockAdd;
        _x.usersBlockRemove = usersBlockRemove;
        _x.volumeBlockAdjustment = volumeBlockAdjustment;
        _x.vpnAlwaysOnLockdownMode = vpnAlwaysOnLockdownMode;
        _x.vpnAlwaysOnPackageIdentifier = vpnAlwaysOnPackageIdentifier;
        _x.wifiBlockEditConfigurations = wifiBlockEditConfigurations;
        _x.wifiBlockEditPolicyDefinedConfigurations = wifiBlockEditPolicyDefinedConfigurations;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidDeviceOwnerGeneralDeviceConfiguration[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append(", ");
        b.append("supportsScopeTags=");
        b.append(this.supportsScopeTags);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsEdition=");
        b.append(this.deviceManagementApplicabilityRuleOsEdition);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleOsVersion=");
        b.append(this.deviceManagementApplicabilityRuleOsVersion);
        b.append(", ");
        b.append("deviceManagementApplicabilityRuleDeviceMode=");
        b.append(this.deviceManagementApplicabilityRuleDeviceMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("version=");
        b.append(this.version);
        b.append(", ");
        b.append("accountsBlockModification=");
        b.append(this.accountsBlockModification);
        b.append(", ");
        b.append("appsAllowInstallFromUnknownSources=");
        b.append(this.appsAllowInstallFromUnknownSources);
        b.append(", ");
        b.append("appsAutoUpdatePolicy=");
        b.append(this.appsAutoUpdatePolicy);
        b.append(", ");
        b.append("appsDefaultPermissionPolicy=");
        b.append(this.appsDefaultPermissionPolicy);
        b.append(", ");
        b.append("appsRecommendSkippingFirstUseHints=");
        b.append(this.appsRecommendSkippingFirstUseHints);
        b.append(", ");
        b.append("bluetoothBlockConfiguration=");
        b.append(this.bluetoothBlockConfiguration);
        b.append(", ");
        b.append("bluetoothBlockContactSharing=");
        b.append(this.bluetoothBlockContactSharing);
        b.append(", ");
        b.append("cameraBlocked=");
        b.append(this.cameraBlocked);
        b.append(", ");
        b.append("cellularBlockWiFiTethering=");
        b.append(this.cellularBlockWiFiTethering);
        b.append(", ");
        b.append("certificateCredentialConfigurationDisabled=");
        b.append(this.certificateCredentialConfigurationDisabled);
        b.append(", ");
        b.append("microsoftLauncherConfigurationEnabled=");
        b.append(this.microsoftLauncherConfigurationEnabled);
        b.append(", ");
        b.append("microsoftLauncherCustomWallpaperEnabled=");
        b.append(this.microsoftLauncherCustomWallpaperEnabled);
        b.append(", ");
        b.append("microsoftLauncherCustomWallpaperImageUrl=");
        b.append(this.microsoftLauncherCustomWallpaperImageUrl);
        b.append(", ");
        b.append("microsoftLauncherCustomWallpaperAllowUserModification=");
        b.append(this.microsoftLauncherCustomWallpaperAllowUserModification);
        b.append(", ");
        b.append("microsoftLauncherFeedEnabled=");
        b.append(this.microsoftLauncherFeedEnabled);
        b.append(", ");
        b.append("microsoftLauncherFeedAllowUserModification=");
        b.append(this.microsoftLauncherFeedAllowUserModification);
        b.append(", ");
        b.append("microsoftLauncherDockPresenceConfiguration=");
        b.append(this.microsoftLauncherDockPresenceConfiguration);
        b.append(", ");
        b.append("microsoftLauncherDockPresenceAllowUserModification=");
        b.append(this.microsoftLauncherDockPresenceAllowUserModification);
        b.append(", ");
        b.append("microsoftLauncherSearchBarPlacementConfiguration=");
        b.append(this.microsoftLauncherSearchBarPlacementConfiguration);
        b.append(", ");
        b.append("enrollmentProfile=");
        b.append(this.enrollmentProfile);
        b.append(", ");
        b.append("dataRoamingBlocked=");
        b.append(this.dataRoamingBlocked);
        b.append(", ");
        b.append("dateTimeConfigurationBlocked=");
        b.append(this.dateTimeConfigurationBlocked);
        b.append(", ");
        b.append("factoryResetDeviceAdministratorEmails=");
        b.append(this.factoryResetDeviceAdministratorEmails);
        b.append(", ");
        b.append("factoryResetBlocked=");
        b.append(this.factoryResetBlocked);
        b.append(", ");
        b.append("globalProxy=");
        b.append(this.globalProxy);
        b.append(", ");
        b.append("googleAccountsBlocked=");
        b.append(this.googleAccountsBlocked);
        b.append(", ");
        b.append("kioskModeScreenSaverConfigurationEnabled=");
        b.append(this.kioskModeScreenSaverConfigurationEnabled);
        b.append(", ");
        b.append("kioskModeScreenSaverImageUrl=");
        b.append(this.kioskModeScreenSaverImageUrl);
        b.append(", ");
        b.append("kioskModeScreenSaverDisplayTimeInSeconds=");
        b.append(this.kioskModeScreenSaverDisplayTimeInSeconds);
        b.append(", ");
        b.append("kioskModeScreenSaverStartDelayInSeconds=");
        b.append(this.kioskModeScreenSaverStartDelayInSeconds);
        b.append(", ");
        b.append("kioskModeScreenSaverDetectMediaDisabled=");
        b.append(this.kioskModeScreenSaverDetectMediaDisabled);
        b.append(", ");
        b.append("kioskModeApps=");
        b.append(this.kioskModeApps);
        b.append(", ");
        b.append("kioskModeWallpaperUrl=");
        b.append(this.kioskModeWallpaperUrl);
        b.append(", ");
        b.append("kioskModeExitCode=");
        b.append(this.kioskModeExitCode);
        b.append(", ");
        b.append("kioskModeVirtualHomeButtonEnabled=");
        b.append(this.kioskModeVirtualHomeButtonEnabled);
        b.append(", ");
        b.append("kioskModeVirtualHomeButtonType=");
        b.append(this.kioskModeVirtualHomeButtonType);
        b.append(", ");
        b.append("kioskModeBluetoothConfigurationEnabled=");
        b.append(this.kioskModeBluetoothConfigurationEnabled);
        b.append(", ");
        b.append("kioskModeWiFiConfigurationEnabled=");
        b.append(this.kioskModeWiFiConfigurationEnabled);
        b.append(", ");
        b.append("kioskModeFlashlightConfigurationEnabled=");
        b.append(this.kioskModeFlashlightConfigurationEnabled);
        b.append(", ");
        b.append("kioskModeMediaVolumeConfigurationEnabled=");
        b.append(this.kioskModeMediaVolumeConfigurationEnabled);
        b.append(", ");
        b.append("kioskModeShowDeviceInfo=");
        b.append(this.kioskModeShowDeviceInfo);
        b.append(", ");
        b.append("kioskModeManagedSettingsEntryDisabled=");
        b.append(this.kioskModeManagedSettingsEntryDisabled);
        b.append(", ");
        b.append("kioskModeDebugMenuEasyAccessEnabled=");
        b.append(this.kioskModeDebugMenuEasyAccessEnabled);
        b.append(", ");
        b.append("kioskModeShowAppNotificationBadge=");
        b.append(this.kioskModeShowAppNotificationBadge);
        b.append(", ");
        b.append("kioskModeScreenOrientation=");
        b.append(this.kioskModeScreenOrientation);
        b.append(", ");
        b.append("kioskModeIconSize=");
        b.append(this.kioskModeIconSize);
        b.append(", ");
        b.append("kioskModeFolderIcon=");
        b.append(this.kioskModeFolderIcon);
        b.append(", ");
        b.append("kioskModeWifiAllowedSsids=");
        b.append(this.kioskModeWifiAllowedSsids);
        b.append(", ");
        b.append("microphoneForceMute=");
        b.append(this.microphoneForceMute);
        b.append(", ");
        b.append("networkEscapeHatchAllowed=");
        b.append(this.networkEscapeHatchAllowed);
        b.append(", ");
        b.append("nfcBlockOutgoingBeam=");
        b.append(this.nfcBlockOutgoingBeam);
        b.append(", ");
        b.append("passwordBlockKeyguard=");
        b.append(this.passwordBlockKeyguard);
        b.append(", ");
        b.append("passwordBlockKeyguardFeatures=");
        b.append(this.passwordBlockKeyguardFeatures);
        b.append(", ");
        b.append("passwordExpirationDays=");
        b.append(this.passwordExpirationDays);
        b.append(", ");
        b.append("passwordMinimumLength=");
        b.append(this.passwordMinimumLength);
        b.append(", ");
        b.append("passwordMinimumLetterCharacters=");
        b.append(this.passwordMinimumLetterCharacters);
        b.append(", ");
        b.append("passwordMinimumLowerCaseCharacters=");
        b.append(this.passwordMinimumLowerCaseCharacters);
        b.append(", ");
        b.append("passwordMinimumNonLetterCharacters=");
        b.append(this.passwordMinimumNonLetterCharacters);
        b.append(", ");
        b.append("passwordMinimumNumericCharacters=");
        b.append(this.passwordMinimumNumericCharacters);
        b.append(", ");
        b.append("passwordMinimumSymbolCharacters=");
        b.append(this.passwordMinimumSymbolCharacters);
        b.append(", ");
        b.append("passwordMinimumUpperCaseCharacters=");
        b.append(this.passwordMinimumUpperCaseCharacters);
        b.append(", ");
        b.append("passwordMinutesOfInactivityBeforeScreenTimeout=");
        b.append(this.passwordMinutesOfInactivityBeforeScreenTimeout);
        b.append(", ");
        b.append("passwordPreviousPasswordCountToBlock=");
        b.append(this.passwordPreviousPasswordCountToBlock);
        b.append(", ");
        b.append("passwordRequiredType=");
        b.append(this.passwordRequiredType);
        b.append(", ");
        b.append("passwordSignInFailureCountBeforeFactoryReset=");
        b.append(this.passwordSignInFailureCountBeforeFactoryReset);
        b.append(", ");
        b.append("playStoreMode=");
        b.append(this.playStoreMode);
        b.append(", ");
        b.append("safeBootBlocked=");
        b.append(this.safeBootBlocked);
        b.append(", ");
        b.append("screenCaptureBlocked=");
        b.append(this.screenCaptureBlocked);
        b.append(", ");
        b.append("securityAllowDebuggingFeatures=");
        b.append(this.securityAllowDebuggingFeatures);
        b.append(", ");
        b.append("securityRequireVerifyApps=");
        b.append(this.securityRequireVerifyApps);
        b.append(", ");
        b.append("statusBarBlocked=");
        b.append(this.statusBarBlocked);
        b.append(", ");
        b.append("stayOnModes=");
        b.append(this.stayOnModes);
        b.append(", ");
        b.append("storageAllowUsb=");
        b.append(this.storageAllowUsb);
        b.append(", ");
        b.append("storageBlockExternalMedia=");
        b.append(this.storageBlockExternalMedia);
        b.append(", ");
        b.append("storageBlockUsbFileTransfer=");
        b.append(this.storageBlockUsbFileTransfer);
        b.append(", ");
        b.append("systemUpdateWindowStartMinutesAfterMidnight=");
        b.append(this.systemUpdateWindowStartMinutesAfterMidnight);
        b.append(", ");
        b.append("systemUpdateWindowEndMinutesAfterMidnight=");
        b.append(this.systemUpdateWindowEndMinutesAfterMidnight);
        b.append(", ");
        b.append("systemUpdateInstallType=");
        b.append(this.systemUpdateInstallType);
        b.append(", ");
        b.append("systemWindowsBlocked=");
        b.append(this.systemWindowsBlocked);
        b.append(", ");
        b.append("usersBlockAdd=");
        b.append(this.usersBlockAdd);
        b.append(", ");
        b.append("usersBlockRemove=");
        b.append(this.usersBlockRemove);
        b.append(", ");
        b.append("volumeBlockAdjustment=");
        b.append(this.volumeBlockAdjustment);
        b.append(", ");
        b.append("vpnAlwaysOnLockdownMode=");
        b.append(this.vpnAlwaysOnLockdownMode);
        b.append(", ");
        b.append("vpnAlwaysOnPackageIdentifier=");
        b.append(this.vpnAlwaysOnPackageIdentifier);
        b.append(", ");
        b.append("wifiBlockEditConfigurations=");
        b.append(this.wifiBlockEditConfigurations);
        b.append(", ");
        b.append("wifiBlockEditPolicyDefinedConfigurations=");
        b.append(this.wifiBlockEditPolicyDefinedConfigurations);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
