package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.MimeContent;
import odata.msgraph.client.beta.enums.AndroidDeviceOwnerEnrollmentMode;


/**
 * <i>“Enrollment Profile used to enroll Android Enterprise devices using Google's
 * Cloud Management.”</i>
 */@JsonPropertyOrder({
    "@odata.type", 
    "accountId", 
    "displayName", 
    "description", 
    "enrollmentMode", 
    "createdDateTime", 
    "lastModifiedDateTime", 
    "tokenValue", 
    "tokenCreationDateTime", 
    "tokenExpirationDateTime", 
    "enrolledDeviceCount", 
    "qrCodeContent", 
    "qrCodeImage", 
    "roleScopeTagIds"})
@JsonInclude(Include.NON_NULL)
public class AndroidDeviceOwnerEnrollmentProfile extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.androidDeviceOwnerEnrollmentProfile";
    }

    @JsonProperty("accountId")
    protected String accountId;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("enrollmentMode")
    protected AndroidDeviceOwnerEnrollmentMode enrollmentMode;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("tokenValue")
    protected String tokenValue;

    @JsonProperty("tokenCreationDateTime")
    protected OffsetDateTime tokenCreationDateTime;

    @JsonProperty("tokenExpirationDateTime")
    protected OffsetDateTime tokenExpirationDateTime;

    @JsonProperty("enrolledDeviceCount")
    protected Integer enrolledDeviceCount;

    @JsonProperty("qrCodeContent")
    protected String qrCodeContent;

    @JsonProperty("qrCodeImage")
    protected MimeContent qrCodeImage;

    @JsonProperty("roleScopeTagIds")
    protected List<String> roleScopeTagIds;

    @JsonProperty("roleScopeTagIds@nextLink")
    protected String roleScopeTagIdsNextLink;

    protected AndroidDeviceOwnerEnrollmentProfile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAndroidDeviceOwnerEnrollmentProfile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String accountId;
        private String displayName;
        private String description;
        private AndroidDeviceOwnerEnrollmentMode enrollmentMode;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private String tokenValue;
        private OffsetDateTime tokenCreationDateTime;
        private OffsetDateTime tokenExpirationDateTime;
        private Integer enrolledDeviceCount;
        private String qrCodeContent;
        private MimeContent qrCodeImage;
        private List<String> roleScopeTagIds;
        private String roleScopeTagIdsNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        /**
         * <i>“Tenant GUID the enrollment profile belongs to.”</i>
         * 
         * @param accountId
         *            value of {@code accountId} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder accountId(String accountId) {
            this.accountId = accountId;
            this.changedFields = changedFields.add("accountId");
            return this;
        }

        /**
         * <i>“Display name for the enrollment profile.”</i>
         * 
         * @param displayName
         *            value of {@code displayName} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        /**
         * <i>“Description for the enrollment profile.”</i>
         * 
         * @param description
         *            value of {@code description} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        /**
         * <i>“The enrollment mode of devices that use this enrollment profile.”</i>
         * 
         * @param enrollmentMode
         *            value of {@code enrollmentMode} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enrollmentMode(AndroidDeviceOwnerEnrollmentMode enrollmentMode) {
            this.enrollmentMode = enrollmentMode;
            this.changedFields = changedFields.add("enrollmentMode");
            return this;
        }

        /**
         * <i>“Date time the enrollment profile was created.”</i>
         * 
         * @param createdDateTime
         *            value of {@code createdDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        /**
         * <i>“Date time the enrollment profile was last modified.”</i>
         * 
         * @param lastModifiedDateTime
         *            value of {@code lastModifiedDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        /**
         * <i>“Value of the most recently created token for this enrollment profile.”</i>
         * 
         * @param tokenValue
         *            value of {@code tokenValue} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tokenValue(String tokenValue) {
            this.tokenValue = tokenValue;
            this.changedFields = changedFields.add("tokenValue");
            return this;
        }

        /**
         * <i>“Date time the most recently created token was created.”</i>
         * 
         * @param tokenCreationDateTime
         *            value of {@code tokenCreationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tokenCreationDateTime(OffsetDateTime tokenCreationDateTime) {
            this.tokenCreationDateTime = tokenCreationDateTime;
            this.changedFields = changedFields.add("tokenCreationDateTime");
            return this;
        }

        /**
         * <i>“Date time the most recently created token will expire.”</i>
         * 
         * @param tokenExpirationDateTime
         *            value of {@code tokenExpirationDateTime} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder tokenExpirationDateTime(OffsetDateTime tokenExpirationDateTime) {
            this.tokenExpirationDateTime = tokenExpirationDateTime;
            this.changedFields = changedFields.add("tokenExpirationDateTime");
            return this;
        }

        /**
         * <i>“Total number of Android devices that have enrolled using this enrollment profile
         * .”</i>
         * 
         * @param enrolledDeviceCount
         *            value of {@code enrolledDeviceCount} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder enrolledDeviceCount(Integer enrolledDeviceCount) {
            this.enrolledDeviceCount = enrolledDeviceCount;
            this.changedFields = changedFields.add("enrolledDeviceCount");
            return this;
        }

        /**
         * <i>“String used to generate a QR code for the token.”</i>
         * 
         * @param qrCodeContent
         *            value of {@code qrCodeContent} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder qrCodeContent(String qrCodeContent) {
            this.qrCodeContent = qrCodeContent;
            this.changedFields = changedFields.add("qrCodeContent");
            return this;
        }

        /**
         * <i>“String used to generate a QR code for the token.”</i>
         * 
         * @param qrCodeImage
         *            value of {@code qrCodeImage} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder qrCodeImage(MimeContent qrCodeImage) {
            this.qrCodeImage = qrCodeImage;
            this.changedFields = changedFields.add("qrCodeImage");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(List<String> roleScopeTagIds) {
            this.roleScopeTagIds = roleScopeTagIds;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIds
         *            value of {@code roleScopeTagIds} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIds(String... roleScopeTagIds) {
            return roleScopeTagIds(Arrays.asList(roleScopeTagIds));
        }

        /**
         * <i>“List of Scope Tags for this Entity instance.”</i>
         * 
         * @param roleScopeTagIdsNextLink
         *            value of {@code roleScopeTagIds@nextLink} property (as defined in service metadata)
         * @return {@code this} (for method chaining)
         */
        public Builder roleScopeTagIdsNextLink(String roleScopeTagIdsNextLink) {
            this.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            this.changedFields = changedFields.add("roleScopeTagIds");
            return this;
        }

        public AndroidDeviceOwnerEnrollmentProfile build() {
            AndroidDeviceOwnerEnrollmentProfile _x = new AndroidDeviceOwnerEnrollmentProfile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.androidDeviceOwnerEnrollmentProfile";
            _x.id = id;
            _x.accountId = accountId;
            _x.displayName = displayName;
            _x.description = description;
            _x.enrollmentMode = enrollmentMode;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.tokenValue = tokenValue;
            _x.tokenCreationDateTime = tokenCreationDateTime;
            _x.tokenExpirationDateTime = tokenExpirationDateTime;
            _x.enrolledDeviceCount = enrolledDeviceCount;
            _x.qrCodeContent = qrCodeContent;
            _x.qrCodeImage = qrCodeImage;
            _x.roleScopeTagIds = roleScopeTagIds;
            _x.roleScopeTagIdsNextLink = roleScopeTagIdsNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    /**
     * <i>“Tenant GUID the enrollment profile belongs to.”</i>
     * 
     * @return property accountId
     */
    @Property(name="accountId")
    @JsonIgnore
    public Optional<String> getAccountId() {
        return Optional.ofNullable(accountId);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code accountId} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Tenant GUID the enrollment profile belongs to.”</i>
     * 
     * @param accountId
     *            new value of {@code accountId} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code accountId} field changed
     */
    public AndroidDeviceOwnerEnrollmentProfile withAccountId(String accountId) {
        AndroidDeviceOwnerEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("accountId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerEnrollmentProfile");
        _x.accountId = accountId;
        return _x;
    }

    /**
     * <i>“Display name for the enrollment profile.”</i>
     * 
     * @return property displayName
     */
    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code displayName}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Display name for the enrollment profile.”</i>
     * 
     * @param displayName
     *            new value of {@code displayName} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code displayName} field changed
     */
    public AndroidDeviceOwnerEnrollmentProfile withDisplayName(String displayName) {
        AndroidDeviceOwnerEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerEnrollmentProfile");
        _x.displayName = displayName;
        return _x;
    }

    /**
     * <i>“Description for the enrollment profile.”</i>
     * 
     * @return property description
     */
    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code description}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Description for the enrollment profile.”</i>
     * 
     * @param description
     *            new value of {@code description} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code description} field changed
     */
    public AndroidDeviceOwnerEnrollmentProfile withDescription(String description) {
        AndroidDeviceOwnerEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerEnrollmentProfile");
        _x.description = description;
        return _x;
    }

    /**
     * <i>“The enrollment mode of devices that use this enrollment profile.”</i>
     * 
     * @return property enrollmentMode
     */
    @Property(name="enrollmentMode")
    @JsonIgnore
    public Optional<AndroidDeviceOwnerEnrollmentMode> getEnrollmentMode() {
        return Optional.ofNullable(enrollmentMode);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code enrollmentMode}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“The enrollment mode of devices that use this enrollment profile.”</i>
     * 
     * @param enrollmentMode
     *            new value of {@code enrollmentMode} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enrollmentMode} field changed
     */
    public AndroidDeviceOwnerEnrollmentProfile withEnrollmentMode(AndroidDeviceOwnerEnrollmentMode enrollmentMode) {
        AndroidDeviceOwnerEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("enrollmentMode");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerEnrollmentProfile");
        _x.enrollmentMode = enrollmentMode;
        return _x;
    }

    /**
     * <i>“Date time the enrollment profile was created.”</i>
     * 
     * @return property createdDateTime
     */
    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code createdDateTime}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“Date time the enrollment profile was created.”</i>
     * 
     * @param createdDateTime
     *            new value of {@code createdDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code createdDateTime} field changed
     */
    public AndroidDeviceOwnerEnrollmentProfile withCreatedDateTime(OffsetDateTime createdDateTime) {
        AndroidDeviceOwnerEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerEnrollmentProfile");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    /**
     * <i>“Date time the enrollment profile was last modified.”</i>
     * 
     * @return property lastModifiedDateTime
     */
    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * lastModifiedDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Date time the enrollment profile was last modified.”</i>
     * 
     * @param lastModifiedDateTime
     *            new value of {@code lastModifiedDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code lastModifiedDateTime} field changed
     */
    public AndroidDeviceOwnerEnrollmentProfile withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        AndroidDeviceOwnerEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerEnrollmentProfile");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    /**
     * <i>“Value of the most recently created token for this enrollment profile.”</i>
     * 
     * @return property tokenValue
     */
    @Property(name="tokenValue")
    @JsonIgnore
    public Optional<String> getTokenValue() {
        return Optional.ofNullable(tokenValue);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code tokenValue} field
     * changed. Field description below. The field name is also added to an internal
     * map of changed fields in the returned object so that when {@code this.patch()}
     * is called (if available)on the returned object only the changed fields are
     * submitted.
     * <p>
     * <i>“Value of the most recently created token for this enrollment profile.”</i>
     * 
     * @param tokenValue
     *            new value of {@code tokenValue} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tokenValue} field changed
     */
    public AndroidDeviceOwnerEnrollmentProfile withTokenValue(String tokenValue) {
        AndroidDeviceOwnerEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("tokenValue");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerEnrollmentProfile");
        _x.tokenValue = tokenValue;
        return _x;
    }

    /**
     * <i>“Date time the most recently created token was created.”</i>
     * 
     * @return property tokenCreationDateTime
     */
    @Property(name="tokenCreationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getTokenCreationDateTime() {
        return Optional.ofNullable(tokenCreationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * tokenCreationDateTime} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Date time the most recently created token was created.”</i>
     * 
     * @param tokenCreationDateTime
     *            new value of {@code tokenCreationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tokenCreationDateTime} field changed
     */
    public AndroidDeviceOwnerEnrollmentProfile withTokenCreationDateTime(OffsetDateTime tokenCreationDateTime) {
        AndroidDeviceOwnerEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("tokenCreationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerEnrollmentProfile");
        _x.tokenCreationDateTime = tokenCreationDateTime;
        return _x;
    }

    /**
     * <i>“Date time the most recently created token will expire.”</i>
     * 
     * @return property tokenExpirationDateTime
     */
    @Property(name="tokenExpirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getTokenExpirationDateTime() {
        return Optional.ofNullable(tokenExpirationDateTime);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * tokenExpirationDateTime} field changed. Field description below. The field name
     * is also added to an internal map of changed fields in the returned object so
     * that when {@code this.patch()} is called (if available)on the returned object
     * only the changed fields are submitted.
     * <p>
     * <i>“Date time the most recently created token will expire.”</i>
     * 
     * @param tokenExpirationDateTime
     *            new value of {@code tokenExpirationDateTime} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code tokenExpirationDateTime} field changed
     */
    public AndroidDeviceOwnerEnrollmentProfile withTokenExpirationDateTime(OffsetDateTime tokenExpirationDateTime) {
        AndroidDeviceOwnerEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("tokenExpirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerEnrollmentProfile");
        _x.tokenExpirationDateTime = tokenExpirationDateTime;
        return _x;
    }

    /**
     * <i>“Total number of Android devices that have enrolled using this enrollment profile
     * .”</i>
     * 
     * @return property enrolledDeviceCount
     */
    @Property(name="enrolledDeviceCount")
    @JsonIgnore
    public Optional<Integer> getEnrolledDeviceCount() {
        return Optional.ofNullable(enrolledDeviceCount);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code
     * enrolledDeviceCount} field changed. Field description below. The field name is
     * also added to an internal map of changed fields in the returned object so that
     * when {@code this.patch()} is called (if available)on the returned object only
     * the changed fields are submitted.
     * <p>
     * <i>“Total number of Android devices that have enrolled using this enrollment profile
     * .”</i>
     * 
     * @param enrolledDeviceCount
     *            new value of {@code enrolledDeviceCount} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code enrolledDeviceCount} field changed
     */
    public AndroidDeviceOwnerEnrollmentProfile withEnrolledDeviceCount(Integer enrolledDeviceCount) {
        AndroidDeviceOwnerEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("enrolledDeviceCount");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerEnrollmentProfile");
        _x.enrolledDeviceCount = enrolledDeviceCount;
        return _x;
    }

    /**
     * <i>“String used to generate a QR code for the token.”</i>
     * 
     * @return property qrCodeContent
     */
    @Property(name="qrCodeContent")
    @JsonIgnore
    public Optional<String> getQrCodeContent() {
        return Optional.ofNullable(qrCodeContent);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code qrCodeContent}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“String used to generate a QR code for the token.”</i>
     * 
     * @param qrCodeContent
     *            new value of {@code qrCodeContent} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code qrCodeContent} field changed
     */
    public AndroidDeviceOwnerEnrollmentProfile withQrCodeContent(String qrCodeContent) {
        AndroidDeviceOwnerEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("qrCodeContent");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerEnrollmentProfile");
        _x.qrCodeContent = qrCodeContent;
        return _x;
    }

    /**
     * <i>“String used to generate a QR code for the token.”</i>
     * 
     * @return property qrCodeImage
     */
    @Property(name="qrCodeImage")
    @JsonIgnore
    public Optional<MimeContent> getQrCodeImage() {
        return Optional.ofNullable(qrCodeImage);
    }

    /**
     * Returns an immutable copy of {@code this} with just the {@code qrCodeImage}
     * field changed. Field description below. The field name is also added to an
     * internal map of changed fields in the returned object so that when {@code this.
     * patch()} is called (if available)on the returned object only the changed fields
     * are submitted.
     * <p>
     * <i>“String used to generate a QR code for the token.”</i>
     * 
     * @param qrCodeImage
     *            new value of {@code qrCodeImage} field (as defined in service metadata)
     * @return immutable copy of {@code this} with just the {@code qrCodeImage} field changed
     */
    public AndroidDeviceOwnerEnrollmentProfile withQrCodeImage(MimeContent qrCodeImage) {
        AndroidDeviceOwnerEnrollmentProfile _x = _copy();
        _x.changedFields = changedFields.add("qrCodeImage");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.androidDeviceOwnerEnrollmentProfile");
        _x.qrCodeImage = qrCodeImage;
        return _x;
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds() {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    /**
     * <i>“List of Scope Tags for this Entity instance.”</i>
     * 
     * @return property roleScopeTagIds
     */
    @Property(name="roleScopeTagIds")
    @JsonIgnore
    public CollectionPage<String> getRoleScopeTagIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, roleScopeTagIds, Optional.ofNullable(roleScopeTagIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidDeviceOwnerEnrollmentProfile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AndroidDeviceOwnerEnrollmentProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AndroidDeviceOwnerEnrollmentProfile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AndroidDeviceOwnerEnrollmentProfile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AndroidDeviceOwnerEnrollmentProfile _copy() {
        AndroidDeviceOwnerEnrollmentProfile _x = new AndroidDeviceOwnerEnrollmentProfile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.accountId = accountId;
        _x.displayName = displayName;
        _x.description = description;
        _x.enrollmentMode = enrollmentMode;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.tokenValue = tokenValue;
        _x.tokenCreationDateTime = tokenCreationDateTime;
        _x.tokenExpirationDateTime = tokenExpirationDateTime;
        _x.enrolledDeviceCount = enrolledDeviceCount;
        _x.qrCodeContent = qrCodeContent;
        _x.qrCodeImage = qrCodeImage;
        _x.roleScopeTagIds = roleScopeTagIds;
        return _x;
    }

    @Action(name = "revokeToken")
    @JsonIgnore
    public ActionRequestNoReturn revokeToken() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.revokeToken"), _parameters);
    }

    @Action(name = "createToken")
    @JsonIgnore
    public ActionRequestNoReturn createToken(Integer tokenValidityInSeconds) {
        Preconditions.checkNotNull(tokenValidityInSeconds, "tokenValidityInSeconds cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("tokenValidityInSeconds", "Edm.Int32", tokenValidityInSeconds)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.createToken"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AndroidDeviceOwnerEnrollmentProfile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("accountId=");
        b.append(this.accountId);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("enrollmentMode=");
        b.append(this.enrollmentMode);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("tokenValue=");
        b.append(this.tokenValue);
        b.append(", ");
        b.append("tokenCreationDateTime=");
        b.append(this.tokenCreationDateTime);
        b.append(", ");
        b.append("tokenExpirationDateTime=");
        b.append(this.tokenExpirationDateTime);
        b.append(", ");
        b.append("enrolledDeviceCount=");
        b.append(this.enrolledDeviceCount);
        b.append(", ");
        b.append("qrCodeContent=");
        b.append(this.qrCodeContent);
        b.append(", ");
        b.append("qrCodeImage=");
        b.append(this.qrCodeImage);
        b.append(", ");
        b.append("roleScopeTagIds=");
        b.append(this.roleScopeTagIds);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
