package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

@JsonPropertyOrder({
    "@odata.type", 
    "appId", 
    "location", 
    "isDefault", 
    "domain"})
@JsonInclude(Include.NON_NULL)
public class AllowedDataLocation extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.allowedDataLocation";
    }

    @JsonProperty("appId")
    protected String appId;

    @JsonProperty("location")
    protected String location;

    @JsonProperty("isDefault")
    protected Boolean isDefault;

    @JsonProperty("domain")
    protected String domain;

    protected AllowedDataLocation() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAllowedDataLocation() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String appId;
        private String location;
        private Boolean isDefault;
        private String domain;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder appId(String appId) {
            this.appId = appId;
            this.changedFields = changedFields.add("appId");
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            this.changedFields = changedFields.add("location");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.changedFields = changedFields.add("isDefault");
            return this;
        }

        public Builder domain(String domain) {
            this.domain = domain;
            this.changedFields = changedFields.add("domain");
            return this;
        }

        public AllowedDataLocation build() {
            AllowedDataLocation _x = new AllowedDataLocation();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.allowedDataLocation";
            _x.id = id;
            _x.appId = appId;
            _x.location = location;
            _x.isDefault = isDefault;
            _x.domain = domain;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="appId")
    @JsonIgnore
    public Optional<String> getAppId() {
        return Optional.ofNullable(appId);
    }

    public AllowedDataLocation withAppId(String appId) {
        AllowedDataLocation _x = _copy();
        _x.changedFields = changedFields.add("appId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.allowedDataLocation");
        _x.appId = appId;
        return _x;
    }

    @Property(name="location")
    @JsonIgnore
    public Optional<String> getLocation() {
        return Optional.ofNullable(location);
    }

    public AllowedDataLocation withLocation(String location) {
        AllowedDataLocation _x = _copy();
        _x.changedFields = changedFields.add("location");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.allowedDataLocation");
        _x.location = location;
        return _x;
    }

    @Property(name="isDefault")
    @JsonIgnore
    public Optional<Boolean> getIsDefault() {
        return Optional.ofNullable(isDefault);
    }

    public AllowedDataLocation withIsDefault(Boolean isDefault) {
        AllowedDataLocation _x = _copy();
        _x.changedFields = changedFields.add("isDefault");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.allowedDataLocation");
        _x.isDefault = isDefault;
        return _x;
    }

    @Property(name="domain")
    @JsonIgnore
    public Optional<String> getDomain() {
        return Optional.ofNullable(domain);
    }

    public AllowedDataLocation withDomain(String domain) {
        AllowedDataLocation _x = _copy();
        _x.changedFields = changedFields.add("domain");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.allowedDataLocation");
        _x.domain = domain;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AllowedDataLocation patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AllowedDataLocation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AllowedDataLocation put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AllowedDataLocation _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AllowedDataLocation _copy() {
        AllowedDataLocation _x = new AllowedDataLocation();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.appId = appId;
        _x.location = location;
        _x.isDefault = isDefault;
        _x.domain = domain;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AllowedDataLocation[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("appId=");
        b.append(this.appId);
        b.append(", ");
        b.append("location=");
        b.append(this.location);
        b.append(", ");
        b.append("isDefault=");
        b.append(this.isDefault);
        b.append(", ");
        b.append("domain=");
        b.append(this.domain);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
