package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.EdmSchemaInfo;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AlertHistoryState;
import odata.msgraph.client.beta.complex.AlertTrigger;
import odata.msgraph.client.beta.complex.CloudAppSecurityState;
import odata.msgraph.client.beta.complex.FileSecurityState;
import odata.msgraph.client.beta.complex.HostSecurityState;
import odata.msgraph.client.beta.complex.MalwareState;
import odata.msgraph.client.beta.complex.NetworkConnection;
import odata.msgraph.client.beta.complex.Process;
import odata.msgraph.client.beta.complex.RegistryKeyState;
import odata.msgraph.client.beta.complex.SecurityResource;
import odata.msgraph.client.beta.complex.SecurityVendorInformation;
import odata.msgraph.client.beta.complex.UserSecurityState;
import odata.msgraph.client.beta.complex.VulnerabilityState;
import odata.msgraph.client.beta.enums.AlertFeedback;
import odata.msgraph.client.beta.enums.AlertSeverity;
import odata.msgraph.client.beta.enums.AlertStatus;
import odata.msgraph.client.beta.schema.SchemaInfo;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.SortRestrictions</b>
 * <p>
 * Sortable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = true
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * true
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * true
 */@JsonPropertyOrder({
    "@odata.type", 
    "activityGroupName", 
    "assignedTo", 
    "azureSubscriptionId", 
    "azureTenantId", 
    "category", 
    "closedDateTime", 
    "cloudAppStates", 
    "comments", 
    "confidence", 
    "createdDateTime", 
    "description", 
    "detectionIds", 
    "eventDateTime", 
    "feedback", 
    "fileStates", 
    "historyStates", 
    "hostStates", 
    "incidentIds", 
    "lastModifiedDateTime", 
    "malwareStates", 
    "networkConnections", 
    "processes", 
    "recommendedActions", 
    "registryKeyStates", 
    "securityResources", 
    "severity", 
    "sourceMaterials", 
    "status", 
    "tags", 
    "title", 
    "triggers", 
    "userStates", 
    "vendorInformation", 
    "vulnerabilityStates"})
@JsonInclude(Include.NON_NULL)
public class Alert extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.alert";
    }

    @JsonProperty("activityGroupName")
    protected String activityGroupName;

    @JsonProperty("assignedTo")
    protected String assignedTo;

    @JsonProperty("azureSubscriptionId")
    protected String azureSubscriptionId;

    @JsonProperty("azureTenantId")
    protected String azureTenantId;

    @JsonProperty("category")
    protected String category;

    @JsonProperty("closedDateTime")
    protected OffsetDateTime closedDateTime;

    @JsonProperty("cloudAppStates")
    protected List<CloudAppSecurityState> cloudAppStates;

    @JsonProperty("cloudAppStates@nextLink")
    protected String cloudAppStatesNextLink;

    @JsonProperty("comments")
    protected List<String> comments;

    @JsonProperty("comments@nextLink")
    protected String commentsNextLink;

    @JsonProperty("confidence")
    protected Integer confidence;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("detectionIds")
    protected List<String> detectionIds;

    @JsonProperty("detectionIds@nextLink")
    protected String detectionIdsNextLink;

    @JsonProperty("eventDateTime")
    protected OffsetDateTime eventDateTime;

    @JsonProperty("feedback")
    protected AlertFeedback feedback;

    @JsonProperty("fileStates")
    protected List<FileSecurityState> fileStates;

    @JsonProperty("fileStates@nextLink")
    protected String fileStatesNextLink;

    @JsonProperty("historyStates")
    protected List<AlertHistoryState> historyStates;

    @JsonProperty("historyStates@nextLink")
    protected String historyStatesNextLink;

    @JsonProperty("hostStates")
    protected List<HostSecurityState> hostStates;

    @JsonProperty("hostStates@nextLink")
    protected String hostStatesNextLink;

    @JsonProperty("incidentIds")
    protected List<String> incidentIds;

    @JsonProperty("incidentIds@nextLink")
    protected String incidentIdsNextLink;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("malwareStates")
    protected List<MalwareState> malwareStates;

    @JsonProperty("malwareStates@nextLink")
    protected String malwareStatesNextLink;

    @JsonProperty("networkConnections")
    protected List<NetworkConnection> networkConnections;

    @JsonProperty("networkConnections@nextLink")
    protected String networkConnectionsNextLink;

    @JsonProperty("processes")
    protected List<Process> processes;

    @JsonProperty("processes@nextLink")
    protected String processesNextLink;

    @JsonProperty("recommendedActions")
    protected List<String> recommendedActions;

    @JsonProperty("recommendedActions@nextLink")
    protected String recommendedActionsNextLink;

    @JsonProperty("registryKeyStates")
    protected List<RegistryKeyState> registryKeyStates;

    @JsonProperty("registryKeyStates@nextLink")
    protected String registryKeyStatesNextLink;

    @JsonProperty("securityResources")
    protected List<SecurityResource> securityResources;

    @JsonProperty("securityResources@nextLink")
    protected String securityResourcesNextLink;

    @JsonProperty("severity")
    protected AlertSeverity severity;

    @JsonProperty("sourceMaterials")
    protected List<String> sourceMaterials;

    @JsonProperty("sourceMaterials@nextLink")
    protected String sourceMaterialsNextLink;

    @JsonProperty("status")
    protected AlertStatus status;

    @JsonProperty("tags")
    protected List<String> tags;

    @JsonProperty("tags@nextLink")
    protected String tagsNextLink;

    @JsonProperty("title")
    protected String title;

    @JsonProperty("triggers")
    protected List<AlertTrigger> triggers;

    @JsonProperty("triggers@nextLink")
    protected String triggersNextLink;

    @JsonProperty("userStates")
    protected List<UserSecurityState> userStates;

    @JsonProperty("userStates@nextLink")
    protected String userStatesNextLink;

    @JsonProperty("vendorInformation")
    protected SecurityVendorInformation vendorInformation;

    @JsonProperty("vulnerabilityStates")
    protected List<VulnerabilityState> vulnerabilityStates;

    @JsonProperty("vulnerabilityStates@nextLink")
    protected String vulnerabilityStatesNextLink;

    protected Alert() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAlert() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String activityGroupName;
        private String assignedTo;
        private String azureSubscriptionId;
        private String azureTenantId;
        private String category;
        private OffsetDateTime closedDateTime;
        private List<CloudAppSecurityState> cloudAppStates;
        private String cloudAppStatesNextLink;
        private List<String> comments;
        private String commentsNextLink;
        private Integer confidence;
        private OffsetDateTime createdDateTime;
        private String description;
        private List<String> detectionIds;
        private String detectionIdsNextLink;
        private OffsetDateTime eventDateTime;
        private AlertFeedback feedback;
        private List<FileSecurityState> fileStates;
        private String fileStatesNextLink;
        private List<AlertHistoryState> historyStates;
        private String historyStatesNextLink;
        private List<HostSecurityState> hostStates;
        private String hostStatesNextLink;
        private List<String> incidentIds;
        private String incidentIdsNextLink;
        private OffsetDateTime lastModifiedDateTime;
        private List<MalwareState> malwareStates;
        private String malwareStatesNextLink;
        private List<NetworkConnection> networkConnections;
        private String networkConnectionsNextLink;
        private List<Process> processes;
        private String processesNextLink;
        private List<String> recommendedActions;
        private String recommendedActionsNextLink;
        private List<RegistryKeyState> registryKeyStates;
        private String registryKeyStatesNextLink;
        private List<SecurityResource> securityResources;
        private String securityResourcesNextLink;
        private AlertSeverity severity;
        private List<String> sourceMaterials;
        private String sourceMaterialsNextLink;
        private AlertStatus status;
        private List<String> tags;
        private String tagsNextLink;
        private String title;
        private List<AlertTrigger> triggers;
        private String triggersNextLink;
        private List<UserSecurityState> userStates;
        private String userStatesNextLink;
        private SecurityVendorInformation vendorInformation;
        private List<VulnerabilityState> vulnerabilityStates;
        private String vulnerabilityStatesNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder activityGroupName(String activityGroupName) {
            this.activityGroupName = activityGroupName;
            this.changedFields = changedFields.add("activityGroupName");
            return this;
        }

        public Builder assignedTo(String assignedTo) {
            this.assignedTo = assignedTo;
            this.changedFields = changedFields.add("assignedTo");
            return this;
        }

        public Builder azureSubscriptionId(String azureSubscriptionId) {
            this.azureSubscriptionId = azureSubscriptionId;
            this.changedFields = changedFields.add("azureSubscriptionId");
            return this;
        }

        public Builder azureTenantId(String azureTenantId) {
            this.azureTenantId = azureTenantId;
            this.changedFields = changedFields.add("azureTenantId");
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        public Builder closedDateTime(OffsetDateTime closedDateTime) {
            this.closedDateTime = closedDateTime;
            this.changedFields = changedFields.add("closedDateTime");
            return this;
        }

        public Builder cloudAppStates(List<CloudAppSecurityState> cloudAppStates) {
            this.cloudAppStates = cloudAppStates;
            this.changedFields = changedFields.add("cloudAppStates");
            return this;
        }

        public Builder cloudAppStates(CloudAppSecurityState... cloudAppStates) {
            return cloudAppStates(Arrays.asList(cloudAppStates));
        }

        public Builder cloudAppStatesNextLink(String cloudAppStatesNextLink) {
            this.cloudAppStatesNextLink = cloudAppStatesNextLink;
            this.changedFields = changedFields.add("cloudAppStates");
            return this;
        }

        public Builder comments(List<String> comments) {
            this.comments = comments;
            this.changedFields = changedFields.add("comments");
            return this;
        }

        public Builder comments(String... comments) {
            return comments(Arrays.asList(comments));
        }

        public Builder commentsNextLink(String commentsNextLink) {
            this.commentsNextLink = commentsNextLink;
            this.changedFields = changedFields.add("comments");
            return this;
        }

        public Builder confidence(Integer confidence) {
            this.confidence = confidence;
            this.changedFields = changedFields.add("confidence");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder detectionIds(List<String> detectionIds) {
            this.detectionIds = detectionIds;
            this.changedFields = changedFields.add("detectionIds");
            return this;
        }

        public Builder detectionIds(String... detectionIds) {
            return detectionIds(Arrays.asList(detectionIds));
        }

        public Builder detectionIdsNextLink(String detectionIdsNextLink) {
            this.detectionIdsNextLink = detectionIdsNextLink;
            this.changedFields = changedFields.add("detectionIds");
            return this;
        }

        public Builder eventDateTime(OffsetDateTime eventDateTime) {
            this.eventDateTime = eventDateTime;
            this.changedFields = changedFields.add("eventDateTime");
            return this;
        }

        public Builder feedback(AlertFeedback feedback) {
            this.feedback = feedback;
            this.changedFields = changedFields.add("feedback");
            return this;
        }

        public Builder fileStates(List<FileSecurityState> fileStates) {
            this.fileStates = fileStates;
            this.changedFields = changedFields.add("fileStates");
            return this;
        }

        public Builder fileStates(FileSecurityState... fileStates) {
            return fileStates(Arrays.asList(fileStates));
        }

        public Builder fileStatesNextLink(String fileStatesNextLink) {
            this.fileStatesNextLink = fileStatesNextLink;
            this.changedFields = changedFields.add("fileStates");
            return this;
        }

        public Builder historyStates(List<AlertHistoryState> historyStates) {
            this.historyStates = historyStates;
            this.changedFields = changedFields.add("historyStates");
            return this;
        }

        public Builder historyStates(AlertHistoryState... historyStates) {
            return historyStates(Arrays.asList(historyStates));
        }

        public Builder historyStatesNextLink(String historyStatesNextLink) {
            this.historyStatesNextLink = historyStatesNextLink;
            this.changedFields = changedFields.add("historyStates");
            return this;
        }

        public Builder hostStates(List<HostSecurityState> hostStates) {
            this.hostStates = hostStates;
            this.changedFields = changedFields.add("hostStates");
            return this;
        }

        public Builder hostStates(HostSecurityState... hostStates) {
            return hostStates(Arrays.asList(hostStates));
        }

        public Builder hostStatesNextLink(String hostStatesNextLink) {
            this.hostStatesNextLink = hostStatesNextLink;
            this.changedFields = changedFields.add("hostStates");
            return this;
        }

        public Builder incidentIds(List<String> incidentIds) {
            this.incidentIds = incidentIds;
            this.changedFields = changedFields.add("incidentIds");
            return this;
        }

        public Builder incidentIds(String... incidentIds) {
            return incidentIds(Arrays.asList(incidentIds));
        }

        public Builder incidentIdsNextLink(String incidentIdsNextLink) {
            this.incidentIdsNextLink = incidentIdsNextLink;
            this.changedFields = changedFields.add("incidentIds");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder malwareStates(List<MalwareState> malwareStates) {
            this.malwareStates = malwareStates;
            this.changedFields = changedFields.add("malwareStates");
            return this;
        }

        public Builder malwareStates(MalwareState... malwareStates) {
            return malwareStates(Arrays.asList(malwareStates));
        }

        public Builder malwareStatesNextLink(String malwareStatesNextLink) {
            this.malwareStatesNextLink = malwareStatesNextLink;
            this.changedFields = changedFields.add("malwareStates");
            return this;
        }

        public Builder networkConnections(List<NetworkConnection> networkConnections) {
            this.networkConnections = networkConnections;
            this.changedFields = changedFields.add("networkConnections");
            return this;
        }

        public Builder networkConnections(NetworkConnection... networkConnections) {
            return networkConnections(Arrays.asList(networkConnections));
        }

        public Builder networkConnectionsNextLink(String networkConnectionsNextLink) {
            this.networkConnectionsNextLink = networkConnectionsNextLink;
            this.changedFields = changedFields.add("networkConnections");
            return this;
        }

        public Builder processes(List<Process> processes) {
            this.processes = processes;
            this.changedFields = changedFields.add("processes");
            return this;
        }

        public Builder processes(Process... processes) {
            return processes(Arrays.asList(processes));
        }

        public Builder processesNextLink(String processesNextLink) {
            this.processesNextLink = processesNextLink;
            this.changedFields = changedFields.add("processes");
            return this;
        }

        public Builder recommendedActions(List<String> recommendedActions) {
            this.recommendedActions = recommendedActions;
            this.changedFields = changedFields.add("recommendedActions");
            return this;
        }

        public Builder recommendedActions(String... recommendedActions) {
            return recommendedActions(Arrays.asList(recommendedActions));
        }

        public Builder recommendedActionsNextLink(String recommendedActionsNextLink) {
            this.recommendedActionsNextLink = recommendedActionsNextLink;
            this.changedFields = changedFields.add("recommendedActions");
            return this;
        }

        public Builder registryKeyStates(List<RegistryKeyState> registryKeyStates) {
            this.registryKeyStates = registryKeyStates;
            this.changedFields = changedFields.add("registryKeyStates");
            return this;
        }

        public Builder registryKeyStates(RegistryKeyState... registryKeyStates) {
            return registryKeyStates(Arrays.asList(registryKeyStates));
        }

        public Builder registryKeyStatesNextLink(String registryKeyStatesNextLink) {
            this.registryKeyStatesNextLink = registryKeyStatesNextLink;
            this.changedFields = changedFields.add("registryKeyStates");
            return this;
        }

        public Builder securityResources(List<SecurityResource> securityResources) {
            this.securityResources = securityResources;
            this.changedFields = changedFields.add("securityResources");
            return this;
        }

        public Builder securityResources(SecurityResource... securityResources) {
            return securityResources(Arrays.asList(securityResources));
        }

        public Builder securityResourcesNextLink(String securityResourcesNextLink) {
            this.securityResourcesNextLink = securityResourcesNextLink;
            this.changedFields = changedFields.add("securityResources");
            return this;
        }

        public Builder severity(AlertSeverity severity) {
            this.severity = severity;
            this.changedFields = changedFields.add("severity");
            return this;
        }

        public Builder sourceMaterials(List<String> sourceMaterials) {
            this.sourceMaterials = sourceMaterials;
            this.changedFields = changedFields.add("sourceMaterials");
            return this;
        }

        public Builder sourceMaterials(String... sourceMaterials) {
            return sourceMaterials(Arrays.asList(sourceMaterials));
        }

        public Builder sourceMaterialsNextLink(String sourceMaterialsNextLink) {
            this.sourceMaterialsNextLink = sourceMaterialsNextLink;
            this.changedFields = changedFields.add("sourceMaterials");
            return this;
        }

        public Builder status(AlertStatus status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder tags(List<String> tags) {
            this.tags = tags;
            this.changedFields = changedFields.add("tags");
            return this;
        }

        public Builder tags(String... tags) {
            return tags(Arrays.asList(tags));
        }

        public Builder tagsNextLink(String tagsNextLink) {
            this.tagsNextLink = tagsNextLink;
            this.changedFields = changedFields.add("tags");
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            this.changedFields = changedFields.add("title");
            return this;
        }

        public Builder triggers(List<AlertTrigger> triggers) {
            this.triggers = triggers;
            this.changedFields = changedFields.add("triggers");
            return this;
        }

        public Builder triggers(AlertTrigger... triggers) {
            return triggers(Arrays.asList(triggers));
        }

        public Builder triggersNextLink(String triggersNextLink) {
            this.triggersNextLink = triggersNextLink;
            this.changedFields = changedFields.add("triggers");
            return this;
        }

        public Builder userStates(List<UserSecurityState> userStates) {
            this.userStates = userStates;
            this.changedFields = changedFields.add("userStates");
            return this;
        }

        public Builder userStates(UserSecurityState... userStates) {
            return userStates(Arrays.asList(userStates));
        }

        public Builder userStatesNextLink(String userStatesNextLink) {
            this.userStatesNextLink = userStatesNextLink;
            this.changedFields = changedFields.add("userStates");
            return this;
        }

        public Builder vendorInformation(SecurityVendorInformation vendorInformation) {
            this.vendorInformation = vendorInformation;
            this.changedFields = changedFields.add("vendorInformation");
            return this;
        }

        public Builder vulnerabilityStates(List<VulnerabilityState> vulnerabilityStates) {
            this.vulnerabilityStates = vulnerabilityStates;
            this.changedFields = changedFields.add("vulnerabilityStates");
            return this;
        }

        public Builder vulnerabilityStates(VulnerabilityState... vulnerabilityStates) {
            return vulnerabilityStates(Arrays.asList(vulnerabilityStates));
        }

        public Builder vulnerabilityStatesNextLink(String vulnerabilityStatesNextLink) {
            this.vulnerabilityStatesNextLink = vulnerabilityStatesNextLink;
            this.changedFields = changedFields.add("vulnerabilityStates");
            return this;
        }

        public Alert build() {
            Alert _x = new Alert();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.alert";
            _x.id = id;
            _x.activityGroupName = activityGroupName;
            _x.assignedTo = assignedTo;
            _x.azureSubscriptionId = azureSubscriptionId;
            _x.azureTenantId = azureTenantId;
            _x.category = category;
            _x.closedDateTime = closedDateTime;
            _x.cloudAppStates = cloudAppStates;
            _x.cloudAppStatesNextLink = cloudAppStatesNextLink;
            _x.comments = comments;
            _x.commentsNextLink = commentsNextLink;
            _x.confidence = confidence;
            _x.createdDateTime = createdDateTime;
            _x.description = description;
            _x.detectionIds = detectionIds;
            _x.detectionIdsNextLink = detectionIdsNextLink;
            _x.eventDateTime = eventDateTime;
            _x.feedback = feedback;
            _x.fileStates = fileStates;
            _x.fileStatesNextLink = fileStatesNextLink;
            _x.historyStates = historyStates;
            _x.historyStatesNextLink = historyStatesNextLink;
            _x.hostStates = hostStates;
            _x.hostStatesNextLink = hostStatesNextLink;
            _x.incidentIds = incidentIds;
            _x.incidentIdsNextLink = incidentIdsNextLink;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.malwareStates = malwareStates;
            _x.malwareStatesNextLink = malwareStatesNextLink;
            _x.networkConnections = networkConnections;
            _x.networkConnectionsNextLink = networkConnectionsNextLink;
            _x.processes = processes;
            _x.processesNextLink = processesNextLink;
            _x.recommendedActions = recommendedActions;
            _x.recommendedActionsNextLink = recommendedActionsNextLink;
            _x.registryKeyStates = registryKeyStates;
            _x.registryKeyStatesNextLink = registryKeyStatesNextLink;
            _x.securityResources = securityResources;
            _x.securityResourcesNextLink = securityResourcesNextLink;
            _x.severity = severity;
            _x.sourceMaterials = sourceMaterials;
            _x.sourceMaterialsNextLink = sourceMaterialsNextLink;
            _x.status = status;
            _x.tags = tags;
            _x.tagsNextLink = tagsNextLink;
            _x.title = title;
            _x.triggers = triggers;
            _x.triggersNextLink = triggersNextLink;
            _x.userStates = userStates;
            _x.userStatesNextLink = userStatesNextLink;
            _x.vendorInformation = vendorInformation;
            _x.vulnerabilityStates = vulnerabilityStates;
            _x.vulnerabilityStatesNextLink = vulnerabilityStatesNextLink;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="activityGroupName")
    @JsonIgnore
    public Optional<String> getActivityGroupName() {
        return Optional.ofNullable(activityGroupName);
    }

    public Alert withActivityGroupName(String activityGroupName) {
        Alert _x = _copy();
        _x.changedFields = changedFields.add("activityGroupName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alert");
        _x.activityGroupName = activityGroupName;
        return _x;
    }

    @Property(name="assignedTo")
    @JsonIgnore
    public Optional<String> getAssignedTo() {
        return Optional.ofNullable(assignedTo);
    }

    public Alert withAssignedTo(String assignedTo) {
        Alert _x = _copy();
        _x.changedFields = changedFields.add("assignedTo");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alert");
        _x.assignedTo = assignedTo;
        return _x;
    }

    @Property(name="azureSubscriptionId")
    @JsonIgnore
    public Optional<String> getAzureSubscriptionId() {
        return Optional.ofNullable(azureSubscriptionId);
    }

    public Alert withAzureSubscriptionId(String azureSubscriptionId) {
        Alert _x = _copy();
        _x.changedFields = changedFields.add("azureSubscriptionId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alert");
        _x.azureSubscriptionId = azureSubscriptionId;
        return _x;
    }

    @Property(name="azureTenantId")
    @JsonIgnore
    public Optional<String> getAzureTenantId() {
        return Optional.ofNullable(azureTenantId);
    }

    public Alert withAzureTenantId(String azureTenantId) {
        Alert _x = _copy();
        _x.changedFields = changedFields.add("azureTenantId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alert");
        _x.azureTenantId = azureTenantId;
        return _x;
    }

    @Property(name="category")
    @JsonIgnore
    public Optional<String> getCategory() {
        return Optional.ofNullable(category);
    }

    public Alert withCategory(String category) {
        Alert _x = _copy();
        _x.changedFields = changedFields.add("category");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alert");
        _x.category = category;
        return _x;
    }

    @Property(name="closedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getClosedDateTime() {
        return Optional.ofNullable(closedDateTime);
    }

    public Alert withClosedDateTime(OffsetDateTime closedDateTime) {
        Alert _x = _copy();
        _x.changedFields = changedFields.add("closedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alert");
        _x.closedDateTime = closedDateTime;
        return _x;
    }

    @Property(name="cloudAppStates")
    @JsonIgnore
    public CollectionPage<CloudAppSecurityState> getCloudAppStates() {
        return new CollectionPage<CloudAppSecurityState>(contextPath, CloudAppSecurityState.class, cloudAppStates, Optional.ofNullable(cloudAppStatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="cloudAppStates")
    @JsonIgnore
    public CollectionPage<CloudAppSecurityState> getCloudAppStates(HttpRequestOptions options) {
        return new CollectionPage<CloudAppSecurityState>(contextPath, CloudAppSecurityState.class, cloudAppStates, Optional.ofNullable(cloudAppStatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="comments")
    @JsonIgnore
    public CollectionPage<String> getComments() {
        return new CollectionPage<String>(contextPath, String.class, comments, Optional.ofNullable(commentsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="comments")
    @JsonIgnore
    public CollectionPage<String> getComments(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, comments, Optional.ofNullable(commentsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="confidence")
    @JsonIgnore
    public Optional<Integer> getConfidence() {
        return Optional.ofNullable(confidence);
    }

    public Alert withConfidence(Integer confidence) {
        Alert _x = _copy();
        _x.changedFields = changedFields.add("confidence");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alert");
        _x.confidence = confidence;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public Alert withCreatedDateTime(OffsetDateTime createdDateTime) {
        Alert _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alert");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public Alert withDescription(String description) {
        Alert _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alert");
        _x.description = description;
        return _x;
    }

    @Property(name="detectionIds")
    @JsonIgnore
    public CollectionPage<String> getDetectionIds() {
        return new CollectionPage<String>(contextPath, String.class, detectionIds, Optional.ofNullable(detectionIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="detectionIds")
    @JsonIgnore
    public CollectionPage<String> getDetectionIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, detectionIds, Optional.ofNullable(detectionIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="eventDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEventDateTime() {
        return Optional.ofNullable(eventDateTime);
    }

    public Alert withEventDateTime(OffsetDateTime eventDateTime) {
        Alert _x = _copy();
        _x.changedFields = changedFields.add("eventDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alert");
        _x.eventDateTime = eventDateTime;
        return _x;
    }

    @Property(name="feedback")
    @JsonIgnore
    public Optional<AlertFeedback> getFeedback() {
        return Optional.ofNullable(feedback);
    }

    public Alert withFeedback(AlertFeedback feedback) {
        Alert _x = _copy();
        _x.changedFields = changedFields.add("feedback");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alert");
        _x.feedback = feedback;
        return _x;
    }

    @Property(name="fileStates")
    @JsonIgnore
    public CollectionPage<FileSecurityState> getFileStates() {
        return new CollectionPage<FileSecurityState>(contextPath, FileSecurityState.class, fileStates, Optional.ofNullable(fileStatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="fileStates")
    @JsonIgnore
    public CollectionPage<FileSecurityState> getFileStates(HttpRequestOptions options) {
        return new CollectionPage<FileSecurityState>(contextPath, FileSecurityState.class, fileStates, Optional.ofNullable(fileStatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="historyStates")
    @JsonIgnore
    public CollectionPage<AlertHistoryState> getHistoryStates() {
        return new CollectionPage<AlertHistoryState>(contextPath, AlertHistoryState.class, historyStates, Optional.ofNullable(historyStatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="historyStates")
    @JsonIgnore
    public CollectionPage<AlertHistoryState> getHistoryStates(HttpRequestOptions options) {
        return new CollectionPage<AlertHistoryState>(contextPath, AlertHistoryState.class, historyStates, Optional.ofNullable(historyStatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="hostStates")
    @JsonIgnore
    public CollectionPage<HostSecurityState> getHostStates() {
        return new CollectionPage<HostSecurityState>(contextPath, HostSecurityState.class, hostStates, Optional.ofNullable(hostStatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="hostStates")
    @JsonIgnore
    public CollectionPage<HostSecurityState> getHostStates(HttpRequestOptions options) {
        return new CollectionPage<HostSecurityState>(contextPath, HostSecurityState.class, hostStates, Optional.ofNullable(hostStatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="incidentIds")
    @JsonIgnore
    public CollectionPage<String> getIncidentIds() {
        return new CollectionPage<String>(contextPath, String.class, incidentIds, Optional.ofNullable(incidentIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="incidentIds")
    @JsonIgnore
    public CollectionPage<String> getIncidentIds(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, incidentIds, Optional.ofNullable(incidentIdsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public Alert withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        Alert _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alert");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="malwareStates")
    @JsonIgnore
    public CollectionPage<MalwareState> getMalwareStates() {
        return new CollectionPage<MalwareState>(contextPath, MalwareState.class, malwareStates, Optional.ofNullable(malwareStatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="malwareStates")
    @JsonIgnore
    public CollectionPage<MalwareState> getMalwareStates(HttpRequestOptions options) {
        return new CollectionPage<MalwareState>(contextPath, MalwareState.class, malwareStates, Optional.ofNullable(malwareStatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="networkConnections")
    @JsonIgnore
    public CollectionPage<NetworkConnection> getNetworkConnections() {
        return new CollectionPage<NetworkConnection>(contextPath, NetworkConnection.class, networkConnections, Optional.ofNullable(networkConnectionsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="networkConnections")
    @JsonIgnore
    public CollectionPage<NetworkConnection> getNetworkConnections(HttpRequestOptions options) {
        return new CollectionPage<NetworkConnection>(contextPath, NetworkConnection.class, networkConnections, Optional.ofNullable(networkConnectionsNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="processes")
    @JsonIgnore
    public CollectionPage<Process> getProcesses() {
        return new CollectionPage<Process>(contextPath, Process.class, processes, Optional.ofNullable(processesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="processes")
    @JsonIgnore
    public CollectionPage<Process> getProcesses(HttpRequestOptions options) {
        return new CollectionPage<Process>(contextPath, Process.class, processes, Optional.ofNullable(processesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="recommendedActions")
    @JsonIgnore
    public CollectionPage<String> getRecommendedActions() {
        return new CollectionPage<String>(contextPath, String.class, recommendedActions, Optional.ofNullable(recommendedActionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="recommendedActions")
    @JsonIgnore
    public CollectionPage<String> getRecommendedActions(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, recommendedActions, Optional.ofNullable(recommendedActionsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="registryKeyStates")
    @JsonIgnore
    public CollectionPage<RegistryKeyState> getRegistryKeyStates() {
        return new CollectionPage<RegistryKeyState>(contextPath, RegistryKeyState.class, registryKeyStates, Optional.ofNullable(registryKeyStatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="registryKeyStates")
    @JsonIgnore
    public CollectionPage<RegistryKeyState> getRegistryKeyStates(HttpRequestOptions options) {
        return new CollectionPage<RegistryKeyState>(contextPath, RegistryKeyState.class, registryKeyStates, Optional.ofNullable(registryKeyStatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="securityResources")
    @JsonIgnore
    public CollectionPage<SecurityResource> getSecurityResources() {
        return new CollectionPage<SecurityResource>(contextPath, SecurityResource.class, securityResources, Optional.ofNullable(securityResourcesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="securityResources")
    @JsonIgnore
    public CollectionPage<SecurityResource> getSecurityResources(HttpRequestOptions options) {
        return new CollectionPage<SecurityResource>(contextPath, SecurityResource.class, securityResources, Optional.ofNullable(securityResourcesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="severity")
    @JsonIgnore
    public Optional<AlertSeverity> getSeverity() {
        return Optional.ofNullable(severity);
    }

    public Alert withSeverity(AlertSeverity severity) {
        Alert _x = _copy();
        _x.changedFields = changedFields.add("severity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alert");
        _x.severity = severity;
        return _x;
    }

    @Property(name="sourceMaterials")
    @JsonIgnore
    public CollectionPage<String> getSourceMaterials() {
        return new CollectionPage<String>(contextPath, String.class, sourceMaterials, Optional.ofNullable(sourceMaterialsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="sourceMaterials")
    @JsonIgnore
    public CollectionPage<String> getSourceMaterials(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, sourceMaterials, Optional.ofNullable(sourceMaterialsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<AlertStatus> getStatus() {
        return Optional.ofNullable(status);
    }

    public Alert withStatus(AlertStatus status) {
        Alert _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alert");
        _x.status = status;
        return _x;
    }

    @Property(name="tags")
    @JsonIgnore
    public CollectionPage<String> getTags() {
        return new CollectionPage<String>(contextPath, String.class, tags, Optional.ofNullable(tagsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="tags")
    @JsonIgnore
    public CollectionPage<String> getTags(HttpRequestOptions options) {
        return new CollectionPage<String>(contextPath, String.class, tags, Optional.ofNullable(tagsNextLink), EdmSchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="title")
    @JsonIgnore
    public Optional<String> getTitle() {
        return Optional.ofNullable(title);
    }

    public Alert withTitle(String title) {
        Alert _x = _copy();
        _x.changedFields = changedFields.add("title");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alert");
        _x.title = title;
        return _x;
    }

    @Property(name="triggers")
    @JsonIgnore
    public CollectionPage<AlertTrigger> getTriggers() {
        return new CollectionPage<AlertTrigger>(contextPath, AlertTrigger.class, triggers, Optional.ofNullable(triggersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="triggers")
    @JsonIgnore
    public CollectionPage<AlertTrigger> getTriggers(HttpRequestOptions options) {
        return new CollectionPage<AlertTrigger>(contextPath, AlertTrigger.class, triggers, Optional.ofNullable(triggersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="userStates")
    @JsonIgnore
    public CollectionPage<UserSecurityState> getUserStates() {
        return new CollectionPage<UserSecurityState>(contextPath, UserSecurityState.class, userStates, Optional.ofNullable(userStatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="userStates")
    @JsonIgnore
    public CollectionPage<UserSecurityState> getUserStates(HttpRequestOptions options) {
        return new CollectionPage<UserSecurityState>(contextPath, UserSecurityState.class, userStates, Optional.ofNullable(userStatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="vendorInformation")
    @JsonIgnore
    public Optional<SecurityVendorInformation> getVendorInformation() {
        return Optional.ofNullable(vendorInformation);
    }

    public Alert withVendorInformation(SecurityVendorInformation vendorInformation) {
        Alert _x = _copy();
        _x.changedFields = changedFields.add("vendorInformation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.alert");
        _x.vendorInformation = vendorInformation;
        return _x;
    }

    @Property(name="vulnerabilityStates")
    @JsonIgnore
    public CollectionPage<VulnerabilityState> getVulnerabilityStates() {
        return new CollectionPage<VulnerabilityState>(contextPath, VulnerabilityState.class, vulnerabilityStates, Optional.ofNullable(vulnerabilityStatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="vulnerabilityStates")
    @JsonIgnore
    public CollectionPage<VulnerabilityState> getVulnerabilityStates(HttpRequestOptions options) {
        return new CollectionPage<VulnerabilityState>(contextPath, VulnerabilityState.class, vulnerabilityStates, Optional.ofNullable(vulnerabilityStatesNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Alert patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Alert _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Alert put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Alert _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Alert _copy() {
        Alert _x = new Alert();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.activityGroupName = activityGroupName;
        _x.assignedTo = assignedTo;
        _x.azureSubscriptionId = azureSubscriptionId;
        _x.azureTenantId = azureTenantId;
        _x.category = category;
        _x.closedDateTime = closedDateTime;
        _x.cloudAppStates = cloudAppStates;
        _x.comments = comments;
        _x.confidence = confidence;
        _x.createdDateTime = createdDateTime;
        _x.description = description;
        _x.detectionIds = detectionIds;
        _x.eventDateTime = eventDateTime;
        _x.feedback = feedback;
        _x.fileStates = fileStates;
        _x.historyStates = historyStates;
        _x.hostStates = hostStates;
        _x.incidentIds = incidentIds;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.malwareStates = malwareStates;
        _x.networkConnections = networkConnections;
        _x.processes = processes;
        _x.recommendedActions = recommendedActions;
        _x.registryKeyStates = registryKeyStates;
        _x.securityResources = securityResources;
        _x.severity = severity;
        _x.sourceMaterials = sourceMaterials;
        _x.status = status;
        _x.tags = tags;
        _x.title = title;
        _x.triggers = triggers;
        _x.userStates = userStates;
        _x.vendorInformation = vendorInformation;
        _x.vulnerabilityStates = vulnerabilityStates;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Alert[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("activityGroupName=");
        b.append(this.activityGroupName);
        b.append(", ");
        b.append("assignedTo=");
        b.append(this.assignedTo);
        b.append(", ");
        b.append("azureSubscriptionId=");
        b.append(this.azureSubscriptionId);
        b.append(", ");
        b.append("azureTenantId=");
        b.append(this.azureTenantId);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("closedDateTime=");
        b.append(this.closedDateTime);
        b.append(", ");
        b.append("cloudAppStates=");
        b.append(this.cloudAppStates);
        b.append(", ");
        b.append("comments=");
        b.append(this.comments);
        b.append(", ");
        b.append("confidence=");
        b.append(this.confidence);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("detectionIds=");
        b.append(this.detectionIds);
        b.append(", ");
        b.append("eventDateTime=");
        b.append(this.eventDateTime);
        b.append(", ");
        b.append("feedback=");
        b.append(this.feedback);
        b.append(", ");
        b.append("fileStates=");
        b.append(this.fileStates);
        b.append(", ");
        b.append("historyStates=");
        b.append(this.historyStates);
        b.append(", ");
        b.append("hostStates=");
        b.append(this.hostStates);
        b.append(", ");
        b.append("incidentIds=");
        b.append(this.incidentIds);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("malwareStates=");
        b.append(this.malwareStates);
        b.append(", ");
        b.append("networkConnections=");
        b.append(this.networkConnections);
        b.append(", ");
        b.append("processes=");
        b.append(this.processes);
        b.append(", ");
        b.append("recommendedActions=");
        b.append(this.recommendedActions);
        b.append(", ");
        b.append("registryKeyStates=");
        b.append(this.registryKeyStates);
        b.append(", ");
        b.append("securityResources=");
        b.append(this.securityResources);
        b.append(", ");
        b.append("severity=");
        b.append(this.severity);
        b.append(", ");
        b.append("sourceMaterials=");
        b.append(this.sourceMaterials);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("tags=");
        b.append(this.tags);
        b.append(", ");
        b.append("title=");
        b.append(this.title);
        b.append(", ");
        b.append("triggers=");
        b.append(this.triggers);
        b.append(", ");
        b.append("userStates=");
        b.append(this.userStates);
        b.append(", ");
        b.append("vendorInformation=");
        b.append(this.vendorInformation);
        b.append(", ");
        b.append("vulnerabilityStates=");
        b.append(this.vulnerabilityStates);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
