package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.complex.AgreementFileData;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.ExpandRestrictions</b>
 * <p>
 * Expandable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.FilterRestrictions</b>
 * <p>
 * Filterable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.SortRestrictions</b>
 * <p>
 * Sortable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.TopSupported</b>
 * <p>
 * false
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 */@JsonPropertyOrder({
    "@odata.type", 
    "language", 
    "fileName", 
    "fileData", 
    "isDefault"})
@JsonInclude(Include.NON_NULL)
public class AgreementFile extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.agreementFile";
    }

    @JsonProperty("language")
    protected String language;

    @JsonProperty("fileName")
    protected String fileName;

    @JsonProperty("fileData")
    protected AgreementFileData fileData;

    @JsonProperty("isDefault")
    protected Boolean isDefault;

    protected AgreementFile() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAgreementFile() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String language;
        private String fileName;
        private AgreementFileData fileData;
        private Boolean isDefault;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder language(String language) {
            this.language = language;
            this.changedFields = changedFields.add("language");
            return this;
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.changedFields = changedFields.add("fileName");
            return this;
        }

        public Builder fileData(AgreementFileData fileData) {
            this.fileData = fileData;
            this.changedFields = changedFields.add("fileData");
            return this;
        }

        public Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            this.changedFields = changedFields.add("isDefault");
            return this;
        }

        public AgreementFile build() {
            AgreementFile _x = new AgreementFile();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.agreementFile";
            _x.id = id;
            _x.language = language;
            _x.fileName = fileName;
            _x.fileData = fileData;
            _x.isDefault = isDefault;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="language")
    @JsonIgnore
    public Optional<String> getLanguage() {
        return Optional.ofNullable(language);
    }

    public AgreementFile withLanguage(String language) {
        AgreementFile _x = _copy();
        _x.changedFields = changedFields.add("language");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreementFile");
        _x.language = language;
        return _x;
    }

    @Property(name="fileName")
    @JsonIgnore
    public Optional<String> getFileName() {
        return Optional.ofNullable(fileName);
    }

    public AgreementFile withFileName(String fileName) {
        AgreementFile _x = _copy();
        _x.changedFields = changedFields.add("fileName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreementFile");
        _x.fileName = fileName;
        return _x;
    }

    @Property(name="fileData")
    @JsonIgnore
    public Optional<AgreementFileData> getFileData() {
        return Optional.ofNullable(fileData);
    }

    public AgreementFile withFileData(AgreementFileData fileData) {
        AgreementFile _x = _copy();
        _x.changedFields = changedFields.add("fileData");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreementFile");
        _x.fileData = fileData;
        return _x;
    }

    @Property(name="isDefault")
    @JsonIgnore
    public Optional<Boolean> getIsDefault() {
        return Optional.ofNullable(isDefault);
    }

    public AgreementFile withIsDefault(Boolean isDefault) {
        AgreementFile _x = _copy();
        _x.changedFields = changedFields.add("isDefault");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.agreementFile");
        _x.isDefault = isDefault;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AgreementFile patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AgreementFile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AgreementFile put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AgreementFile _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AgreementFile _copy() {
        AgreementFile _x = new AgreementFile();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.language = language;
        _x.fileName = fileName;
        _x.fileData = fileData;
        _x.isDefault = isDefault;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AgreementFile[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("language=");
        b.append(this.language);
        b.append(", ");
        b.append("fileName=");
        b.append(this.fileName);
        b.append(", ");
        b.append("fileData=");
        b.append(this.fileData);
        b.append(", ");
        b.append("isDefault=");
        b.append(this.isDefault);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
