package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.Duration;
import java.time.LocalDate;
import java.util.Optional;

import odata.msgraph.client.beta.enums.AnalyticsActivityType;

@JsonPropertyOrder({
    "@odata.type", 
    "activity", 
    "startDate", 
    "endDate", 
    "timeZoneUsed", 
    "duration"})
@JsonInclude(Include.NON_NULL)
public class ActivityStatistics extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.activityStatistics";
    }

    @JsonProperty("activity")
    protected AnalyticsActivityType activity;

    @JsonProperty("startDate")
    protected LocalDate startDate;

    @JsonProperty("endDate")
    protected LocalDate endDate;

    @JsonProperty("timeZoneUsed")
    protected String timeZoneUsed;

    @JsonProperty("duration")
    protected Duration duration;

    protected ActivityStatistics() {
        super();
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="activity")
    @JsonIgnore
    public Optional<AnalyticsActivityType> getActivity() {
        return Optional.ofNullable(activity);
    }

    public ActivityStatistics withActivity(AnalyticsActivityType activity) {
        ActivityStatistics _x = _copy();
        _x.changedFields = changedFields.add("activity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.activityStatistics");
        _x.activity = activity;
        return _x;
    }

    @Property(name="startDate")
    @JsonIgnore
    public Optional<LocalDate> getStartDate() {
        return Optional.ofNullable(startDate);
    }

    public ActivityStatistics withStartDate(LocalDate startDate) {
        ActivityStatistics _x = _copy();
        _x.changedFields = changedFields.add("startDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.activityStatistics");
        _x.startDate = startDate;
        return _x;
    }

    @Property(name="endDate")
    @JsonIgnore
    public Optional<LocalDate> getEndDate() {
        return Optional.ofNullable(endDate);
    }

    public ActivityStatistics withEndDate(LocalDate endDate) {
        ActivityStatistics _x = _copy();
        _x.changedFields = changedFields.add("endDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.activityStatistics");
        _x.endDate = endDate;
        return _x;
    }

    @Property(name="timeZoneUsed")
    @JsonIgnore
    public Optional<String> getTimeZoneUsed() {
        return Optional.ofNullable(timeZoneUsed);
    }

    public ActivityStatistics withTimeZoneUsed(String timeZoneUsed) {
        ActivityStatistics _x = _copy();
        _x.changedFields = changedFields.add("timeZoneUsed");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.activityStatistics");
        _x.timeZoneUsed = timeZoneUsed;
        return _x;
    }

    @Property(name="duration")
    @JsonIgnore
    public Optional<Duration> getDuration() {
        return Optional.ofNullable(duration);
    }

    public ActivityStatistics withDuration(Duration duration) {
        ActivityStatistics _x = _copy();
        _x.changedFields = changedFields.add("duration");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.activityStatistics");
        _x.duration = duration;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ActivityStatistics patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ActivityStatistics _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ActivityStatistics put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ActivityStatistics _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ActivityStatistics _copy() {
        ActivityStatistics _x = new ActivityStatistics();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.activity = activity;
        _x.startDate = startDate;
        _x.endDate = endDate;
        _x.timeZoneUsed = timeZoneUsed;
        _x.duration = duration;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ActivityStatistics[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("activity=");
        b.append(this.activity);
        b.append(", ");
        b.append("startDate=");
        b.append(this.startDate);
        b.append(", ");
        b.append("endDate=");
        b.append(this.endDate);
        b.append(", ");
        b.append("timeZoneUsed=");
        b.append(this.timeZoneUsed);
        b.append(", ");
        b.append("duration=");
        b.append(this.duration);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
