package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.UserActivityRequest;
import odata.msgraph.client.beta.enums.Status;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.SelectRestrictions</b>
 * <p>
 * Selectable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.CountRestrictions</b>
 * <p>
 * Countable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.SkipSupported</b>
 * <p>
 * false
 */@JsonPropertyOrder({
    "@odata.type", 
    "status", 
    "activeDurationSeconds", 
    "createdDateTime", 
    "lastActiveDateTime", 
    "lastModifiedDateTime", 
    "expirationDateTime", 
    "startedDateTime", 
    "userTimezone"})
@JsonInclude(Include.NON_NULL)
public class ActivityHistoryItem extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.activityHistoryItem";
    }

    @JsonProperty("status")
    protected Status status;

    @JsonProperty("activeDurationSeconds")
    protected Integer activeDurationSeconds;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("lastActiveDateTime")
    protected OffsetDateTime lastActiveDateTime;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    @JsonProperty("startedDateTime")
    protected OffsetDateTime startedDateTime;

    @JsonProperty("userTimezone")
    protected String userTimezone;

    protected ActivityHistoryItem() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderActivityHistoryItem() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private Status status;
        private Integer activeDurationSeconds;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastActiveDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private OffsetDateTime expirationDateTime;
        private OffsetDateTime startedDateTime;
        private String userTimezone;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder activeDurationSeconds(Integer activeDurationSeconds) {
            this.activeDurationSeconds = activeDurationSeconds;
            this.changedFields = changedFields.add("activeDurationSeconds");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastActiveDateTime(OffsetDateTime lastActiveDateTime) {
            this.lastActiveDateTime = lastActiveDateTime;
            this.changedFields = changedFields.add("lastActiveDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        public Builder startedDateTime(OffsetDateTime startedDateTime) {
            this.startedDateTime = startedDateTime;
            this.changedFields = changedFields.add("startedDateTime");
            return this;
        }

        public Builder userTimezone(String userTimezone) {
            this.userTimezone = userTimezone;
            this.changedFields = changedFields.add("userTimezone");
            return this;
        }

        public ActivityHistoryItem build() {
            ActivityHistoryItem _x = new ActivityHistoryItem();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.activityHistoryItem";
            _x.id = id;
            _x.status = status;
            _x.activeDurationSeconds = activeDurationSeconds;
            _x.createdDateTime = createdDateTime;
            _x.lastActiveDateTime = lastActiveDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.expirationDateTime = expirationDateTime;
            _x.startedDateTime = startedDateTime;
            _x.userTimezone = userTimezone;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<Status> getStatus() {
        return Optional.ofNullable(status);
    }

    public ActivityHistoryItem withStatus(Status status) {
        ActivityHistoryItem _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.activityHistoryItem");
        _x.status = status;
        return _x;
    }

    @Property(name="activeDurationSeconds")
    @JsonIgnore
    public Optional<Integer> getActiveDurationSeconds() {
        return Optional.ofNullable(activeDurationSeconds);
    }

    public ActivityHistoryItem withActiveDurationSeconds(Integer activeDurationSeconds) {
        ActivityHistoryItem _x = _copy();
        _x.changedFields = changedFields.add("activeDurationSeconds");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.activityHistoryItem");
        _x.activeDurationSeconds = activeDurationSeconds;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public ActivityHistoryItem withCreatedDateTime(OffsetDateTime createdDateTime) {
        ActivityHistoryItem _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.activityHistoryItem");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="lastActiveDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastActiveDateTime() {
        return Optional.ofNullable(lastActiveDateTime);
    }

    public ActivityHistoryItem withLastActiveDateTime(OffsetDateTime lastActiveDateTime) {
        ActivityHistoryItem _x = _copy();
        _x.changedFields = changedFields.add("lastActiveDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.activityHistoryItem");
        _x.lastActiveDateTime = lastActiveDateTime;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public ActivityHistoryItem withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        ActivityHistoryItem _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.activityHistoryItem");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    public ActivityHistoryItem withExpirationDateTime(OffsetDateTime expirationDateTime) {
        ActivityHistoryItem _x = _copy();
        _x.changedFields = changedFields.add("expirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.activityHistoryItem");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    @Property(name="startedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartedDateTime() {
        return Optional.ofNullable(startedDateTime);
    }

    public ActivityHistoryItem withStartedDateTime(OffsetDateTime startedDateTime) {
        ActivityHistoryItem _x = _copy();
        _x.changedFields = changedFields.add("startedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.activityHistoryItem");
        _x.startedDateTime = startedDateTime;
        return _x;
    }

    @Property(name="userTimezone")
    @JsonIgnore
    public Optional<String> getUserTimezone() {
        return Optional.ofNullable(userTimezone);
    }

    public ActivityHistoryItem withUserTimezone(String userTimezone) {
        ActivityHistoryItem _x = _copy();
        _x.changedFields = changedFields.add("userTimezone");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.activityHistoryItem");
        _x.userTimezone = userTimezone;
        return _x;
    }

    @NavigationProperty(name="activity")
    @JsonIgnore
    public UserActivityRequest getActivity() {
        return new UserActivityRequest(contextPath.addSegment("activity"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ActivityHistoryItem patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ActivityHistoryItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ActivityHistoryItem put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ActivityHistoryItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ActivityHistoryItem _copy() {
        ActivityHistoryItem _x = new ActivityHistoryItem();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.status = status;
        _x.activeDurationSeconds = activeDurationSeconds;
        _x.createdDateTime = createdDateTime;
        _x.lastActiveDateTime = lastActiveDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.expirationDateTime = expirationDateTime;
        _x.startedDateTime = startedDateTime;
        _x.userTimezone = userTimezone;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ActivityHistoryItem[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("activeDurationSeconds=");
        b.append(this.activeDurationSeconds);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastActiveDateTime=");
        b.append(this.lastActiveDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append(", ");
        b.append("startedDateTime=");
        b.append(this.startedDateTime);
        b.append(", ");
        b.append("userTimezone=");
        b.append(this.userTimezone);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
