package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.List;

@JsonPropertyOrder({
    "@odata.type"})
@JsonInclude(Include.NON_NULL)
public class ActivityBasedTimeoutPolicy extends StsPolicy implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.activityBasedTimeoutPolicy";
    }

    protected ActivityBasedTimeoutPolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderActivityBasedTimeoutPolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime deletedDateTime;
        private String description;
        private String displayName;
        private List<String> definition;
        private String definitionNextLink;
        private Boolean isOrganizationDefault;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder deletedDateTime(OffsetDateTime deletedDateTime) {
            this.deletedDateTime = deletedDateTime;
            this.changedFields = changedFields.add("deletedDateTime");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder definition(List<String> definition) {
            this.definition = definition;
            this.changedFields = changedFields.add("definition");
            return this;
        }

        public Builder definition(String... definition) {
            return definition(Arrays.asList(definition));
        }

        public Builder definitionNextLink(String definitionNextLink) {
            this.definitionNextLink = definitionNextLink;
            this.changedFields = changedFields.add("definition");
            return this;
        }

        public Builder isOrganizationDefault(Boolean isOrganizationDefault) {
            this.isOrganizationDefault = isOrganizationDefault;
            this.changedFields = changedFields.add("isOrganizationDefault");
            return this;
        }

        public ActivityBasedTimeoutPolicy build() {
            ActivityBasedTimeoutPolicy _x = new ActivityBasedTimeoutPolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.activityBasedTimeoutPolicy";
            _x.id = id;
            _x.deletedDateTime = deletedDateTime;
            _x.description = description;
            _x.displayName = displayName;
            _x.definition = definition;
            _x.definitionNextLink = definitionNextLink;
            _x.isOrganizationDefault = isOrganizationDefault;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ActivityBasedTimeoutPolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        ActivityBasedTimeoutPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public ActivityBasedTimeoutPolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        ActivityBasedTimeoutPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private ActivityBasedTimeoutPolicy _copy() {
        ActivityBasedTimeoutPolicy _x = new ActivityBasedTimeoutPolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.deletedDateTime = deletedDateTime;
        _x.description = description;
        _x.displayName = displayName;
        _x.definition = definition;
        _x.isOrganizationDefault = isOrganizationDefault;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ActivityBasedTimeoutPolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("deletedDateTime=");
        b.append(this.deletedDateTime);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("definition=");
        b.append(this.definition);
        b.append(", ");
        b.append("isOrganizationDefault=");
        b.append(this.isOrganizationDefault);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
