package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;


/**
 * <p>
 * <b>Org.OData.Capabilities.V1.UpdateRestrictions</b>
 * <p>
 * Updatable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.InsertRestrictions</b>
 * <p>
 * Insertable = false
 * <p>
 * <b>Org.OData.Capabilities.V1.DeleteRestrictions</b>
 * <p>
 * Deletable = false
 */@JsonPropertyOrder({
    "@odata.type", 
    "number", 
    "displayName", 
    "category", 
    "subCategory", 
    "blocked", 
    "lastModifiedDateTime"})
@JsonInclude(Include.NON_NULL)
public class Account extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.account";
    }

    @JsonProperty("number")
    protected String number;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("category")
    protected String category;

    @JsonProperty("subCategory")
    protected String subCategory;

    @JsonProperty("blocked")
    protected Boolean blocked;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    protected Account() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccount() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String number;
        private String displayName;
        private String category;
        private String subCategory;
        private Boolean blocked;
        private OffsetDateTime lastModifiedDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder number(String number) {
            this.number = number;
            this.changedFields = changedFields.add("number");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            this.changedFields = changedFields.add("category");
            return this;
        }

        public Builder subCategory(String subCategory) {
            this.subCategory = subCategory;
            this.changedFields = changedFields.add("subCategory");
            return this;
        }

        public Builder blocked(Boolean blocked) {
            this.blocked = blocked;
            this.changedFields = changedFields.add("blocked");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Account build() {
            Account _x = new Account();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.account";
            _x.id = id;
            _x.number = number;
            _x.displayName = displayName;
            _x.category = category;
            _x.subCategory = subCategory;
            _x.blocked = blocked;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="number")
    @JsonIgnore
    public Optional<String> getNumber() {
        return Optional.ofNullable(number);
    }

    public Account withNumber(String number) {
        Account _x = _copy();
        _x.changedFields = changedFields.add("number");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.account");
        _x.number = number;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public Account withDisplayName(String displayName) {
        Account _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.account");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="category")
    @JsonIgnore
    public Optional<String> getCategory() {
        return Optional.ofNullable(category);
    }

    public Account withCategory(String category) {
        Account _x = _copy();
        _x.changedFields = changedFields.add("category");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.account");
        _x.category = category;
        return _x;
    }

    @Property(name="subCategory")
    @JsonIgnore
    public Optional<String> getSubCategory() {
        return Optional.ofNullable(subCategory);
    }

    public Account withSubCategory(String subCategory) {
        Account _x = _copy();
        _x.changedFields = changedFields.add("subCategory");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.account");
        _x.subCategory = subCategory;
        return _x;
    }

    @Property(name="blocked")
    @JsonIgnore
    public Optional<Boolean> getBlocked() {
        return Optional.ofNullable(blocked);
    }

    public Account withBlocked(Boolean blocked) {
        Account _x = _copy();
        _x.changedFields = changedFields.add("blocked");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.account");
        _x.blocked = blocked;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public Account withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        Account _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.account");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Account patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        Account _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public Account put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        Account _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private Account _copy() {
        Account _x = new Account();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.number = number;
        _x.displayName = displayName;
        _x.category = category;
        _x.subCategory = subCategory;
        _x.blocked = blocked;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Account[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("number=");
        b.append(this.number);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("category=");
        b.append(this.category);
        b.append(", ");
        b.append("subCategory=");
        b.append(this.subCategory);
        b.append(", ");
        b.append("blocked=");
        b.append(this.blocked);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
