package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AccessReviewScheduleSettings;
import odata.msgraph.client.beta.complex.AccessReviewScope;
import odata.msgraph.client.beta.complex.UserIdentity;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewInstanceCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "createdDateTime", 
    "lastModifiedDateTime", 
    "status", 
    "descriptionForAdmins", 
    "descriptionForReviewers", 
    "createdBy", 
    "scope", 
    "reviewers", 
    "settings"})
@JsonInclude(Include.NON_NULL)
public class AccessReviewScheduleDefinition extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReviewScheduleDefinition";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("lastModifiedDateTime")
    protected OffsetDateTime lastModifiedDateTime;

    @JsonProperty("status")
    protected String status;

    @JsonProperty("descriptionForAdmins")
    protected String descriptionForAdmins;

    @JsonProperty("descriptionForReviewers")
    protected String descriptionForReviewers;

    @JsonProperty("createdBy")
    protected UserIdentity createdBy;

    @JsonProperty("scope")
    protected AccessReviewScope scope;

    @JsonProperty("reviewers")
    protected List<AccessReviewScope> reviewers;

    @JsonProperty("reviewers@nextLink")
    protected String reviewersNextLink;

    @JsonProperty("settings")
    protected AccessReviewScheduleSettings settings;

    protected AccessReviewScheduleDefinition() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessReviewScheduleDefinition() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime lastModifiedDateTime;
        private String status;
        private String descriptionForAdmins;
        private String descriptionForReviewers;
        private UserIdentity createdBy;
        private AccessReviewScope scope;
        private List<AccessReviewScope> reviewers;
        private String reviewersNextLink;
        private AccessReviewScheduleSettings settings;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder lastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
            this.lastModifiedDateTime = lastModifiedDateTime;
            this.changedFields = changedFields.add("lastModifiedDateTime");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder descriptionForAdmins(String descriptionForAdmins) {
            this.descriptionForAdmins = descriptionForAdmins;
            this.changedFields = changedFields.add("descriptionForAdmins");
            return this;
        }

        public Builder descriptionForReviewers(String descriptionForReviewers) {
            this.descriptionForReviewers = descriptionForReviewers;
            this.changedFields = changedFields.add("descriptionForReviewers");
            return this;
        }

        public Builder createdBy(UserIdentity createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder scope(AccessReviewScope scope) {
            this.scope = scope;
            this.changedFields = changedFields.add("scope");
            return this;
        }

        public Builder reviewers(List<AccessReviewScope> reviewers) {
            this.reviewers = reviewers;
            this.changedFields = changedFields.add("reviewers");
            return this;
        }

        public Builder reviewers(AccessReviewScope... reviewers) {
            return reviewers(Arrays.asList(reviewers));
        }

        public Builder reviewersNextLink(String reviewersNextLink) {
            this.reviewersNextLink = reviewersNextLink;
            this.changedFields = changedFields.add("reviewers");
            return this;
        }

        public Builder settings(AccessReviewScheduleSettings settings) {
            this.settings = settings;
            this.changedFields = changedFields.add("settings");
            return this;
        }

        public AccessReviewScheduleDefinition build() {
            AccessReviewScheduleDefinition _x = new AccessReviewScheduleDefinition();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.accessReviewScheduleDefinition";
            _x.id = id;
            _x.displayName = displayName;
            _x.createdDateTime = createdDateTime;
            _x.lastModifiedDateTime = lastModifiedDateTime;
            _x.status = status;
            _x.descriptionForAdmins = descriptionForAdmins;
            _x.descriptionForReviewers = descriptionForReviewers;
            _x.createdBy = createdBy;
            _x.scope = scope;
            _x.reviewers = reviewers;
            _x.reviewersNextLink = reviewersNextLink;
            _x.settings = settings;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public AccessReviewScheduleDefinition withDisplayName(String displayName) {
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleDefinition");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public AccessReviewScheduleDefinition withCreatedDateTime(OffsetDateTime createdDateTime) {
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleDefinition");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="lastModifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getLastModifiedDateTime() {
        return Optional.ofNullable(lastModifiedDateTime);
    }

    public AccessReviewScheduleDefinition withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = changedFields.add("lastModifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleDefinition");
        _x.lastModifiedDateTime = lastModifiedDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public AccessReviewScheduleDefinition withStatus(String status) {
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleDefinition");
        _x.status = status;
        return _x;
    }

    @Property(name="descriptionForAdmins")
    @JsonIgnore
    public Optional<String> getDescriptionForAdmins() {
        return Optional.ofNullable(descriptionForAdmins);
    }

    public AccessReviewScheduleDefinition withDescriptionForAdmins(String descriptionForAdmins) {
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = changedFields.add("descriptionForAdmins");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleDefinition");
        _x.descriptionForAdmins = descriptionForAdmins;
        return _x;
    }

    @Property(name="descriptionForReviewers")
    @JsonIgnore
    public Optional<String> getDescriptionForReviewers() {
        return Optional.ofNullable(descriptionForReviewers);
    }

    public AccessReviewScheduleDefinition withDescriptionForReviewers(String descriptionForReviewers) {
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = changedFields.add("descriptionForReviewers");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleDefinition");
        _x.descriptionForReviewers = descriptionForReviewers;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<UserIdentity> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public AccessReviewScheduleDefinition withCreatedBy(UserIdentity createdBy) {
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleDefinition");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="scope")
    @JsonIgnore
    public Optional<AccessReviewScope> getScope() {
        return Optional.ofNullable(scope);
    }

    public AccessReviewScheduleDefinition withScope(AccessReviewScope scope) {
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = changedFields.add("scope");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleDefinition");
        _x.scope = scope;
        return _x;
    }

    @Property(name="reviewers")
    @JsonIgnore
    public CollectionPage<AccessReviewScope> getReviewers() {
        return new CollectionPage<AccessReviewScope>(contextPath, AccessReviewScope.class, reviewers, Optional.ofNullable(reviewersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="reviewers")
    @JsonIgnore
    public CollectionPage<AccessReviewScope> getReviewers(HttpRequestOptions options) {
        return new CollectionPage<AccessReviewScope>(contextPath, AccessReviewScope.class, reviewers, Optional.ofNullable(reviewersNextLink), SchemaInfo.INSTANCE, Collections.emptyList(), options);
    }

    @Property(name="settings")
    @JsonIgnore
    public Optional<AccessReviewScheduleSettings> getSettings() {
        return Optional.ofNullable(settings);
    }

    public AccessReviewScheduleDefinition withSettings(AccessReviewScheduleSettings settings) {
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = changedFields.add("settings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewScheduleDefinition");
        _x.settings = settings;
        return _x;
    }

    @NavigationProperty(name="instances")
    @JsonIgnore
    public AccessReviewInstanceCollectionRequest getInstances() {
        return new AccessReviewInstanceCollectionRequest(
                        contextPath.addSegment("instances"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessReviewScheduleDefinition patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessReviewScheduleDefinition put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AccessReviewScheduleDefinition _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AccessReviewScheduleDefinition _copy() {
        AccessReviewScheduleDefinition _x = new AccessReviewScheduleDefinition();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.createdDateTime = createdDateTime;
        _x.lastModifiedDateTime = lastModifiedDateTime;
        _x.status = status;
        _x.descriptionForAdmins = descriptionForAdmins;
        _x.descriptionForReviewers = descriptionForReviewers;
        _x.createdBy = createdBy;
        _x.scope = scope;
        _x.reviewers = reviewers;
        _x.settings = settings;
        return _x;
    }

    @Action(name = "stop")
    @JsonIgnore
    public ActionRequestNoReturn stop() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.stop"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReviewScheduleDefinition[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("lastModifiedDateTime=");
        b.append(this.lastModifiedDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("descriptionForAdmins=");
        b.append(this.descriptionForAdmins);
        b.append(", ");
        b.append("descriptionForReviewers=");
        b.append(this.descriptionForReviewers);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("scope=");
        b.append(this.scope);
        b.append(", ");
        b.append("reviewers=");
        b.append(this.reviewers);
        b.append(", ");
        b.append("settings=");
        b.append(this.settings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
