package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AccessReviewInstanceDecisionItemTarget;
import odata.msgraph.client.beta.complex.UserIdentity;

@JsonPropertyOrder({
    "@odata.type", 
    "accessReviewId", 
    "reviewedBy", 
    "reviewedDateTime", 
    "decision", 
    "justification", 
    "appliedBy", 
    "appliedDateTime", 
    "applyResult", 
    "recommendation", 
    "target"})
@JsonInclude(Include.NON_NULL)
public class AccessReviewInstanceDecisionItem extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReviewInstanceDecisionItem";
    }

    @JsonProperty("accessReviewId")
    protected String accessReviewId;

    @JsonProperty("reviewedBy")
    protected UserIdentity reviewedBy;

    @JsonProperty("reviewedDateTime")
    protected OffsetDateTime reviewedDateTime;

    @JsonProperty("decision")
    protected String decision;

    @JsonProperty("justification")
    protected String justification;

    @JsonProperty("appliedBy")
    protected UserIdentity appliedBy;

    @JsonProperty("appliedDateTime")
    protected OffsetDateTime appliedDateTime;

    @JsonProperty("applyResult")
    protected String applyResult;

    @JsonProperty("recommendation")
    protected String recommendation;

    @JsonProperty("target")
    protected AccessReviewInstanceDecisionItemTarget target;

    protected AccessReviewInstanceDecisionItem() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessReviewInstanceDecisionItem() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String accessReviewId;
        private UserIdentity reviewedBy;
        private OffsetDateTime reviewedDateTime;
        private String decision;
        private String justification;
        private UserIdentity appliedBy;
        private OffsetDateTime appliedDateTime;
        private String applyResult;
        private String recommendation;
        private AccessReviewInstanceDecisionItemTarget target;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder accessReviewId(String accessReviewId) {
            this.accessReviewId = accessReviewId;
            this.changedFields = changedFields.add("accessReviewId");
            return this;
        }

        public Builder reviewedBy(UserIdentity reviewedBy) {
            this.reviewedBy = reviewedBy;
            this.changedFields = changedFields.add("reviewedBy");
            return this;
        }

        public Builder reviewedDateTime(OffsetDateTime reviewedDateTime) {
            this.reviewedDateTime = reviewedDateTime;
            this.changedFields = changedFields.add("reviewedDateTime");
            return this;
        }

        public Builder decision(String decision) {
            this.decision = decision;
            this.changedFields = changedFields.add("decision");
            return this;
        }

        public Builder justification(String justification) {
            this.justification = justification;
            this.changedFields = changedFields.add("justification");
            return this;
        }

        public Builder appliedBy(UserIdentity appliedBy) {
            this.appliedBy = appliedBy;
            this.changedFields = changedFields.add("appliedBy");
            return this;
        }

        public Builder appliedDateTime(OffsetDateTime appliedDateTime) {
            this.appliedDateTime = appliedDateTime;
            this.changedFields = changedFields.add("appliedDateTime");
            return this;
        }

        public Builder applyResult(String applyResult) {
            this.applyResult = applyResult;
            this.changedFields = changedFields.add("applyResult");
            return this;
        }

        public Builder recommendation(String recommendation) {
            this.recommendation = recommendation;
            this.changedFields = changedFields.add("recommendation");
            return this;
        }

        public Builder target(AccessReviewInstanceDecisionItemTarget target) {
            this.target = target;
            this.changedFields = changedFields.add("target");
            return this;
        }

        public AccessReviewInstanceDecisionItem build() {
            AccessReviewInstanceDecisionItem _x = new AccessReviewInstanceDecisionItem();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.accessReviewInstanceDecisionItem";
            _x.id = id;
            _x.accessReviewId = accessReviewId;
            _x.reviewedBy = reviewedBy;
            _x.reviewedDateTime = reviewedDateTime;
            _x.decision = decision;
            _x.justification = justification;
            _x.appliedBy = appliedBy;
            _x.appliedDateTime = appliedDateTime;
            _x.applyResult = applyResult;
            _x.recommendation = recommendation;
            _x.target = target;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="accessReviewId")
    @JsonIgnore
    public Optional<String> getAccessReviewId() {
        return Optional.ofNullable(accessReviewId);
    }

    public AccessReviewInstanceDecisionItem withAccessReviewId(String accessReviewId) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("accessReviewId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.accessReviewId = accessReviewId;
        return _x;
    }

    @Property(name="reviewedBy")
    @JsonIgnore
    public Optional<UserIdentity> getReviewedBy() {
        return Optional.ofNullable(reviewedBy);
    }

    public AccessReviewInstanceDecisionItem withReviewedBy(UserIdentity reviewedBy) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("reviewedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.reviewedBy = reviewedBy;
        return _x;
    }

    @Property(name="reviewedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getReviewedDateTime() {
        return Optional.ofNullable(reviewedDateTime);
    }

    public AccessReviewInstanceDecisionItem withReviewedDateTime(OffsetDateTime reviewedDateTime) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("reviewedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.reviewedDateTime = reviewedDateTime;
        return _x;
    }

    @Property(name="decision")
    @JsonIgnore
    public Optional<String> getDecision() {
        return Optional.ofNullable(decision);
    }

    public AccessReviewInstanceDecisionItem withDecision(String decision) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("decision");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.decision = decision;
        return _x;
    }

    @Property(name="justification")
    @JsonIgnore
    public Optional<String> getJustification() {
        return Optional.ofNullable(justification);
    }

    public AccessReviewInstanceDecisionItem withJustification(String justification) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("justification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.justification = justification;
        return _x;
    }

    @Property(name="appliedBy")
    @JsonIgnore
    public Optional<UserIdentity> getAppliedBy() {
        return Optional.ofNullable(appliedBy);
    }

    public AccessReviewInstanceDecisionItem withAppliedBy(UserIdentity appliedBy) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("appliedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.appliedBy = appliedBy;
        return _x;
    }

    @Property(name="appliedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getAppliedDateTime() {
        return Optional.ofNullable(appliedDateTime);
    }

    public AccessReviewInstanceDecisionItem withAppliedDateTime(OffsetDateTime appliedDateTime) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("appliedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.appliedDateTime = appliedDateTime;
        return _x;
    }

    @Property(name="applyResult")
    @JsonIgnore
    public Optional<String> getApplyResult() {
        return Optional.ofNullable(applyResult);
    }

    public AccessReviewInstanceDecisionItem withApplyResult(String applyResult) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("applyResult");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.applyResult = applyResult;
        return _x;
    }

    @Property(name="recommendation")
    @JsonIgnore
    public Optional<String> getRecommendation() {
        return Optional.ofNullable(recommendation);
    }

    public AccessReviewInstanceDecisionItem withRecommendation(String recommendation) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("recommendation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.recommendation = recommendation;
        return _x;
    }

    @Property(name="target")
    @JsonIgnore
    public Optional<AccessReviewInstanceDecisionItemTarget> getTarget() {
        return Optional.ofNullable(target);
    }

    public AccessReviewInstanceDecisionItem withTarget(AccessReviewInstanceDecisionItemTarget target) {
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = changedFields.add("target");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstanceDecisionItem");
        _x.target = target;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessReviewInstanceDecisionItem patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessReviewInstanceDecisionItem put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AccessReviewInstanceDecisionItem _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AccessReviewInstanceDecisionItem _copy() {
        AccessReviewInstanceDecisionItem _x = new AccessReviewInstanceDecisionItem();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.accessReviewId = accessReviewId;
        _x.reviewedBy = reviewedBy;
        _x.reviewedDateTime = reviewedDateTime;
        _x.decision = decision;
        _x.justification = justification;
        _x.appliedBy = appliedBy;
        _x.appliedDateTime = appliedDateTime;
        _x.applyResult = applyResult;
        _x.recommendation = recommendation;
        _x.target = target;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReviewInstanceDecisionItem[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("accessReviewId=");
        b.append(this.accessReviewId);
        b.append(", ");
        b.append("reviewedBy=");
        b.append(this.reviewedBy);
        b.append(", ");
        b.append("reviewedDateTime=");
        b.append(this.reviewedDateTime);
        b.append(", ");
        b.append("decision=");
        b.append(this.decision);
        b.append(", ");
        b.append("justification=");
        b.append(this.justification);
        b.append(", ");
        b.append("appliedBy=");
        b.append(this.appliedBy);
        b.append(", ");
        b.append("appliedDateTime=");
        b.append(this.appliedDateTime);
        b.append(", ");
        b.append("applyResult=");
        b.append(this.applyResult);
        b.append(", ");
        b.append("recommendation=");
        b.append(this.recommendation);
        b.append(", ");
        b.append("target=");
        b.append(this.target);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
