package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.AccessReviewInstanceDecisionItemCollectionRequest;
import odata.msgraph.client.beta.entity.request.AccessReviewScheduleDefinitionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "startDateTime", 
    "endDateTime", 
    "status"})
@JsonInclude(Include.NON_NULL)
public class AccessReviewInstance extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReviewInstance";
    }

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("status")
    protected String status;

    protected AccessReviewInstance() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessReviewInstance() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private OffsetDateTime startDateTime;
        private OffsetDateTime endDateTime;
        private String status;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public AccessReviewInstance build() {
            AccessReviewInstance _x = new AccessReviewInstance();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.accessReviewInstance";
            _x.id = id;
            _x.startDateTime = startDateTime;
            _x.endDateTime = endDateTime;
            _x.status = status;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public AccessReviewInstance withStartDateTime(OffsetDateTime startDateTime) {
        AccessReviewInstance _x = _copy();
        _x.changedFields = changedFields.add("startDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstance");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public AccessReviewInstance withEndDateTime(OffsetDateTime endDateTime) {
        AccessReviewInstance _x = _copy();
        _x.changedFields = changedFields.add("endDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstance");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public AccessReviewInstance withStatus(String status) {
        AccessReviewInstance _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewInstance");
        _x.status = status;
        return _x;
    }

    @NavigationProperty(name="decisions")
    @JsonIgnore
    public AccessReviewInstanceDecisionItemCollectionRequest getDecisions() {
        return new AccessReviewInstanceDecisionItemCollectionRequest(
                        contextPath.addSegment("decisions"));
    }

    @NavigationProperty(name="definition")
    @JsonIgnore
    public AccessReviewScheduleDefinitionRequest getDefinition() {
        return new AccessReviewScheduleDefinitionRequest(contextPath.addSegment("definition"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessReviewInstance patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AccessReviewInstance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessReviewInstance put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AccessReviewInstance _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AccessReviewInstance _copy() {
        AccessReviewInstance _x = new AccessReviewInstance();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.startDateTime = startDateTime;
        _x.endDateTime = endDateTime;
        _x.status = status;
        return _x;
    }

    @Action(name = "stop")
    @JsonIgnore
    public ActionRequestNoReturn stop() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.stop"), _parameters);
    }

    @Action(name = "sendReminder")
    @JsonIgnore
    public ActionRequestNoReturn sendReminder() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sendReminder"), _parameters);
    }

    @Action(name = "resetDecisions")
    @JsonIgnore
    public ActionRequestNoReturn resetDecisions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.resetDecisions"), _parameters);
    }

    @Action(name = "applyDecisions")
    @JsonIgnore
    public ActionRequestNoReturn applyDecisions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.applyDecisions"), _parameters);
    }

    @Action(name = "acceptRecommendations")
    @JsonIgnore
    public ActionRequestNoReturn acceptRecommendations() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.acceptRecommendations"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReviewInstance[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
