package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.UserIdentity;

@JsonPropertyOrder({
    "@odata.type", 
    "accessReviewId", 
    "reviewedBy", 
    "reviewedDateTime", 
    "reviewResult", 
    "justification", 
    "appliedBy", 
    "appliedDateTime", 
    "applyResult", 
    "accessRecommendation"})
@JsonInclude(Include.NON_NULL)
public class AccessReviewDecision extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReviewDecision";
    }

    @JsonProperty("accessReviewId")
    protected String accessReviewId;

    @JsonProperty("reviewedBy")
    protected UserIdentity reviewedBy;

    @JsonProperty("reviewedDateTime")
    protected OffsetDateTime reviewedDateTime;

    @JsonProperty("reviewResult")
    protected String reviewResult;

    @JsonProperty("justification")
    protected String justification;

    @JsonProperty("appliedBy")
    protected UserIdentity appliedBy;

    @JsonProperty("appliedDateTime")
    protected OffsetDateTime appliedDateTime;

    @JsonProperty("applyResult")
    protected String applyResult;

    @JsonProperty("accessRecommendation")
    protected String accessRecommendation;

    protected AccessReviewDecision() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessReviewDecision() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String accessReviewId;
        private UserIdentity reviewedBy;
        private OffsetDateTime reviewedDateTime;
        private String reviewResult;
        private String justification;
        private UserIdentity appliedBy;
        private OffsetDateTime appliedDateTime;
        private String applyResult;
        private String accessRecommendation;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder accessReviewId(String accessReviewId) {
            this.accessReviewId = accessReviewId;
            this.changedFields = changedFields.add("accessReviewId");
            return this;
        }

        public Builder reviewedBy(UserIdentity reviewedBy) {
            this.reviewedBy = reviewedBy;
            this.changedFields = changedFields.add("reviewedBy");
            return this;
        }

        public Builder reviewedDateTime(OffsetDateTime reviewedDateTime) {
            this.reviewedDateTime = reviewedDateTime;
            this.changedFields = changedFields.add("reviewedDateTime");
            return this;
        }

        public Builder reviewResult(String reviewResult) {
            this.reviewResult = reviewResult;
            this.changedFields = changedFields.add("reviewResult");
            return this;
        }

        public Builder justification(String justification) {
            this.justification = justification;
            this.changedFields = changedFields.add("justification");
            return this;
        }

        public Builder appliedBy(UserIdentity appliedBy) {
            this.appliedBy = appliedBy;
            this.changedFields = changedFields.add("appliedBy");
            return this;
        }

        public Builder appliedDateTime(OffsetDateTime appliedDateTime) {
            this.appliedDateTime = appliedDateTime;
            this.changedFields = changedFields.add("appliedDateTime");
            return this;
        }

        public Builder applyResult(String applyResult) {
            this.applyResult = applyResult;
            this.changedFields = changedFields.add("applyResult");
            return this;
        }

        public Builder accessRecommendation(String accessRecommendation) {
            this.accessRecommendation = accessRecommendation;
            this.changedFields = changedFields.add("accessRecommendation");
            return this;
        }

        public AccessReviewDecision build() {
            AccessReviewDecision _x = new AccessReviewDecision();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.accessReviewDecision";
            _x.id = id;
            _x.accessReviewId = accessReviewId;
            _x.reviewedBy = reviewedBy;
            _x.reviewedDateTime = reviewedDateTime;
            _x.reviewResult = reviewResult;
            _x.justification = justification;
            _x.appliedBy = appliedBy;
            _x.appliedDateTime = appliedDateTime;
            _x.applyResult = applyResult;
            _x.accessRecommendation = accessRecommendation;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="accessReviewId")
    @JsonIgnore
    public Optional<String> getAccessReviewId() {
        return Optional.ofNullable(accessReviewId);
    }

    public AccessReviewDecision withAccessReviewId(String accessReviewId) {
        AccessReviewDecision _x = _copy();
        _x.changedFields = changedFields.add("accessReviewId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewDecision");
        _x.accessReviewId = accessReviewId;
        return _x;
    }

    @Property(name="reviewedBy")
    @JsonIgnore
    public Optional<UserIdentity> getReviewedBy() {
        return Optional.ofNullable(reviewedBy);
    }

    public AccessReviewDecision withReviewedBy(UserIdentity reviewedBy) {
        AccessReviewDecision _x = _copy();
        _x.changedFields = changedFields.add("reviewedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewDecision");
        _x.reviewedBy = reviewedBy;
        return _x;
    }

    @Property(name="reviewedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getReviewedDateTime() {
        return Optional.ofNullable(reviewedDateTime);
    }

    public AccessReviewDecision withReviewedDateTime(OffsetDateTime reviewedDateTime) {
        AccessReviewDecision _x = _copy();
        _x.changedFields = changedFields.add("reviewedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewDecision");
        _x.reviewedDateTime = reviewedDateTime;
        return _x;
    }

    @Property(name="reviewResult")
    @JsonIgnore
    public Optional<String> getReviewResult() {
        return Optional.ofNullable(reviewResult);
    }

    public AccessReviewDecision withReviewResult(String reviewResult) {
        AccessReviewDecision _x = _copy();
        _x.changedFields = changedFields.add("reviewResult");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewDecision");
        _x.reviewResult = reviewResult;
        return _x;
    }

    @Property(name="justification")
    @JsonIgnore
    public Optional<String> getJustification() {
        return Optional.ofNullable(justification);
    }

    public AccessReviewDecision withJustification(String justification) {
        AccessReviewDecision _x = _copy();
        _x.changedFields = changedFields.add("justification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewDecision");
        _x.justification = justification;
        return _x;
    }

    @Property(name="appliedBy")
    @JsonIgnore
    public Optional<UserIdentity> getAppliedBy() {
        return Optional.ofNullable(appliedBy);
    }

    public AccessReviewDecision withAppliedBy(UserIdentity appliedBy) {
        AccessReviewDecision _x = _copy();
        _x.changedFields = changedFields.add("appliedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewDecision");
        _x.appliedBy = appliedBy;
        return _x;
    }

    @Property(name="appliedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getAppliedDateTime() {
        return Optional.ofNullable(appliedDateTime);
    }

    public AccessReviewDecision withAppliedDateTime(OffsetDateTime appliedDateTime) {
        AccessReviewDecision _x = _copy();
        _x.changedFields = changedFields.add("appliedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewDecision");
        _x.appliedDateTime = appliedDateTime;
        return _x;
    }

    @Property(name="applyResult")
    @JsonIgnore
    public Optional<String> getApplyResult() {
        return Optional.ofNullable(applyResult);
    }

    public AccessReviewDecision withApplyResult(String applyResult) {
        AccessReviewDecision _x = _copy();
        _x.changedFields = changedFields.add("applyResult");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewDecision");
        _x.applyResult = applyResult;
        return _x;
    }

    @Property(name="accessRecommendation")
    @JsonIgnore
    public Optional<String> getAccessRecommendation() {
        return Optional.ofNullable(accessRecommendation);
    }

    public AccessReviewDecision withAccessRecommendation(String accessRecommendation) {
        AccessReviewDecision _x = _copy();
        _x.changedFields = changedFields.add("accessRecommendation");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReviewDecision");
        _x.accessRecommendation = accessRecommendation;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessReviewDecision patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AccessReviewDecision _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessReviewDecision put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AccessReviewDecision _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AccessReviewDecision _copy() {
        AccessReviewDecision _x = new AccessReviewDecision();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.accessReviewId = accessReviewId;
        _x.reviewedBy = reviewedBy;
        _x.reviewedDateTime = reviewedDateTime;
        _x.reviewResult = reviewResult;
        _x.justification = justification;
        _x.appliedBy = appliedBy;
        _x.appliedDateTime = appliedDateTime;
        _x.applyResult = applyResult;
        _x.accessRecommendation = accessRecommendation;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReviewDecision[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("accessReviewId=");
        b.append(this.accessReviewId);
        b.append(", ");
        b.append("reviewedBy=");
        b.append(this.reviewedBy);
        b.append(", ");
        b.append("reviewedDateTime=");
        b.append(this.reviewedDateTime);
        b.append(", ");
        b.append("reviewResult=");
        b.append(this.reviewResult);
        b.append(", ");
        b.append("justification=");
        b.append(this.justification);
        b.append(", ");
        b.append("appliedBy=");
        b.append(this.appliedBy);
        b.append(", ");
        b.append("appliedDateTime=");
        b.append(this.appliedDateTime);
        b.append(", ");
        b.append("applyResult=");
        b.append(this.applyResult);
        b.append(", ");
        b.append("accessRecommendation=");
        b.append(this.accessRecommendation);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
