package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.complex.AccessReviewSettings;
import odata.msgraph.client.beta.complex.Identity;
import odata.msgraph.client.beta.complex.UserIdentity;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewDecisionCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessReviewReviewerCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "startDateTime", 
    "endDateTime", 
    "status", 
    "createdBy", 
    "businessFlowTemplateId", 
    "reviewerType", 
    "description", 
    "settings", 
    "reviewedEntity"})
@JsonInclude(Include.NON_NULL)
public class AccessReview extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessReview";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("startDateTime")
    protected OffsetDateTime startDateTime;

    @JsonProperty("endDateTime")
    protected OffsetDateTime endDateTime;

    @JsonProperty("status")
    protected String status;

    @JsonProperty("createdBy")
    protected UserIdentity createdBy;

    @JsonProperty("businessFlowTemplateId")
    protected String businessFlowTemplateId;

    @JsonProperty("reviewerType")
    protected String reviewerType;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("settings")
    protected AccessReviewSettings settings;

    @JsonProperty("reviewedEntity")
    protected Identity reviewedEntity;

    protected AccessReview() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessReview() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private OffsetDateTime startDateTime;
        private OffsetDateTime endDateTime;
        private String status;
        private UserIdentity createdBy;
        private String businessFlowTemplateId;
        private String reviewerType;
        private String description;
        private AccessReviewSettings settings;
        private Identity reviewedEntity;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder startDateTime(OffsetDateTime startDateTime) {
            this.startDateTime = startDateTime;
            this.changedFields = changedFields.add("startDateTime");
            return this;
        }

        public Builder endDateTime(OffsetDateTime endDateTime) {
            this.endDateTime = endDateTime;
            this.changedFields = changedFields.add("endDateTime");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.changedFields = changedFields.add("status");
            return this;
        }

        public Builder createdBy(UserIdentity createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder businessFlowTemplateId(String businessFlowTemplateId) {
            this.businessFlowTemplateId = businessFlowTemplateId;
            this.changedFields = changedFields.add("businessFlowTemplateId");
            return this;
        }

        public Builder reviewerType(String reviewerType) {
            this.reviewerType = reviewerType;
            this.changedFields = changedFields.add("reviewerType");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder settings(AccessReviewSettings settings) {
            this.settings = settings;
            this.changedFields = changedFields.add("settings");
            return this;
        }

        public Builder reviewedEntity(Identity reviewedEntity) {
            this.reviewedEntity = reviewedEntity;
            this.changedFields = changedFields.add("reviewedEntity");
            return this;
        }

        public AccessReview build() {
            AccessReview _x = new AccessReview();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.accessReview";
            _x.id = id;
            _x.displayName = displayName;
            _x.startDateTime = startDateTime;
            _x.endDateTime = endDateTime;
            _x.status = status;
            _x.createdBy = createdBy;
            _x.businessFlowTemplateId = businessFlowTemplateId;
            _x.reviewerType = reviewerType;
            _x.description = description;
            _x.settings = settings;
            _x.reviewedEntity = reviewedEntity;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public AccessReview withDisplayName(String displayName) {
        AccessReview _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReview");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="startDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getStartDateTime() {
        return Optional.ofNullable(startDateTime);
    }

    public AccessReview withStartDateTime(OffsetDateTime startDateTime) {
        AccessReview _x = _copy();
        _x.changedFields = changedFields.add("startDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReview");
        _x.startDateTime = startDateTime;
        return _x;
    }

    @Property(name="endDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getEndDateTime() {
        return Optional.ofNullable(endDateTime);
    }

    public AccessReview withEndDateTime(OffsetDateTime endDateTime) {
        AccessReview _x = _copy();
        _x.changedFields = changedFields.add("endDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReview");
        _x.endDateTime = endDateTime;
        return _x;
    }

    @Property(name="status")
    @JsonIgnore
    public Optional<String> getStatus() {
        return Optional.ofNullable(status);
    }

    public AccessReview withStatus(String status) {
        AccessReview _x = _copy();
        _x.changedFields = changedFields.add("status");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReview");
        _x.status = status;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<UserIdentity> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public AccessReview withCreatedBy(UserIdentity createdBy) {
        AccessReview _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReview");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="businessFlowTemplateId")
    @JsonIgnore
    public Optional<String> getBusinessFlowTemplateId() {
        return Optional.ofNullable(businessFlowTemplateId);
    }

    public AccessReview withBusinessFlowTemplateId(String businessFlowTemplateId) {
        AccessReview _x = _copy();
        _x.changedFields = changedFields.add("businessFlowTemplateId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReview");
        _x.businessFlowTemplateId = businessFlowTemplateId;
        return _x;
    }

    @Property(name="reviewerType")
    @JsonIgnore
    public Optional<String> getReviewerType() {
        return Optional.ofNullable(reviewerType);
    }

    public AccessReview withReviewerType(String reviewerType) {
        AccessReview _x = _copy();
        _x.changedFields = changedFields.add("reviewerType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReview");
        _x.reviewerType = reviewerType;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public AccessReview withDescription(String description) {
        AccessReview _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReview");
        _x.description = description;
        return _x;
    }

    @Property(name="settings")
    @JsonIgnore
    public Optional<AccessReviewSettings> getSettings() {
        return Optional.ofNullable(settings);
    }

    public AccessReview withSettings(AccessReviewSettings settings) {
        AccessReview _x = _copy();
        _x.changedFields = changedFields.add("settings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReview");
        _x.settings = settings;
        return _x;
    }

    @Property(name="reviewedEntity")
    @JsonIgnore
    public Optional<Identity> getReviewedEntity() {
        return Optional.ofNullable(reviewedEntity);
    }

    public AccessReview withReviewedEntity(Identity reviewedEntity) {
        AccessReview _x = _copy();
        _x.changedFields = changedFields.add("reviewedEntity");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessReview");
        _x.reviewedEntity = reviewedEntity;
        return _x;
    }

    @NavigationProperty(name="reviewers")
    @JsonIgnore
    public AccessReviewReviewerCollectionRequest getReviewers() {
        return new AccessReviewReviewerCollectionRequest(
                        contextPath.addSegment("reviewers"));
    }

    @NavigationProperty(name="decisions")
    @JsonIgnore
    public AccessReviewDecisionCollectionRequest getDecisions() {
        return new AccessReviewDecisionCollectionRequest(
                        contextPath.addSegment("decisions"));
    }

    @NavigationProperty(name="myDecisions")
    @JsonIgnore
    public AccessReviewDecisionCollectionRequest getMyDecisions() {
        return new AccessReviewDecisionCollectionRequest(
                        contextPath.addSegment("myDecisions"));
    }

    @NavigationProperty(name="instances")
    @JsonIgnore
    public AccessReviewCollectionRequest getInstances() {
        return new AccessReviewCollectionRequest(
                        contextPath.addSegment("instances"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessReview patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AccessReview _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessReview put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AccessReview _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AccessReview _copy() {
        AccessReview _x = new AccessReview();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.startDateTime = startDateTime;
        _x.endDateTime = endDateTime;
        _x.status = status;
        _x.createdBy = createdBy;
        _x.businessFlowTemplateId = businessFlowTemplateId;
        _x.reviewerType = reviewerType;
        _x.description = description;
        _x.settings = settings;
        _x.reviewedEntity = reviewedEntity;
        return _x;
    }

    @Action(name = "stop")
    @JsonIgnore
    public ActionRequestNoReturn stop() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.stop"), _parameters);
    }

    @Action(name = "sendReminder")
    @JsonIgnore
    public ActionRequestNoReturn sendReminder() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.sendReminder"), _parameters);
    }

    @Action(name = "resetDecisions")
    @JsonIgnore
    public ActionRequestNoReturn resetDecisions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.resetDecisions"), _parameters);
    }

    @Action(name = "applyDecisions")
    @JsonIgnore
    public ActionRequestNoReturn applyDecisions() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.applyDecisions"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessReview[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("startDateTime=");
        b.append(this.startDateTime);
        b.append(", ");
        b.append("endDateTime=");
        b.append(this.endDateTime);
        b.append(", ");
        b.append("status=");
        b.append(this.status);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("businessFlowTemplateId=");
        b.append(this.businessFlowTemplateId);
        b.append(", ");
        b.append("reviewerType=");
        b.append(this.reviewerType);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("settings=");
        b.append(this.settings);
        b.append(", ");
        b.append("reviewedEntity=");
        b.append(this.reviewedEntity);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
