package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import odata.msgraph.client.beta.entity.request.ConnectedOrganizationRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "objectId", 
    "altSecId", 
    "displayName", 
    "principalName", 
    "email", 
    "onPremisesSecurityIdentifier", 
    "type", 
    "connectedOrganizationId"})
@JsonInclude(Include.NON_NULL)
public class AccessPackageSubject extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessPackageSubject";
    }

    @JsonProperty("objectId")
    protected String objectId;

    @JsonProperty("altSecId")
    protected String altSecId;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("principalName")
    protected String principalName;

    @JsonProperty("email")
    protected String email;

    @JsonProperty("onPremisesSecurityIdentifier")
    protected String onPremisesSecurityIdentifier;

    @JsonProperty("type")
    protected String type;

    @JsonProperty("connectedOrganizationId")
    protected String connectedOrganizationId;

    protected AccessPackageSubject() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessPackageSubject() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String objectId;
        private String altSecId;
        private String displayName;
        private String principalName;
        private String email;
        private String onPremisesSecurityIdentifier;
        private String type;
        private String connectedOrganizationId;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder objectId(String objectId) {
            this.objectId = objectId;
            this.changedFields = changedFields.add("objectId");
            return this;
        }

        public Builder altSecId(String altSecId) {
            this.altSecId = altSecId;
            this.changedFields = changedFields.add("altSecId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder principalName(String principalName) {
            this.principalName = principalName;
            this.changedFields = changedFields.add("principalName");
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            this.changedFields = changedFields.add("email");
            return this;
        }

        public Builder onPremisesSecurityIdentifier(String onPremisesSecurityIdentifier) {
            this.onPremisesSecurityIdentifier = onPremisesSecurityIdentifier;
            this.changedFields = changedFields.add("onPremisesSecurityIdentifier");
            return this;
        }

        public Builder type(String type) {
            this.type = type;
            this.changedFields = changedFields.add("type");
            return this;
        }

        public Builder connectedOrganizationId(String connectedOrganizationId) {
            this.connectedOrganizationId = connectedOrganizationId;
            this.changedFields = changedFields.add("connectedOrganizationId");
            return this;
        }

        public AccessPackageSubject build() {
            AccessPackageSubject _x = new AccessPackageSubject();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.accessPackageSubject";
            _x.id = id;
            _x.objectId = objectId;
            _x.altSecId = altSecId;
            _x.displayName = displayName;
            _x.principalName = principalName;
            _x.email = email;
            _x.onPremisesSecurityIdentifier = onPremisesSecurityIdentifier;
            _x.type = type;
            _x.connectedOrganizationId = connectedOrganizationId;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="objectId")
    @JsonIgnore
    public Optional<String> getObjectId() {
        return Optional.ofNullable(objectId);
    }

    public AccessPackageSubject withObjectId(String objectId) {
        AccessPackageSubject _x = _copy();
        _x.changedFields = changedFields.add("objectId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageSubject");
        _x.objectId = objectId;
        return _x;
    }

    @Property(name="altSecId")
    @JsonIgnore
    public Optional<String> getAltSecId() {
        return Optional.ofNullable(altSecId);
    }

    public AccessPackageSubject withAltSecId(String altSecId) {
        AccessPackageSubject _x = _copy();
        _x.changedFields = changedFields.add("altSecId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageSubject");
        _x.altSecId = altSecId;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public AccessPackageSubject withDisplayName(String displayName) {
        AccessPackageSubject _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageSubject");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="principalName")
    @JsonIgnore
    public Optional<String> getPrincipalName() {
        return Optional.ofNullable(principalName);
    }

    public AccessPackageSubject withPrincipalName(String principalName) {
        AccessPackageSubject _x = _copy();
        _x.changedFields = changedFields.add("principalName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageSubject");
        _x.principalName = principalName;
        return _x;
    }

    @Property(name="email")
    @JsonIgnore
    public Optional<String> getEmail() {
        return Optional.ofNullable(email);
    }

    public AccessPackageSubject withEmail(String email) {
        AccessPackageSubject _x = _copy();
        _x.changedFields = changedFields.add("email");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageSubject");
        _x.email = email;
        return _x;
    }

    @Property(name="onPremisesSecurityIdentifier")
    @JsonIgnore
    public Optional<String> getOnPremisesSecurityIdentifier() {
        return Optional.ofNullable(onPremisesSecurityIdentifier);
    }

    public AccessPackageSubject withOnPremisesSecurityIdentifier(String onPremisesSecurityIdentifier) {
        AccessPackageSubject _x = _copy();
        _x.changedFields = changedFields.add("onPremisesSecurityIdentifier");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageSubject");
        _x.onPremisesSecurityIdentifier = onPremisesSecurityIdentifier;
        return _x;
    }

    @Property(name="type")
    @JsonIgnore
    public Optional<String> getType() {
        return Optional.ofNullable(type);
    }

    public AccessPackageSubject withType(String type) {
        AccessPackageSubject _x = _copy();
        _x.changedFields = changedFields.add("type");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageSubject");
        _x.type = type;
        return _x;
    }

    @Property(name="connectedOrganizationId")
    @JsonIgnore
    public Optional<String> getConnectedOrganizationId() {
        return Optional.ofNullable(connectedOrganizationId);
    }

    public AccessPackageSubject withConnectedOrganizationId(String connectedOrganizationId) {
        AccessPackageSubject _x = _copy();
        _x.changedFields = changedFields.add("connectedOrganizationId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageSubject");
        _x.connectedOrganizationId = connectedOrganizationId;
        return _x;
    }

    @NavigationProperty(name="connectedOrganization")
    @JsonIgnore
    public ConnectedOrganizationRequest getConnectedOrganization() {
        return new ConnectedOrganizationRequest(contextPath.addSegment("connectedOrganization"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackageSubject patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AccessPackageSubject _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackageSubject put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AccessPackageSubject _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AccessPackageSubject _copy() {
        AccessPackageSubject _x = new AccessPackageSubject();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.objectId = objectId;
        _x.altSecId = altSecId;
        _x.displayName = displayName;
        _x.principalName = principalName;
        _x.email = email;
        _x.onPremisesSecurityIdentifier = onPremisesSecurityIdentifier;
        _x.type = type;
        _x.connectedOrganizationId = connectedOrganizationId;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessPackageSubject[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("objectId=");
        b.append(this.objectId);
        b.append(", ");
        b.append("altSecId=");
        b.append(this.altSecId);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("principalName=");
        b.append(this.principalName);
        b.append(", ");
        b.append("email=");
        b.append(this.email);
        b.append(", ");
        b.append("onPremisesSecurityIdentifier=");
        b.append(this.onPremisesSecurityIdentifier);
        b.append(", ");
        b.append("type=");
        b.append(this.type);
        b.append(", ");
        b.append("connectedOrganizationId=");
        b.append(this.connectedOrganizationId);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
