package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.AccessPackageSubjectRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "catalogId", 
    "executeImmediately", 
    "isValidationOnly", 
    "requestType", 
    "requestState", 
    "requestStatus", 
    "expirationDateTime", 
    "justification"})
@JsonInclude(Include.NON_NULL)
public class AccessPackageResourceRequest extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessPackageResourceRequest";
    }

    @JsonProperty("catalogId")
    protected String catalogId;

    @JsonProperty("executeImmediately")
    protected Boolean executeImmediately;

    @JsonProperty("isValidationOnly")
    protected Boolean isValidationOnly;

    @JsonProperty("requestType")
    protected String requestType;

    @JsonProperty("requestState")
    protected String requestState;

    @JsonProperty("requestStatus")
    protected String requestStatus;

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    @JsonProperty("justification")
    protected String justification;

    protected AccessPackageResourceRequest() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessPackageResourceRequest() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String catalogId;
        private Boolean executeImmediately;
        private Boolean isValidationOnly;
        private String requestType;
        private String requestState;
        private String requestStatus;
        private OffsetDateTime expirationDateTime;
        private String justification;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            this.changedFields = changedFields.add("catalogId");
            return this;
        }

        public Builder executeImmediately(Boolean executeImmediately) {
            this.executeImmediately = executeImmediately;
            this.changedFields = changedFields.add("executeImmediately");
            return this;
        }

        public Builder isValidationOnly(Boolean isValidationOnly) {
            this.isValidationOnly = isValidationOnly;
            this.changedFields = changedFields.add("isValidationOnly");
            return this;
        }

        public Builder requestType(String requestType) {
            this.requestType = requestType;
            this.changedFields = changedFields.add("requestType");
            return this;
        }

        public Builder requestState(String requestState) {
            this.requestState = requestState;
            this.changedFields = changedFields.add("requestState");
            return this;
        }

        public Builder requestStatus(String requestStatus) {
            this.requestStatus = requestStatus;
            this.changedFields = changedFields.add("requestStatus");
            return this;
        }

        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        public Builder justification(String justification) {
            this.justification = justification;
            this.changedFields = changedFields.add("justification");
            return this;
        }

        public AccessPackageResourceRequest build() {
            AccessPackageResourceRequest _x = new AccessPackageResourceRequest();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.accessPackageResourceRequest";
            _x.id = id;
            _x.catalogId = catalogId;
            _x.executeImmediately = executeImmediately;
            _x.isValidationOnly = isValidationOnly;
            _x.requestType = requestType;
            _x.requestState = requestState;
            _x.requestStatus = requestStatus;
            _x.expirationDateTime = expirationDateTime;
            _x.justification = justification;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="catalogId")
    @JsonIgnore
    public Optional<String> getCatalogId() {
        return Optional.ofNullable(catalogId);
    }

    public AccessPackageResourceRequest withCatalogId(String catalogId) {
        AccessPackageResourceRequest _x = _copy();
        _x.changedFields = changedFields.add("catalogId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceRequest");
        _x.catalogId = catalogId;
        return _x;
    }

    @Property(name="executeImmediately")
    @JsonIgnore
    public Optional<Boolean> getExecuteImmediately() {
        return Optional.ofNullable(executeImmediately);
    }

    public AccessPackageResourceRequest withExecuteImmediately(Boolean executeImmediately) {
        AccessPackageResourceRequest _x = _copy();
        _x.changedFields = changedFields.add("executeImmediately");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceRequest");
        _x.executeImmediately = executeImmediately;
        return _x;
    }

    @Property(name="isValidationOnly")
    @JsonIgnore
    public Optional<Boolean> getIsValidationOnly() {
        return Optional.ofNullable(isValidationOnly);
    }

    public AccessPackageResourceRequest withIsValidationOnly(Boolean isValidationOnly) {
        AccessPackageResourceRequest _x = _copy();
        _x.changedFields = changedFields.add("isValidationOnly");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceRequest");
        _x.isValidationOnly = isValidationOnly;
        return _x;
    }

    @Property(name="requestType")
    @JsonIgnore
    public Optional<String> getRequestType() {
        return Optional.ofNullable(requestType);
    }

    public AccessPackageResourceRequest withRequestType(String requestType) {
        AccessPackageResourceRequest _x = _copy();
        _x.changedFields = changedFields.add("requestType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceRequest");
        _x.requestType = requestType;
        return _x;
    }

    @Property(name="requestState")
    @JsonIgnore
    public Optional<String> getRequestState() {
        return Optional.ofNullable(requestState);
    }

    public AccessPackageResourceRequest withRequestState(String requestState) {
        AccessPackageResourceRequest _x = _copy();
        _x.changedFields = changedFields.add("requestState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceRequest");
        _x.requestState = requestState;
        return _x;
    }

    @Property(name="requestStatus")
    @JsonIgnore
    public Optional<String> getRequestStatus() {
        return Optional.ofNullable(requestStatus);
    }

    public AccessPackageResourceRequest withRequestStatus(String requestStatus) {
        AccessPackageResourceRequest _x = _copy();
        _x.changedFields = changedFields.add("requestStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceRequest");
        _x.requestStatus = requestStatus;
        return _x;
    }

    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    public AccessPackageResourceRequest withExpirationDateTime(OffsetDateTime expirationDateTime) {
        AccessPackageResourceRequest _x = _copy();
        _x.changedFields = changedFields.add("expirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceRequest");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    @Property(name="justification")
    @JsonIgnore
    public Optional<String> getJustification() {
        return Optional.ofNullable(justification);
    }

    public AccessPackageResourceRequest withJustification(String justification) {
        AccessPackageResourceRequest _x = _copy();
        _x.changedFields = changedFields.add("justification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResourceRequest");
        _x.justification = justification;
        return _x;
    }

    @NavigationProperty(name="accessPackageResource")
    @JsonIgnore
    public odata.msgraph.client.beta.entity.request.AccessPackageResourceRequest getAccessPackageResource() {
        return new odata.msgraph.client.beta.entity.request.AccessPackageResourceRequest(contextPath.addSegment("accessPackageResource"));
    }

    @NavigationProperty(name="requestor")
    @JsonIgnore
    public AccessPackageSubjectRequest getRequestor() {
        return new AccessPackageSubjectRequest(contextPath.addSegment("requestor"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackageResourceRequest patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AccessPackageResourceRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackageResourceRequest put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AccessPackageResourceRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AccessPackageResourceRequest _copy() {
        AccessPackageResourceRequest _x = new AccessPackageResourceRequest();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.catalogId = catalogId;
        _x.executeImmediately = executeImmediately;
        _x.isValidationOnly = isValidationOnly;
        _x.requestType = requestType;
        _x.requestState = requestState;
        _x.requestStatus = requestStatus;
        _x.expirationDateTime = expirationDateTime;
        _x.justification = justification;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessPackageResourceRequest[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("catalogId=");
        b.append(this.catalogId);
        b.append(", ");
        b.append("executeImmediately=");
        b.append(this.executeImmediately);
        b.append(", ");
        b.append("isValidationOnly=");
        b.append(this.isValidationOnly);
        b.append(", ");
        b.append("requestType=");
        b.append(this.requestType);
        b.append(", ");
        b.append("requestState=");
        b.append(this.requestState);
        b.append(", ");
        b.append("requestStatus=");
        b.append(this.requestStatus);
        b.append(", ");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append(", ");
        b.append("justification=");
        b.append(this.justification);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
