package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceRoleCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceScopeCollectionRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "displayName", 
    "description", 
    "url", 
    "resourceType", 
    "originId", 
    "originSystem", 
    "isPendingOnboarding", 
    "addedBy", 
    "addedOn"})
@JsonInclude(Include.NON_NULL)
public class AccessPackageResource extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessPackageResource";
    }

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("url")
    protected String url;

    @JsonProperty("resourceType")
    protected String resourceType;

    @JsonProperty("originId")
    protected String originId;

    @JsonProperty("originSystem")
    protected String originSystem;

    @JsonProperty("isPendingOnboarding")
    protected Boolean isPendingOnboarding;

    @JsonProperty("addedBy")
    protected String addedBy;

    @JsonProperty("addedOn")
    protected OffsetDateTime addedOn;

    protected AccessPackageResource() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessPackageResource() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String displayName;
        private String description;
        private String url;
        private String resourceType;
        private String originId;
        private String originSystem;
        private Boolean isPendingOnboarding;
        private String addedBy;
        private OffsetDateTime addedOn;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder url(String url) {
            this.url = url;
            this.changedFields = changedFields.add("url");
            return this;
        }

        public Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            this.changedFields = changedFields.add("resourceType");
            return this;
        }

        public Builder originId(String originId) {
            this.originId = originId;
            this.changedFields = changedFields.add("originId");
            return this;
        }

        public Builder originSystem(String originSystem) {
            this.originSystem = originSystem;
            this.changedFields = changedFields.add("originSystem");
            return this;
        }

        public Builder isPendingOnboarding(Boolean isPendingOnboarding) {
            this.isPendingOnboarding = isPendingOnboarding;
            this.changedFields = changedFields.add("isPendingOnboarding");
            return this;
        }

        public Builder addedBy(String addedBy) {
            this.addedBy = addedBy;
            this.changedFields = changedFields.add("addedBy");
            return this;
        }

        public Builder addedOn(OffsetDateTime addedOn) {
            this.addedOn = addedOn;
            this.changedFields = changedFields.add("addedOn");
            return this;
        }

        public AccessPackageResource build() {
            AccessPackageResource _x = new AccessPackageResource();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.accessPackageResource";
            _x.id = id;
            _x.displayName = displayName;
            _x.description = description;
            _x.url = url;
            _x.resourceType = resourceType;
            _x.originId = originId;
            _x.originSystem = originSystem;
            _x.isPendingOnboarding = isPendingOnboarding;
            _x.addedBy = addedBy;
            _x.addedOn = addedOn;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public AccessPackageResource withDisplayName(String displayName) {
        AccessPackageResource _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResource");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public AccessPackageResource withDescription(String description) {
        AccessPackageResource _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResource");
        _x.description = description;
        return _x;
    }

    @Property(name="url")
    @JsonIgnore
    public Optional<String> getUrl() {
        return Optional.ofNullable(url);
    }

    public AccessPackageResource withUrl(String url) {
        AccessPackageResource _x = _copy();
        _x.changedFields = changedFields.add("url");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResource");
        _x.url = url;
        return _x;
    }

    @Property(name="resourceType")
    @JsonIgnore
    public Optional<String> getResourceType() {
        return Optional.ofNullable(resourceType);
    }

    public AccessPackageResource withResourceType(String resourceType) {
        AccessPackageResource _x = _copy();
        _x.changedFields = changedFields.add("resourceType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResource");
        _x.resourceType = resourceType;
        return _x;
    }

    @Property(name="originId")
    @JsonIgnore
    public Optional<String> getOriginId() {
        return Optional.ofNullable(originId);
    }

    public AccessPackageResource withOriginId(String originId) {
        AccessPackageResource _x = _copy();
        _x.changedFields = changedFields.add("originId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResource");
        _x.originId = originId;
        return _x;
    }

    @Property(name="originSystem")
    @JsonIgnore
    public Optional<String> getOriginSystem() {
        return Optional.ofNullable(originSystem);
    }

    public AccessPackageResource withOriginSystem(String originSystem) {
        AccessPackageResource _x = _copy();
        _x.changedFields = changedFields.add("originSystem");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResource");
        _x.originSystem = originSystem;
        return _x;
    }

    @Property(name="isPendingOnboarding")
    @JsonIgnore
    public Optional<Boolean> getIsPendingOnboarding() {
        return Optional.ofNullable(isPendingOnboarding);
    }

    public AccessPackageResource withIsPendingOnboarding(Boolean isPendingOnboarding) {
        AccessPackageResource _x = _copy();
        _x.changedFields = changedFields.add("isPendingOnboarding");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResource");
        _x.isPendingOnboarding = isPendingOnboarding;
        return _x;
    }

    @Property(name="addedBy")
    @JsonIgnore
    public Optional<String> getAddedBy() {
        return Optional.ofNullable(addedBy);
    }

    public AccessPackageResource withAddedBy(String addedBy) {
        AccessPackageResource _x = _copy();
        _x.changedFields = changedFields.add("addedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResource");
        _x.addedBy = addedBy;
        return _x;
    }

    @Property(name="addedOn")
    @JsonIgnore
    public Optional<OffsetDateTime> getAddedOn() {
        return Optional.ofNullable(addedOn);
    }

    public AccessPackageResource withAddedOn(OffsetDateTime addedOn) {
        AccessPackageResource _x = _copy();
        _x.changedFields = changedFields.add("addedOn");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageResource");
        _x.addedOn = addedOn;
        return _x;
    }

    @NavigationProperty(name="accessPackageResourceScopes")
    @JsonIgnore
    public AccessPackageResourceScopeCollectionRequest getAccessPackageResourceScopes() {
        return new AccessPackageResourceScopeCollectionRequest(
                        contextPath.addSegment("accessPackageResourceScopes"));
    }

    @NavigationProperty(name="accessPackageResourceRoles")
    @JsonIgnore
    public AccessPackageResourceRoleCollectionRequest getAccessPackageResourceRoles() {
        return new AccessPackageResourceRoleCollectionRequest(
                        contextPath.addSegment("accessPackageResourceRoles"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackageResource patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AccessPackageResource _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackageResource put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AccessPackageResource _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AccessPackageResource _copy() {
        AccessPackageResource _x = new AccessPackageResource();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.displayName = displayName;
        _x.description = description;
        _x.url = url;
        _x.resourceType = resourceType;
        _x.originId = originId;
        _x.originSystem = originSystem;
        _x.isPendingOnboarding = isPendingOnboarding;
        _x.addedBy = addedBy;
        _x.addedOn = addedOn;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessPackageResource[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("url=");
        b.append(this.url);
        b.append(", ");
        b.append("resourceType=");
        b.append(this.resourceType);
        b.append(", ");
        b.append("originId=");
        b.append(this.originId);
        b.append(", ");
        b.append("originSystem=");
        b.append(this.originSystem);
        b.append(", ");
        b.append("isPendingOnboarding=");
        b.append(this.isPendingOnboarding);
        b.append(", ");
        b.append("addedBy=");
        b.append(this.addedBy);
        b.append(", ");
        b.append("addedOn=");
        b.append(this.addedOn);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
