package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.TypedObject;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Map;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.AccessPackageRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageSubjectRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "requestType", 
    "requestState", 
    "requestStatus", 
    "isValidationOnly", 
    "createdDateTime", 
    "completedDate", 
    "expirationDateTime", 
    "justification"})
@JsonInclude(Include.NON_NULL)
public class AccessPackageAssignmentRequest extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessPackageAssignmentRequest";
    }

    @JsonProperty("requestType")
    protected String requestType;

    @JsonProperty("requestState")
    protected String requestState;

    @JsonProperty("requestStatus")
    protected String requestStatus;

    @JsonProperty("isValidationOnly")
    protected Boolean isValidationOnly;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("completedDate")
    protected OffsetDateTime completedDate;

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    @JsonProperty("justification")
    protected String justification;

    protected AccessPackageAssignmentRequest() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessPackageAssignmentRequest() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String requestType;
        private String requestState;
        private String requestStatus;
        private Boolean isValidationOnly;
        private OffsetDateTime createdDateTime;
        private OffsetDateTime completedDate;
        private OffsetDateTime expirationDateTime;
        private String justification;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder requestType(String requestType) {
            this.requestType = requestType;
            this.changedFields = changedFields.add("requestType");
            return this;
        }

        public Builder requestState(String requestState) {
            this.requestState = requestState;
            this.changedFields = changedFields.add("requestState");
            return this;
        }

        public Builder requestStatus(String requestStatus) {
            this.requestStatus = requestStatus;
            this.changedFields = changedFields.add("requestStatus");
            return this;
        }

        public Builder isValidationOnly(Boolean isValidationOnly) {
            this.isValidationOnly = isValidationOnly;
            this.changedFields = changedFields.add("isValidationOnly");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder completedDate(OffsetDateTime completedDate) {
            this.completedDate = completedDate;
            this.changedFields = changedFields.add("completedDate");
            return this;
        }

        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        public Builder justification(String justification) {
            this.justification = justification;
            this.changedFields = changedFields.add("justification");
            return this;
        }

        public AccessPackageAssignmentRequest build() {
            AccessPackageAssignmentRequest _x = new AccessPackageAssignmentRequest();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.accessPackageAssignmentRequest";
            _x.id = id;
            _x.requestType = requestType;
            _x.requestState = requestState;
            _x.requestStatus = requestStatus;
            _x.isValidationOnly = isValidationOnly;
            _x.createdDateTime = createdDateTime;
            _x.completedDate = completedDate;
            _x.expirationDateTime = expirationDateTime;
            _x.justification = justification;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="requestType")
    @JsonIgnore
    public Optional<String> getRequestType() {
        return Optional.ofNullable(requestType);
    }

    public AccessPackageAssignmentRequest withRequestType(String requestType) {
        AccessPackageAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("requestType");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentRequest");
        _x.requestType = requestType;
        return _x;
    }

    @Property(name="requestState")
    @JsonIgnore
    public Optional<String> getRequestState() {
        return Optional.ofNullable(requestState);
    }

    public AccessPackageAssignmentRequest withRequestState(String requestState) {
        AccessPackageAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("requestState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentRequest");
        _x.requestState = requestState;
        return _x;
    }

    @Property(name="requestStatus")
    @JsonIgnore
    public Optional<String> getRequestStatus() {
        return Optional.ofNullable(requestStatus);
    }

    public AccessPackageAssignmentRequest withRequestStatus(String requestStatus) {
        AccessPackageAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("requestStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentRequest");
        _x.requestStatus = requestStatus;
        return _x;
    }

    @Property(name="isValidationOnly")
    @JsonIgnore
    public Optional<Boolean> getIsValidationOnly() {
        return Optional.ofNullable(isValidationOnly);
    }

    public AccessPackageAssignmentRequest withIsValidationOnly(Boolean isValidationOnly) {
        AccessPackageAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("isValidationOnly");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentRequest");
        _x.isValidationOnly = isValidationOnly;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public AccessPackageAssignmentRequest withCreatedDateTime(OffsetDateTime createdDateTime) {
        AccessPackageAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentRequest");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="completedDate")
    @JsonIgnore
    public Optional<OffsetDateTime> getCompletedDate() {
        return Optional.ofNullable(completedDate);
    }

    public AccessPackageAssignmentRequest withCompletedDate(OffsetDateTime completedDate) {
        AccessPackageAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("completedDate");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentRequest");
        _x.completedDate = completedDate;
        return _x;
    }

    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    public AccessPackageAssignmentRequest withExpirationDateTime(OffsetDateTime expirationDateTime) {
        AccessPackageAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("expirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentRequest");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    @Property(name="justification")
    @JsonIgnore
    public Optional<String> getJustification() {
        return Optional.ofNullable(justification);
    }

    public AccessPackageAssignmentRequest withJustification(String justification) {
        AccessPackageAssignmentRequest _x = _copy();
        _x.changedFields = changedFields.add("justification");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentRequest");
        _x.justification = justification;
        return _x;
    }

    @NavigationProperty(name="accessPackage")
    @JsonIgnore
    public AccessPackageRequest getAccessPackage() {
        return new AccessPackageRequest(contextPath.addSegment("accessPackage"));
    }

    @NavigationProperty(name="accessPackageAssignment")
    @JsonIgnore
    public odata.msgraph.client.beta.entity.request.AccessPackageAssignmentRequest getAccessPackageAssignment() {
        return new odata.msgraph.client.beta.entity.request.AccessPackageAssignmentRequest(contextPath.addSegment("accessPackageAssignment"));
    }

    @NavigationProperty(name="requestor")
    @JsonIgnore
    public AccessPackageSubjectRequest getRequestor() {
        return new AccessPackageSubjectRequest(contextPath.addSegment("requestor"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackageAssignmentRequest patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AccessPackageAssignmentRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackageAssignmentRequest put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AccessPackageAssignmentRequest _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AccessPackageAssignmentRequest _copy() {
        AccessPackageAssignmentRequest _x = new AccessPackageAssignmentRequest();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.requestType = requestType;
        _x.requestState = requestState;
        _x.requestStatus = requestStatus;
        _x.isValidationOnly = isValidationOnly;
        _x.createdDateTime = createdDateTime;
        _x.completedDate = completedDate;
        _x.expirationDateTime = expirationDateTime;
        _x.justification = justification;
        return _x;
    }

    @Action(name = "Cancel")
    @JsonIgnore
    public ActionRequestNoReturn cancel() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.Cancel"), _parameters);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessPackageAssignmentRequest[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("requestType=");
        b.append(this.requestType);
        b.append(", ");
        b.append("requestState=");
        b.append(this.requestState);
        b.append(", ");
        b.append("requestStatus=");
        b.append(this.requestStatus);
        b.append(", ");
        b.append("isValidationOnly=");
        b.append(this.isValidationOnly);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("completedDate=");
        b.append(this.completedDate);
        b.append(", ");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append(", ");
        b.append("justification=");
        b.append(this.justification);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
