package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.complex.ApprovalSettings;
import odata.msgraph.client.beta.complex.AssignmentReviewSettings;
import odata.msgraph.client.beta.complex.RequestorSettings;
import odata.msgraph.client.beta.entity.request.AccessPackageCatalogRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "accessPackageId", 
    "displayName", 
    "description", 
    "canExtend", 
    "durationInDays", 
    "expirationDateTime", 
    "createdBy", 
    "createdDateTime", 
    "modifiedBy", 
    "modifiedDateTime", 
    "requestorSettings", 
    "requestApprovalSettings", 
    "accessReviewSettings"})
@JsonInclude(Include.NON_NULL)
public class AccessPackageAssignmentPolicy extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessPackageAssignmentPolicy";
    }

    @JsonProperty("accessPackageId")
    protected String accessPackageId;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("canExtend")
    protected Boolean canExtend;

    @JsonProperty("durationInDays")
    protected Integer durationInDays;

    @JsonProperty("expirationDateTime")
    protected OffsetDateTime expirationDateTime;

    @JsonProperty("createdBy")
    protected String createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("modifiedBy")
    protected String modifiedBy;

    @JsonProperty("modifiedDateTime")
    protected OffsetDateTime modifiedDateTime;

    @JsonProperty("requestorSettings")
    protected RequestorSettings requestorSettings;

    @JsonProperty("requestApprovalSettings")
    protected ApprovalSettings requestApprovalSettings;

    @JsonProperty("accessReviewSettings")
    protected AssignmentReviewSettings accessReviewSettings;

    protected AccessPackageAssignmentPolicy() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessPackageAssignmentPolicy() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String accessPackageId;
        private String displayName;
        private String description;
        private Boolean canExtend;
        private Integer durationInDays;
        private OffsetDateTime expirationDateTime;
        private String createdBy;
        private OffsetDateTime createdDateTime;
        private String modifiedBy;
        private OffsetDateTime modifiedDateTime;
        private RequestorSettings requestorSettings;
        private ApprovalSettings requestApprovalSettings;
        private AssignmentReviewSettings accessReviewSettings;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder accessPackageId(String accessPackageId) {
            this.accessPackageId = accessPackageId;
            this.changedFields = changedFields.add("accessPackageId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder canExtend(Boolean canExtend) {
            this.canExtend = canExtend;
            this.changedFields = changedFields.add("canExtend");
            return this;
        }

        public Builder durationInDays(Integer durationInDays) {
            this.durationInDays = durationInDays;
            this.changedFields = changedFields.add("durationInDays");
            return this;
        }

        public Builder expirationDateTime(OffsetDateTime expirationDateTime) {
            this.expirationDateTime = expirationDateTime;
            this.changedFields = changedFields.add("expirationDateTime");
            return this;
        }

        public Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder modifiedBy(String modifiedBy) {
            this.modifiedBy = modifiedBy;
            this.changedFields = changedFields.add("modifiedBy");
            return this;
        }

        public Builder modifiedDateTime(OffsetDateTime modifiedDateTime) {
            this.modifiedDateTime = modifiedDateTime;
            this.changedFields = changedFields.add("modifiedDateTime");
            return this;
        }

        public Builder requestorSettings(RequestorSettings requestorSettings) {
            this.requestorSettings = requestorSettings;
            this.changedFields = changedFields.add("requestorSettings");
            return this;
        }

        public Builder requestApprovalSettings(ApprovalSettings requestApprovalSettings) {
            this.requestApprovalSettings = requestApprovalSettings;
            this.changedFields = changedFields.add("requestApprovalSettings");
            return this;
        }

        public Builder accessReviewSettings(AssignmentReviewSettings accessReviewSettings) {
            this.accessReviewSettings = accessReviewSettings;
            this.changedFields = changedFields.add("accessReviewSettings");
            return this;
        }

        public AccessPackageAssignmentPolicy build() {
            AccessPackageAssignmentPolicy _x = new AccessPackageAssignmentPolicy();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.accessPackageAssignmentPolicy";
            _x.id = id;
            _x.accessPackageId = accessPackageId;
            _x.displayName = displayName;
            _x.description = description;
            _x.canExtend = canExtend;
            _x.durationInDays = durationInDays;
            _x.expirationDateTime = expirationDateTime;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.modifiedBy = modifiedBy;
            _x.modifiedDateTime = modifiedDateTime;
            _x.requestorSettings = requestorSettings;
            _x.requestApprovalSettings = requestApprovalSettings;
            _x.accessReviewSettings = accessReviewSettings;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="accessPackageId")
    @JsonIgnore
    public Optional<String> getAccessPackageId() {
        return Optional.ofNullable(accessPackageId);
    }

    public AccessPackageAssignmentPolicy withAccessPackageId(String accessPackageId) {
        AccessPackageAssignmentPolicy _x = _copy();
        _x.changedFields = changedFields.add("accessPackageId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentPolicy");
        _x.accessPackageId = accessPackageId;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public AccessPackageAssignmentPolicy withDisplayName(String displayName) {
        AccessPackageAssignmentPolicy _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentPolicy");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public AccessPackageAssignmentPolicy withDescription(String description) {
        AccessPackageAssignmentPolicy _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentPolicy");
        _x.description = description;
        return _x;
    }

    @Property(name="canExtend")
    @JsonIgnore
    public Optional<Boolean> getCanExtend() {
        return Optional.ofNullable(canExtend);
    }

    public AccessPackageAssignmentPolicy withCanExtend(Boolean canExtend) {
        AccessPackageAssignmentPolicy _x = _copy();
        _x.changedFields = changedFields.add("canExtend");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentPolicy");
        _x.canExtend = canExtend;
        return _x;
    }

    @Property(name="durationInDays")
    @JsonIgnore
    public Optional<Integer> getDurationInDays() {
        return Optional.ofNullable(durationInDays);
    }

    public AccessPackageAssignmentPolicy withDurationInDays(Integer durationInDays) {
        AccessPackageAssignmentPolicy _x = _copy();
        _x.changedFields = changedFields.add("durationInDays");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentPolicy");
        _x.durationInDays = durationInDays;
        return _x;
    }

    @Property(name="expirationDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpirationDateTime() {
        return Optional.ofNullable(expirationDateTime);
    }

    public AccessPackageAssignmentPolicy withExpirationDateTime(OffsetDateTime expirationDateTime) {
        AccessPackageAssignmentPolicy _x = _copy();
        _x.changedFields = changedFields.add("expirationDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentPolicy");
        _x.expirationDateTime = expirationDateTime;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<String> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public AccessPackageAssignmentPolicy withCreatedBy(String createdBy) {
        AccessPackageAssignmentPolicy _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentPolicy");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public AccessPackageAssignmentPolicy withCreatedDateTime(OffsetDateTime createdDateTime) {
        AccessPackageAssignmentPolicy _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentPolicy");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="modifiedBy")
    @JsonIgnore
    public Optional<String> getModifiedBy() {
        return Optional.ofNullable(modifiedBy);
    }

    public AccessPackageAssignmentPolicy withModifiedBy(String modifiedBy) {
        AccessPackageAssignmentPolicy _x = _copy();
        _x.changedFields = changedFields.add("modifiedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentPolicy");
        _x.modifiedBy = modifiedBy;
        return _x;
    }

    @Property(name="modifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedDateTime() {
        return Optional.ofNullable(modifiedDateTime);
    }

    public AccessPackageAssignmentPolicy withModifiedDateTime(OffsetDateTime modifiedDateTime) {
        AccessPackageAssignmentPolicy _x = _copy();
        _x.changedFields = changedFields.add("modifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentPolicy");
        _x.modifiedDateTime = modifiedDateTime;
        return _x;
    }

    @Property(name="requestorSettings")
    @JsonIgnore
    public Optional<RequestorSettings> getRequestorSettings() {
        return Optional.ofNullable(requestorSettings);
    }

    public AccessPackageAssignmentPolicy withRequestorSettings(RequestorSettings requestorSettings) {
        AccessPackageAssignmentPolicy _x = _copy();
        _x.changedFields = changedFields.add("requestorSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentPolicy");
        _x.requestorSettings = requestorSettings;
        return _x;
    }

    @Property(name="requestApprovalSettings")
    @JsonIgnore
    public Optional<ApprovalSettings> getRequestApprovalSettings() {
        return Optional.ofNullable(requestApprovalSettings);
    }

    public AccessPackageAssignmentPolicy withRequestApprovalSettings(ApprovalSettings requestApprovalSettings) {
        AccessPackageAssignmentPolicy _x = _copy();
        _x.changedFields = changedFields.add("requestApprovalSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentPolicy");
        _x.requestApprovalSettings = requestApprovalSettings;
        return _x;
    }

    @Property(name="accessReviewSettings")
    @JsonIgnore
    public Optional<AssignmentReviewSettings> getAccessReviewSettings() {
        return Optional.ofNullable(accessReviewSettings);
    }

    public AccessPackageAssignmentPolicy withAccessReviewSettings(AssignmentReviewSettings accessReviewSettings) {
        AccessPackageAssignmentPolicy _x = _copy();
        _x.changedFields = changedFields.add("accessReviewSettings");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignmentPolicy");
        _x.accessReviewSettings = accessReviewSettings;
        return _x;
    }

    @NavigationProperty(name="accessPackage")
    @JsonIgnore
    public AccessPackageRequest getAccessPackage() {
        return new AccessPackageRequest(contextPath.addSegment("accessPackage"));
    }

    @NavigationProperty(name="accessPackageCatalog")
    @JsonIgnore
    public AccessPackageCatalogRequest getAccessPackageCatalog() {
        return new AccessPackageCatalogRequest(contextPath.addSegment("accessPackageCatalog"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackageAssignmentPolicy patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AccessPackageAssignmentPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackageAssignmentPolicy put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AccessPackageAssignmentPolicy _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AccessPackageAssignmentPolicy _copy() {
        AccessPackageAssignmentPolicy _x = new AccessPackageAssignmentPolicy();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.accessPackageId = accessPackageId;
        _x.displayName = displayName;
        _x.description = description;
        _x.canExtend = canExtend;
        _x.durationInDays = durationInDays;
        _x.expirationDateTime = expirationDateTime;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.modifiedBy = modifiedBy;
        _x.modifiedDateTime = modifiedDateTime;
        _x.requestorSettings = requestorSettings;
        _x.requestApprovalSettings = requestApprovalSettings;
        _x.accessReviewSettings = accessReviewSettings;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessPackageAssignmentPolicy[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("accessPackageId=");
        b.append(this.accessPackageId);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("canExtend=");
        b.append(this.canExtend);
        b.append(", ");
        b.append("durationInDays=");
        b.append(this.durationInDays);
        b.append(", ");
        b.append("expirationDateTime=");
        b.append(this.expirationDateTime);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("modifiedBy=");
        b.append(this.modifiedBy);
        b.append(", ");
        b.append("modifiedDateTime=");
        b.append(this.modifiedDateTime);
        b.append(", ");
        b.append("requestorSettings=");
        b.append(this.requestorSettings);
        b.append(", ");
        b.append("requestApprovalSettings=");
        b.append(this.requestApprovalSettings);
        b.append(", ");
        b.append("accessReviewSettings=");
        b.append(this.accessReviewSettings);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
