package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentResourceRoleCollectionRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageAssignmentPolicyRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageSubjectRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "catalogId", 
    "accessPackageId", 
    "assignmentPolicyId", 
    "targetId", 
    "assignmentStatus", 
    "assignmentState", 
    "isExtended", 
    "expiredDateTime"})
@JsonInclude(Include.NON_NULL)
public class AccessPackageAssignment extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessPackageAssignment";
    }

    @JsonProperty("catalogId")
    protected String catalogId;

    @JsonProperty("accessPackageId")
    protected String accessPackageId;

    @JsonProperty("assignmentPolicyId")
    protected String assignmentPolicyId;

    @JsonProperty("targetId")
    protected String targetId;

    @JsonProperty("assignmentStatus")
    protected String assignmentStatus;

    @JsonProperty("assignmentState")
    protected String assignmentState;

    @JsonProperty("isExtended")
    protected Boolean isExtended;

    @JsonProperty("expiredDateTime")
    protected OffsetDateTime expiredDateTime;

    protected AccessPackageAssignment() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessPackageAssignment() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String catalogId;
        private String accessPackageId;
        private String assignmentPolicyId;
        private String targetId;
        private String assignmentStatus;
        private String assignmentState;
        private Boolean isExtended;
        private OffsetDateTime expiredDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            this.changedFields = changedFields.add("catalogId");
            return this;
        }

        public Builder accessPackageId(String accessPackageId) {
            this.accessPackageId = accessPackageId;
            this.changedFields = changedFields.add("accessPackageId");
            return this;
        }

        public Builder assignmentPolicyId(String assignmentPolicyId) {
            this.assignmentPolicyId = assignmentPolicyId;
            this.changedFields = changedFields.add("assignmentPolicyId");
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.changedFields = changedFields.add("targetId");
            return this;
        }

        public Builder assignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
            this.changedFields = changedFields.add("assignmentStatus");
            return this;
        }

        public Builder assignmentState(String assignmentState) {
            this.assignmentState = assignmentState;
            this.changedFields = changedFields.add("assignmentState");
            return this;
        }

        public Builder isExtended(Boolean isExtended) {
            this.isExtended = isExtended;
            this.changedFields = changedFields.add("isExtended");
            return this;
        }

        public Builder expiredDateTime(OffsetDateTime expiredDateTime) {
            this.expiredDateTime = expiredDateTime;
            this.changedFields = changedFields.add("expiredDateTime");
            return this;
        }

        public AccessPackageAssignment build() {
            AccessPackageAssignment _x = new AccessPackageAssignment();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.accessPackageAssignment";
            _x.id = id;
            _x.catalogId = catalogId;
            _x.accessPackageId = accessPackageId;
            _x.assignmentPolicyId = assignmentPolicyId;
            _x.targetId = targetId;
            _x.assignmentStatus = assignmentStatus;
            _x.assignmentState = assignmentState;
            _x.isExtended = isExtended;
            _x.expiredDateTime = expiredDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="catalogId")
    @JsonIgnore
    public Optional<String> getCatalogId() {
        return Optional.ofNullable(catalogId);
    }

    public AccessPackageAssignment withCatalogId(String catalogId) {
        AccessPackageAssignment _x = _copy();
        _x.changedFields = changedFields.add("catalogId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignment");
        _x.catalogId = catalogId;
        return _x;
    }

    @Property(name="accessPackageId")
    @JsonIgnore
    public Optional<String> getAccessPackageId() {
        return Optional.ofNullable(accessPackageId);
    }

    public AccessPackageAssignment withAccessPackageId(String accessPackageId) {
        AccessPackageAssignment _x = _copy();
        _x.changedFields = changedFields.add("accessPackageId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignment");
        _x.accessPackageId = accessPackageId;
        return _x;
    }

    @Property(name="assignmentPolicyId")
    @JsonIgnore
    public Optional<String> getAssignmentPolicyId() {
        return Optional.ofNullable(assignmentPolicyId);
    }

    public AccessPackageAssignment withAssignmentPolicyId(String assignmentPolicyId) {
        AccessPackageAssignment _x = _copy();
        _x.changedFields = changedFields.add("assignmentPolicyId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignment");
        _x.assignmentPolicyId = assignmentPolicyId;
        return _x;
    }

    @Property(name="targetId")
    @JsonIgnore
    public Optional<String> getTargetId() {
        return Optional.ofNullable(targetId);
    }

    public AccessPackageAssignment withTargetId(String targetId) {
        AccessPackageAssignment _x = _copy();
        _x.changedFields = changedFields.add("targetId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignment");
        _x.targetId = targetId;
        return _x;
    }

    @Property(name="assignmentStatus")
    @JsonIgnore
    public Optional<String> getAssignmentStatus() {
        return Optional.ofNullable(assignmentStatus);
    }

    public AccessPackageAssignment withAssignmentStatus(String assignmentStatus) {
        AccessPackageAssignment _x = _copy();
        _x.changedFields = changedFields.add("assignmentStatus");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignment");
        _x.assignmentStatus = assignmentStatus;
        return _x;
    }

    @Property(name="assignmentState")
    @JsonIgnore
    public Optional<String> getAssignmentState() {
        return Optional.ofNullable(assignmentState);
    }

    public AccessPackageAssignment withAssignmentState(String assignmentState) {
        AccessPackageAssignment _x = _copy();
        _x.changedFields = changedFields.add("assignmentState");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignment");
        _x.assignmentState = assignmentState;
        return _x;
    }

    @Property(name="isExtended")
    @JsonIgnore
    public Optional<Boolean> getIsExtended() {
        return Optional.ofNullable(isExtended);
    }

    public AccessPackageAssignment withIsExtended(Boolean isExtended) {
        AccessPackageAssignment _x = _copy();
        _x.changedFields = changedFields.add("isExtended");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignment");
        _x.isExtended = isExtended;
        return _x;
    }

    @Property(name="expiredDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getExpiredDateTime() {
        return Optional.ofNullable(expiredDateTime);
    }

    public AccessPackageAssignment withExpiredDateTime(OffsetDateTime expiredDateTime) {
        AccessPackageAssignment _x = _copy();
        _x.changedFields = changedFields.add("expiredDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackageAssignment");
        _x.expiredDateTime = expiredDateTime;
        return _x;
    }

    @NavigationProperty(name="accessPackage")
    @JsonIgnore
    public AccessPackageRequest getAccessPackage() {
        return new AccessPackageRequest(contextPath.addSegment("accessPackage"));
    }

    @NavigationProperty(name="accessPackageAssignmentPolicy")
    @JsonIgnore
    public AccessPackageAssignmentPolicyRequest getAccessPackageAssignmentPolicy() {
        return new AccessPackageAssignmentPolicyRequest(contextPath.addSegment("accessPackageAssignmentPolicy"));
    }

    @NavigationProperty(name="target")
    @JsonIgnore
    public AccessPackageSubjectRequest getTarget() {
        return new AccessPackageSubjectRequest(contextPath.addSegment("target"));
    }

    @NavigationProperty(name="accessPackageAssignmentRequests")
    @JsonIgnore
    public AccessPackageAssignmentRequestCollectionRequest getAccessPackageAssignmentRequests() {
        return new AccessPackageAssignmentRequestCollectionRequest(
                        contextPath.addSegment("accessPackageAssignmentRequests"));
    }

    @NavigationProperty(name="accessPackageAssignmentResourceRoles")
    @JsonIgnore
    public AccessPackageAssignmentResourceRoleCollectionRequest getAccessPackageAssignmentResourceRoles() {
        return new AccessPackageAssignmentResourceRoleCollectionRequest(
                        contextPath.addSegment("accessPackageAssignmentResourceRoles"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackageAssignment patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AccessPackageAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackageAssignment put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AccessPackageAssignment _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AccessPackageAssignment _copy() {
        AccessPackageAssignment _x = new AccessPackageAssignment();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.catalogId = catalogId;
        _x.accessPackageId = accessPackageId;
        _x.assignmentPolicyId = assignmentPolicyId;
        _x.targetId = targetId;
        _x.assignmentStatus = assignmentStatus;
        _x.assignmentState = assignmentState;
        _x.isExtended = isExtended;
        _x.expiredDateTime = expiredDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessPackageAssignment[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("catalogId=");
        b.append(this.catalogId);
        b.append(", ");
        b.append("accessPackageId=");
        b.append(this.accessPackageId);
        b.append(", ");
        b.append("assignmentPolicyId=");
        b.append(this.assignmentPolicyId);
        b.append(", ");
        b.append("targetId=");
        b.append(this.targetId);
        b.append(", ");
        b.append("assignmentStatus=");
        b.append(this.assignmentStatus);
        b.append(", ");
        b.append("assignmentState=");
        b.append(this.assignmentState);
        b.append(", ");
        b.append("isExtended=");
        b.append(this.isExtended);
        b.append(", ");
        b.append("expiredDateTime=");
        b.append(this.expiredDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
