package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentPolicyCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceRoleScopeCollectionRequest;
import odata.msgraph.client.beta.entity.request.AccessPackageCatalogRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "catalogId", 
    "displayName", 
    "description", 
    "isHidden", 
    "isRoleScopesVisible", 
    "createdBy", 
    "createdDateTime", 
    "modifiedBy", 
    "modifiedDateTime"})
@JsonInclude(Include.NON_NULL)
public class AccessPackage extends Entity implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.accessPackage";
    }

    @JsonProperty("catalogId")
    protected String catalogId;

    @JsonProperty("displayName")
    protected String displayName;

    @JsonProperty("description")
    protected String description;

    @JsonProperty("isHidden")
    protected Boolean isHidden;

    @JsonProperty("isRoleScopesVisible")
    protected Boolean isRoleScopesVisible;

    @JsonProperty("createdBy")
    protected String createdBy;

    @JsonProperty("createdDateTime")
    protected OffsetDateTime createdDateTime;

    @JsonProperty("modifiedBy")
    protected String modifiedBy;

    @JsonProperty("modifiedDateTime")
    protected OffsetDateTime modifiedDateTime;

    protected AccessPackage() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAccessPackage() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private String catalogId;
        private String displayName;
        private String description;
        private Boolean isHidden;
        private Boolean isRoleScopesVisible;
        private String createdBy;
        private OffsetDateTime createdDateTime;
        private String modifiedBy;
        private OffsetDateTime modifiedDateTime;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            this.changedFields = changedFields.add("catalogId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("description");
            return this;
        }

        public Builder isHidden(Boolean isHidden) {
            this.isHidden = isHidden;
            this.changedFields = changedFields.add("isHidden");
            return this;
        }

        public Builder isRoleScopesVisible(Boolean isRoleScopesVisible) {
            this.isRoleScopesVisible = isRoleScopesVisible;
            this.changedFields = changedFields.add("isRoleScopesVisible");
            return this;
        }

        public Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            this.changedFields = changedFields.add("createdBy");
            return this;
        }

        public Builder createdDateTime(OffsetDateTime createdDateTime) {
            this.createdDateTime = createdDateTime;
            this.changedFields = changedFields.add("createdDateTime");
            return this;
        }

        public Builder modifiedBy(String modifiedBy) {
            this.modifiedBy = modifiedBy;
            this.changedFields = changedFields.add("modifiedBy");
            return this;
        }

        public Builder modifiedDateTime(OffsetDateTime modifiedDateTime) {
            this.modifiedDateTime = modifiedDateTime;
            this.changedFields = changedFields.add("modifiedDateTime");
            return this;
        }

        public AccessPackage build() {
            AccessPackage _x = new AccessPackage();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.accessPackage";
            _x.id = id;
            _x.catalogId = catalogId;
            _x.displayName = displayName;
            _x.description = description;
            _x.isHidden = isHidden;
            _x.isRoleScopesVisible = isRoleScopesVisible;
            _x.createdBy = createdBy;
            _x.createdDateTime = createdDateTime;
            _x.modifiedBy = modifiedBy;
            _x.modifiedDateTime = modifiedDateTime;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="catalogId")
    @JsonIgnore
    public Optional<String> getCatalogId() {
        return Optional.ofNullable(catalogId);
    }

    public AccessPackage withCatalogId(String catalogId) {
        AccessPackage _x = _copy();
        _x.changedFields = changedFields.add("catalogId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackage");
        _x.catalogId = catalogId;
        return _x;
    }

    @Property(name="displayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(displayName);
    }

    public AccessPackage withDisplayName(String displayName) {
        AccessPackage _x = _copy();
        _x.changedFields = changedFields.add("displayName");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackage");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public AccessPackage withDescription(String description) {
        AccessPackage _x = _copy();
        _x.changedFields = changedFields.add("description");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackage");
        _x.description = description;
        return _x;
    }

    @Property(name="isHidden")
    @JsonIgnore
    public Optional<Boolean> getIsHidden() {
        return Optional.ofNullable(isHidden);
    }

    public AccessPackage withIsHidden(Boolean isHidden) {
        AccessPackage _x = _copy();
        _x.changedFields = changedFields.add("isHidden");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackage");
        _x.isHidden = isHidden;
        return _x;
    }

    @Property(name="isRoleScopesVisible")
    @JsonIgnore
    public Optional<Boolean> getIsRoleScopesVisible() {
        return Optional.ofNullable(isRoleScopesVisible);
    }

    public AccessPackage withIsRoleScopesVisible(Boolean isRoleScopesVisible) {
        AccessPackage _x = _copy();
        _x.changedFields = changedFields.add("isRoleScopesVisible");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackage");
        _x.isRoleScopesVisible = isRoleScopesVisible;
        return _x;
    }

    @Property(name="createdBy")
    @JsonIgnore
    public Optional<String> getCreatedBy() {
        return Optional.ofNullable(createdBy);
    }

    public AccessPackage withCreatedBy(String createdBy) {
        AccessPackage _x = _copy();
        _x.changedFields = changedFields.add("createdBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackage");
        _x.createdBy = createdBy;
        return _x;
    }

    @Property(name="createdDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getCreatedDateTime() {
        return Optional.ofNullable(createdDateTime);
    }

    public AccessPackage withCreatedDateTime(OffsetDateTime createdDateTime) {
        AccessPackage _x = _copy();
        _x.changedFields = changedFields.add("createdDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackage");
        _x.createdDateTime = createdDateTime;
        return _x;
    }

    @Property(name="modifiedBy")
    @JsonIgnore
    public Optional<String> getModifiedBy() {
        return Optional.ofNullable(modifiedBy);
    }

    public AccessPackage withModifiedBy(String modifiedBy) {
        AccessPackage _x = _copy();
        _x.changedFields = changedFields.add("modifiedBy");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackage");
        _x.modifiedBy = modifiedBy;
        return _x;
    }

    @Property(name="modifiedDateTime")
    @JsonIgnore
    public Optional<OffsetDateTime> getModifiedDateTime() {
        return Optional.ofNullable(modifiedDateTime);
    }

    public AccessPackage withModifiedDateTime(OffsetDateTime modifiedDateTime) {
        AccessPackage _x = _copy();
        _x.changedFields = changedFields.add("modifiedDateTime");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.accessPackage");
        _x.modifiedDateTime = modifiedDateTime;
        return _x;
    }

    @NavigationProperty(name="accessPackageCatalog")
    @JsonIgnore
    public AccessPackageCatalogRequest getAccessPackageCatalog() {
        return new AccessPackageCatalogRequest(contextPath.addSegment("accessPackageCatalog"));
    }

    @NavigationProperty(name="accessPackageResourceRoleScopes")
    @JsonIgnore
    public AccessPackageResourceRoleScopeCollectionRequest getAccessPackageResourceRoleScopes() {
        return new AccessPackageResourceRoleScopeCollectionRequest(
                        contextPath.addSegment("accessPackageResourceRoleScopes"));
    }

    @NavigationProperty(name="accessPackageAssignmentPolicies")
    @JsonIgnore
    public AccessPackageAssignmentPolicyCollectionRequest getAccessPackageAssignmentPolicies() {
        return new AccessPackageAssignmentPolicyCollectionRequest(
                        contextPath.addSegment("accessPackageAssignmentPolicies"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackage patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AccessPackage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AccessPackage put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AccessPackage _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AccessPackage _copy() {
        AccessPackage _x = new AccessPackage();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.catalogId = catalogId;
        _x.displayName = displayName;
        _x.description = description;
        _x.isHidden = isHidden;
        _x.isRoleScopesVisible = isRoleScopesVisible;
        _x.createdBy = createdBy;
        _x.createdDateTime = createdDateTime;
        _x.modifiedBy = modifiedBy;
        _x.modifiedDateTime = modifiedDateTime;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AccessPackage[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("catalogId=");
        b.append(this.catalogId);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("description=");
        b.append(this.description);
        b.append(", ");
        b.append("isHidden=");
        b.append(this.isHidden);
        b.append(", ");
        b.append("isRoleScopesVisible=");
        b.append(this.isRoleScopesVisible);
        b.append(", ");
        b.append("createdBy=");
        b.append(this.createdBy);
        b.append(", ");
        b.append("createdDateTime=");
        b.append(this.createdDateTime);
        b.append(", ");
        b.append("modifiedBy=");
        b.append(this.modifiedBy);
        b.append(", ");
        b.append("modifiedDateTime=");
        b.append(this.modifiedDateTime);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
