package odata.msgraph.client.beta.entity;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ClientException;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.ODataEntityType;
import com.github.davidmoten.odata.client.RequestOptions;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.NavigationProperty;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.RequestHelper;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;

import odata.msgraph.client.beta.entity.request.UserRequest;

@JsonPropertyOrder({
    "@odata.type", 
    "userId", 
    "email"})
@JsonInclude(Include.NON_NULL)
public class AadUserConversationMember extends ConversationMember implements ODataEntityType {

    @Override
    public String odataTypeName() {
        return "microsoft.graph.aadUserConversationMember";
    }

    @JsonProperty("userId")
    protected String userId;

    @JsonProperty("email")
    protected String email;

    protected AadUserConversationMember() {
        super();
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderAadUserConversationMember() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private List<String> roles;
        private String rolesNextLink;
        private String displayName;
        private String userId;
        private String email;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder id(String id) {
            this.id = id;
            this.changedFields = changedFields.add("id");
            return this;
        }

        public Builder roles(List<String> roles) {
            this.roles = roles;
            this.changedFields = changedFields.add("roles");
            return this;
        }

        public Builder roles(String... roles) {
            return roles(Arrays.asList(roles));
        }

        public Builder rolesNextLink(String rolesNextLink) {
            this.rolesNextLink = rolesNextLink;
            this.changedFields = changedFields.add("roles");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = changedFields.add("displayName");
            return this;
        }

        public Builder userId(String userId) {
            this.userId = userId;
            this.changedFields = changedFields.add("userId");
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            this.changedFields = changedFields.add("email");
            return this;
        }

        public AadUserConversationMember build() {
            AadUserConversationMember _x = new AadUserConversationMember();
            _x.contextPath = null;
            _x.changedFields = changedFields;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "microsoft.graph.aadUserConversationMember";
            _x.id = id;
            _x.roles = roles;
            _x.rolesNextLink = rolesNextLink;
            _x.displayName = displayName;
            _x.userId = userId;
            _x.email = email;
            return _x;
        }
    }

    @Override
    @JsonIgnore
    public ChangedFields getChangedFields() {
        return changedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        if (addKeysToContextPath && id != null) {
            contextPath = contextPath.clearQueries().addKeys(new NameValue(id.toString()));
        }
    }

    @Property(name="userId")
    @JsonIgnore
    public Optional<String> getUserId() {
        return Optional.ofNullable(userId);
    }

    public AadUserConversationMember withUserId(String userId) {
        AadUserConversationMember _x = _copy();
        _x.changedFields = changedFields.add("userId");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aadUserConversationMember");
        _x.userId = userId;
        return _x;
    }

    @Property(name="email")
    @JsonIgnore
    public Optional<String> getEmail() {
        return Optional.ofNullable(email);
    }

    public AadUserConversationMember withEmail(String email) {
        AadUserConversationMember _x = _copy();
        _x.changedFields = changedFields.add("email");
        _x.odataType = Util.nvl(odataType, "microsoft.graph.aadUserConversationMember");
        _x.email = email;
        return _x;
    }

    @NavigationProperty(name="user")
    @JsonIgnore
    public UserRequest getUser() {
        return new UserRequest(contextPath.addSegment("user"));
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    /**
     * Submits only changed fields for update and returns an 
     * immutable copy of {@code this} with changed fields reset.
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AadUserConversationMember patch() {
        RequestHelper.patch(this, contextPath, RequestOptions.EMPTY);
        AadUserConversationMember _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    /**
     * Submits all fields for update and returns an immutable copy of {@code this}
     * with changed fields reset (they were ignored anyway).
     *
     * @return a copy of {@code this} with changed fields reset
     * @throws ClientException if HTTP response is not as expected
     */
    public AadUserConversationMember put() {
        RequestHelper.put(this, contextPath, RequestOptions.EMPTY);
        AadUserConversationMember _x = _copy();
        _x.changedFields = null;
        return _x;
    }

    private AadUserConversationMember _copy() {
        AadUserConversationMember _x = new AadUserConversationMember();
        _x.contextPath = contextPath;
        _x.changedFields = changedFields;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.id = id;
        _x.roles = roles;
        _x.displayName = displayName;
        _x.userId = userId;
        _x.email = email;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AadUserConversationMember[");
        b.append("id=");
        b.append(this.id);
        b.append(", ");
        b.append("roles=");
        b.append(this.roles);
        b.append(", ");
        b.append("displayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("userId=");
        b.append(this.userId);
        b.append(", ");
        b.append("email=");
        b.append(this.email);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }
}
